unit Demo16F1;
//
// PixelGraphicLibrary - Demo 16
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, Buttons, StdCtrls, ComCtrls, ExtCtrls, Demo16U2;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGSaveDialog1: TPGSaveDialog;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    Print1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.Filename:=PGImage1.Filename;
if PGOpenDialog1.Execute then
   PGImage1.Filename:=PGOpenDialog1.Filename;
Saveas1.Enabled:=not PGImage1.Empty;
Print1.Enabled:=not PGImage1.Empty;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog1.Filename:=PGImage1.Filename;
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.Filename);
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
PGImage1.LendPixelGraphic.Print(true, true, self);
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how to add support for other file formats.' + #13#13 +
   'A self invented 8 bit file format "xyz" and a new extension for JPEG FIFF files "myjpg" are added.' + #13#13 +
   'This should demonstrate how to add support for other file formats.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
