unit Demo14F;
//
// PixelGraphicLibrary - Demo 14
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, PGraphic, Menus;

type
  TForm1 = class(TForm)
    PGImage1: TPGImage;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    { Private declarations }
    FStep: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
   DC: HDC;
   BitsPerPixel: Integer;
begin
PGImage1.TakePixelGraphic(TPixelGraphic.Create);
// Find out if we are on an 16 color, 256 color or high/true color system
DC := GetDC(0);
try
   BitsPerPixel := GetDeviceCaps(DC, PLANES) * GetDeviceCaps(DC, BITSPIXEL);
finally
   ReleaseDC(0, DC);
end;
if BitsPerPixel<8 then // 16 colors
   begin
   PGImage1.PixelGraphic.SetDimension(128, 128, bc4);
   PGImage1.PixelGraphic.PaletteKind:=pSys16;
   end
else
   if BitsPerPixel=8 then // 256 colors
      begin
      PGImage1.PixelGraphic.SetDimension(128, 128, bc8);
      PGImage1.PixelGraphic.PaletteKind:=pSpecial216;
      end
   else // high/true color
      PGImage1.PixelGraphic.SetDimension(128, 128, bc24);
FStep:=0;
Info1Click(Self);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
   x, y: Integer;
   ThePixelGraphic: TPixelGraphic;
   r, b: Byte;
   g: array[0..127] of byte;
begin
ThePixelGraphic:=PGImage1.PixelGraphic;
// Calculate the g values and save them in an array because we need each 128 times and sin is a slow operation.
for x := 0 to 127 do
   g[x]:=127+Trunc(127*sin(4*pi*(x-FStep)/128));
for y := 0 to 127 do
   begin
   r:=127+Trunc(127*sin(3*pi*(y+FStep)/128));
   b:=255-r;
   for x := 0 to 127 do
      ThePixelGraphic.Pixels[x,y]:=rgb(r,g[x],b);
   end;
ThePixelGraphic.Changed(Self);   
Inc(FStep);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how fast the Pixels property of TPixelGraphic is. It is fast enough to be used for simple animations. ' +
   'Note that this animation is NOT done by palette animation. On every timer event the color value of every single pixel is set.'#13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.      
