unit Demo13F;
//
// PixelGraphicLibrary - Demo 13
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         Menus, PGraphic, Buttons, StdCtrls;

type
   TForm1 = class (TForm)
      MainMenu1: TMainMenu;
      File1: TMenuItem;
      Open1: TMenuItem;
      Flip1: TMenuItem;
      Horizontal1: TMenuItem;
      Vertical1: TMenuItem;
      Pas: TButton;
      Button1: TButton;
      PGImage1: TPGImage;
      PGOpenDialog1: TPGOpenDialog;
      Info1: TMenuItem;
      procedure Horizontal1Click(Sender: TObject);
      procedure Open1Click(Sender: TObject);
      procedure Vertical1Click(Sender: TObject);
      procedure Info1Click(Sender: TObject);
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
if PGOpenDialog1.Execute then
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
end;

procedure TForm1.Horizontal1Click(Sender: TObject);
begin
PGImage1.PixelGraphic.FlipHorizontal;
end;

procedure TForm1.Vertical1Click(Sender: TObject);
begin
PGImage1.PixelGraphic.FlipVertical;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of the TPixelGraphic.FlipHorizontal and TPixelGraphic.FlipVertical.'#13#13 +
   'Don'#39't confuse these methods of TPixelGraphic with the properties of TPGImage. ' +
   'These methods of TPixelGraphic do really flip the graphic in memory ' +
   'so that you can save the changed graphic. The properties of TPGImage ' +
   'determine only how the graphic is displayed.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.

