unit Demo11F1;
//
// PixelGraphicLibrary - Demo 11
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, Buttons, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGSaveDialog1: TPGSaveDialog;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    Print1: TMenuItem;
    Paint1: TMenuItem;
    RadomLines1: TMenuItem;
    Scales1: TMenuItem;
    RandomEllipses1: TMenuItem;
    RandomText1: TMenuItem;
    New1: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure RadomLines1Click(Sender: TObject);
    procedure Scales1Click(Sender: TObject);
    procedure RandomEllipses1Click(Sender: TObject);
    procedure RandomText1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Demo11F2;

{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.Filename:=PGImage1.Filename;
if PGOpenDialog1.Execute then
   begin
   PGImage1.KeepOldPaintPixelGraphic:=false;
   PGImage1.Filename:=PGOpenDialog1.Filename;
   PGImage1.KeepOldPaintPixelGraphic:=true;
   end;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog1.Filename:=PGImage1.Filename;
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.Filename);
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
PGImage1.LendPixelGraphic.Print(true, true, self);
end;

procedure TForm1.RadomLines1Click(Sender: TObject);
var
   i: Integer;
   PG: TPixelGraphic;
begin
PG:=PGImage1.PixelGraphic;
PG.BeginUpdate;
try
   for i:=0 to 100 do
      begin
      PG.Canvas.Pen.Color:=rgb(Random(256), Random(256), Random(256));
      PG.Canvas.MoveTo(Random(PG.Width), Random(PG.Height));
      PG.Canvas.LineTo(Random(PG.Width), Random(PG.Height));
      end;
finally
   PG.EndUpdate;
end;
FreePGMemoryContexts;
end;

procedure TForm1.Scales1Click(Sender: TObject);
var
   i: Integer;
   PG: TPixelGraphic;
begin
PG:=PGImage1.PixelGraphic;
PG.BeginUpdate;
try
   for i:=0 to 255 do
      begin
      PG.Canvas.Pen.Color:=rgb(i,0,0);
      PG.Canvas.MoveTo(i+10, 10);
      PG.Canvas.LineTo(i+10, 20);
      PG.Canvas.Pen.Color:=rgb(0,i,0);
      PG.Canvas.MoveTo(i+10, 30);
      PG.Canvas.LineTo(i+10, 40);
      PG.Canvas.Pen.Color:=rgb(0,0,i);
      PG.Canvas.MoveTo(i+10, 50);
      PG.Canvas.LineTo(i+10, 60);
      PG.Canvas.Pen.Color:=rgb(i,i,i);
      PG.Canvas.MoveTo(i+10, 70);
      PG.Canvas.LineTo(i+10, 80);
      end;
finally
   PG.EndUpdate;
end;
FreePGMemoryContexts;
end;

procedure TForm1.RandomEllipses1Click(Sender: TObject);
var
   i: Integer;
   PG: TPixelGraphic;
begin
PG:=PGImage1.PixelGraphic;
PG.BeginUpdate;
try
   for i:=0 to 25 do
      begin
      PG.Canvas.Pen.Color:=rgb(Random(256), Random(256), Random(256));
      PG.Canvas.Brush.Color:=rgb(Random(256), Random(256), Random(256));
      PG.Canvas.Ellipse(Random(PG.Width), Random(PG.Height), Random(PG.Width), Random(PG.Height));
      end;
finally
   PG.EndUpdate;
end;
FreePGMemoryContexts;
end;

procedure TForm1.RandomText1Click(Sender: TObject);
var
   i: Integer;
   PG: TPixelGraphic;
begin
PG:=PGImage1.PixelGraphic;
PG.BeginUpdate;
try
   for i:=0 to 25 do
      begin
      PG.Canvas.Font.Name:='Arial';
      PG.Canvas.Brush.Style:=bsClear;
      PG.Canvas.Font.Color:=rgb(Random(256), Random(256), Random(256));
      PG.Canvas.Font.Size:=random(20)+6;
      PG.Canvas.TextOut(Random(PG.Width-PG.Canvas.TextWidth('PixelGraphicLibrary')), Random(PG.Height-PG.Canvas.TextHeight('PixelGraphicLibrary')), 'PixelGraphicLibrary');
      PG.Canvas.Brush.Style:=bsSolid;
      end;
finally
   PG.EndUpdate;
end;
FreePGMemoryContexts;
end;

procedure TForm1.New1Click(Sender: TObject);
var
   aPaletteKind: TPaletteKind;
   aBitCount: TBitCount;
   aWidth: Integer;
   aHeight: Integer;
begin
if Form2.ShowModal=mrOK then
   begin
   aWidth:=StrToInt(Form2.Edit1.Text);
   aHeight:=StrToInt(Form2.Edit2.Text);
   case Form2.RadioGroup1.ItemIndex of
      0: aBitCount:=bc1;
      1: aBitCount:=bc4;
      2: aBitCount:=bc8
   else
      aBitCount:=bc24;
   end;
   PGImage1.KeepOldPaintPixelGraphic:=false;
   PGImage1.PixelGraphic.SetDimension(aWidth, aHeight, aBitCount);
   if aBitCount<>bc24 then
      begin
      aPaletteKind:=pNone;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pBlackWhite' then
         aPaletteKind:=pBlackWhite;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSysGray4' then
         aPaletteKind:=pSysGray4;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSys16' then
         aPaletteKind:=pSys16;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray4' then
         aPaletteKind:=pGray4;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray16' then
         aPaletteKind:=pGray16;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray236' then
         aPaletteKind:=pGray236;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pGray256' then
         aPaletteKind:=pGray256;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSpecial125' then
         aPaletteKind:=pSpecial125;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSpecial216' then
         aPaletteKind:=pSpecial216;
      if Form2.RadioGroup2.Items[Form2.RadioGroup2.ItemIndex] = 'pSpecial252' then
         aPaletteKind:=pSpecial252;
      PGImage1.PixelGraphic.PaletteKind:=aPaletteKind;
      end;
   PGImage1.KeepOldPaintPixelGraphic:=true;
   end;
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how to use a PixelGraphic'#39's Canvas. Note that you should call FreePGMemoryContexts at the end of a procedure that used a PixelGraphic'#39's Canvas.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
