unit Demo09F;
//
// PixelGraphicLibrary - Demo 9
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, Buttons, StdCtrls, ComCtrls, ExtCtrls, ClipBrd;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    PGOpenDialog1: TPGOpenDialog;
    PGSaveDialog1: TPGSaveDialog;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    Print1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N1: TMenuItem;
    CancelSelection1: TMenuItem;
    AttachSelection1: TMenuItem;
    Timer1: TTimer;
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure AttachSelection1Click(Sender: TObject);
    procedure CancelSelection1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    FPixelGraphicToPaste: TPixelGraphic;
    procedure CancelSelectionAndFreePixelGraphicToPaste;
    procedure UpDateMenuItems;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CancelSelectionAndFreePixelGraphicToPaste;
begin
PGImage1.Selection:=false;
PGImage1.ActionMode:=amMoveResizeCreateSelection;
PGImage1.SelectionColor2:=clRed;
if FPixelGraphicToPaste<>nil then
   begin
   FPixelGraphicToPaste.Free;
   FPixelGraphicToPaste:=nil;
   end;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.Filename:=PGImage1.Filename;
if PGOpenDialog1.Execute then
   begin
   PGImage1.Filename:=PGOpenDialog1.Filename;
   CancelSelectionAndFreePixelGraphicToPaste;
   UpDateMenuItems;
   end;
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
PGSaveDialog1.Filename:=PGImage1.Filename;
if PGSaveDialog1.Execute then
   PGImage1.SaveToFile(PGSaveDialog1.Filename);
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
PGImage1.LendPixelGraphic.Print(true, true, self);
end;

procedure TForm1.CancelSelection1Click(Sender: TObject);
begin
CancelSelectionAndFreePixelGraphicToPaste;
UpDateMenuItems;
end;

procedure TForm1.AttachSelection1Click(Sender: TObject);
begin
PGImage1.PixelGraphic.DrawRect(
      PGImage1.SelectionLeft,
      PGImage1.SelectionTop,
      FPixelGraphicToPaste.Width,
      FPixelGraphicToPaste.Height,
      0,
      0,
      FPixelGraphicToPaste);
CancelSelectionAndFreePixelGraphicToPaste;
UpDateMenuItems;
end;

procedure TForm1.Copy1Click(Sender: TObject);
var
   aPG: TPixelGraphic;
   i: Integer;
begin
aPG:=TPixelGraphic.Create;
try
   with PGImage1.LendNoModifyPixelGraphic do
      begin
      aPG.SetDimension(PGImage1.SelectionWidth, PGImage1.SelectionHeight, BitCount);
      aPG.NumPaletteEntries:=NumPaletteEntries;
      if NumPaletteEntries>0 then
         for i:=0 to NumPaletteEntries-1 do
            aPG.PaletteEntries[i]:=PaletteEntries[i];
      end;
   aPG.DrawRect(
      0,
      0,
      aPG.Width,
      aPG.Height,
      PGImage1.SelectionLeft,
      PGImage1.SelectionTop,
      PGImage1.LendNoModifyPixelGraphic);
      aPG.SaveToClipboard;
finally
   aPG.Free;
end;
CancelSelectionAndFreePixelGraphicToPaste;
UpDateMenuItems;
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
if Clipboard.HasFormat(CF_DIB) and (PGImage1.LendNoModifyPixelGraphic<>nil) then
   begin
   if FPixelGraphicToPaste<> nil then
      FPixelGraphicToPaste.Free;
   FPixelGraphicToPaste:=TPixelGraphic.Create;
   FPixelGraphicToPaste.LoadFromClipboard;
   PGImage1.SelectionLeft:=0;
   PGImage1.SelectionTop:=0;
   PGImage1.SelectionWidth:=FPixelGraphicToPaste.Width;
   PGImage1.SelectionHeight:=FPixelGraphicToPaste.Height;
   PGImage1.ActionMode:=amMoveSelection;
   PGImage1.SelectionColor2:=clBlue;
   PGImage1.Selection:=true;
   UpDateMenuItems;
   end;
end;

procedure TForm1.UpDateMenuItems;
begin
Saveas1.Enabled:=PGImage1.LendNoModifyPixelGraphic<>nil;
Print1.Enabled:=PGImage1.LendNoModifyPixelGraphic<>nil;
CancelSelection1.Enabled:=PGImage1.Selection;
AttachSelection1.Enabled:=FPixelGraphicToPaste<>nil;
Copy1.Enabled:=(PGImage1.LendNoModifyPixelGraphic<>nil) and (PGImage1.Selection) and (FPixelGraphicToPaste=nil);
Paste1.Enabled:=Clipboard.HasFormat(CF_DIB) and (PGImage1.LendNoModifyPixelGraphic<>nil);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
// In case another application puts a Bitmap into the clipboard
begin
UpDateMenuItems;
end;

procedure TForm1.Info1Click(Sender: TObject);
// Set application title and show the info-message
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how to work with selections and how the methods LoadFromClipboard and SaveToClipboard can be used.' + #13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'+ #13#13 +
   'http://www.beyersdorf.com/');
end;

end.
