unit Demo08F;
//
// PixelGraphicLibrary - Demo 8
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         PGraphic, Menus;

type
   TForm1 = class (TForm)
      PGImage1: TPGImage;
      PGImage2: TPGImage;
      MainMenu1: TMainMenu;
      File1: TMenuItem;
      Open1: TMenuItem;
      PGOpenDialog1: TPGOpenDialog;
      Info1: TMenuItem;
      procedure Open1Click(Sender: TObject);
      procedure FormCreate(Sender: TObject);
      procedure Changed(Sender: TObject);
      procedure Info1Click(Sender: TObject);
      procedure PGImage2PicBoxOnMouseDown(Sender: TObject; Button: TMouseButton;
            Shift: TShiftState; X, Y: Integer);
   private
      { Private-Deklarationen }
      XDest: Integer; // last horizontal position of MouseDown in right graphic
      YDest: Integer; // last horizontal position of MouseDown in left graphic
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
if PGOpenDialog1.Execute then
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
PGImage2.TakePixelGraphic(TPixelGraphic.Create);
PGImage2.PixelGraphic.SetDimension(300, 300, bc24);
Changed(Self);
Info1Click(Self);
end;

procedure TForm1.Changed(Sender: TObject);
begin
PGImage2.PixelGraphic.Erase;
PGImage2.PixelGraphic.DrawRect(
   XDest, YDest, PGImage1.SelectionWidth, PGImage1.SelectionHeight,
   PGImage1.SelectionLeft, PGImage1.SelectionTop,
   PGImage1.LendNoModifyPixelGraphic);
end;

procedure TForm1.PGImage2PicBoxOnMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
XDest := X;
YDest := Y;
Changed(Self);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of the procedure TPixelGraphic.DrawRect.'#13#13 +
   'Please select an area in the left box and click on different positions the right box.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

end.

