unit Demo07F;
//
// PixelGraphicLibrary - Demo 7
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         PGraphic, Menus;

type
   TForm1 = class (TForm)
      PGImage2: TPGImage;
      MainMenu1: TMainMenu;
      File1: TMenuItem;
      Open1: TMenuItem;
      PGOpenDialog1: TPGOpenDialog;
      Info1: TMenuItem;
      Angle1: TMenuItem;
      RotateMode1: TMenuItem;
      rmFast1: TMenuItem;
      rmPrecise1: TMenuItem;
    PGImage1: TPGImage;
      procedure Open1Click(Sender: TObject);
      procedure FormCreate(Sender: TObject);
      procedure Changed(Sender: TObject);
      procedure Info1Click(Sender: TObject);
      procedure Angle1Click(Sender: TObject);
      procedure rmFast1Click(Sender: TObject);
      procedure rmPrecise1Click(Sender: TObject);
   private
      { Private-Deklarationen }
      Angle: Extended;
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
begin
if PGOpenDialog1.Execute then
   begin
   Update;
   PGImage1.LoadFromFile(PGOpenDialog1.FileName);
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var aPixelGraphic: TPixelGraphic;
begin
aPixelGraphic:=TPixelGraphic.Create;
aPixelGraphic.RotateMode:=rmFast;
PGImage2.PixelGraphic:=aPixelGraphic;
Angle := 45;
Changed(Self);
Info1Click(Self);
end;

procedure TForm1.Changed(Sender: TObject);
begin
PGImage2.PixelGraphic.Rotate(Angle, true, PGImage1.LendNoModifyPixelGraphic);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of the procedure Rotate.'#13#13 +
   'Please try different angles and different settings for RotateMode.'#13#13 +
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13 +
   'http://www.beyersdorf.com/');
end;

procedure TForm1.Angle1Click(Sender: TObject);
var AngleStr: string;
begin
AngleStr := FloatToStr(Angle);
if InputQuery('Rotation', 'Angle:', AngleStr) then
   begin
   Angle := StrToFloat(AngleStr);
   Update;
   Changed(Self);
   end;
end;

procedure TForm1.rmFast1Click(Sender: TObject);
begin
PGImage2.PixelGraphic.RotateMode := rmFast;
rmFast1.Checked := true;
Changed(Self);
end;

procedure TForm1.rmPrecise1Click(Sender: TObject);
begin
PGImage2.PixelGraphic.RotateMode := rmPrecise;
rmPrecise1.Checked := true;
Changed(Self);
end;

end.

