unit Demo06F;
//
// PixelGraphicLibrary - Demo 5
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//
interface
uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         PGraphic, Menus;

type
   TForm1 = class (TForm)
      PGImage1: TPGImage;
      PGImage2: TPGImage;
      MainMenu1: TMainMenu;
      File1: TMenuItem;
      Open1: TMenuItem;
      PGOpenDialog1: TPGOpenDialog;
      Info1: TMenuItem;
      Angle1: TMenuItem;
      RotateMode1: TMenuItem;
      rmFast1: TMenuItem;
      rmPrecise1: TMenuItem;
      procedure Open1Click(Sender: TObject);
      procedure FormCreate(Sender: TObject);
      procedure Changed(Sender: TObject);
      procedure Info1Click(Sender: TObject);
      procedure PGImage2PicBoxOnMouseDown(Sender: TObject; Button: TMouseButton;
            Shift: TShiftState; X, Y: Integer);
      procedure Angle1Click(Sender: TObject);
      procedure rmFast1Click(Sender: TObject);
      procedure rmPrecise1Click(Sender: TObject);
   private
      { Private-Deklarationen }
      Angle: Extended;
      XDest: Integer;
      YDest: Integer;
   public
      { Public-Deklarationen }
   end;

var
   Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.Open1Click(Sender: TObject);
   begin
   if PGOpenDialog1.Execute then
      begin
      PGImage1.LoadFromFile(PGOpenDialog1.FileName);
      end;
   end;

procedure TForm1.FormCreate(Sender: TObject);
   begin
   PGImage2.TakePixelGraphic(TPixelGraphic.Create);
   PGImage2.PixelGraphic.SetDimension(280,280,bc24);
   Angle := 45;
   XDest := 140;
   YDest := 140;
   Changed(Self);
   Info1Click(Self);
   end;

procedure TForm1.Changed(Sender: TObject);
begin
PGImage2.LendPixelGraphic.Erase;
PGImage2.LendPixelGraphic.RotateRect(Angle, XDest, YDest,
   PGImage1.SelectionLeft + PGImage1.SelectionWidth div 2,
   PGImage1.SelectionTop + PGImage1.SelectionHeight div 2,
   PGImage1.SelectionLeft, PGImage1.SelectionTop,
   PGImage1.SelectionWidth, PGImage1.SelectionHeight,
   PGImage1.LendNoModifyPixelGraphic);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This demonstrates the use of the procedure RotateRect.'#13#13+
   'Please load a picture and select an area in the left box and click on different positions the right box. Play with different settings for RotateMode and different angles.'#13#13+
   'http://www.beyersdorf.com/');
end;

procedure TForm1.PGImage2PicBoxOnMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
   begin
   XDest := X;
   YDest := Y;
   Changed(Self);
   end;

procedure TForm1.Angle1Click(Sender: TObject);
   var
      AngleStr: string;

   begin
   AngleStr := FloatToStr(Angle);
   if InputQuery('Rotation', 'Angle:', AngleStr) then
      try
         try
            Angle := StrToFloat(AngleStr);
         except
         end;
      finally
         Changed(Self);
      end;
   end;

procedure TForm1.rmFast1Click(Sender: TObject);
   begin
   PGImage2.LendPixelGraphic.RotateMode := rmFast;
   rmFast1.Checked := true;
   Changed(Self);
   end;

procedure TForm1.rmPrecise1Click(Sender: TObject);
   begin
   PGImage2.LendPixelGraphic.RotateMode := rmPrecise;
   rmPrecise1.Checked := true;
   Changed(Self);
   end;
end.

