unit Demo03F;
//
// PixelGraphicLibrary - Demo 3
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PGOpenDialog1: TPGOpenDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Filter1: TMenuItem;
    Info1: TMenuItem;
    RGB1: TMenuItem;
    CMY1: TMenuItem;
    YCbCr1: TMenuItem;
    HLS1: TMenuItem;
    HSV1: TMenuItem;
    BCG1: TMenuItem;
    Grayscale1: TMenuItem;
    Negative1: TMenuItem;
    Sharpen1: TMenuItem;
    Detail1: TMenuItem;
    Smooth1: TMenuItem;
    Blur1: TMenuItem;
    Contour1: TMenuItem;
    PGImage1: TPGImage;
    RGBFilterDialog1: TRGBFilterDialog;
    CMYFilterDialog1: TCMYFilterDialog;
    YCbCrFilterDialog1: TYCbCrFilterDialog;
    HLSFilterDialog1: THLSFilterDialog;
    HSVFilterDialog1: THSVFilterDialog;
    GrayScaleFilterDialog1: TGrayScaleFilterDialog;
    NegativeFilterDialog1: TNegativeFilterDialog;
    BCGFilterDialog1: TBCGFilterDialog;
    SharpenFilterDialog1: TSharpenFilterDialog;
    DetailFilterDialog1: TDetailFilterDialog;
    SmoothFilterDialog1: TSmoothFilterDialog;
    StatusBar1: TStatusBar;
    BlurFilterDialog1: TBlurFilterDialog;
    ContourFilterDialog1: TContourFilterDialog;
    Language1: TMenuItem;
    English1: TMenuItem;
    German1: TMenuItem;
    French1: TMenuItem;
    Dutch1: TMenuItem;
    Spanish1: TMenuItem;
    procedure RGB1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure CMY1Click(Sender: TObject);
    procedure YCbCr1Click(Sender: TObject);
    procedure HLS1Click(Sender: TObject);
    procedure HSV1Click(Sender: TObject);
    procedure Negative1Click(Sender: TObject);
    procedure Grayscale1Click(Sender: TObject);
    procedure BCG1Click(Sender: TObject);
    procedure Sharpen1Click(Sender: TObject);
    procedure Detail1Click(Sender: TObject);
    procedure Smooth1Click(Sender: TObject);
    procedure PGImage1PixelGraphicProgressEnd(Sender: TObject);
    procedure PGImage1PixelGraphicProgress(Sender: TObject; Step,
      Max: Integer; var Abort: Boolean);
    procedure PGImage1PixelGraphicProgressStart(Sender: TObject);
    procedure Blur1Click(Sender: TObject);
    procedure Contour1Click(Sender: TObject);
    procedure English1Click(Sender: TObject);
    procedure German1Click(Sender: TObject);
    procedure French1Click(Sender: TObject);
    procedure Dutch1Click(Sender: TObject);
    procedure Spanish1Click(Sender: TObject);
  private
    { Private declarations }
    LastStatusBarUpdate: Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.Open1Click(Sender: TObject);
begin
PGOpenDialog1.FileName:=PGImage1.FileName;
if PGOpenDialog1.Execute then
   begin
   Update;
   PGImage1.KeepOldPaintPixelGraphic:=false;
   PGImage1.FileName:=PGOpenDialog1.FileName;
   PGImage1.KeepOldPaintPixelGraphic:=true;
   end;
end;


procedure TForm1.RGB1Click(Sender: TObject);
begin
if RGBFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(RGBFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.CMY1Click(Sender: TObject);
begin
if CMYFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(CMYFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.YCbCr1Click(Sender: TObject);
begin
if YCbCrFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(YCbCrFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.HLS1Click(Sender: TObject);
begin
if HLSFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(HLSFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.HSV1Click(Sender: TObject);
begin
if HSVFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(HSVFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.Negative1Click(Sender: TObject);
begin
if NegativeFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(NegativeFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.Grayscale1Click(Sender: TObject);
begin
if GrayScaleFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(GrayScaleFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.BCG1Click(Sender: TObject);
begin
if BCGFilterDialog1.Execute(PGImage1.PixelGraphic) then
   begin
   Update;
   PGImage1.PixelGraphic.ApplyFilter(BCGFilterDialog1.Filter, PGImage1.PixelGraphic);
   end;
end;

procedure TForm1.Sharpen1Click(Sender: TObject);
var aPixelGraphic: TPixelGraphic;
begin
if SharpenFilterDialog1.Execute then
   begin
   Update;
   aPixelGraphic:=TPixelGraphic.Create;
   aPixelGraphic.OnProgressStart:=PGImage1PixelGraphicProgressStart;
   aPixelGraphic.OnProgress:=PGImage1PixelGraphicProgress;
   aPixelGraphic.OnProgressEnd:=PGImage1PixelGraphicProgressEnd;
   aPixelGraphic.ApplyFilter(SharpenFilterDialog1.Filter, PGImage1.PixelGraphic);
   PGImage1.PixelGraphic:=aPixelGraphic;
   end;
end;

procedure TForm1.Detail1Click(Sender: TObject);
var aPixelGraphic: TPixelGraphic;
begin
if DetailFilterDialog1.Execute then
   begin
   Update;
   aPixelGraphic:=TPixelGraphic.Create;
   aPixelGraphic.OnProgressStart:=PGImage1PixelGraphicProgressStart;
   aPixelGraphic.OnProgress:=PGImage1PixelGraphicProgress;
   aPixelGraphic.OnProgressEnd:=PGImage1PixelGraphicProgressEnd;
   aPixelGraphic.ApplyFilter(DetailFilterDialog1.Filter, PGImage1.PixelGraphic);
   PGImage1.PixelGraphic:=aPixelGraphic;
   end;
end;

procedure TForm1.Smooth1Click(Sender: TObject);
var aPixelGraphic: TPixelGraphic;
begin
if SmoothFilterDialog1.Execute then
   begin
   Update;
   aPixelGraphic:=TPixelGraphic.Create;
   aPixelGraphic.OnProgressStart:=PGImage1PixelGraphicProgressStart;
   aPixelGraphic.OnProgress:=PGImage1PixelGraphicProgress;
   aPixelGraphic.OnProgressEnd:=PGImage1PixelGraphicProgressEnd;
   aPixelGraphic.ApplyFilter(SmoothFilterDialog1.Filter, PGImage1.PixelGraphic);
   PGImage1.PixelGraphic:=aPixelGraphic;
   end;
end;

procedure TForm1.Blur1Click(Sender: TObject);
var aPixelGraphic: TPixelGraphic;
begin
if BlurFilterDialog1.Execute then
   begin
   Update;
   aPixelGraphic:=TPixelGraphic.Create;
   aPixelGraphic.OnProgressStart:=PGImage1PixelGraphicProgressStart;
   aPixelGraphic.OnProgress:=PGImage1PixelGraphicProgress;
   aPixelGraphic.OnProgressEnd:=PGImage1PixelGraphicProgressEnd;
   aPixelGraphic.ApplyFilter(BlurFilterDialog1.Filter, PGImage1.PixelGraphic);
   PGImage1.PixelGraphic:=aPixelGraphic;
   end;
end;

procedure TForm1.Contour1Click(Sender: TObject);
var aPixelGraphic: TPixelGraphic;
begin
if ContourFilterDialog1.Execute then
   begin
   Update;
   aPixelGraphic:=TPixelGraphic.Create;
   aPixelGraphic.OnProgressStart:=PGImage1PixelGraphicProgressStart;
   aPixelGraphic.OnProgress:=PGImage1PixelGraphicProgress;
   aPixelGraphic.OnProgressEnd:=PGImage1PixelGraphicProgressEnd;
   aPixelGraphic.ApplyFilter(ContourFilterDialog1.Filter, PGImage1.PixelGraphic);
   PGImage1.PixelGraphic:=aPixelGraphic;
   end;
end;

procedure TForm1.PGImage1PixelGraphicProgressEnd(Sender: TObject);
begin
StatusBar1.SimpleText:='';
end;

procedure TForm1.PGImage1PixelGraphicProgress(Sender: TObject; Step,
  Max: Integer; var Abort: Boolean);
begin
// Avoid division by zero.
// And avoid loosing to much time redrawing the StatusBar, so we update
// the info only if the last update was more then 1/20 second ago.
if (Max>0) and (GetTickCount-LastStatusBarUpdate>50) then
   begin
   StatusBar1.SimpleText:=IntToStr(Step*100 div Max)+'%';
   StatusBar1.Update;
   LastStatusBarUpdate:=GetTickCount;
   end;
end;

procedure TForm1.PGImage1PixelGraphicProgressStart(Sender: TObject);
begin
LastStatusBarUpdate:=0;
end;
                           
procedure TForm1.Info1Click(Sender: TObject);
begin
Application.Title:=Caption;
ShowMessage(
   'This should demonstrate how to use the PixelGraphicLibrary'#39's filter '+
   'dialogs and how the language of the filter dialog can be changed at runtime!'#13#13 +
   'Note: Have a look at FAQ032 if you need to translate the text of the filter dialogs to a language not listed.'#13#13+
   ' Copyright 1996-1998 Peter Beyersdorf, Germany'#13#13+
   'http://www.beyersdorf.com/');
end;

procedure TForm1.English1Click(Sender: TObject);
begin
PGLanguage:=pglEnglish;
English1.Checked:=true;
end;

procedure TForm1.German1Click(Sender: TObject);
begin
PGLanguage:=pglGerman;
German1.Checked:=true;
end;

procedure TForm1.French1Click(Sender: TObject);
begin
PGLanguage:=pglFrench;
French1.Checked:=true;
end;

procedure TForm1.Dutch1Click(Sender: TObject);
begin
PGLanguage:=pglDutch;
Dutch1.Checked:=true;
end;

procedure TForm1.Spanish1Click(Sender: TObject);
begin
PGLanguage:=pglSpanish;
Spanish1.Checked:=true;
end;

end.
