unit Demo02F2;
//
// PixelGraphicLibrary - Demo 2
// Version: 1.0 beta 5 for Delphi 2 and Delphi 3
// Copyright  1996-1998 Peter Beyersdorf, Lbeck, Germany
// http://www.beyersdorf.com/
//

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGraphic, Menus, StdCtrls, ComCtrls, ExtCtrls, Demo02F3, Demo02U4;

type
  TForm2 = class(TForm)
    MainMenu1: TMainMenu;
    Info1: TMenuItem;
    PGImage1: TPGImage;
    ListBox1: TListBox;
    PGGroupBox1: TPGGroupBox;
    PGRadioButton1: TPGRadioButton;
    PGRadioButton2: TPGRadioButton;
    PGRadioButton3: TPGRadioButton;
    PGRadioButton4: TPGRadioButton;
    PGRadioButton5: TPGRadioButton;
    PGCheckBox1: TPGCheckBox;
    PGCheckBox2: TPGCheckBox;
    PGCheckBox3: TPGCheckBox;
    PGLabel1: TPGLabel;
    PGLabel2: TPGLabel;
    Button1: TButton;
    procedure Info1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure PGRadioButton1Click(Sender: TObject);
    procedure PGRadioButton2Click(Sender: TObject);
    procedure PGRadioButton3Click(Sender: TObject);
    procedure PGRadioButton4Click(Sender: TObject);
    procedure PGRadioButton5Click(Sender: TObject);
    procedure PGCheckBox1Click(Sender: TObject);
    procedure PGCheckBox2Click(Sender: TObject);
    procedure PGCheckBox3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.FormCreate(Sender: TObject);
var
   SearchRec: TSearchRec;
   Result: Integer;
begin
// Fill ListBox1 with the names of all DemoBk*.jpg files which can be found.
Result := FindFirst('DemoBk*.jpg', faArchive, SearchRec);
while Result = 0 do
   begin
   ListBox1.Items.Add(SearchRec.Name);
   Result := FindNext(SearchRec);
   end;
FindClose(SearchRec);
ListBox1.ItemIndex:=0;
ListBox1Click(Self);
end;

procedure TForm2.ListBox1Click(Sender: TObject);
// This code set a new background when a entry of the listbox is clicked.
// You won't need all this, if you choose one background image for your
// application.

var
   aColor: TColor;
begin
PGImage1.Filename:=ListBox1.Items[ListBox1.ItemIndex];
// Find out if white or black is the better color for fonts on the new background.
aColor:=PGImage1.LendNoModifyPixelGraphic.AverageColor;
// The eye is most sensible to green and it is more sensible to red than to blue.
// The 6 is the sum of the red, green and blue weights. The treshold 164 seems to give a good result.
if 2*GetRValue(aColor)+3*GetGValue(aColor)+GetBValue(aColor)<6*164 then
   Font.Color:=clWhite
else
   Font.Color:=clBlack;
end;

procedure TForm2.PGRadioButton1Click(Sender: TObject);
begin
PGImage1.Tiling:=tNone;
end;

procedure TForm2.PGRadioButton2Click(Sender: TObject);
begin
PGImage1.Tiling:=tRepeat;
end;

procedure TForm2.PGRadioButton3Click(Sender: TObject);
begin
PGImage1.Tiling:=tMirrorHorizontal;
end;

procedure TForm2.PGRadioButton4Click(Sender: TObject);
begin
PGImage1.Tiling:=tMirrorVertical;
end;

procedure TForm2.PGRadioButton5Click(Sender: TObject);
begin
PGImage1.Tiling:=tMirror;
end;

procedure TForm2.PGCheckBox1Click(Sender: TObject);
begin
PGImage1.Center:=PGCheckBox1.Checked;
end;

procedure TForm2.PGCheckBox2Click(Sender: TObject);
begin
PGImage1.FlipHorizontal:=PGCheckBox2.Checked;
end;

procedure TForm2.PGCheckBox3Click(Sender: TObject);
begin
PGImage1.FlipVertical:=PGCheckBox3.Checked;
end;

procedure TForm2.Button1Click(Sender: TObject);
var
   Form3: TForm3;
   aPixelGraphic: TPixelGraphic;
begin
Form3:=TForm3.Create(Self);
try
   aPixelGraphic:=TPixelGraphic.Create;
   aPixelGraphic.LoadFromResourceName(HInstance, 'COLORBALL');
   Form3.PGImage1.PixelGraphic:=aPixelGraphic; // same like TakePixelGraphic
   Form3.ShowModal;
finally
   Form3.Free;
end;
end;

procedure TForm2.Info1Click(Sender: TObject);
begin
ShowInfo;
end;

end.
