{PE Workshop v.1.2 Copyright (C) 1999-2000 Andrei Glinski.}

{main program}

unit MAIN;
{$IOCHECKS Off} { <-- on or off, it'll crash anyway}
interface

uses
Windows, SysUtils, Classes, Controls, Forms, Dialogs,
ComCtrls, Menus, ExtCtrls, StdCtrls, Grids, inifiles,CNV,sdel,dead;

type
  TFRM = class(TForm)
{Note: not all existing in the .dfm controls are
declared here, only referenced ones. This makes the .exe
a few kilobytes smaller.}
    MM: TMainMenu;
    RG_HEX: TRadioGroup;
    RG_VXD: TRadioGroup;
    TV: TTreeView;
    OD: TOpenDialog;
    SD: TSaveDialog;
    NB: TNotebook;
    NB_HDR: TNotebook;
    B_IS: TButton;
    M_EXIT: TMenuItem;
    M_SAS: TMenuItem;
    M_FO: TMenuItem;
    m_cfg: TMenuItem;
    i01: TCheckBox;
    i09: TCheckBox;
    i13: TCheckBox;
    i00: TCheckBox;
    i02: TCheckBox;
    i03: TCheckBox;
    i06: TCheckBox;
    i07: TCheckBox;
    D00: TCheckBox;
    d01: TCheckBox;
    d02: TCheckBox;
    d03: TCheckBox;
    i08: TCheckBox;
    i10: TCheckBox;
    i12: TCheckBox;
    i15: TCheckBox;
    i04: TCheckBox;
    i05: TCheckBox;
    i11: TCheckBox;
    i14: TCheckBox;
    SG_DIR: TStringGrid;
    SG_SEC: TStringGrid;
    L_SecName: TLabel;
    LIF: TLabel;
    S03: TCheckBox;
    s06: TCheckBox;
    s07: TCheckBox;
    S08: TCheckBox;
    s12: TCheckBox;
    s11: TCheckBox;
    s10: TCheckBox;
    S26: TCheckBox;
    s27: TCheckBox;
    s28: TCheckBox;
    s29: TCheckBox;
    s30: TCheckBox;
    s13: TCheckBox;
    s31: TCheckBox;
    S32: TCheckBox;
    M_RR: TMenuItem;
    M_CNV: TMenuItem;
    m_check: TMenuItem;
    M_CLOSE: TMenuItem;
    m_scfg: TMenuItem;
    SG_imp: TStringGrid;
    SG_EXP: TStringGrid;
    SG_idt: TStringGrid;
    e_SecFlg: TEdit;
    E_DLLF: TEdit;
    E_FLAGS: TEdit;
    E_IS: TEdit;
    E_SR: TEdit;
    E_SC: TEdit;
    E_HR: TEdit;
    E_HC: TEdit;
    E_OSH: TEdit;
    E_OSL: TEdit;
    E_LH: TEdit;
    E_LL: TEdit;
    E_UH: TEdit;
    E_UL: TEdit;
    E_SSH: TEdit;
    E_SSL: TEdit;
    E_TIME: TEdit;
    E_NUMD: TEdit;
    E_NUMS: TEdit;
    E_NT: TEdit;
    E_EP: TEdit;
    E_SUM: TEdit;
    B_NT: TButton;
    E_MAG: TEdit;
    E_CPU: TEdit;
    E_SS: TEdit;
    E_CS: TEdit;
    E_ID: TEdit;
    E_HS: TEdit;
    B_HS: TButton;
    E_UD: TEdit;
    E_LDF: TEdit;
    E_DB: TEdit;
    E_CB: TEdit;
    E_IB: TEdit;
    E_ExpFlg: TEdit;
    E_etime: TEdit;
    E_EVH: TEdit;
    e_NRVA: TEdit;
    E_eob: TEdit;
    E_NumEAT: TEdit;
    E_NumName: TEdit;
    E_nameRVA: TEdit;
    E_ORVA: TEdit;
    E_EVL: TEdit;
    E_ATRVA: TEdit;
    E_resflg: TEdit;
    E_rtime: TEdit;
    E_rver: TEdit;
    E_RNamed: TEdit;
    E_Rid: TEdit;
    B_FA: TButton;
    M_REFR: TMenuItem;
    m_font: TMenuItem;
    M_SAVE: TMenuItem;
    cb_sum: TCheckBox;
    m_def: TMenuItem;
    m_vxd: TMenuItem;
    m_st: TMenuItem;
    LF0: TCheckBox;
    LF1: TCheckBox;
    mc_sec: TPopupMenu;
    m_savesec: TMenuItem;
    m_loadsec: TMenuItem;
    m_delsec: TMenuItem;
    m_rmsec: TMenuItem;
    m_adds: TMenuItem;
    FD: TFontDialog;
    m_addb: TMenuItem;
    m_adda: TMenuItem;
    mc_imp: TPopupMenu;
    m_oall: TMenuItem;
    m_othis: TMenuItem;
    m_nall: TMenuItem;
    m_nthis: TMenuItem;
    m_txtv: TMenuItem;
    m_txtl: TMenuItem;
    m_txts: TMenuItem;
    m_txtas: TMenuItem;
    m_sig: TMenuItem;
    m_dead: TMenuItem;
    m_exp: TMenuItem;
    m_shex: TMenuItem;
    m_sdec: TMenuItem;
    GB: TGroupBox;
    m_virt: TMenuItem;
    B_SUM: TButton;
    mc_dir: TPopupMenu;
    m_assec: TMenuItem;
    m_dhex: TMenuItem;
    m_ddec: TMenuItem;
    E_OA: TEdit;
    m_phys: TMenuItem;
    m_impf: TMenuItem;
    FDLG: TFindDialog;
    HC: THeaderControl;
    E_FA: TEdit;
    memo1: TMemo;
    mc_exp: TPopupMenu;
    m_find: TMenuItem;
    m_DPR: TMenuItem;
    M_ASCII: TMenuItem;
    M_UNI: TMenuItem;
    cb_adjcol: TCheckBox;
    m_txtf: TMenuItem;
    M_STN: TMenuItem;
    M_STM: TMenuItem;
    M_STS: TMenuItem;
    M_RO: TMenuItem;
    m_RW: TMenuItem;
    M_1251: TMenuItem;
    B_IB: TButton;
    M_DO: TMenuItem;
    m_rmovl: TMenuItem;
    m_ovls: TMenuItem;
    m_ovlmks: TMenuItem;
    procedure M_EXIT_C(Sender: TObject);
    procedure M_FO_C(Sender: TObject);
    procedure FCR(Sender: TObject);
    procedure m_switch(Sender: TObject);
    procedure FCQ(Sender: TObject; var CanClose: Boolean);
    procedure TV_C(Sender: TObject; Node: TTreeNode);
    procedure e_flags_c(Sender: TObject);
    procedure e_flags_ch(Sender: TObject);
    procedure B_HS_C(Sender:TObject);
    procedure EKD(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure e_dllf_ch(Sender: TObject);
    procedure e_dllf_c2(Sender: TObject);
    procedure e_secflg_c(Sender: TObject);
    procedure e_secflg_ch(Sender: TObject);
    procedure M_CNV_C(Sender: TObject);
    procedure m_check_c(Sender: TObject);
    procedure m_savesec_c(Sender: TObject);
    procedure m_loadsec_c(Sender: TObject);
    procedure m_delsec_c(Sender: TObject);
    procedure M_CLOSE_C(Sender: TObject);
    procedure m_scfg_c(Sender: TObject);
    procedure B_NT_C(Sender: TObject);
    procedure B_FA_C(Sender: TObject);
    procedure mc_dir_pop(Sender: TObject);
    procedure as_sec(sender:tobject);
    procedure SGK(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SGE(Sender: TObject);
    procedure m_font_c(Sender: TObject);
    procedure m_rmsec_c(Sender: TObject);
    procedure m_txtl_c(Sender: TObject);
    procedure m_txts_c(Sender: TObject);
    procedure m_txtas_c(Sender: TObject);
    procedure B_IS_C(Sender: TObject);
    procedure M_SAVE_C(Sender: TObject);
    procedure m_def_c(Sender: TObject);
    procedure m_vxd_c(Sender: TObject);
    procedure M_REFR_C(Sender:TObject);
    procedure e_ldf_c(Sender: TObject);
    procedure e_ldf_ch(Sender: TObject);
    procedure m_addsec_c(Sender: TObject);
    procedure m_exp_c(Sender: TObject);
    procedure M_RW_C(Sender: TObject);
    procedure m_sig_c(Sender: TObject);
    procedure m_dead_c(Sender: TObject);
    procedure col_mode(Sender:TObject);
    procedure m_virt_c(Sender: TObject);
    procedure B_SUM_C(Sender: TObject);
    procedure m_phys_c(Sender: TObject);
    procedure m_txtf_c(Sender: TObject);
    procedure find(Sender: TObject);
    procedure M_SAS_C(Sender: TObject);
    procedure SRS(HeaderControl: THeaderControl; Section: THeaderSection);
    procedure M_STM_C(Sender: TObject);
    procedure M_STN_C(Sender:TObject);
    procedure M_STS_C(Sender:TObject);
    procedure m_dpr_c(Sender:TObject);
    procedure FINDS(Sender:TObject);
    procedure M_RR_C(Sender:TObject);
    procedure B_IB_C(Sender: TObject);
    procedure to_named(Sender: TObject);
    procedure to_ord(Sender: TObject);
    procedure M_DO_C(Sender: TObject);
    procedure m_rmovl_c(Sender: TObject);
    procedure m_ovls_c(Sender: TObject);
    procedure m_ovlmks_c(Sender: TObject);
  public
    PROCEDURE ERRPROC(Sender:TObject;E:Exception);
  end;

 TExportInfo=record
     RVA:Integer;
     NamePtr:Integer;{RVA}
     Ordinal:word;
     Name:string;
     end;

 TDataArray=array[0..10000000] of byte;

{info about an imported dll}
 TImpDLLInfo=record
     iFuncs:Integer; {index of 1st function}
     numFuncs:byte;
     name:string; {dll name}
     end;

{info about an imported function}
 TImpFuncInfo=record
     NameRVA:Integer; {func. hint-name rva/ordinal}
     Addr:Integer; {func. VA}
     ByOrdinal:boolean;
     hint:word;
     name:string; {func. name}
     end;

{treeview info}
 TTVinfo=record
  page:Integer;
  data:Integer;
  end;

{$INCLUDE EXEFMT32.INC}

{not all the functions are declared here}
 function getbit(CONST Num:Integer;CONST Idx:byte):boolean;
 Function StrToIntEx(const S:string):Integer;
 function HexAsmToPas(CONST s:string):string;
 function RVA2Offset(CONST RVA:Integer):Integer;
 function offset2RVA(CONST Offset:Integer):Integer;
 function ReadPchar(f_offset:Integer):string;
 function IntToStrEx(CONST intNum:Integer;CONST nDigits:byte):string;
 function GetOwnerSection(CONST d_index:Integer):Integer;
 function DescribeDir(CONST d_index:Integer):string;
 function PhysSz(CONST sec_idx:Integer):Integer;
 procedure StatusMode;
 function alignVal(CONST num:Integer;CONST alignf:Integer):Integer;
 function SecPSize(CONST sec_idx:Integer):Integer;
 function DescribeSec(CONST sec_idx:Integer):string;
 procedure AssignExe;
 PROCEDURE STATUS(CONST S:STRING);
 PROCEDURE NBPI(CONST I:Integer);

{Program limitations are in the array declarations.
Increase numbers if not enough, more memory
will be eaten however.}

{Upper and lower case helped me to distinguish recently written code
and old stuff. It is not just to make it look worse.}

{Code that needs attention is marked !!! or FIXME}

var
  FRM:TFRM;
  exefile, {this identifies the opened exe file}
  tempfile:file; {used for various operations.}
  ft:textfile; {we do some text operations also}
  MZ:mzhdr; {DOS header}
  PE:pehdr; {PE header - not all structures, see type definition}
  EDT:PEExportDirTable;
  iDT:array[1..80] of peidte{PE import dir entry};
  EDToffset, {offset to EDT}
  rdtoffset, {offset to resource directory}
  iDTOffset, {offset to IDT}
  IDTSize, {idt entries count, # of used dlls}
  cur_sec, {identifies currently selected section}
{I need these global for one asm statement}
  jaw,jaw2:Integer; {Just Another (d)Word-type variable}
  PData:^TDataArray; {it's a temp buffer}
  exefn, {keeps opened exe name}
  sss, {temporary}
  exportdll:string;
  f_open, {file is open}
  disable_ctl, {disable some event handlers}
  IsPE:boolean; {true if current file is PE}
  INI:tinifile; {for inifile operations}
  TVI:array[0..100]of ttvinfo; {TreeView Info}
  impDLLs:array[1..80] of TImpDllInfo; {imported dlls}
  impFuncs:array[1..1500] of TImpFuncInfo;
      {imported functions of all imported dlls.}
  SEC:array[1..30] of PEOBJTABLEREC; {sections}
  dirs:array[1..20] of PEdirectory; {directories}
  Exportz:array[1..2000] of TExportInfo; {exported functions}
  resDir:ARRAY[0..100]OF perdt;
  ResTree:array[1..100] of perestree;

const
{$INCLUDE STUB.INC} {mini dos stub}
  TMPname='$$PEW$$.TMP'; {temp file. will be owerwritten!}
{window position entries in win.ini}
  zLeft:ansistring='L';
  zTop:ansistring='T';
  zHeight:ansistring='H';
  zWidth:ansistring='W';
{section name in win.ini}
  zIniSec:ansistring='PE Workshop';

{frequently used strings}
  zName='Name';
  zrva='RVA';
  zflags='Flags';
  zVxdCFG='\PEW_VXD.CFG';
  zExpCfg:ansistring='\EXPORTS.CFG';
  zOrd='Ordinal';

implementation
{$R *.DFM}

{==== EXCEPTION HANDLER ====}
PROCEDURE TFRM.ERRPROC(Sender:TObject; E:Exception);
BEGIN
{redirect annoying messageboxes about excepions to status line}
STATUS(E.MESSAGE);
END;

{==== e.g. 0xFFFF to $FFFF ====}
function HexAsmToPas(CONST s:string):string;
begin
if copy(s,1,2)='0x' then RESULT:='$'+copy(s,3,length(s)-2)
else if s[length(s)]='h' then
    RESULT:='$'+copy(s,1,length(s)-1)
    else RESULT:=s;
end;

{==== extended StrToInt ====}
Function StrToIntEx(const S:string):Integer;
begin
  try
	RESULT:=strtoint(hexasmtopas(s))
  except
	RESULT:=0;
  end;
end;

{==== Extended IntToStr ====}
function IntToStrEx(CONST intNum:Integer;CONST nDigits:byte):string;
VAR S1:STRING;
begin
S1:=inttohex(intnum,nDigits);
case FRM.rg_hex.itemindex of
	0:RESULT:='$'+S1;
	1:RESULT:='0x'+S1;
	2:RESULT:='0'+S1+'h';
	3:RESULT:=inttostr(intNum);
	end;
end;

{==== Delphi should have such function ====}
function getbit(CONST Num:Integer;CONST Idx:byte):boolean;assembler;
asm
bt num,idx
setb @result
end;

{==== case insensitive pos() ====}
function fPOS(src:pchar;scmp:pchar):Integer;assembler;
{should be fast enough for 486dx-40}
asm
push esi
push edi
   push src
   xor ecx,ecx
   mov esi,scmp
   push esi
@@lcase:
   mov al,[esi]
   cmp al,0
   jz @@gogetit
   or al,$20
   mov [esi],al
   inc esi
   inc ecx
   jmp @@lcase
@@gogetit:
   pop edi
   pop esi
   push esi
   mov edx,ecx
@@scan:
   lodsb
   cmp al,0
   jz @@out_0 {not found}
   or al,$20
   cmp al,[edi]
   jz @@nextb
   mov eax,edx
   sub eax,ecx
   sub edi,eax
   sub esi,eax
   mov ecx,edx
   jmp @@scan
@@nextb:
   dec ecx
   jz @@out_1 {found}
   inc edi
   jmp @@scan
@@out_0:
   pop eax
   mov @result,0
   jmp @@ret
@@out_1:
   mov edi,esi
   pop eax
   sub esi,eax
   sub esi,edx
   inc esi
   mov @result,esi
   mov esi,edi
   mov al,$1f
@@right:
   inc esi
   cmp al,[esi]
   jb @@right
   mov byte [esi],0
   sub edi,edx
@@left:
   dec edi
   cmp al,[edi]
   jb @@left
   inc edi
   mov jaw2,edi
@@ret:
pop edi
pop esi
end;

{==== allocate memory for temp buffer ====}
procedure getmempdata(sz:Integer);
begin
getmem(pdata,sz);
end;

{==== deallocate temp buffer ====}
procedure disposepdata;
begin
dispose(pdata);
{I use dispose, but there are other suchlike functions.
I don't know which is correct to use there.}
end;

{==== returns num, aligned by the factor alignf ====}
function alignVal(CONST num:Integer;CONST alignf:Integer):Integer;
begin
if frac(num/alignf)<>0 then RESULT:=trunc(num/alignf+1)*alignf
   else RESULT:=num;
end;

{==== min ====}
function MINVAL(CONST X,Y:Integer):Integer;
BEGIN
IF X>Y THEN RESULT:=Y ELSE RESULT:=X;
END;

{==== returns estimated PhysicalSize ====}
function SecPSize(CONST sec_idx:Integer):Integer;
begin
RESULT:=MINVAL(SeC[sec_idx].PSize,SeC[sec_idx].VSize);
end;

{==== textual section description ====}
function DescribeSec(CONST sec_idx:Integer):string;
begin
result:=sec[sec_idx].objectname+' ('+inttostr(sec_idx)+')';
end;

{==== describes resource ====}
{must be changed, because keeping resource descriptions
in array like restype is bad}
function describeRES(const RT:Integer):string;
begin
if ((rt>16) OR (RT<=0)) then result:=inttostrex(rt,8)
         else result:=restype[rt];
end;

{==== go to requested NoteBook PageIndex ====}
PROCEDURE NBPI(CONST I:Integer);
BEGIN
FRM.NB.PAGEINDEX:=I;
END;

procedure nbpiz;
begin
nbpi(0);
end;

procedure memo1beginupdate;
begin
WITH FRM DO
	BEGIN
	memo1.lines.beginupdate;
	memo1.clear;
	END;
NBPIz;
end;

procedure memo1EndUpdate;
begin
frm.memo1.lines.endupdate;
end;

{==== add line to memo ====}
procedure memo1add(const s:string);
begin
frm.memo1.lines.add(s);
end;

{==== load file to memo ====}
procedure memo1load(const fname:string);
begin
frm.memo1.lines.loadfromfile(fname);
end;

{==== disable event handling in TreeView for updating ====}
procedure disable_ops;
begin
disable_ctl:=true;
frm.TV.items.clear;
end;

{==== write to text file ====}
procedure writelnft(const s:string);
begin
writeln(ft,s);
end;

procedure assignft;
begin
assignfile(ft,frm.sd.filename);
rewrite(ft);
end;

procedure closeft;
begin
closefile(ft);
end;

procedure wininicreate;
begin
ini:=tinifile.create('WIN.INI');
end;

{==== e.g. pew_vxd.cfg --> c:\pewks\pew_vxd.cfg ====}
function InPewDir(const filename1:string):string;
begin
result:=extractfiledir(paramstr(0))+filename1;
end;

procedure OpenAndRereadExe;
begin
AssignExe;
frm.m_RR_c(nil);
end;

procedure AssignExe;
begin
assignfile(exefile,exefn);
filemode:=0;
if not (ofreadonly in frm.od.options) then filemode:=2;
try
reset(exefile,1);
finally end;
end;

{==== create temp file ====}
procedure assigntemp(const fn:string);
begin
assignfile(tempfile,fn);
rewrite(tempfile,1);
end;

{==== create temp file (r/o) ====}
procedure assignTempR;
begin
FILEMODE:=0;
ASSIGNFILE(TEMPFILE,frm.OD.FILENAME);
RESET(TEMPFILE,1);
end;

{==== create tempfile with default name ====}
procedure assignTMP;
begin
assigntemp(tmpname);
end;

{==== read section into buffer ====}
procedure ReadSec(sec_idx:Integer);
begin
seek(exefile,sec[sec_idx].Offset);
blockread(exefile,pdata^,sec[sec_idx].PSize,sec_idx);
end;

{==== find the end of non-zero data in buffer ====}
function InitData(sz:Integer):Integer;
begin
repeat dec(sz);
until ((pdata^[sz]<>0) or (sz=0));
RESULT:=sz;
end;

{==== clear buffer ====}
procedure clearPdata(const SZ:Integer);
begin
FILLCHAR(PDATA^,sz,0);
end;

{==== this value can change, so it is a function ====}
FUNCTION OBJTABLEOFFSET:Integer;
BEGIN
RESULT:=MZ.NEWHDROFFSET+PE.NTHDRSIZE+24
END;

{==== how much initialized data is in a section ? ====}
function initsec(CONST sec_idx:Integer):Integer;
var phsize:Integer;
begin
  phsize:=sec[sec_idx].PSize;
  IF phsize>0 THEN
	BEGIN
	getmempdata(phsize);
	readsec(sec_idx);
	RESULT:=initdata(phsize);INC(RESULT);
	disposepdata;
  end;
end;

{==== returns properly aligned physical size ====}
function PhysSz(CONST sec_idx:Integer):Integer;
begin
RESULT:=alignval(SecPSize(sec_idx),pe.filealign);
end;

function fsizetmp:Integer;
begin
result:=FILESIZE(TEMPFILE);
end;

function fsizexe:Integer;
begin
result:=filesize(exefile);
end;

{==== update left part of status line ====}
procedure StatusMode;
var ss:string;
begin
if filemode=0 then ss:='R  '
   else ss:='W  ';
FRM.HC.SectionS[0].text:=ss+inttostr(fsizexe);
end;

{==== put message in the status bar ====}
PROCEDURE STATUS(CONST S:STRING);
BEGIN
FRM.HC.SectionS[1].text:=S;
END;

{==== often used messages ====}
procedure sFound;
begin
STATUS('Found');
end;

procedure sNotFound;
begin
STATUS('Not found');
end;

procedure sReady;
begin
STATUS('Ready');
end;

PROCEDURE sTextSaved;
begin
STATUS('Text saved');
end;

PROCEDURE sNoOvl;
begin
STATUS('No overlay');
end;

{==== rva to file offset ====}
function RVA2Offset(CONST RVA:Integer):Integer;
var ji:Integer;
begin
ji:=0; {returns 0 if unknown}
repeat inc(ji);
until (ji>pe.numobjects) or
      ((RVA>=SeC[ji].rva)
      and (rva<SeC[ji].rva+MINVAL(sec[ji].vsize,sec[ji].Psize)));
if (ji>pe.numobjects) then RESULT:=0
   else RESULT:=SeC[ji].Offset+rva-SeC[ji].rva;
end;

{==== file offset to rva ====}
function offset2RVA(CONST Offset:Integer):Integer;
var ji:Integer;
begin
ji:=0; {returns 0 if unknown}
repeat inc(ji);
until (ji>pe.numobjects) or
      ((offset>=SeC[ji].Offset)
      and (offset<(SeC[ji].Offset+SeC[ji].PSize)));
if (ji>pe.numobjects) then RESULT:=0
   else RESULT:=offset-SeC[ji].Offset+SeC[ji].rva;
end;

{==== get number of a section that contains a directory ====}
function GetOwnerSection(CONST d_index:Integer):Integer;
var sect:Integer;
begin
sect:=0; {return 0 if no owner}
repeat inc(sect);
until (sect>pe.numobjects) or
      ((dirs[d_index].rva>=SeC[sect].rva)
      and (dirs[d_index].rva<SeC[sect].rva+SeC[sect].VSize));
if sect>pe.numobjects then RESULT:=0 {!!!}
   else RESULT:=sect;
end;

{==== read asciz string starting from file offset ====}
function ReadPchar(f_offset:Integer):string;
var block:array[1..200] of char;
begin
seek(exefile,f_offset);
blockread(exefile,block,50,f_offset);
RESULT:=pchar(@block);
end;

{==== return directory description ====}
function DescribeDir(CONST d_index:Integer):string;
VAR S1:STRING;
begin
S1:=inttostr(d_index)+')';
if d_index<14 then RESULT:=dirDescr[d_index]+'('+S1
else RESULT:='Reserved('+S1;
end;

procedure closexe;
begin
closefile(exefile);
end;

procedure CloseTemp;
begin
closefile(tempfile);
closexe;
try
  erase(exefile);
  rename(tempfile,EXEfn);
except erase(tempfile); {erase temp if failed}
  STATUS('File error');
end;
reset(exefile,1);
frm.m_RR_c(nil);
end;

{==== save main headers ====}
PROCEDURE SAVEMAINHDRS(var f:file);
BEGIN
seek(f,0);
blockwrite(f,mz,sizeof(mzhdr));
seek(f,mz.newhdroffset);
blockwrite(f,pe,sizeof(pehdr));
blockwrite(f,dirs,sizeof(pedirectory)*pe.numrvasizes);
seek(f,objtableoffset);
blockwrite(f,sec,sizeof(peobjtablerec)*pe.numobjects);
END;

{==== save all (supported) headers ====}
procedure SaveHDRs(var f:file);
begin
SAVEMAINHDRS(F);
if edtoffset>0 then
   begin
   seek(f,edtoffset);
   blockwrite(f,edt,sizeof(PEexportdirtable));
   end;
{FIXME: resource handling is not implemented}
{if rdtoffset>0 then
   begin
   seek(f,rdtoffset);
   blockwrite(f,resdir[0],sizeof(PERDT));
   end;}
   frm.m_rr_c(nil); {reread}
end;

procedure enablemenu(mode:byte);
{0 - disable all
 1 - enable generic (non-PE)
 2 - enable all}
{FIXME: should be also different for ro/rw opened file}
procedure enable(var m:tmenuitem);
    begin
     m.enabled:=boolean(mode);
    end;
begin
with frm do
Begin
{all}
enable(m_ascii);
enable(m_uni);
enable(m_1251);
enable(m_vxd);
enable(m_close);
enable(m_rw);
enable(m_ro);
{pe}
if mode=1 then mode:=0;
enable(m_rr);
enable(m_save);
enable(m_sas);
enable(m_cnv);
enable(m_st);

enable(m_rmovl);
enable(m_ovlmks);
enable(m_ovls);

enable(m_check);
enable(m_def);
enable(m_dpr);
enable(m_exp);
enable(m_sig);
enable(m_dead);
End;
end;

{==== initialize/refresh text in controls ====}
procedure tFRM.M_REFR_C(sender:tobject);
var node2,mynode:ttreenode;
    tvidx, {TVI counter}
    j1,j2:Integer; {temp}
begin
statusmode;
if ispe then
BEGIN
enablemenu(2);
disable_ops;
tvidx:=0;
caption:=hint+exefn;
mynode:=TV.items.add(TV.topitem,'Header');
mynode.data:=@tvi[0];
tvi[0].page:=1;
for J1:=0 to 5 do
begin
     mynode:=TV.items.addchild(TV.topitem,NB_hdr.pages.strings[J1]);
     inc(tvidx);tvi[tvidx].page:=1;
     mynode.data:=@tvi[tvidx];tvi[tvidx].data:=J1;
end;
{fill header data}
{general}
e_numd.text:=inttostr(pe.numrvasizes);
e_nums.text:=inttostr(pe.numobjects);
e_nt.text:=inttostrex(pe.nthdrsize,4);
e_EP.text:=inttostrex(pe.entrypointrva,8);
e_SUM.text:=inttostrex(pe.filechecksum,8);
e_mag.text:=inttostrex(pe.magicoptionalhdr,4);
e_hs.text:=inttostrex(pe.headersize,8);
{flags}
e_flags.text:=inttostrex(pe.flags,4);
{memory}
e_is.text:=inttostrex(pe.imagesize,8);
e_sr.text:=inttostrex(pe.stackreservesize,8);
e_sc.text:=inttostrex(pe.stackcommitsize,8);
e_hR.text:=inttostrex(pe.heapreservesize,8);
e_hC.text:=inttostrex(pe.heapcommitsize,8);
e_cs.text:=inttostrex(pe.codesize,8);
e_id.text:=inttostrex(pe.initdata,8);
e_ud.text:=inttostrex(pe.uninitdata,8);
{align}
e_ib.text:=inttostrex(pe.imagebase,8);
e_db.text:=inttostrex(pe.database,8);
e_cb.text:=inttostrex(pe.codebase,8);
e_oa.text:=inttostrex(pe.objectalign,8);
e_fa.text:=inttostrex(pe.filealign,8);
{versions}
e_cpu.text:=inttostrex(pe.cputype,4);
e_osh.text:=inttostr(pe.osmajor);
e_osl.text:=inttostr(pe.osminor);
e_lh.text:=inttostr(pe.lmajor);
e_ll.text:=inttostr(pe.lminor);
e_uh.text:=inttostr(pe.usermajor);
e_uL.text:=inttostr(pe.userminor);
e_time.text:=inttostrex(pe.timedate,8);
e_ssh.text:=inttostr(pe.subsysmajor);
e_ssL.text:=inttostr(pe.subsysminor);
e_ss.text:=inttostrex(pe.subsystem,4);
{dll flags}
e_ldf.text:=inttostrex(pe.loaderflags,8);
e_dllF.text:=inttostrex(pe.dllflags,4);

{directories}
mynode:=TV.items.add(TV.topitem,'Directories');
inc(tvidx);
mynode.data:=@tvi[tvidx];
tvi[tvidx].page:=2;
sg_Dir.rowcount:=pe.numrvasizes+1;
for J1:=1 to pe.numrvasizes do
    begin
    sg_Dir.cells[0,J1]:=describedir(J1);
    sg_Dir.cells[1,J1]:=inttostrex(dirs[J1].rva,8);
    sg_Dir.cells[2,J1]:=inttostrex(dirs[J1].size,8);
    end;

{sections}
mynode:=TV.items.add(TV.topitem,'Sections');
inc(tvidx);
mynode.data:=@tvi[tvidx];
tvi[tvidx].page:=3;tvi[tvidx].data:=mynode.absoluteindex;
sg_sec.rowcount:=pe.numobjects+1;
for J1:=1 to pe.numrvasizes do sg_Dir.cells[3,J1]:='';
for J1:=1 to pe.numobjects do
begin
{SeC[J1].objectname[7]:=#0;}
node2:=TV.items.addchild(mynode,SeC[J1].objectname);
inc(tvidx);node2.data:=@tvi[tvidx];
tvi[tvidx].page:=6;tvi[tvidx].data:=J1;
sg_sec.cells[0,J1]:=SeC[J1].objectname;
sg_sec.cells[1,J1]:=inttostrex(SeC[J1].VSize,8);
sg_sec.cells[2,J1]:=inttostrex(SeC[J1].PSize,8);
sg_sec.cells[3,J1]:=inttostrex(SeC[J1].rva,8);
sg_sec.cells[4,J1]:=inttostrex(SeC[J1].Offset,8);
end;
for J1:=1 to pe.numrvasizes do
BEGIN
J2:=GETOWNERSECTION(J1);
if J2>0 then sg_Dir.cells[3,J1]:=DESCRIBESEC(J2);
END;

{exports}
if (EDTOFFSET>0) then
{not (dirs[d_export].rva=0)}
begin
mynode:=TV.items.add(TV.topitem,'Exports');
inc(tvidx);mynode.data:=@tvi[tvidx];
tvi[tvidx].page:=7;
if edt.numnameptrs<>0 then
begin
mynode:=TV.items.addchild(mynode,exportdll);
inc(tvidx);mynode.data:=@tvi[tvidx];
tvi[tvidx].page:=8;
sg_exp.rowcount:=edt.numnameptrs+1;
for J1:=1 to edt.numnameptrs do
begin {exported names}
sg_exp.cells[0,J1]:=inttostrex(Exportz[J1].rva,8);
sg_exp.cells[2,J1]:=Exportz[J1].name;
sg_exp.cells[1,J1]:=inttostr(Exportz[J1].ordinal+edt.ordinalBase);
end;
end;
E_expFlg.text:=inttostrex(edt.exportflags,8);
E_etime.text:=inttostrex(edt.timestamp,8);
E_evH.text:=inttostrex(edt.verMajor,4);
E_evL.text:=inttostrex(edt.verMinor,4);
E_NRVA.text:=inttostrex(edt.namerva,8);
E_eob.text:=inttostrex(edt.ordinalBase,8);
E_numEAT.text:=inttostrex(edt.numEATentries,8);
E_numName.text:=inttostrex(edt.numnameptrs,8);
E_ATrva.text:=inttostrex(edt.addressTRVA,8);
E_namerva.text:=inttostrex(edt.namePtrTRVA,8);
E_oRva.text:=inttostrex(edt.OrdinalTRVA,8);
End;

{imports}
if IDTOFFSET>0 then
{NOT (dirs[d_import].rva=0)}
begin
mynode:=TV.items.add(TV.topitem,'Imports');
inc(tvidx);mynode.data:=@tvi[tvidx];
tvi[tvidx].page:=9;
sg_idt.rowcount:=idtsize+1;
for J1:=1 to idtsize do
begin
sg_idt.cells[0,J1]:=impDlls[J1].name;
sg_idt.cells[1,J1]:=inttostrex(idt[J1].nameRVA,8);
sg_idt.cells[2,J1]:=inttostrex(idt[J1].lookuprva,8);
sg_idt.cells[3,J1]:=inttostrex(idt[J1].IAtrva,8);
sg_idt.cells[4,J1]:=inttostrex(idt[J1].flags,8);
sg_idt.cells[5,J1]:=inttostrex(idt[J1].timestamp,8);
node2:=TV.items.addchild(mynode,impDlls[J1].name);
inc(tvidx);node2.data:=@tvi[tvidx];
tvi[tvidx].page:=11;
tvi[tvidx].data:=J1;
end;
end;{/imp}

{resources}
if rdtoffset>0 then
{not (dirs[d_resource].rva=0)}
begin
{rdt}
mynode:=TV.items.add(TV.topitem,'Resources');
inc(tvidx);mynode.data:=@tvi[tvidx];
tvi[tvidx].page:=12;
e_resflg.text:=inttostrex(resDir[0].flags,8);
e_rtime.text:=inttostrex(resDir[0].time,8);
e_rver.text:=inttostrex(resDir[0].version,8);
e_rnamed.text:=inttostr(resDir[0].numname);
e_rId.text:=inttostr(resDir[0].numid);
{FIXME:this should show resource tree in TV}
{FOR J1:=1 TO (resDir[0].numname+resDir[0].numid) DO
 BEGIN
 NODE2:=TV.ITEMS.ADDCHILD(MYNODE,
   describeRES(RESTREE[J1].IDRVA)+'='
   +INTTOSTREX(RESTREE[J1].DATARVA,8));
memo1add(INTTOSTREX(RESTREE[J1].IDRVA,8)+'='
   +INTTOSTREX(RESTREE[J1].DATARVA,8));
 inc(tvidx);node2.data:=@tvi[tvidx];
 tvi[tvidx].page:=0;
 END;}
end;
{/resources}

{/all}
STATUS('PE file');
TV.selected:=TV.topitem;
disable_ctl:=false;{endupdate}
END {is a pe}
else enablemenu(1);
end; {RLL}

{==== read main mz&pe headers ====}
procedure readpe(var f:file);
begin
STATUS('Reading file...');
{hc.update;}
f_open:=true;{file is open}
ispe:=false;
seek(f,0);
blockread(f,MZ,sizeof(MZ));
if (MZ.Signature=$5a4d) then
   begin {mz-exe detected}
   seek(f,mz.NewHdrOffset);
   blockread(f,pe,sizeof(pe));
   if (pe.signature=$4550)
      then {PE}
      Begin
      ispe:=true;
      {Read directories}
      seek(f,mz.newhdroffset+sizeof(pehdr));
      blockread(f,dirs,pe.numrvasizes*sizeof(pedirectory));
      {read sections}
      seek(f,ObjTableOffset);
      blockread(f,SeC,pe.numobjects*sizeof(peobjtablerec));
      End;
   end;
end;

{==== read structures from file ====}
procedure TFRM.M_RR_C(Sender:TObject);
var j1,j2,j3,j4:Integer;
begin
readpe(exefile);
if ispe then
Begin
{read exports}
if (dirs[d_export].rva<>0) then
begin
EDToffset:=rva2offset(dirs[d_export].rva);
if edtoffset>0 then
BEGIN
seek(exefile,edtoffset);
blockread(exefile,edt,sizeof(edt));
j1:=rva2offset(edt.namerva);
if j1<>0 then exportdll:=readpchar(j1)
	   else exportdll:='DLL';
j2:=EDToffset-dirs[d_export].rva;
for j1:=1 to edt.numnameptrs do
begin {read exported names and ordinals}
seek(exefile,j2+edt.nameptrtrva+4*(j1-1));
blockread(exefile,j3,4);
Exportz[j1].name:=readpchar(j3+j2);
seek(exefile,j2+edt.ordinaltrva+2*(j1-1));
j3:=0;
blockread(exefile,j3,2);
Exportz[j1].ordinal:=j3;
seek(exefile,j2+edt.addresstrva+4*j3);
blockread(exefile,j3,4);
Exportz[j1].rva:=j3;
end;
END ELSE EDTOFFSET:=0;
{END;}
End else EDTOFFSET:=0;

{read imports}
if (dirs[d_import].rva<>0) then
begin
iDTOffset:=rva2offset(dirs[d_import].rva);
IF IDTOFFSET>0 THEN
BEGIN
seek(exefile,IDTOFFSET);idtsize:=0;
repeat
inc(idtsize);
blockread(exefile,idt[idtsize],sizeof(peidte)); {PEimportdirentry}
until (idt[idtsize].namerva=0);
dec(idtsize);j3:=1;
for j1:=1 to idtsize do
begin
impDlls[j1].name:=ReadPchar(rva2offset(idt[j1].namerva));
impdlls[j1].iFuncs:=j3;
j4:=0; {to count functions of this dll}
if (idt[j1].lookupRVA=0)
        then
   begin
   idt[j1].lookupRVA:=idt[j1].iatRVA;
   idt[j1].iatRVA:=0;
   end;
repeat {read from lookup/iat table}
if (idt[j1].iatRVA>0)
        then
begin
seek(exefile,rva2offset(idt[j1].iatRVA)+j4*4);
blockread(exefile,impfuncs[j3].addr,4);
end
else impfuncs[j3].addr:=0;
seek(exefile,rva2offset(idt[j1].lookupRVA)+j4*4);
blockread(exefile,j2,4);
if getbit(j2,31) then
begin {by oridnal}
impfuncs[j3].byordinal:=true;
impfuncs[j3].namerva:=(j2 xor $80000000);
impfuncs[j3].name:='';
impfuncs[j3].hint:=0;
end
else {by name}
begin
impfuncs[j3].byordinal:=false;
impfuncs[j3].namerva:=j2;
seek(exefile,rva2offset(impfuncs[j3].namerva));
blockread(exefile,impfuncs[j3].hint,2);
impfuncs[j3].name:=readpchar(filepos(exefile));
end;
inc(j3);inc(j4);
until j2=0;
impdlls[j1].numFuncs:=j4-1;
dec(j3);
end;
END;
end else iDTOffset:=0;{/imports}

{read RESources}
{FIXME: not implemented}
if (dirs[d_resource].rva>0) then
begin
rdtoffset:=rva2offset(dirs[d_resource].rva);

j1:=0;j3:=0;
seek(exefile,rdtoffset);
blockread(exefile,resdir[0],sizeof(PERDT));
{while not ((resdir[j1].numid=0) and (resdir[j1].numname=0)) do
BEgin
inc(j1);
blockread(exefile,resdir[j1],sizeof(PERDT));
blockread(exefile,RESTREE[j3],8*(RESDIR[j1].NUMID+RESDIR[j1].NUMNAME));
j3:=j3+RESDIR[j1].NUMID+RESDIR[j1].NUMNAME;
ENd;}

end else rdtoffset:=0;{/resources}

{end; }{/is a pe}
{everything to be read from PE is read!}
  end {/mz detected}
  else {raw binary}
   begin
   pe.numobjects:=1;
   sec[1].psize:=fsizexe;
   sec[1].vsize:=sec[1].psize;
   sec[1].rva:=0;
   sec[1].offset:=0;
   STATUS('Raw binary');
   ispe:=false;
   END;
m_refr_c(nil);{refresh}
end;

procedure TFRM.M_EXIT_C(Sender: TObject);
begin close; end;

{==== /file/open ====}
procedure TFRM.M_FO_C(Sender: TObject);
begin
if OD.execute then
   begin
   if f_open then {a file is open already}
      m_Close_c(nil);{CLOSE FILE}
   exefn:=od.filename;
   OpenAndRereadExe;
   end;
end;

{==== form.create ====}
procedure TFRM.FCR(Sender: TObject);
          function readInt(CONST ident:string;CONST default:Integer):Integer;
          begin
          result:=ini.readInteger(zinisec,ident,default);
          end;
begin
wininicreate;
left:=readint(zleft,left);
top:=readint(ztop,top);
height:=readint(zheight,height);
width:=readint(zwidth,width);
rg_hex.itemindex:=readint(rg_hex.name,1);
memo1.font.size:=Readint(memo1.name,10);
rg_VXD.itemindex:=readint(rg_VXD.name,0);
cb_sum.checked:=boolean(readint(cb_sum.name,0));
cb_adjcol.checked:=boolean(readint(cb_adjcol.name,1));
memo1.font.name:=ini.Readstring(zinisec,m_font.name,memo1.font.name);
TV.width:=Readint(TV.name,150);
if readint(od.name,0)>0 then od.options:=[ofreadonly];
hc.sections[0].width:=tv.width;
ini.free;
{f_open:=false;}
fd.font:=memo1.font;
sd.filter:=od.filter;

sg_idt.cells[0,0]:='DLL';
sg_idt.cells[1,0]:='Name RVA';
sg_idt.cells[2,0]:='Lookup RVA';
{sg_idt.cells[3,0]:='# Imports';}
sg_idt.cells[4,0]:=zflags;
sg_idt.cells[5,0]:='Time';
sg_idt.cells[3,0]:='IAT RVA';

sg_imp.cells[0,0]:=zname;
sg_imp.cells[1,0]:=zord;
sg_imp.cells[2,0]:='Hint';
sg_imp.cells[3,0]:='Address';

sg_exp.cells[0,0]:=zrva;
sg_exp.cells[1,0]:=zord;
sg_exp.cells[2,0]:=zname;

sg_sec.cells[0,0]:=zname;
sg_sec.cells[1,0]:='Virtual Size';
sg_sec.cells[2,0]:='Physical Size';
sg_sec.cells[3,0]:=zrva;
sg_sec.cells[4,0]:='Offset';

sg_Dir.cells[1,0]:=zrva;
sg_Dir.cells[2,0]:='Size';
sg_Dir.cells[3,0]:='Location';

{its a temporary hack before actual command line
parser will be writen. probably it should be in
other place}
exefn:=strscan(cmdline,#32)+1;
if length(exefn)>0 then OpenAndRereadExe;
NBPIz;{show license}
end;

{requested notebook index is in .tag}
procedure TFRM.m_switch(Sender: TObject);
begin
NBPI(tcomponent(sender).tag);
end;

{==== form close query ====}
procedure TFRM.FCQ(Sender:TObject;var CanClose:Boolean);
begin
if (not cb_sum.checked) then canclose:=true
else {need to set checksum and save changes}
     begin
     m_save_c(nil);{or the checksum will be wrong}
     b_sum_c(nil);
     m_save_c(nil);
     end;
end;

{==== treeview.onchange ====}
procedure TFRM.TV_C(Sender:TObject;Node:TTreeNode);
var page:Integer;
begin
if not disable_ctl then
begin
sReady;
page:=ttvinfo(node.data^).page;
cur_sec:=ttvinfo(node.data^).data;
NBPI(page);
{some pages require initialization}
case page of
1:{header}
  NB_hdr.pageindex:=cur_sec;
6:{section flags}
  begin
  e_secflg.text:=inttostrex(sec[cur_sec].objectflags,8);
  l_secname.caption:=describesec(cur_sec);
  end;
11:{imports}
  begin
  page:=impdlls[cur_sec].numfuncs;
  sg_imp.rowcount:=page+1;
  Lif.caption:=inttostr(page)+lif.hint+node.text;
  for page:=impdlls[cur_sec].ifuncs
      to (impdlls[cur_sec].numfuncs+impdlls[cur_sec].ifuncs) do
  begin {for}
  if not impfuncs[page].byordinal then
  begin
  sg_imp.cells[0,1+page-impdlls[cur_sec].ifuncs]:=impfuncs[page].name;
  sg_imp.cells[2,1+page-impdlls[cur_sec].ifuncs]:=inttostrex(impfuncs[page].hint,4);
  end
  else
  begin
  sg_imp.cells[0,1+page-impdlls[cur_sec].ifuncs]:='<ordinal>';
  sg_imp.cells[2,1+page-impdlls[cur_sec].ifuncs]:='';
  end;
  sg_imp.cells[1,1+page-impdlls[cur_sec].ifuncs]:=inttostrex(impfuncs[page].namerva,8);
  sg_imp.cells[3,1+page-impdlls[cur_sec].ifuncs]:=inttostrex(impfuncs[page].addr,8);
  end;{for}
  end;
end;
end;
end;

{image flags checkboxes changed}
procedure TFRM.e_flags_c(Sender:TObject);
begin
if not disable_ctl then
  begin
   pe.flags:=(pe.flags xor TComponent(sender).tag);
   e_flags.text:=inttostrex(pe.flags,4);
  end;
end;

FUNCTION GETFLAG(CONST I:BYTE):BOOLEAN;
BEGIN
RESULT:=getbit(pe.flags,I);
END;
{image flags tedit changed}
procedure TFRM.e_flags_ch(Sender: TObject);
begin
disable_ctl:=true;
pe.flags:=strtointex(e_flags.text);
i01.checked:=GETFLAG(1);
i00.checked:=GETFLAG(0);
i04.checked:=GETFLAG(4);
i14.checked:=GETFLAG(14);
i05.checked:=GETFLAG(5);
i11.checked:=GETFLAG(11);
i15.checked:=GETFLAG(15);
i07.checked:=GETFLAG(7);
i12.checked:=GETFLAG(12);
i10.checked:=GETFLAG(10);
i03.checked:=GETFLAG(3);
i02.checked:=GETFLAG(2);
i06.checked:=GETFLAG(6);
i08.checked:=GETFLAG(8);
i13.checked:=GETFLAG(13);
i09.checked:=GETFLAG(9);
disable_ctl:=false;
end;

{==== calculate header size ====}
procedure TFRM.B_HS_C(Sender: TObject);
begin
pe.headersize:=ObjtableOffset+pe.numobjects*sizeof(peobjtablerec);
E_hs.text:=inttostrex(pe.headersize,8);
end;


{==== universal edit.keydown ====}
procedure TFRM.EKD(Sender:TObject;var Key:Word;Shift:TShiftState);
begin
if (ssCtrl in Shift) then
   begin
   if key=$44 then tedit(sender).text:=inttostr(strtointex(tedit(sender).text));
   if key=$45 then tedit(sender).text:=inttostrex(strtointex(tedit(sender).text),tedit(sender).maxlength-2);
   end;
end;

{dll flags tedit changed}
procedure TFRM.e_dllf_ch(Sender: TObject);
begin
disable_ctl:=true;
PE.dllFlags:=strtointex(e_dllF.text);
d00.checked:=getbit(PE.dllFlags,0);
d01.checked:=getbit(PE.dllFlags,1);
d02.checked:=getbit(PE.dllFlags,2);
d03.checked:=getbit(PE.dllFlags,3);
disable_ctl:=false;
end;

{checkboxes, related to dll flags tedit changed}
procedure TFRM.e_dllf_c2(Sender: TObject);
begin
if not disable_ctl then
begin
PE.dllFlags:=PE.dllFlags xor tcomponent(sender).tag;
e_dllF.text:=inttostrex(PE.dllFlags,4);
end;
end;

{==== hex column ====}
procedure TFRM.col_mode(Sender:TObject);
var i:Integer;
begin
with tstringgrid(activecontrol) do
begin
if tcomponent(sender).tag>0 then
 for i:=fixedrows to rowcount do
 cells[col,i]:=inttostrex(strtointex(cells[col,i]),8)
else
 for i:=fixedrows to rowcount do
 cells[col,i]:=inttostr(strtointex(cells[col,i]));
end;
end;

{section flags checkboxes changed}
procedure TFRM.e_secflg_c(Sender: TObject);
begin
if not disable_ctl then
begin
disable_ctl:=true;
SeC[cur_sec].objectflags:=(SeC[cur_sec].objectflags xor TComponent(sender).tag);
e_secflg.text:=inttostrex(SeC[cur_sec].objectflags,8);
disable_ctl:=false;
end;
end;
{section flags tedit changed}
procedure TFRM.e_secflg_ch(Sender: TObject);
          FUNCTION GETOBJFLG(CONST I:BYTE):BOOLEAN;
          BEGIN
          RESULT:=getbit(Jaw,I);
          END;
begin
SeC[cur_sec].objectflags:=strtointex(e_secflg.text);
if not disable_ctl then begin
disable_ctl:=true;
Jaw:=SeC[cur_sec].objectflags;
S03.checked:=GETOBJFLG(2);
S06.checked:=GETOBJFLG(5);
S07.checked:=GETOBJFLG(6);
S08.checked:=GETOBJFLG(7);
S10.checked:=GETOBJFLG(9);
S11.checked:=GETOBJFLG(10);
S12.checked:=GETOBJFLG(11);
S13.checked:=GETOBJFLG(12);
S26.checked:=GETOBJFLG(25);
S27.checked:=GETOBJFLG(26);
S28.checked:=GETOBJFLG(27);
S29.checked:=GETOBJFLG(28);
S30.checked:=GETOBJFLG(29);
S31.checked:=GETOBJFLG(30);
S32.checked:=GETOBJFLG(31);
disable_ctl:=false;
end;
end;

{==== F8 ====}
procedure TFRM.M_CNV_C(Sender: TObject);
begin
CCC.Show;
end;

{==== check structure ====}
procedure TFRM.m_check_c(Sender: TObject);
var j,j3,j2:Integer;
begin
memo1.lines.clear;NBPIz;
memo1add('==> Header');
{if (pe.MagicOptionalHdr<>$10b) then
   memo1add('Optional header magic is not 0x010B.');}
if (pe.filealign<512) or (pe.filealign>$10000) then
   memo1add('File Alignment exceeds range.');
if (pe.objectalign<$1000) or (pe.objectalign>$10000000) then
   memo1add('Object Alignment exceeds range.');
memo1add('==> Directories');
for j:=1 to pe.numrvasizes do
begin
{sss:=describedir(j);}
j3:=getownersection(j);
if ((j3=0) and (dirs[j].size>0)) then
   memo1add(describedir(j)+' isn''t located in any section.')
else
begin
 if (dirs[j].size>SeC[j3].PSize) then
    memo1add(describedir(j)+' is larger than the owning section''s Physical Size.');
 if (dirs[j].size>SeC[j3].VSize) then
    memo1add(describedir(j)+' is larger than the owning section''s Virtual Size.');
end;
end;
memo1add('==> Object table');
j:=fsizexe;
for j3:=1 to pe.numobjects do
Begin
if (sec[j3].Offset+sec[j3].PSize)>j then
   memo1add(describesec(j3)+' is physically beyond file.');
if frac(sec[j3].Offset/pe.filealign)>0 then
   memo1add(describesec(j3)+' is not physically aligned.');
if frac(sec[j3].rva/pe.objectalign)>0 then
   memo1add(describesec(j3)+' is not virtually aligned.');
for j2:=j3+1 to pe.numobjects do
    begin
    if ((sec[j3].Offset>=sec[j2].Offset) and
       (sec[j3].Offset<sec[j2].PSize+sec[j2].Offset)) then
          memo1add(describesec(j3)+' and '+describesec(j2)+' are physically crosslinked.');
    end;
enD;
{STATUS('No more errors');}
end;

{==== SAVE SECTION ====}
procedure TFRM.m_savesec_c(Sender: TObject);
var j3:Integer;
begin
sd.filename:=sg_sec.cells[0,sg_sec.row];
if sd.execute then
begin
j3:=SeC[sg_sec.row].PSize;
getmempdata(j3);
readsec(sg_sec.row);
assigntemp(sd.filename);
blockwrite(tempfile,Pdata^,j3);
closefile(tempfile);
disposepdata;
STATUS(FORMAT('Section saved (%d)',[J3]));
end;
end;

{==== LOAD SECTION ====}
procedure TFRM.m_loadsec_c(Sender: TObject);
var j1,j2:Integer;
begin
if od.execute then
begin
assignTeMPr;
J1:=SeC[sg_sec.row].PSize;
getmempdata(j1);
J2:=fsizetmp;
if j1>j2 then J1:=j2;
blockread(tempfile,pdata^,J1);
closefile(tempfile);
seek(exefile,SeC[sg_sec.row].Offset);
blockwrite(exefile,Pdata^,J1);
disposepdata;
STATUS(FORMAT('Section loaded (%d)',[J1]));
end;
end;

{==== clear section from table ====}
procedure TFRM.m_delsec_c(Sender: TObject);
var j:Integer;
begin
dec(pe.numobjects);
for j:=sg_sec.row to pe.numobjects do
                SeC[j]:=SeC[j+1];
m_Refr_c(nil);
end;

{==== close exefile ====}
procedure TFRM.M_CLOSE_C(Sender: TObject);
begin
closexe;
f_open:=false;
disable_ops;
disable_ctl:=false;
caption:=zinisec;
NBPIz;
{?}ispe:=false;
enablemenu(0);
end;

procedure writeint(const ident:string; const value:Integer);
begin
ini.writeInteger(zinisec,ident,value);
end;

{==== save config ====}
procedure TFRM.m_scfg_c(Sender: TObject);
begin
wininicreate;
writeint(cb_sum.name,Integer(cb_sum.checked));
writeint(cb_adjcol.name,Integer(cb_adjcol.checked));
writeint(rg_hex.name,rg_hex.itemindex);
writeint(rg_VXD.name,rg_VXD.itemindex);
writeint(zLeft,left);
writeint(zTop,top);
writeint(zHeight,height);
writeint(zWidth,width);
ini.writestring(zIniSec,m_font.name,memo1.font.name);
writeint(memo1.name,memo1.font.size);
writeint(TV.name,TV.width);
writeint(od.name,Integer(ofreadonly in od.options));
ini.free;
STATUS('Options saved');
end;


{==== nt header size ====}
procedure TFRM.B_NT_C(Sender: TObject);
var j:Integer;
begin
j:=96+pe.numrvasizes*8;
e_nt.text:=inttostrex(j,4);
end;

{==== change alignment ====}
procedure TFRM.B_FA_C(Sender: TObject);
var j1,j2:Integer;
begin
{?}pe.filealign:=strtointex(e_fa.text);
j1:=alignval(SeC[1].Offset,pe.filealign);
getmempdata(j1);
assigntmp;
seek(exefile,0);
clearpdata(j1);
blockread(exefile,pdata^,SeC[1].Offset);
blockwrite(tempfile,pdata^,j1);
disposepdata;
for j1:=1 to pe.numobjects do
 BegIn
 j2:=physsz(j1);
 getmempdata(j2);
try
 if j2>0 then
    begin
    clearpdata(j2);
    seek(exefile,SeC[j1].Offset);
    blockread(exefile,pdata^,SecPSize(j1));
    end;
 SeC[j1].PSize:=j2;
 SeC[j1].Offset:=filepos(tempfile);
 if j2>0 then
    blockwrite(tempfile,pdata^,SeC[j1].PSize);
 finally disposepdata; end;
 EnD;
{!}saveMAINhdrs(tempfile);
closetemp;
STATUS('Alignment changed');statusmode;
end;

{==== create as_section submenu ====}
procedure TFRM.mc_dir_pop(Sender: TObject);
var mnu:Tmenuitem;
    i:Integer;
begin
for i:=1 to m_assec.count do m_assec.delete(0);
for i:=1 to pe.numobjects do
begin
mnu:=tmenuitem.create(mc_dir);
mnu.tag:=i;
mnu.onclick:=as_sec;
mnu.caption:=describesec(i);
m_assec.add(mnu);
end;
end;

{==== directory as section ====}
procedure tFRM.as_sec(sender:tobject);
begin
sg_Dir.cells[1,sg_Dir.row]:=sg_sec.cells[3,tcomponent(sender).tag];
sg_Dir.cells[2,sg_Dir.row]:=sg_sec.cells[1,tcomponent(sender).tag];
end;

{==== stringgrid.keydown ====}
procedure TFRM.SGK(Sender:TObject;var Key:Word;Shift:TShiftState);
begin
{messagedlg(inttostrex(key,4),mtinformation,[mbok],0);}
with tstringgrid(sender) do
begin
if key=$78 then popupmenu.popup(clientorigin.x,clientorigin.y);
if key=$76 then begin
                fdlg.tag:=helpcontext;
                fdlg.execute;
                end;
if (ssCtrl in Shift) then
   begin
   if key=$45 then cells[col,row]:=inttostrex(strtointex(cells[col,row]),8);
   if key=$44 then cells[col,row]:=inttostr(strtointex(cells[col,row]));
   end;
end;
end;

{==== stringgrid.onenter (columns width adjustment) ====}
procedure TFRM.SGE(Sender: TObject);
var ratio:single;
    j1,j2:Integer;
begin
if cb_adjcol.checked then
BEGIN
j2:=0;
for j1:=0 to tstringgrid(sender).colcount-1
  do j2:=j2+tstringgrid(sender).colwidths[j1];
ratio:=tstringgrid(sender).clientwidth/j2;
   if (ratio<(tcomponent(sender).tag/j2))
   then ratio:=tcomponent(sender).tag/j2;
for j1:=0 to tstringgrid(sender).colcount-1
  do tstringgrid(sender).colwidths[j1]:=round(tstringgrid(sender).colwidths[j1]*ratio-1);
END;
end;

{==== change font ====}
procedure TFRM.m_font_c(Sender:TObject);
begin
if fd.execute then memo1.font:=fd.font;
end;

{==== remove section from file ====}
procedure TFRM.m_rmsec_c(Sender: TObject);
var j1,j2:Integer;
begin
if fDS.showmodal=mrok then
BEGin
seek(exefile,0);
j1:=SeC[sg_sec.row].Offset;
IF J1=0 THEN
	BEGIN {watcom fix?}
	J1:=SeC[sg_sec.row+1].Offset;
	SeC[sg_sec.row].Offset:=SeC[sg_sec.row+1].Offset;
	END;
getmempdata(fsizexe);
try
blockread(exefile,pdata^,j1);
assigntmp;
blockwrite(tempfile,pdata^,j1);
if not fDS.d2.checked then {DON'T MOVE PHYS.}
begin
clearpdata(SeC[sg_sec.row].PSize);{!!!}
blockwrite(tempfile,pdata^,SeC[sg_sec.row].PSize);
end;

if fDS.d4.checked then {update dirs}
for j1:=1 to pe.numrvasizes do
 if getownersection(j1)=sg_sec.row then
   begin
   dirs[j1].rva:=0;dirs[j1].size:=0;
   end;

if fDS.d3.checked then  {move virtually}
begin
  j2:=SeC[sg_sec.row+1].rva-SeC[sg_sec.row].rva;
  if (sg_sec.row<pe.numobjects) then
     for j1:=sg_sec.row+1 to pe.numobjects do
         SeC[j1].rva:=SeC[j1].rva-j2;
  if fDS.d4.checked then {UPDATE DIRS}
    for j1:=1 to pe.numrvasizes do
      if getownersection(j1)>=sg_sec.row then
         dirs[j1].rva:=dirs[j1].rva-j2;
end;

if (sg_sec.row<pe.numobjects) then
begin
     j1:=SeC[sg_sec.row+1].Offset;
     seek(exefile,j1);
     j1:=fsizexe-j1;
     blockread(exefile,pdata^,j1);
     blockwrite(tempfile,pdata^,j1);
end;

if fDS.D2.checked then {move next physically}
begin
j2:=SeC[sg_sec.row+1].Offset-SeC[sg_sec.row].Offset;
if (sg_sec.row<pe.numobjects) then
 for j1:=sg_sec.row+1 to pe.numobjects do
  SeC[j1].Offset:=SeC[j1].Offset-j2;
end;

m_delsec_c(nil);{clear from object table}

if fDS.D1.checked then B_IS_C(nil); {image size}
{!!!}saveMAINhdrs(tempfile);
finally disposepdata;
closetemp;
end;
STATUS('Section deleted');
statusmode;
ENd;
end;

{==== remember filename of text file ====}
procedure savetxt_caption(const cap:string);
begin
with frm do
begin
m_txtl.hint:=cap;
m_txts.caption:=m_txts.hint+m_txtl.hint;
end;
end;

{==== load text ====}
procedure TFRM.m_txtl_c(Sender: TObject);
begin
if od.execute then
begin
  memo1load(od.filename);
  savetxt_caption(od.filename);
  NBPIz;
  STATUS('Text loaded');
end;
end;

{==== save text ====}
procedure TFRM.m_txts_c(Sender: TObject);
begin
if length(m_txtl.hint)>0 then
memo1.lines.savetofile(m_txtl.hint);
sTextSaved;
end;

{==== save text as ====}
procedure TFRM.m_txtas_c(Sender: TObject);
begin
sd.filename:=m_txtl.hint;
if sd.execute then
begin
memo1.lines.savetofile(sd.filename);
savetxt_caption(sd.filename);
sTextSaved;
end;
end;

{==== image size determination ====}
procedure TFRM.B_IS_C(Sender: TObject);
begin
pe.imagesize:=alignval(SeC[pe.numobjects].VSize+sec[pe.numobjects].rva,pe.objectalign);
E_IS.text:=inttostrex(pe.imagesize,8);
end;

{==== update controls from internal structures ====}
procedure TFRM.M_SAVE_C(Sender: TObject);
var j1,j2:Integer;
begin
{header data}
{general}
pe.numrvasizes:=strtointex(e_numd.text);
pe.numobjects:=strtointex(e_nums.text);
pe.nthdrsize:=strtointex(e_nt.text);
pe.entrypointrva:=strtointex(e_EP.text);
pe.filechecksum:=strtointex(e_SUM.text);
pe.magicoptionalhdr:=strtointex(e_mag.text);
pe.headersize:=strtointex(e_hs.text);
{flags}
pe.flags:=strtointex(e_flags.text);
{memory}
pe.imagesize:=strtointex(e_is.text);
pe.stackreservesize:=strtointex(e_sR.text);
pe.stackcommitsize:=strtointex(e_sC.text);
pe.heapreservesize:=strtointex(e_hR.text);
pe.heapcommitsize:=strtointex(e_hC.text);
pe.codesize:=strtointex(e_cs.text);
pe.initdata:=strtointex(e_id.text);
pe.uninitdata:=strtointex(e_ud.text);
{align}
pe.imagebase:=strtointex(e_ib.text);
pe.database:=strtointex(e_db.text);
pe.codebase:=strtointex(e_cb.text);
pe.objectalign:=strtointex(e_oa.text);
pe.filealign:=strtointex(e_fa.text);
{versions}
pe.cputype:=strtointex(e_cpu.text);
pe.osmajor:=strtointex(e_osh.text);
pe.osminor:=strtointex(e_osl.text);
pe.lmajor:=strtointex(e_lh.text);
pe.lminor:=strtointex(e_ll.text);
pe.usermajor:=strtointex(e_uh.text);
pe.userminor:=strtointex(e_ul.text);
pe.timedate:=strtointex(e_time.text);
pe.subsysmajor:=strtointex(e_ssh.text);
pe.subsysminor:=strtointex(e_ssl.text);
pe.subsystem:=strtointex(e_ss.text);
{dll flags}
pe.loaderflags:=strtointex(e_ldf.text);
pe.dllflags:=strtointex(e_dllF.text);

{directories}
for j1:=1 to pe.numrvasizes do
begin
dirs[j1].rva:=strtointex(sg_Dir.cells[1,j1]);
dirs[j1].size:=strtointex(sg_Dir.cells[2,j1]);
end;
{/directories}

{sections}
for j1:=1 to pe.numobjects do
begin
for j2:=1 to minval(8,length(sg_sec.cells[0,j1])) do
   SeC[j1].objectname[j2-1]:=sg_sec.cells[0,j1][j2];
SeC[j1].VSize:=strtointex(sg_sec.cells[1,j1]);
SeC[j1].PSize:=strtointex(sg_sec.cells[2,j1]);
SeC[j1].rva:=strtointex(sg_sec.cells[3,j1]);
SeC[j1].Offset:=strtointex(sg_sec.cells[4,j1]);
end;
{/sections}

{exports}
if not ((dirs[d_export].rva=0) {or (dirs[d_export].size=0)}) then
begin
if edt.numnameptrs<>0 then
begin
for j1:=1 to edt.numnameptrs do
begin {exported names}
Exportz[j1].rva:=strtointex(sg_exp.cells[0,j1]);
Exportz[j1].name:=sg_exp.cells[2,j1];
Exportz[j1].ordinal:=strtointex(sg_exp.cells[1,j1]);
end;
end;
edt.exportflags:=strtointex(E_expFlg.text);
edt.timestamp:=strtointex(E_etime.text);
edt.verMajor:=strtointex(E_evh.text);
edt.verMinor:=strtointex(E_evl.text);
edt.namerva:=strtointex(E_NRVA.text);
edt.ordinalBase:=strtointex(E_eob.text);
edt.numEATentries:=strtointex(E_numEAT.text);
edt.numnameptrs:=strtointex(E_numName.text);
edt.addressTRVA:=strtointex(E_ATrva.text);
edt.namePtrTRVA:=strtointex(E_nameRVA.text);
edt.OrdinalTRVA:=strtointex(E_oRva.text);
End;
{/exports}

{imports}
if not ((dirs[d_import].rva=0) {or (dirs[d_import].size=0)}) then
begin
for j1:=1 to idtsize do
begin
impDlls[j1].name:=sg_idt.cells[0,j1];
idt[j1].nameRVA:=strtointex(sg_idt.cells[1,j1]);
idt[j1].lookuprva:=strtointex(sg_idt.cells[2,j1]);
impDlls[j1].numfuncs:=strtointex(sg_idt.cells[3,j1]);
end;
end;
{/imports}

{rdt}
if not ((dirs[d_resource].rva=0) or (dirs[d_resource].size=0)) then
begin
resDir[0].flags:=strtointex(e_resflg.text);
resDir[0].time:=strtointex(e_rtime.text);
resDir[0].version:=strtointex(e_rver.text);
resDir[0].numname:=strtointex(e_rnamed.text);
resDir[0].numid:=strtointex(e_rId.text);
end;
{/rdt}

savehdrs(exefile);
{rer(nil);}
STATUS('Changes saved');
end;

{==== save def ====}
procedure TFRM.m_def_c(Sender: TObject);
var j1:Integer;
begin
sd.filename:=changeFileext(exportdll,'.DEF');
if sd.execute then
begin
assignft;
writelnft('LIBRARY '+exportDll);
writelnft('EXPORTS');
for j1:=1 to EDT.numNamePtrs do
writelnft(#32+Exportz[j1].name+#9#9#64+inttostr(Exportz[j1].ordinal+edt.ordinalbase));
closeft;
STATUS('DEF file saved');
end;
end;

{==== find vxd calls ====}
procedure TFRM.m_vxd_c(Sender: TObject);
var vxdID:word;
    ja1,ja2,ja3:Integer;
    ss1:string;
begin
memo1beginupdate;
memo1add('Offset'#9#9'Type');
ini:=tinifile.create(inpewdir(ZvxdCFG));
try
for ja1:=1 to pe.numobjects do
BEgin
getmempdata(SeC[ja1].PSize);
readsec(ja1);
{memo1add(sec[ja1].objectname);}
try
for ja2:=0 to SeC[ja1].PSize-6 do
 begin
 if ((pdata^[ja2]=$cd) and (pdata^[ja2+1]=$20)) then
  begin
  ja3:=rva2offset(SeC[ja1].rva+ja2);
  ss1:=inttostrex(ja3,8);if ja3=0 then ss1:='';
  ja3:=pdata^[ja2+2]+(pdata^[ja2+3] shl 8);
  if getbit(ja3,15) then
    begin
     ja3:=(ja3 xor $8000);
     ss1:=ss1+#9'Jump'#9;
    end
   else ss1:=ss1+#9'Call'#9;
  vxdID:=pdata^[ja2+4]+(pdata^[ja2+5] shl 8);
  if (rg_VXD.itemindex<>1) then
   begin
   ss1:=ss1+ini.readstring(inttohex(vxdid,4),zname,inttostrex(vxdid,4));
   ss1:=ss1+'.';
   ss1:=ss1+ini.readstring(inttohex(vxdid,4),inttohex(ja3,4),inttostrex(ja3,4));
   memo1add(ss1);
   ss1:=#9#9#9;
   end;
  if (rg_VXD.itemindex<>0) then
   begin
   ss1:=ss1+inttostrex(vxdid,4)+'.'+inttostrex(ja3,4);
   memo1add(ss1);
   end;
  end;
 end;
finally disposepdata;
end;
ENd;
finally ini.free; memo1endupdate;
end;
STATUS('No more VxD calls found');
end;

{loader flags checkboxes changed}
procedure TFRM.e_ldf_c(Sender: TObject);
begin
if not disable_ctl then
begin
disable_ctl:=true;
pe.loaderflags:=(pe.loaderflags xor tcomponent(sender).tag);
e_ldf.text:=inttostrex(pe.loaderflags,8);
disable_ctl:=false;
end;
end;
{loader flags tedit changed}
procedure TFRM.e_ldf_ch(Sender: TObject);
begin
if not disable_ctl then
begin
disable_ctl:=true;
pe.loaderflags:=strtointex(e_ldf.text);
lf0.checked:=getbit(pe.loaderflags,0);
lf1.checked:=getbit(pe.loaderflags,1);
disable_ctl:=false;
end;
end;

procedure addsec(sec_idx:Integer);
var j:Integer;
begin
for j:=pe.numobjects downto sec_idx
    do sec[j+1]:=sec[j];
inc(pe.numobjects);
sec[sec_idx].objectname:=zname;
sec[sec_idx].objectflags:=$50000040;
sec[sec_idx].rva:=sec[sec_idx-1].rva+(trunc(sec[sec_idx-1].VSize/pe.objectalign)+1)*pe.objectalign;
{sec[sec_idx].VSize:=sec[sec_idx+1].rva-sec[sec_idx].rva;}
sec[sec_idx].Offset:=sec[sec_idx-1].Offset+sec[sec_idx-1].PSize;
{sec[sec_idx].PSize:=sec[sec_idx+1].Offset-sec[sec_idx].Offset;}
end;

{==== add section ====}
procedure TFRM.m_addsec_c(Sender: TObject);
begin
addsec(sg_sec.row+tcomponent(sender).tag);
m_refr_c(nil);
end;

{==== save export config ====}
procedure TFRM.m_exp_c(Sender: TObject);
var j:Integer;
begin
ini:=tinifile.create(inpewdir(zExpCfg));
try for j:=1 to edt.numnameptrs do
ini.writestring(exportDLL,Exportz[j].name,inttostr(Exportz[j].ordinal));
finally ini.free; end;
STATUS('Export configuration saved');
end;

{==== change FILEMODE ====}
procedure TFRM.M_RW_C(Sender: TObject);
var fm:Integer;
begin
fm:=filemode;
filemode:=tcomponent(sender).tag;
closexe;
try
  reset(exefile,1);
  {STATUS('Mode changed successfully');}
  {statusMode;}
  m_rr_c(nil);
except
  filemode:=fm;reset(exefile,1);
  STATUS('Mode change failed');
end;
end;

{==== ADD FILE SIGNATURE ====}
procedure TFRM.m_sig_c(Sender:TObject);
var pdata2:^tdataArray;
    J,J3,J2:Integer;
    SIG:STRING;
begin
b_hs_c(nil);{calc header size}
j:=memo1.gettextlen;
j3:=j+pe.headersize;
j2:=trunc(j3/pe.filealign+1)*pe.filealign;
j3:=j2-j3;
assigntmp;
getmem(pdata2,fsizexe);
try
  seek(exefile,0);
  blockread(exefile,pdata2^,j2);
  SIG:=memo1.text;
  for j3:=pe.headersize to j2
      do pdata2^[j3]:=0;
  move(PCHAR(sig)^,pdata2^[pe.headersize],j);
  blockwrite(tempfile,pdata2^,j2);
  j3:=fsizexe-sec[1].Offset;
  seek(exefile,sec[1].Offset);
  blockread(exefile,pdata2^,j3);
  blockwrite(tempfile,pdata2^,j3);
  if j2>sec[1].Offset then
	begin
	  j2:=j2-sec[1].Offset;
	  for j3:=1 to pe.numobjects do
	  inc(sec[j3].Offset,j2);
	end;
  saveMAINhdrs(tempfile);
finally
  dispose(pdata2);
  closetemp;
end;
end;

{==== remove dead space ====}
procedure TFRM.m_dead_c(Sender: TObject);
var tj,j2,fsold:Integer;
begin
if rds.showmodal=mrok THEN
BEGIN
IF RDS.RD5.CHECKED THEN {set MINIMAL STUB}
   m_stm_c(nil);
assigntmp;
fsold:=fsizexe;
getmempdata(fsold); {eat memory}
try
seek(exefile,0);
blockread(exefile,pdata^,mz.newhdroffset);
IF RDS.RD1.CHECKED THEN {MOVE PE HEADER}
  BEGIN
  mz.newhdroffset:=alignval(initdata(mz.newhdroffset)+1,2);
  if mz.newhdroffset<$40 then mz.newhdroffset:=$40;
  END;
blockwrite(tempfile,pdata^,mz.newhdroffset);
clearpdata(sec[1].Offset);
IF RDS.RD2.CHECKED THEN {MOVE SECS TO HDR}
   tj:=alignval(ObjTableOffset+pe.numobjects*sizeof(peobjtablerec),pe.filealign)
   ELSE tj:=SEC[1].OFFSET;
blockwrite(tempfile,pdata^,tj-mz.newhdroffset);
for tj:=1 to pe.numobjects do
{sections copying cycle}
begin
  readsec(tj);
  IF RDS.RD3.CHECKED THEN {MIN PHYS SZ}
     sec[tj].PSize:=alignval(initdata(sec[tj].PSize),pe.filealign)
     ELSE sec[tj].PSize:=alignval(sec[tj].PSize,PE.FILEALIGN);
  j2:=ALIGNVAL(sec[tj].PSize,PE.FILEALIGN);
  {CLEAR AFTER VSIZE}
  IF RDS.RD4.CHECKED AND (j2<sec[tj].PSize) THEN
     SEC[tj].PSIZE:=j2;
  If (tj=pe.numobjects) and rds.rd6.checked
   then {truncate last}
        SEC[tj].PSIZE:=alignval(initdata(sec[tj].PSize),16);
  blockwrite(tempfile,pdata^,sec[tj].PSize);
  sec[tj].Offset:=filepos(tempfile)-sec[tj].PSize;
end;
saveMAINhdrs(tempfile);
finally disposepdata;closetemp; end;
STATUS(inttostr(fsold-fsizexe)+' bytes removed');
statusmode;
END;
end;

{==== calculate virtual size ====}
procedure TFRM.m_virt_c(Sender: TObject);
var sec_idx,sz:Integer;
begin
sec_idx:=sg_sec.row;
sz:=initsec(sec_idx);
if messagedlg('Estimated minimal virtual size'#13'for '
   +describesec(sec_idx)+' is '
   +inttostrex(sz,8)+#$2E#13'Apply?',
   mtconfirmation,[mbok,mbcancel],0)=mrok
   then sg_sec.cells[1,sec_idx]:=inttostrex(sz,8);
end;

{==== set checksum ====}
procedure TFRM.B_SUM_C(Sender: TObject);
var hmod,proca:Integer;
{it crashes if i use this declaration.
type
Sum=function(Fname:pchar;
             var HdrSum:Integer;
             var CheckSum:Integer):Integer;stdcall;}
begin
hmod:=loadlibrary('IMAGEHLP.DLL');
IF hmod<>0 THEN
BEGIN
proca:=Integer(getprocaddress(hmod,'MapFileAndCheckSumA'));
asm
push offset jaw
push offset jaw2
push exefn
call [proca]
mov jaw2,eax
end;
if jaw2=0 then E_SUM.text:=inttostrex(jaw,8)
   else STATUS('Error setting checksum');
freelibrary(hmod);
END;
end;

{==== get physical size of selected section ====}
procedure TFRM.m_phys_c(Sender: TObject);
var row_num,sz:Integer;
begin
row_num:=sg_sec.row;
sz:=alignval(initsec(row_num),pe.filealign);
if messagedlg('Estimated minimal physical size'#13'for '+
   describesec(row_num)+' is '+inttostrex(sz,8)+
   #$2E#13'Apply?',
   mtconfirmation,[mbok,mbcancel],0)=mrok
   then sg_sec.cells[2,row_num]:=inttostrex(sz,8);
end;

{==== convert import(s) to ordinal ====}
{FIXME: doesn't work}
procedure TFRM.to_ord(Sender: TObject);
var j1,j2,j3:Integer;
begin
j2:=ttvinfo(tv.selected.data^).data;
ini:=tinifile.create(inpewdir(zExpCfg));
if tcomponent(sender).tag>0
 then {one f}
begin j1:=impdlls[j2].ifuncs+sg_imp.row-1;j3:=j1; end
 else {All f}
begin j1:=impdlls[j2].ifuncs;j3:=(impdlls[j2].numfuncs+impdlls[j2].ifuncs); end;

for j1:=j1 to j3 do
begin
j3:=ini.readInteger(impdlls[j2].name,impfuncs[j1].name,-1);
if j3<>-1 then
   begin
   impfuncs[j1].nameRVA:=j3;
   impfuncs[j1].byordinal:=true;
   impfuncs[j1].name:='';
   end;
end;

ini.free;
tv_c(nil,tv.selected);
end;

{==== find in sTRINGgRID/TEXT - show DIALOG ====}
procedure TFRM.m_txtf_c(Sender: TObject);
begin
fdlg.tag:=tcomponent(sender).tag;
fdlg.execute;
jaw:=-1;
end;

{==== perform search in stringgrid ====}
procedure TFRM.find(Sender: TObject);
var pSG:tstringgrid;
    j,j3:Integer;
label stopit;
begin
case fdlg.tag of
0:psg:=sg_imp;{imports from dll}
1:psg:=sg_exp;{exports}
2:psg:=sg_idt;{idt}
3:psg:=sg_Dir;{dirs}
4:psg:=sg_sec;{sections}
end;
IF FDlg.TAG=5 THEN {SEARCH TEXT}
BEGIN
j3:=fpos(pchar(memo1.text)+jaw+1,pchar(fdlg.findtext));
 if j3>0 then
    begin
    j:=memo1.lines.indexof(pchar(jaw2));
    memo1.lines.insert(j,'');
    memo1.lines.delete(j);
    {memo1.setfocus;}
    memo1.selstart:=j3+jaw;jaw:=memo1.selstart;
    memo1.sellength:=length(fdlg.findtext);
    sFound;
    end
    else sNotFound;
END
ELSE {stringgrid}
try
for j:=0 to psg.rowcount-1 do
begin
 for jaw:=0 to psg.colcount-1 do
  begin
   if (pos(ansiuppercase(fdlg.findtext),ansiuppercase(psg.cells[jaw,j]))>0)
   then goto stopit;
  end;
end;
stopit:psg.row:=j;
psg.col:=jaw;
sFound;
except sNotFound; end;
end;

{==== save EXEFILE as ====}
procedure TFRM.M_SAS_C(Sender: TObject);
begin
if sd.execute then
begin
if COPYFILE(pchar(EXEFN),pchar(sd.filename),false) then
begin
closexe;
exefn:=sd.filename;
AssignExe;
m_save_c(nil);
end;
end;
end;

{==== HEADER/TREEVIEW RESIZING ====}
{Delphi2 doesn't have TSplitter, so I use this cool method}
procedure TFRM.SRS(HeaderControl: THeaderControl; Section: THeaderSection);
begin
tv.width:=section.width;
end;

{==== ALMOST no stub - 40h ====}
procedure TFRM.M_STM_C(Sender:TObject);
begin
MZ:=MINISTUB;SAVEHDRS(EXEFILE);
STATUS('Stub replaced');
end;

{==== NEW STUB - FROM FILE ====}
procedure TFRM.M_STN_C(Sender:TObject);
var jw,jw2,jw3:Integer;
begin
IF OD.EXECUTE THEN
BEGIN
assignTempr;
JW:=fsizetmp;
JW2:=ALIGNVAL(JW+SEC[1].OFFSET-MZ.NEWHDROFFSET,PE.FILEALIGN);
getmempdata(JW2);
{clearpdata(jw2); ?}
BLOCKREAD(TEMPFILE,PDATA^,JW);

MZ.NEWHDROFFSET:=ALIGNVAL(JW,2);
CLOSEFILE(TEMPFILE);

FILEMODE:=2;ASSIGNTMP;
BLOCKWRITE(TEMPFILE,PDATA^,JW2);
disposepdata;
SEEK(EXEFILE,SEC[1].OFFSET);
JW:=SEC[PE.NUMOBJECTS].OFFSET+SEC[PE.NUMOBJECTS].PSIZE-SEC[1].OFFSET;
getmempdata(JW);
BLOCKREAD(EXEFILE,PDATA^,JW,JW3);
BLOCKWRITE(TEMPFILE,PDATA^,JW);
disposepdata;
JW:=SEC[1].OFFSET-JW2;
FOR JW2:=1 TO PE.NUMOBJECTS DO
    SEC[JW2].OFFSET:=SEC[JW2].OFFSET-JW;
{!}SAVEmainHDRS(TEMPFILE);
CLOSETEMP;
sReady;
END;
end;

{==== SAVE STUB ====}
procedure TFRM.M_STS_C(Sender: TObject);
var sst,xxx:Integer;
begin
IF SD.EXECUTE THEN
BEGIN
sst:=(MZ.NUMPAGES-1)*512+MZ.BYTESLASTPAGE;
{hiew has a bug with this}
IF MZ.BYTESLASTPAGE=0 THEN INC(sst,512);
getmempdata(sst);
SEEK(EXEFILE,0);
BLOCKREAD(EXEFILE,PDATA^,sst,xxx);{!!!?}
FILLCHAR(PDATA^[$3C],4,0);
ASSIGNTEMP(SD.FILENAME);
BLOCKWRITE(TEMPFILE,PDATA^,sst);
CLOSEFILE(TEMPFILE);
disposepdata;
sReady;
END;
end;

{==== is a valid Delphi identifier? if not, make valid ====}
procedure validIdent{(var s:string)};
begin
{to have separate copy of string}
sss:=copy(Exportz[jaw].name,1,length(Exportz[jaw].name));
if not isvalidident(sss) then
   asm
   push edi
   push esi
   mov esi,sss
{   mov esi,[esi] - needed for var s}
   push esi
   mov edi,esi
@@next:
   lodsb
   test al,al
   je @@ok
   cmp al,'0'
   jb @@next
   cmp al,'9'
   ja @@chars
@@store:
   stosb
   jmp @@next
@@chars:
   or al,$20
   cmp al,$60
   jbe @@next
   cmp al,$7a
   jbe @@store
   jmp @@next
@@ok:
   mov byte [edi],0
   pop esi
   sub edi,esi
   mov [esi-4],edi
   pop esi
   pop edi
   end;
end;

{==== save .dpr library template ====}
procedure TFRM.m_dpr_c(Sender: TObject);
var j:Integer;
    ch:char;
begin
if sd.execute then
begin
assignft;
writelnft('LIBRARY '+changeFileext(exportdll,'')+';');
for j:=1 to EDT.numNamePtrs do
begin
validident;
writelnft(format(#13#10'function %s:Integer;'#13#10'Begin'#13#10'End;',[sss]));
end;
writelnft(#13#10'EXPORTS');
ch:=',';
for j:=1 to EDT.numNamePtrs do
begin
if j=EDT.numNamePtrs then ch:=';';
validident;
writelnft(sss+' index '+inttostr(Exportz[j].ordinal
          +edt.ordinalbase)+' name '#39+Exportz[j].name+#39+ch);
end;
writelnft(#13#10'Begin'#13#10'End.');
closeft;
sReady;
end;
end;

{==== strings filters ====}
{need to speed up these}
procedure TFRM.FINDS(Sender: TObject);
var i:byte;
    j,j2,j3:Integer;
    procedure memo1proc;
          begin
          memo1add(inttostrex(j2+sec[j].offset,8)+#9+inttostrex(j3,4)+#9+sss);
          end;

begin {find strings}
memo1beginupdate;
memo1add('Offset'#9#9'Length'#9'String'#13#10);
FOR J:=1 TO PE.NUMOBJECTS DO
BEGIN
if sec[j].psize>0 then
BeGiN
getmempdata(SEC[J].PSIZE);
READSEC(J);j2:=0;j3:=0;i:=255;

case tcomponent(SENDER).TAG of
0: {ascii}
repeat
if (((pdata^[j2]>47) and (pdata^[j2]<57)) or
   ((pdata^[j2]>64) and (pdata^[j2]<127)) or (pdata^[j2]=32))
then inc(j3)
   else
  begin
  if j3>5 then {get string only if longer than 5}
   begin
   pdata^[2]:=0;
   sss:=pchar(@pdata^[j2-j3]);
   memo1proc;
   end;
  j3:=0;
  end;
inc(j2);
until j2>sec[j].psize;
1: {UNICODE}
repeat
if ((pdata^[j2]=i) and (pdata^[j2-1]>$1F)) then inc(j3)
else
  begin
   if j3>4 then {get u-string if longer than 4}
   begin
   if i<>0 then inc(j3);
   sss:=widecharlentostring(pwidechar(@pdata^[j2-j3*2-1]),j3);
   if copy(sss,1,3)<>'???' then memo1proc;
   end;
  dec(j2);j3:=0;
  i:=pdata^[j2];
  end;
inc(j2,2);
until j2>=sec[j].psize;
2: {russian}
{!!! the same code as ascii}
repeat
if (((pdata^[j2]>191) and (pdata^[j2]<=255))
   or (pdata^[j2]=32))
then inc(j3)
   else
  begin
  if j3>5 then {get string}
   begin
     pdata^[j2]:=0;
     sss:=pchar(@pdata^[j2-j3]);
     memo1proc;
   end;
  j3:=0;
  end;
inc(j2);
until j2>sec[j].psize;
end {case};
disposepdata;
EnD;
END;
memo1endupdate;
STATUS('No more strings found');
end;

{==== relocate image base ====}
procedure TFRM.B_IB_C(Sender: TObject);
var pRelocs:^tdataarray; {pointer to buffer which
                         will contain block of relocations}
    cur_blk:pointer; {pointer to current entry in the block}
    delta,rs,crva,i:Integer;
begin
if dirs[d_fixup].rva<>0 then
Begin
delta:=strtointex(e_ib.text)-pe.imagebase;
rs:=getownersection(d_fixup);
getmempdata(sec[rs].psize);
getmem(prelocs,4096);
readsec(rs);
cur_blk:=pdata;

while (Integer(cur_blk^)<>0) do
   begin {process 1 page}
   crva:=rva2offset(Integer(cur_blk^));
   seek(exefile,crva);
   blockread(exefile,prelocs^,4096);
   inc(Integer(cur_blk),4);
   rs:=Integer(cur_blk^) shr 1;
   inc(Integer(cur_blk),4);
   for i:=5 to rs do
       begin
{FIXME: type 3 relocations supported only}
       if (word(cur_blk^) and $f000)=$3000 then
          asm
          mov eax,[cur_blk]
          mov eax,[eax]
          and eax,$FFF
          mov ecx,prelocs
          add ecx,eax
          mov edx,delta
          add [ecx],edx
          end;
{          else unsupported relocation type}
       inc(Integer(cur_blk),2);
       end;
   seek(exefile,crva);
   blockwrite(exefile,prelocs^,4096);
   end;
dispose(prelocs);
disposepdata;
m_save_c(nil);
End
Else status('No relocations');
end;

{==== convert import(s) to named from ordinal ====}
{FIXME: just hangs}
procedure TFRM.to_named(Sender: TObject);
var j1,j2,j3:Integer;
    sl:tstringlist;
begin
j2:=ttvinfo(tv.selected.data^).data;
ini:=tinifile.create(inpewdir(zExpCfg));
sl:=tstringlist.create;
ini.readsectionvalues(impdlls[j2].name,sl);
for j1:=0 to sl.count-1 do
begin
sl.strings[j1]:=sl.values[sl.names[j1]]+'='+sl.names[j1];
end;
if tcomponent(sender).tag>0
 then {one function}
begin j1:=impdlls[j2].ifuncs+sg_imp.row-1;j3:=j1; end
 else {All functions}
begin j1:=impdlls[j2].ifuncs;j3:=(impdlls[j2].numfuncs+impdlls[j2].ifuncs); end;

for j1:=j1 to j3 do
begin
if impfuncs[j1].byordinal then
BEGIN
if sl.indexof(inttostr(impfuncs[j1].nameRVA))>0 then
   begin
   impfuncs[j1].byordinal:=false;
   impfuncs[j1].name:=sl.values[inttostr(impfuncs[j1].nameRVA)];
   end;
END;
end;
sl.free;
ini.free;
tv_c(nil,tv.selected);
end;

{==== rebuild dump ====}
procedure TFRM.M_DO_C(Sender: TObject);
var i:Integer;
begin
if OD.execute then
   begin
if f_open then {a file is open already, close it}
            m_Close_c(nil);{CLOSE FILE}
   assigntempr;
   readpe(tempfile);
   if ispe then
BeGiN
   if sd.execute then
   BEGIN
    assignfile(exefile,sd.filename);
    exefn:=sd.filename;
    rewrite(exefile,1);
    getmempdata(sec[1].offset);
    seek(tempfile,0);
    blockread(tempfile,pdata^,sec[1].offset);
    blockwrite(exefile,pdata^,sec[1].offset);
    disposepdata;
    for i:=1 to pe.numobjects do
      begin
        getmempdata(sec[i].psize);
        seek(tempfile,sec[i].rva);
        blockread(tempfile,pdata^,sec[i].psize);
        seek(exefile,sec[i].offset);
        blockwrite(exefile,pdata^,sec[i].psize);
        disposepdata;
      end;
    m_rr_c(nil);
   END;
EnD else status('Bad dump');
   closefile(tempfile);
   end;
end;

{==== return overlay size & seek to the start of it ====}
function ovlsize:Integer;
begin
seek(exefile,sec[pe.numobjects].offset+sec[pe.numobjects].psize);
result:=fsizexe-filepos(exefile);
end;

{==== remove overlay ====}
procedure TFRM.m_rmovl_c(Sender: TObject);
begin
ovlsize;
truncate(exefile);
status('Overlay truncated');
end;

{==== save overlay ====}
procedure TFRM.m_ovls_c(Sender: TObject);
var os:Integer;
begin
os:=ovlsize;
if os>0 then
   begin
   if sd.execute then
      begin
      getmempdata(os);
      blockread(exefile,pdata^,os);
      assigntemp(sd.filename);
      blockwrite(tempfile,Pdata^,os);
      closefile(tempfile);
      disposepdata;
      status(format('Overlay saved (%d)',[os]));
      end;
   end
else sNoOvl;
end;

{==== make section from overlay ====}
procedure TFRM.m_ovlmks_c(Sender: TObject);
var os:Integer;
begin
os:=ovlsize;
if os>0 then
   begin
   addsec(pe.numobjects+1);
   sec[pe.numobjects].psize:=os;
   sec[pe.numobjects].vsize:=os;
   m_refr_c(nil);nbpi(3);
   end
else sNoOvl;
end;

end.

{how do you like this mess?}
