{PE Workshop v.1.2 Copyright (C) 1999-2000 Andrei Glinski.}

{executable format structures for DELPHI32.}

TYPE

{PE OBject table record}

PEObjTableRec=record
    ObjectName:array [0..7] of char;
    VSize:Integer;
    RVA:Integer;
    PSize:Integer;
    Offset:Integer;
    RelocPtr:Integer;
    LineNumPtr:Integer;
    numReloc:word;
    numLines:word;
    ObjectFlags:Integer;
end;

{PE header}

PEhdr=record
   Signature:Integer; {0x00004550}
   CPUtype:word;
   NumObjects:word;
   TimeDate:Integer;
   SymbolTable:Integer;
   numSymbols:Integer;
   NTHdrSize:word;
{the number of remaining bytes in the
header that follow the FLAGS field.}
   Flags:word;
   MagicOptionalHdr:word; { $010B }
   Lmajor:byte;
   Lminor:byte;
   CodeSize:Integer;
   InitData:Integer;
   UninitData:Integer;
   EntryPointRVA:Integer;
   CodeBase:Integer;
   DataBase:Integer;
   ImageBase:Integer;
   ObjectAlign:Integer;
   FileAlign:Integer;
   OSmajor:word;
   OSminor:word;
   UserMajor:word;
   UserMinor:word;
   SubSysMajor:word;
   SubSysMinor:word;
   Reserved9:Integer;
   ImageSize:Integer;
   HeaderSize:Integer;
   FileChecksum:Integer;
   SubSystem:word;
   DLLflags:word;
   StackReserveSize:Integer;
   StackCommitSize:Integer;
   HeapReserveSize:Integer;
   HeapCommitSize:Integer;
   LoaderFlags:Integer;
   NumRVASizes:Integer;
end;

PEdirectory=record
   RVA:Integer;
   Size:Integer;
end;

{export directory table}

PEexportdirtable=record
   exportflags:Integer; {zero}
   timestamp:Integer;
   verMajor:word;
   verMinor:word;
   nameRVA:Integer;
   ordinalBase:Integer;
   numEATentries:Integer;
   numNamePtrs:Integer;
   AddressTRVA:Integer;
   NamePtrTRVA:Integer;
   ordinalTRVA:Integer;
end;

{Correct import directorty table entry?
MS' docs are very wrong on this subject.
Some logic is needed to interpret imports
correctly (meaning of record members
changes depending on their values).
If IAT is missing and iatRVA=0, then
we need to swap iatRVA and lookupRVA, so
our universal code will work with both variants.}

PEIDTE=record
  lookupRVA:Integer;
  timestamp:Integer;
  flags:Integer;
  nameRVA:Integer;
  iatRVA:Integer;
end;

{pe resource directory table}

PERDT=record
  flags:Integer;
  time:Integer;
  version:Integer;
  numName:word;
  numID:word;
end;

{PE resource directory entry}

PErestree=record
  idrva:Integer; {ID or name rva}
  datarva:Integer; {Data #rva# if 80000000h bit is zero}
end;               {otherwise - subdir #rva#}

{resource data entry}

PErde=record
  datarva:Integer; {?}
  size:Integer;
  codepage:Integer;
  reserved:Integer;
end;

{DOS MZ header}

MZhdr=record
    Signature:word; {0x5a4d or 0x4d5a}
    BytesLastPage:word;
    NumPages:word; {512b each}
    Relocations:word;
    HdrParagraphs:word;
    MinMemory:word;
    MaxMemory:word;
    SS:word;
    SP:word;
    Checksum:word;
    IP:word;
    CS:word;
    RelocTableAddr:word;
    NumOverlay:word;
    BINPROG:ARRAY[1..17]OF BYTE; {it's a mess just }
    MESSAGE:array[0..14] of CHAR;  {for my mini-stub}
    NewHdrOffset:Integer;
end;

CONST

{resource types}

RT_CURSOR=1;
RT_BITMAP=2;
RT_ICON=3;
RT_MENU=4;
RT_DIALOG=5;
RT_STRING=6;
RT_FONTDIR=7;
RT_FONT=8;
RT_ACCELERATOR=9;
RT_RCDATA=10;
RT_MESSAGETABLE=11;
RT_GROUP_CURSOR=12;
RT_GROUP_ICON=14;
RT_VERSION=16;
RT_DLGINIT=$F0;

{FIXME: the format of resource type
descriptions must be changed, because RT_* are
not sequential.}

restype:array[1..16]of pchar=(
'Cursor',
'Bitmap',
'Icon',
'Menu',
'Dialog',
'String',
'Fontdir',
'Font',
'Accelerator',
'Rcdata',
'Messagetable',
'Group_cursor',
'13',
'Group_icon',
'15',
'Version');

{PE directory descriptions}

dirDescr:array [1..13] of pchar=(
'Export',
'Import',
'Resource',
'Exception',
'Security',
'Fixup',
'Debug',
'Description',
'Machine Specific',
'TLS',
'Load Config',
'Bound Import',
'IAT');

{... and corresponding indexes}

d_export:byte=1;
d_import:byte=2;
d_resource:byte=3;
d_exeption:byte=4;
d_security:byte=5;
d_fixup:byte=6;
d_debug:byte=7;
d_descr:byte=8;
d_machine:byte=9;
d_tls:byte=10;
d_loadcfg:byte=11;
d_bound:byte=12;
d_iat:byte=13;

{CPU type}

cpu_unknown:word=0;
cpu_386:word=$14c;
cpu_486:word=$14d;
cpu_586:word=$14e;
cpu_mark1:word=$162;
cpu_mark2:word=$163;
cpu_mark3:word=$166;
cpu_type:array[0..6] of word=(0,$14c,$14d,$14e,$162,$163,$166);

{Subsystem type}

sub_type:array[0..5] of word=(0,1,2,3,5,7);
sub_unknown:word=0;
sub_native:word=1;
sub_wingui:word=2;
sub_winchar:word=3;
sub_os2char:word=5;
sub_posix:word=7;

