{PE Workshop v.1.2 Copyright (C) 1999-2000 Andrei Glinski.}

{the address converter}

unit CNV;

interface

uses
Windows,SysUtils,Classes,Controls,Forms,Dialogs,StdCtrls;

type
  TCCC = class(TForm)
    RVA:TEdit;
    VA:TEdit;
    OFFS: TEdit;
    LSEC: TLabel;
    procedure EKD(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure RVA_CH(Sender: TObject);
    procedure VA_CH(Sender: TObject);
    procedure OFFS_Ch(Sender: TObject);
    procedure ccc_a(Sender: TObject);
  end;

var
  CCC: TCCC;

implementation
uses main;
{$R *.DFM}

{show section, which contains specified file offset}
PROCEDURE SHOWSEC(OFFS:INTEGER);
var sect:integer;
BEGIN
sect:=0;
REPEAT INC(sect);
UNTIL ((OFFS>=SEC[sect].OFFSET) AND
      (OFFS<(SEC[sect].OFFSET+SEC[sect].PSIZE))) or
      (sect>PE.NUMOBJECTS);
IF (sect>PE.NUMOBJECTS) THEN CCC.LSec.CAPTION:=''
ELSE CCC.LSec.CAPTION:=MAIN.DESCRIBESEC(sect);
END;

{calculate offset}
PROCEDURE calc_OFFS;
var j:integer;
BEGIN
     J:=rva2offset(strtointex(CCC.RVA.text));
     CCC.offs.text:=inttostrex(J,8);
     SHOWSEC(J);
     disable_ctl:=false;
END;

{calculate virtual address}
PROCEDURE calc_VA;
BEGIN
	disable_ctl:=true;
	CCC.VA.text:=inttostrex(pe.imagebase+strtointex(CCC.RVA.text),8);
END;

{==== edit.keydown ====}
procedure TCCC.EKD(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	if key=$1b then close; {ESC}
	frm.ekd(Sender,Key,Shift);
end;

{rva field changed}
procedure TCCC.RVA_CH(Sender:TObject);
begin
if not disable_ctl then
	begin
		calc_VA;
		calc_OFFS;
	end;
end;

{va changed}
procedure TCCC.VA_CH(Sender:TObject);
begin
if not disable_ctl then
  begin
	disable_ctl:=true;
	RVA.text:=inttostrex(strtointex(VA.text)-pe.imagebase,8);
	calc_OFFS;
  end;
end;

{offset changed}
procedure TCCC.OFFS_Ch(Sender:TObject);
var j:integer;
begin
if not disable_ctl then
begin
disable_ctl:=true;
j:=strtointex(offs.text);
RVA.text:=inttostrex(offset2rva(j),8);
calc_VA;
showsec(j);
disable_ctl:=false;
end;
end;

{==== form.onactivate ====}
procedure TCCC.ccc_a(Sender:TObject);
begin
RVA.clear;
RVA.pastefromclipboard;
disable_ctl:=false;
end;

end.

