/* 
   PEUtils v1.0	
   (c) 1998 Andrew de Quincey
   adq@tardis.ed.ac.uk
   See README.TXT for copying/distribution/modification details.
*/


#ifndef PEJOIN_P_H
#define PEJOIN_P_H


#include <stdio.h>
#include <fcntl.h>
#include <error.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <stdarg.h>
#include "pe.h"


static char* sectionNames[] = {"PEHEADER",
			       "NTOPTIONALHEADER",
			       "DATADIRECTORIES",
			       "SECTIONS",
			       NULL};

static char* peHeaderNames[] = {"CPUTYPE",
				"NUMSECTIONS",
				"DATESTAMP",
				"SYMBOLTABLE",
				"NUMSYMBOLS",
				"OPTIONALHEADERSIZE",
				"FLAGS",
				"DOSSTUB",
				NULL};

static char* ntOptionalHeaderNames[] = {"MAGIC",
				       "LINKERMAJOR",
				       "LINKERMINOR",
				       "CODESIZE",
				       "INITDATASIZE",
				       "UNINITDATASIZE",
				       "ENTRYPOINT",
				       "CODEBASE",
				       "DATABASE",
				       "IMAGEBASE",
				       "SECTIONALIGN",
				       "FILEALIGN",
				       "OSMAJOR",
				       "OSMINOR",
				       "IMAGEMAJOR",
				       "IMAGEMINOR",
				       "SUBSYSTEMMAJOR",
				       "SUBSYSTEMMINOR",
				       "RESERVED",
				       "IMAGESIZE",
				       "HEADERSSIZE",
				       "CHECKSUM",
				       "SUBSYSTEM",
				       "DLLFLAGS",
				       "STACKRESERVESIZE",
				       "STACKCOMMITSIZE",
				       "HEAPRESERVESIZE",
				       "HEAPCOMMITSIZE",
				       "LOADERFLAGS",
				       "NUMDATADIRECTORIES",
				       NULL};


void readX(int fd, void* buf, int size);
void error(char* fmt, ...);
void copyData(int srcFD, int srcLength, int destFD);
int openX(char* file, int flags, int mode);
void writeString(int fd, char* fmt, ...);
int getItemNumber(char* buffer, char** items);
int readString(int fd, char* buffer);
void peHeaderParser(int fd, PEHeader* peHeader, char* dosStubFilename);
void ntOptionalHeaderParser(int fd, NTOptionalHeader* ntOptHeader);
int dataDirectoryParser(int fd, DataDirectory*** dataDirs);
void wipeEndSpace(char* buffer);
int fileLength(int fd);


#endif
