{
 *************************************************************************
 *
 *                           UNIT1.PAS
 *
 * Delphi unit for the peedit program
 *
 * Author : Prof. Abimbola A Olowofoyeku <African_Chief@bigfoot.com>
 *
 * Licence: This code is released as FREEWARE, and is supplied
 *          WITHOUT ANY WARRANTIES WHATSOEVER
 *
 * (c)2000,2001 Prof. Abimbola A Olowofoyeku (The African Chief)
 *
 **************************************************************************
}
UNIT Unit1;

INTERFACE

USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, PEUnit;

TYPE
  TForm1 = CLASS ( TForm )
    GroupBox1 : TGroupBox;
    Button1 : TButton;
    Edit1 : TEdit;
    Edit2 : TEdit;
    Edit3 : TEdit;
    Edit4 : TEdit;
    Label1 : TLabel;
    Label2 : TLabel;
    Label3 : TLabel;
    Label4 : TLabel;
    Edit5 : TEdit;
    Label5 : TLabel;
    Label6 : TLabel;
    Edit6 : TEdit;
    Label7 : TLabel;
    Edit7 : TEdit;
    Edit8 : TEdit;
    Edit9 : TEdit;
    Edit10 : TEdit;
    Edit11 : TEdit;
    Edit12 : TEdit;
    Label8 : TLabel;
    Label9 : TLabel;
    Label10 : TLabel;
    Label11 : TLabel;
    Label12 : TLabel;
    Button3 : TButton;
    OpenDialog1 : TOpenDialog;
    Button4 : TButton;
    Label13 : TLabel;
    Label14 : TLabel;
    Label15 : TLabel;
    Label16 : TLabel;
    Edit13 : TEdit;
    Edit14 : TEdit;
    Edit15 : TEdit;
    Edit16 : TEdit;
    Edit17 : TEdit;
    Edit18 : TEdit;
    Label17 : TLabel;
    Label18 : TLabel;
    Label19 : TLabel;
    Label20 : TLabel;
    Label21 : TLabel;
    Label22 : TLabel;
    BitBtn1 : TBitBtn;
    Edit19 : TEdit;
    Edit20 : TEdit;
    Edit21 : TEdit;
    Label23 : TLabel;
    Label24 : TLabel;
    Label25 : TLabel;
    Edit22 : TEdit;
    Edit23 : TEdit;
    Edit24 : TEdit;
    Edit25 : TEdit;
    Edit26 : TEdit;
    Edit27 : TEdit;
    Edit28 : TEdit;
    Label26 : TLabel;
    Label27 : TLabel;
    Label28 : TLabel;
    Label29 : TLabel;
    Label30 : TLabel;
    Label31 : TLabel;
    Label32 : TLabel;
    AboutBtn : TButton;
    PROCEDURE Button1Click ( Sender : TObject );
    PROCEDURE Button3Click ( Sender : TObject );
    PROCEDURE FormCreate ( Sender : TObject );
    PROCEDURE Button4Click ( Sender : TObject );
    PROCEDURE BitBtn1Click ( Sender : TObject );
    PROCEDURE AboutBtnClick ( Sender : TObject );
  PRIVATE
    { Private declarations }
    FName : String;
    TheFile : File;
    TheRec  : PE_HeaderRec;
    Code    : Longint;
    PROCEDURE Clearall;
    PROCEDURE ReadPE;
  PUBLIC
    { Public declarations }
  END;

VAR
  Form1 : TForm1;

IMPLEMENTATION

{$R *.DFM}

{$I-}

CONST
ProgramName = 'PE Edit v1.0 (c)2000 Prof A Olowofoyeku (The African Chief)';

VAR MyReadOnly : Boolean = True;

PROCEDURE TForm1.Clearall;
BEGIN
   Edit1.Text := '';
   Edit2.Text := '';
   Edit3.Text := '';
   Edit4.Text := '';
   Edit5.Text := '';
   Edit6.Text := '';
   Edit7.Text := '';
   Edit8.Text := '';
   Edit9.Text := '';
   Edit10.Text := '';
   Edit11.Text := '';
   Edit12.Text := '';
   Edit13.Text := '';
   Edit14.Text := '';
   Edit15.Text := '';
   Edit16.Text := '';
   Edit17.Text := '';
   Edit18.Text := '';
   Edit19.Text := '';
   Edit20.Text := '';
   Edit21.Text := '';
   Edit22.Text := '';
   Edit23.Text := '';
   Edit24.Text := '';
   Edit25.Text := '';
   Edit26.Text := '';
   Edit27.Text := '';
   Edit28.Text := '';
   Label15.Caption := '';
   IF MyReadOnly THEN Label16.Caption := 'Read Only'
   ELSE Label16.Caption := 'Undetermined';
   Bitbtn1.Enabled := False;
   FName := '';
   FillChar ( TheRec, Sizeof ( TheRec ), 0 );
END;

PROCEDURE TForm1.Button1Click ( Sender : TObject );
BEGIN
   Close;
END;

PROCEDURE TForm1.ReadPE;
VAR
Ro      : Boolean; // read only ?
old     : byte;
BEGIN
   IF FName = '' THEN BEGIN
      MessageBeep ( 0 );
      Exit;
   END;

   Ro := MyReadOnly;
   IF ( FName > '' ) AND ( FileExists ( FName ) )
   THEN BEGIN
      AssignFile ( TheFile, FName );
      Reset ( TheFile, 1 );
      Code := IOResult;
      IF Code <> 0   // TRY AND open IN read only mode
      THEN BEGIN
         old := FileMode;
         FileMode := fmOpenRead OR fmShareDenyWrite;
         Reset ( TheFile, 1 );
         FileMode := old;
         Code := IoResult;
         IF Code = 0 THEN Ro := True;
      END;

      IF Code <> 0
      THEN BEGIN
         ShowMessage ( 'Unable to open ' + FName );
         Exit;
      END;

      Code := ReadWholePEHeader ( TheFile, TheRec );
      IF Code > 0 THEN
      WITH TheRec.OptionalHeader
      DO BEGIN
            Edit1.Text := IntToStr ( MajorLinkerVersion );
            Edit2.Text := IntToStr ( MinorLinkerVersion );
            Edit3.Text := IntToStr ( ImageBase );
            Edit4.Text := IntToStr ( MajorOperatingSystemVersion );
            Edit5.Text := IntToStr ( MinorOperatingSystemVersion );
            Edit6.Text := IntToStr ( CheckSum );
            Edit7.Text := IntToStr ( MajorImageVersion );
            Edit8.Text := IntToStr ( MinorImageVersion );
            Edit9.Text := IntToStr ( MajorSubsystemVersion );
            Edit10.Text := IntToStr ( MinorSubsystemVersion );
            Edit11.Text := IntToStr ( Subsystem );
            Edit12.Text := IntToStr ( DllCharacteristics );
            Edit13.Text := IntToStr ( SizeOfStackReserve );
            Edit14.Text := IntToStr ( SizeOfStackCommit );
            Edit15.Text := IntToStr ( SizeOfHeapReserve );
            Edit16.Text := IntToStr ( SizeOfHeapCommit );
            Edit17.Text := IntToStr ( BaseOfCode );
            Edit18.Text := IntToStr ( BaseOfData );

            Edit19.Text := IntToStr ( SectionAlignment );
            Edit20.Text := IntToStr ( FileAlignment );
            Edit21.Text := IntToStr ( SizeOfCode );

            Edit22.Text := IntToStr ( SizeOfImage );
            Edit23.Text := IntToStr ( SizeOfHeaders );
            Edit24.Text := IntToStr ( SizeOfInitializedData );
            Edit25.Text := IntToStr ( SizeOfUninitializedData );
            Edit26.Text := IntToStr ( AddressOfEntryPoint );
            Edit27.Text := IntToStr ( TheRec.PEHeader.NumberOfSymbols );
            Edit28.Text := IntToStr ( TheRec.PEHeader.PointerToSymbolTable );


            Label15.Caption := FName;
            IF Ro THEN BEGIN
               Label16.Caption := 'Read Only';
               Bitbtn1.Enabled := False;
            END
            ELSE BEGIN
               Label16.Caption := 'Read and Write';
               Bitbtn1.Enabled := True;
            END;
      END ELSE BEGIN
          ShowMessage ( 'Unable to read PE header information from ' + FName );
          FName := '';
      END;
      CloseFile ( TheFile );
   END;
END;

PROCEDURE TForm1.Button3Click ( Sender : TObject );
BEGIN
   IF FName > ''
   THEN BEGIN
      MessageBeep ( 0 );
      ShowMessage ( 'Please close the current file first.' );
      Exit;
   END;

   IF OpenDialog1.Execute
   THEN BEGIN
      FName :=  Opendialog1.Filename;
   END ELSE BEGIN
     FName := '';
     Exit;
   END;

   ReadPE;
END;

PROCEDURE TForm1.FormCreate ( Sender : TObject );
BEGIN
    Clearall;
END;

PROCEDURE TForm1.Button4Click ( Sender : TObject );
BEGIN
    Clearall;
END;

PROCEDURE TForm1.BitBtn1Click ( Sender : TObject );
VAR
j : longint;
BEGIN
   MessageBeep ( 0 );
   IF Windows.MessageBox ( Handle,
   'Altering a PE file can render the file useless! Are you sure that you still want to alter the file?'#10#10'IF YOU CLICK ON "YES", THEN YOU ARE ON YOUR OWN!!!',
   '!!! SERIOUS WARNING !!!',
   mb_YesNo ) <> id_Yes THEN Exit;

   IF Windows.MessageBox ( Handle,
   'Are you sure that you want to alter the file?',
   '!!! LAST WARNING !!!', mb_YesNo ) <> id_Yes THEN Exit;

   Reset ( TheFile, 1 );
   IF Ioresult <> 0 THEN BEGIN
      ShowMessage ( 'I cannot open ' + FName + ' for writing.' );
      Exit;
   END;

   j := PEOptionalHeaderOffSet ( TheFile );
   Seek ( TheFile, j );
   IF ( j < 1 ) OR ( Ioresult <> 0 )
   THEN BEGIN
      ShowMessage ( 'I cannot open ' + FName + ' for writing.' );
      CloseFile ( TheFile );
      Exit;
   END;


   WITH TheRec.OptionalHeader
   DO BEGIN
           MajorLinkerVersion := StrtoIntDef ( Edit1.Text, ( MajorLinkerVersion ) );
           MinorLinkerVersion := StrtoIntDef ( Edit2.Text, ( MinorLinkerVersion ) );
           ImageBase := StrtoIntDef ( Edit3.Text, ( ImageBase ) );
           MajorOperatingSystemVersion := StrtoIntDef ( Edit4.Text, ( MajorOperatingSystemVersion ) );
           MinorOperatingSystemVersion := StrtoIntDef ( Edit5.Text, ( MinorOperatingSystemVersion ) );
           CheckSum := StrtoIntDef ( Edit6.Text, ( CheckSum ) );
           MajorImageVersion := StrtoIntDef ( Edit7.Text, ( MajorImageVersion ) );
           MinorImageVersion := StrtoIntDef ( Edit8.Text, ( MinorImageVersion ) );
           MajorSubsystemVersion := StrtoIntDef ( Edit9.Text, ( MajorSubsystemVersion ) );
           MinorSubsystemVersion := StrtoIntDef ( Edit10.Text, ( MinorSubsystemVersion ) );
           Subsystem := StrtoIntDef ( Edit11.Text, ( Subsystem ) );
           DllCharacteristics := StrtoIntDef ( Edit12.Text, ( DllCharacteristics ) );
           SizeOfStackReserve := StrtoIntDef ( Edit13.Text, ( SizeOfStackReserve ) );
           SizeOfStackCommit := StrtoIntDef ( Edit14.Text, ( SizeOfStackCommit ) );
           SizeOfHeapReserve := StrtoIntDef ( Edit15.Text, ( SizeOfHeapReserve ) );
           SizeOfHeapCommit := StrtoIntDef ( Edit16.Text, ( SizeOfHeapCommit ) );
           BaseOfCode := StrtoIntDef ( Edit17.Text, ( BaseOfCode ) );
           BaseOfData := StrtoIntDef ( Edit18.Text, ( BaseOfData ) );
           SectionAlignment := StrtoIntDef ( Edit19.Text, ( SectionAlignment ) );
           FileAlignment := StrtoIntDef ( Edit20.Text, ( FileAlignment ) );
           SizeOfCode := StrtoIntDef ( Edit21.Text, ( SizeOfCode ) );

           SizeOfImage := StrtoIntDef ( Edit22.Text, ( SizeOfImage ) );
           SizeOfHeaders := StrtoIntDef ( Edit23.Text, ( SizeOfHeaders ) );
           SizeOfInitializedData := StrtoIntDef ( Edit24.Text, ( SizeOfInitializedData ) );
           SizeOfUninitializedData := StrtoIntDef ( Edit25.Text, ( SizeOfUninitializedData ) );
           AddressOfEntryPoint := StrtoIntDef ( Edit26.Text, ( AddressOfEntryPoint ) );
   END;

   BlockWrite ( TheFile, TheRec.OptionalHeader,
              Sizeof ( TheRec.OptionalHeader ) );
   j := IOResult;
   CloseFile ( TheFile );
   IF j = 0 THEN BEGIN
      ReadPE;
   END ELSE BEGIN
      ShowMessage ( 'I could not write to the file: ' + FName );
   END;
END;

PROCEDURE TForm1.AboutBtnClick ( Sender : TObject );
BEGIN
   MessageBox ( Handle,
   'PE Edit v1.0 (c)2000-2001 Professor Abimbola Olowofoyeku (The African Chief)'#10'http://www.bigfoot.com/~african_chief/'#10#10'USE AT YOUR OWN RISK!',
   'About PE Edit: Viewer and Editor for Win32 PE Headers', 0 );
END;

VAR
s : ShortString;
BEGIN
  s := UpperCase ( ParamStr ( 1 ) );
  IF ( s = '-RW' ) OR ( s = '/RW' ) THEN MyReadOnly := False
  ELSE BEGIN
     IF ( s = '/?' ) OR ( s = '-?' ) OR ( s = '/HELP' )
     OR ( s = '-HELP' ) OR ( s = '--HELP' )
     THEN BEGIN
        MessageBox ( 0,
        'Syntax = PEEdit [-RW]'#10'(-RW = Read and Write)'#10'Default = Read Only'#10#10'USE AT YOUR OWN RISK!!!',
        'PE Edit: Viewer and Editor for Win32 PE Headers', 0 );
        Halt;
     END;
  END;

END.

