/*********************************************************************/
/*                                                                   */
/*  This Program Written by Paul Edwards, 3:711/934@fidonet.         */
/*  Released to the Public Domain                                    */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  pdcommd.h - see pdcommd.c for docs                               */
/*                                                                   */
/*********************************************************************/

#ifndef PDCOMMD_INCLUDED
#define PDCOMMD_INCLUDED

#include <stddef.h>

#include "uart.h"

#define PDCOMM_NO_PARITY UART_NO_PARITY
#define PDCOMM_EVEN_PARITY UART_EVEN_PARITY
#define PDCOMM_ODD_PARITY UART_ODD_PARITY

typedef struct
{
    UART uart;

    int intrpt;
    int parity;
    int parityd;
    int databits;
    int stopbits;
    long bps;
    
    int a8259;
    int imr;
    int vector;
    char oldIRQ[4];
    
    int ch;
    size_t recBufSiz;
    size_t txBufSiz;
    char   *recBuf;
    char   *txBuf;
    char   *recStartPos;
    char   *txStartPos;
    char   *recEndPos;
    char   *txEndPos;
    char   *recReadPos;
    char * volatile txReadPos;
    char   *recWritePos;
    char * volatile txWritePos;
    volatile int txempty;
    int     ctsShake;
    int     ctsOK;
    
} PDCOMM;

void pdcommDefaults(PDCOMM *pdcomm);
void pdcommInit(PDCOMM *pdcomm, char *name);
void pdcommSetSpeed(PDCOMM *pdcomm, unsigned long speed);
void pdcommSetParms(PDCOMM *pdcomm, int parity, int data, int stop);
int pdcommWriteCh(PDCOMM *pdcomm, int ch);
size_t pdcommWriteBuf(PDCOMM *pdcomm, void *vbuf, size_t nelem);
int pdcommReadCh(PDCOMM *pdcomm);
size_t pdcommReadBuf(PDCOMM *pdcomm, void *vbuf, size_t nelem);
void pdcommTerm(PDCOMM *pdcomm);

#define pdcommSetWBuf(a, b, c, d)
#define pdcommSetRBuf(a, b, c, d)
#define pdcommWFlush(a)
#define pdcommRFlush(a)

#endif
