program SplitTextFile;

{                                ᥥ. -, 14.06.95
                                e-Mail: 2:5030/445.8@fidonet.org
ணࠬ ࠧ१ ⥪⮢ 䠩 讣 ࠧ  
⢮ 쪨 (ࠢ⥫쭮).  쪨 䠩:
  )  ࠧ  48 ;
  ) 室  ⮬  ⠫   ⥬  ,   室;
  )  ७, ࠢ  浪  ᮧ: 001, 002  ..;
  ) ᫨ 䠩  ⠪  㦥 ⢮,  ࠥ  直 ᮢ.
ᠭ   40   㡮 ࠪ᪮ 楫: ࠧ१ ⥪⮢
䠩  㬥樥  Object Windows ࠧ஬ 1,5   ⠪
䠩,    ஡:
  ) ᯥ뢠    ࠧ,   ᪮쪮 ਥ;
  ) 㦠   ⥪⮢ ।;
  )  뢥  (㬠 )   ⮣ । 筮.
, ਣ  .
  訡: 쬠 ७ :)
ॡ㥬  Turbo Pascal:  ᮩ
 ४   室 । 樥 ?
  ) ࠢ ⠭ LinesInPage  ࠢ쭮  襣 ਭ
     ⢮ ப  ࠭;
  ) ⠭   ६ TruncateType,  뢠,
      ࠧ࠭稢 ᮧ 쪨 䠩:
      - byLine:  ࠭栬 ப;
      - byPage:  ࠭栬; ࠭楩   LinesInPage ப,
           ப, 稢訥 ᨬ " ࠭",
      - byFixedPage: ᨬ " ࠭"  ⥪ 모뢠,
          ࠭楩 ⠥ ஢ LinesInPage ப.
}

{$i-}

uses Dos;

const
        EOP = #12;
       Each = 48 * 1024;
    BufSize = 16 * 1024;
     Process: string[4] = '-\|/';
      Number: integer = 0;
       Count: integer = 0;
   PageLines: integer = 0;
 LinesInPage: integer = 66;
TruncateType: (byLine, byPage, byFixedPage) = byPage;

var
  Src, Dest: text;
  SrcBuf, DestBuf: array[0..BufSize-1] of byte;
  SrcName, DestName, S: string;
  Total: LongInt;
  SkipLine: boolean;
  I: integer;
  D: DirStr;
  N: NameStr;
  E: ExtStr;

procedure Syntax;
begin
  writeln ('Syntax: SPLIT textfile.doc');
  writeln;
  writeln ('This program create from source many small files (each size 48K)');
  writeln ('New files created with source name and extensions .001, .002, ...');
  halt;
end;

procedure IOcheck;
var
  temp: integer;
begin
  temp := IOResult;
  if temp <> 0 then
  begin
    writeln ('I/O error #',temp,' - abort SPLIT');
    halt;
  end;
end;

begin
  writeln ('SPLIT 1.0 (c) 1995 by EBCEEB,inc.');
  if ParamCount <> 1 then Syntax;

  SrcName := FExpand (ParamStr(1));
  Assign (Src, SrcName);
  SetTextBuf (Src, SrcBuf);
  Reset (Src);
  writeln ('Process file: ', SrcName);

  Number := 1;
  Count := 0;
  if TruncateType = byPage then Inc(LinesInPage);
  repeat
    inc (Count);
    write (Process[Count],#8);
    if Count = Length(Process) then Count:=0;

    Str(Number:3, S);
    for i:=1 to Length(S) do if S[i] = ' ' then S[i]:='0';
    FSplit (SrcName, D, N, E);
    DestName := D + N + '.' + S;
    Assign (Dest, DestName);
    Rewrite (Dest);
    IOcheck;
    SetTextBuf (Dest, DestBuf);
    Total := 0;
    repeat
      SkipLine := False;
      readln (Src, S);
      if TruncateType <> byPage then
      begin
        repeat
          i := Pos (EOP, S);
          if i > 0 then Delete(S, i, 1);
        until i = 0;
        if S = '' then SkipLine := True;
      end;
      if not SkipLine then
      begin
        writeln (Dest, S);
        inc (PageLines);
      end;
      inc (Total, Length(S) + 2);
      if (TruncateType = byLine) or
        ((TruncateType = byPage) and
          ((PageLines = LinesInPage) or (Pos (EOP, S) > 0))) or
        ((TruncateType = byFixedPage) and (PageLines = LinesInPage)) then
      PageLines := 0;
    until Eof(Src) or ((Total >= Each) and (PageLines = 0));
    IOcheck;
    write (Dest, #26);
    Close (Dest);
    inc(Number);
  until Eof(Src);
  write ('Completed.');
  Close (Src);
end.
