                WARN
               .Model   Tiny
               .CODE
                ORG     100h

Start           label   near
                JMP     Main
Comment !
                BW40    db   "BW40"
                CO40    db   "CO40"
                BW80    db   "BW80"
                CO80    db   "CO80"
                MONO    db   "MONO"
                Curs    db   "NORM"
                Hidd    db   "HIDD"
                Numl    db   "NUML"
                KBD@    db   "KBD+"
                KBD_    db   "KBD?"
                CPU@    db   "CPU+"
                CPU_    db   "CPU-"
!
                LF     equ   ,13,10
                EOL    equ   '$'
                LFN    equ   LF,'  - '
                ReturnToDos equ ret

Message    db   ''LF
  db   'Tiny Mode 1.3 (c) 1993-95 by EBCEEB, inc.'LF LF
  db   'Syntax:  MODE <command>'LF
  db   'Command:'LFN
BW40  db  'BW40/'
CO40  db  'CO40/'
BW80  db  'BW80/'
CO80  db  'CO80/'
MONO  db  'MONO    new textmode'LFN
Curs  db  'NORMAL/'
Hidd  db  'HIDDEN    new cursor size'LFN
Numl  db  'NUMLOCK          turn NumLock off'LFN
KBD@  db  'KBD+             set fast keyboard (AT only)'LFN
KBD_  db  'KBD?             ErrorLevel := peekb(0x40,0x17)'LFN
CPU@  db  'CPU+/'
CPU_  db  'CPU-        change CPU speed'LF,EOL

NotAT_Msg  db  'IBM AT required !',7,EOL

CASE            MACRO   Str, Label              ; Compare Macro
                mov     di, offset Str          ; DI = Ofs (Example String)
                call    Compare                 ; Execute Compare function
                je      Label                   ; If equal, then goto Label
                ENDM                            ; Else continue

Compare         label   near                    ; Compare two strings
                mov     cx, dx                  ; CX = Counter for Compare
                mov     si, bx                  ; SI = offset of ParamStr
                repz    cmpsb                   ; Compare with example
                ret                             ; Return result in Zero flag

Main            label   near                    ; Code begin
                cld                             ; Set string direction to normal
                mov     di, 80h                 ; DI = Ofs (ParamStr)
                mov     cl, [di]                ; Load Length (ParamStr) into CL
                xor     ch, ch                  ; And set CH to zero
                inc     di                      ; DI = address of first char
                mov     al, ' '                 ; Example := SPACE
                repz    scasb                   ; Find first not SPACE
                dec     di                      ; Return DI-pointer to previous
                jcxz    Help                    ; IF no params-> put HelpMessage

                mov     bx, di                  ; Else save Ofs (ParamStr) to BX
                mov     dx, 4                   ; DX = ParamLength
                mov     cx, dx                  ; CX = Counter for UpperCase

      UpperCase:mov     al, es:[di]             ; Get next char from string
                cmp     al, 'a'                 ; If this Char < 'a'
                jb      Next                    ;  then no modify
                cmp     al, 'z'                 ; If this Char > 'z'
                ja      Next                    ;  then no modify
                sub     al, ' '                 ; Else modify this Char
      Next:     stosb                           ; Save Char to string
                loop    UpperCase               ; Repeat operation

                xor     ax, ax                  ; For SetTextMode function
                CASE    BW40, SetBW40           ; Compare ParamStr with examples
                CASE    CO40, SetCO40           ; Switch of the functions:
                CASE    BW80, SetBW80           
                CASE    CO80, SetCO80           ;  1. Select number of mode
                CASE    MONO, SetMONO
                CASE    Curs, Cursor            ;  2. Set normal cursor
                CASE    Hidd, Hidden            ;  3. Set hidden cursor
                CASE    Numl, Numlock           ;  4. Turn NumLock off
                CASE    CPU@, Speeder           ;  5. Change CPU speed
                CASE    CPU_, Slower            ;  6. Set fast keyboard
                CASE    KBD@, KbdFast           ;  7. Load Shift-Status
                CASE    KBD_, KbdGet            ;  Else display help

      Help:     mov     ah, 9                   ; Write function
                lea     dx, Message             ; DX = Ofs (Message)
                int     21h                     ; Write Message to console
                ReturnToDos

      SetMONO:  mov     al, 4
      SetCO80:  inc     ax                      ; Set number of mode
      SetBW80:  inc     ax                      ; To 3, 2, 1, 0
      SetCO40:  inc     ax                      ;
      SetBW40:  int     10h                     ; Set new TextMode
                ReturnToDos

      Cursor:   mov     cx, 0607h               ; Set normal cursor for CGA
                jmp short SetCursor             ; And go to setting
      Hidden:   mov     cx, 2000h               ; Set hidden cursor
      SetCursor:inc     ah                      ; SetCursor function (AH=1)
                int     10h                     ; Set new cursor
                ReturnToDos

      NumLock:  mov     ah, 2                   ; Turn NumLock off
                int     16h                     ; This's on ?
                test    al, 20h                 ; IF NumLock is already off
                jz      None                    ;   then do nothing
                mov     al, 0EDh
                out     60h, al
                mov     cx, 2000h
      Waiting:  loop    Waiting
                and     ax, 8000h
                out     60h, al
                xor     bx, bx
                mov     es, bx
                and     al, not 20h
                mov     es:[417h], al
      None:     ReturnToDos

      Slower:   mov     ah, 12h                 ; Set fast or slow PC
                jmp short SetCPU                ; 12h = Slow
      Speeder:  mov     ah, 40h                 ; 40h = Fast
      SetCPU:   mov     al, 74h                 ; Modifying refresh rate
                out     43h, al
                mov     al, ah
                out     41h, al
                mov     al, 0
                out     41h, al
                ReturnToDos

      KbdFast:  mov     ax, 0F000h              ; Set fast keyboard
                mov     es, ax                  ;  -- For AT only --
                cmp byte ptr es:[0FFFEh], 0FCh  ; This is AT ?
                jne     NotAT                   ; IF not AT -> ErrorMsg

                mov     ax, 0305h
                xor     bx, bx
                int     16h
                ReturnToDos

      NotAT:    mov     ah, 9
                lea     dx, NotAT_Msg
                int     21h
                ReturnToDos

      KbdGet:   xor     ax, ax
                mov     es, ax
                mov     al, es:[417h]
                and     al, 7Fh
                mov     ah, 04Ch
                int     21h

                END     Start
