unit IO;

{
Simple unit for Turbo Pascal 7.0:
 - handle-oriented file I/O
 - DOS-oriented screen output
Copywrite (e) 1994-96 by EBCEEB,inc.
e-Mail: 2:5030/445.8@fidonet.org
}

{$A-,I-,S-,V-,D-,L-}

interface

type                   {*  used by LSeek  *}
  TOffset = (SEEK_SET,  SEEK_CUR,  SEEK_END);

const
  StdIn  = 0;          {*  standard handles  *}
  StdOut = 1;
  StdErr = 2;
  StdAUX = 3;
  StdPRN = 4;

  RdOnly  = $40;       {*  used by open()  *}
  WrOnly  = $01;
  RdWr    = $02;

  isExist      = 0;    {*  used by access()  *}
  isExecutable = 1;
  isForWrite   = 2;
  isForRead    = 4;

  faReadOnly  = $01;   {*  used by creat() & chmod()  *}
  faHidden    = $02;
  faSysFile   = $04;
  faVolumeID  = $08;
  faDirectory = $10;
  faArchive   = $20;
  faAnyFile   = $3F;

  LF = (#13#10);

function GetIOError: integer;

procedure PrintStr (const S: string);
procedure PrintStrLF (const S: string);
procedure errPrintStr (const S: string);
procedure errPrintStrLF (const S: string);
procedure TinyPrint (P: PChar);
inline (
  $8C/$D9/     { mov cx, ds }
  $5A/         { pop dx     }
  $1F/         { pop ds     }
  $B4/$09/     { mov ah,9   }
  $CD/$21/     { int 21h    }
  $8E/$D9);    { mov ds, cx }

function _Open  (FileName: PChar; Attr: integer): integer;
function _Creat (FileName: PChar; Attr: integer): integer;
function _Read  (Handle: integer; var Buffer; Count: word): integer;
function _Write (Handle: integer; var Buffer; Count: word): integer;
function _Close (Handle: integer): integer;
function LSeek (Handle: integer; Offset: LongInt; FromWhere: TOffset): LongInt;
function Tell  (Handle: integer): LongInt;
function FileLength (Handle: integer): LongInt;

function _Rename (From, Dest: PChar): integer;
function _ChMod (FileName: PChar; SetIt: boolean; Attr: integer): integer;
function Unlink (FileName: PChar): integer;
function Access (FileName: PChar; What: integer): boolean;
function MkTemp (Path: PChar; Attr: integer): integer;
function IsATTY (Handle: integer): boolean;

implementation

var
   IOError: Integer;
  Position: LongInt;

procedure IOstart;  assembler;
asm
  mov  ax, IOError
  mov  dx, -1
  or   ax, ax
  jz   @done
  stc
@done:
end;

procedure IOreturn;  assembler;
asm
  jnc  @done
{ cmp  IOError, 0
  jne  @done }
  neg  ax
  mov  IOError, ax
  mov  dx, -1
@done:
end;

function GetIOError: integer;  assembler;
asm
  xor  ax, ax
  xchg ax, IOError
  neg  ax
end;

procedure CommonPrint;  assembler;
  { BX = Handle   [BP+6] = @Str }
asm
  push  ds
  lds   si, [bp+6]
  cld
  lodsb
  xor   ah, ah
  xchg  ax, cx
  mov   ah, 40h
  mov   dx, si
  int   21h
  pop   ds
end;

procedure PrintStr (const S: String);  assembler;
asm
  mov   bx, StdOut
  call  CommonPrint
end;

procedure PrintStrLF (const S: string);
begin
  PrintStr (S);
  PrintStr (LF);
end;

procedure errPrintStr (const S: String);  assembler;
asm
  mov   bx, StdErr
  call  CommonPrint
end;

procedure errPrintStrLF (const S: string);
begin
  errPrintStr (S);
  errPrintStr (LF);
end;

function _Open (FileName: PChar; Attr: integer): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  ax, Attr
  mov  ah, 03Dh
  push ds
  lds  dx, FileName
  int  21h
  pop  ds
  call IOreturn
@done:
end;

function _Creat (FileName: PChar; Attr: integer): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 03Ch
  mov  cx, Attr
  push ds
  lds  dx, FileName
  int  21h
  pop  ds
  call IOreturn
@done:
end;

function _Read (Handle: integer; var Buffer; Count: word): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 03Fh
  mov  bx, Handle
  mov  cx, Count
  push ds
  lds  dx, Buffer
  int  21h
  pop  ds
  call IOreturn
@done:
end;

function _Write (Handle: integer; var Buffer; Count: word): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 40h
  mov  bx, Handle
  mov  cx, Count
  push ds
  lds  dx, Buffer
  int  21h
  pop  ds
  call IOreturn
@done:
end;

function _Close (Handle: integer): integer;  assembler;
asm
  mov  ah, 03Eh
  mov  bx, Handle
  int  21h
  call IOreturn
@done:
end;

function LSeek (Handle: integer; Offset: LongInt; FromWhere: TOffset): LongInt;
  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 42h
  mov  al, FromWhere
  mov  bx, Handle
  mov  cx, word (&Offset[2])
  mov  dx, word (&Offset[0])
  int  21h
  call IOreturn
@done:
end;

function Tell (Handle: integer): LongInt;  assembler;
  { Tell := LSeek (Handle, 0, SEEK_CUR) }
asm
  push Handle
  xor  ax, ax
  push ax
  push ax  { push offset 0L }
  inc  ax
  push ax  { push SEEK_CUR }
  call LSeek
end;

function FileLength (Handle: integer): LongInt;  assembler;
asm
  call IOstart
  jc   @done
  mov  ax, 4201h
  mov  bx, Handle
  xor  cx, cx
  xor  dx, dx
  int  21h
  jc   @abort
  push dx
  push ax
  mov  ax, 4202h
  xor  cx, cx
  xor  dx, dx
  int  21h
  mov  word(Position[0]), ax
  mov  word(Position[2]), dx
  pop  dx
  pop  cx
  jc   @abort
  mov  ax, 4200h
  int  21h
  jc   @abort
  mov  ax, word(Position[0])
  mov  dx, word(Position[2])
@abort:
  call IOreturn
@done:
end;

function _Rename (From, Dest: PChar): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  al, 56h
  push ds
  lds  si, From
  les  di, Dest
  int  21h
  call IOreturn
@done:
end;

function _ChMod (FileName: PChar; SetIt: boolean; Attr: integer): integer;
  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 43h
  mov  al, SetIt
  mov  cx, Attr
  push ds
  lds  dx, FileName
  int  21h
  pop  ds
  jc   @error
  xchg ax, cx
  jmp  @done
@error:
  call IOreturn
@done:
end;

function Unlink (FileName: PChar): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 41h
  push ds
  lds  dx, FileName
  int  21h
  pop  ds
  call IOreturn
@done:
end;

function Access (FileName: PChar; What: integer): boolean;
begin
  Access := ((_ChMod (FileName, false, 0) and faReadOnly = 0) or
    (What and isForWrite = 0)) and (GetIOerror = 0);
end;

function MkTemp (Path: PChar; Attr: integer): integer;  assembler;
asm
  call IOstart
  jc   @done
  mov  ah, 05Ah
  mov  cx, Attr
  push ds
  lds  dx, Path
  int  21h
  pop  ds
  call IOreturn
@done:
end;

function IsATTY (Handle: integer): boolean;  assembler;
asm
  mov  ax, 4400h
  mov  bx, Handle
  int  21h
  mov  al, 0
  jc   @done
  shl  dl, 1
  rcl  al, 1
@done:
end;

end.
