program Interval;

(*                               ᥥ. -, 1.06.95
                                e-Mail: 2:5030/445.8@fidonet.org
INTRODUCTION }B-P

 । ணࠬ-쭮, 믮 -   ᥥ.
 ᮫ 砥  ⮬,    (ERRORLEVEL)  ୥. 
ᥡ INTERVAL.EXE ࠭ ᨢ  10- 祭ﬨ /६ (砫쭮 
㫨). ᬮ    "INTERVAL ?". ᫨   ணࠬ
 ࠬ஬ "!",      祭  ᠭ ⥪騥 /
/६ ( ,  㪠   ப).   ࠬ஢ 뢮
 ᪠.  ᭮ 筥, ᫨  "INTERVAL.EXE *
 ᫮㭤 ᫮".  ⥪騥 /६  ࠢ  㦥 -
ᠭ묨. ᫨ ࠧ    ᥪ㭤 ॢ蠥 㪠   ப,
 ⥪騥 /६ ࠭  EXE-䠩     ࠢ 1,
 ⨢ 砥 祣  EXE-䠩    頥 0.

    ࠡ⪨ ६ 㪠뢠,   㦥, ୮, 﫨,
  筮 ,   ⢥   ᥪ㭤, 襤  00:00 1.01.1980.
  㦭 , ᪮쪮 諮   ⮩ ᢥ⫮  - INTERVAL ᫨
 ⮬᪨,   㬥 㫨஢ ६ ࢠ  
: 1  -  3600 ᥪ㭤,  -  30  0 ᥪ㭤  ..

  ᫨ ந諠 訡, 頥 ERRORLEVEL 2.   訡 4:
  -  EXE-䠩  㦥 ᨣ । ⮩
  -   EXE-䠩 ࢠ ᫥⢨ 訡 -뢮
  -  ࠢ ⥪饩  ࠭饩  ᭨,
     ⥪  ࠭饩 - 쬠 ᫥ 
  -   ப   ࠬ   祣  



  interval ? [/n] -  ⥪騥 ࠭ 祭   祥
      (᫨ 㪠 /n,  ⮫쪮  祩  n)
  interval ! [/n] [㭤 []] -  ६  INTERVAL.EXE. ᫨ ६
       㪠,  ⥪饥. ᫨ /n  㪠,  㫥 祩
  interval * [/n] 㭤 [] - 㧭 ࠧ  ⥪騬 ६,
       ᠭ  n- 祩 (0, ᫨ /n  㪠). ᫨ ࠧ 
       ࢠ,  ERRORLEVEL 1,   ERRORLEVEL 0



 -  ⪠,  , 窠, ஢ ⮬ 86400 ᥪ㭤
 - ᫨ 㬠  ணࠬ, 易⥫쭮 ஢ ⥬,
   ⮡ ⠭ Offset ࠭ ᬥ饭 ப "LAST:"  EXE-䠩,
    嫮 ERRORLEVEL 2. ஢ ⠭ Last 
   室 ।ᢥ  ᨣன
 - /६ ᮧ EXE-䠩   ६ 䨪権
 -  樨  ॡ Turbo Pascal 7.0
 -  ࠬ   ࠧ ஡, ᨬ "/" ᪠᪠
   㭪 ParamStr  ࠧ⥫  ਭ
 - ⥪ IO -  ᮡ⢥ ⢮⢮, ࠡ⠥  䠩 १ -
   ਯ   祭  䠩 IO.H  Turbo C 2.0



 , ᫨:
  - INTERVAL.EXE ࠡ⠭ PKLite/LZEXE/Diet/AinExe
  -    -//-    ⠭ ਡ ReadOnly
  - ⨢ ࠭ ஫ 㬬   ᮧ   䠩
    (ਬ, MS AntiVirus ᮧ   楫 䠩 CHKLIST.MS)
  - ⨢ SCAN ᮡ稫  INTERVAL.EXE .. validation code
  -  ⨢   ஢ EXE-䠩
  - ⥫쭮 祭 ࠧ "ਬ砭"



⨬,  ࠧ    ᪠ SPEEDISK, ࠧ  ⪨ - DrWeb
  2  - AIDSTEST  ஢ન ᪠ C: (  㫪).
।⥫쭠 樠  :
        for %c in (0 1 2 3 4 5 6 7 8 9) do interval.exe ! /%c%
᫥騥 ᪨ ந  AUTOEXEC.BAT   :

  @echo off
  :: ⠭ ⢨
   ...

  :: SPEEDISK
  interval.exe * /9 0 7
  if ERRORLEVEL 2 goto IntervalError
  if ERRORLEVEL 1 goto StartSD
  if ERRORLEVEL 0 goto CheckWeb
  :StartSD
  for %c in (c d e f) do speedisk %c%:/f

  :: Doctor Web
  :CheckWeb
  interval.exe * /8 0 1
  if ERRORLEVEL 2 goto IntervalError
  if ERRORLEVEL 1 goto StartWeb
  if ERRORLEVEL 0 goto CheckAIDS
  :StartWeb
  web * /B /V /H /UG:

  :: AIDSTEST
  :CheckAIDS
  interval.exe * /7 7200
  if ERRORLEVEL 2 goto IntervalError
  if ERRORLEVEL 1 goto StartAIDS
  if ERRORLEVEL 0 goto Done
  :StartAIDS
  aidstest c:/s/f
  goto Done

  :IntervalError
  echo INTERVAL NE ZARABOTAL #8-( !^G
  :Done

 4DOS  NDOS  ஢  ᢮ AUTOEXEC.BTM :),
।⢮ 稭 ⮣ alias' ⨯:
  alias watcheck = `interval * /%1 %2 %3 ^ iff %?==1 then ^(%4&)^
    elseiff %?==2 ^ echo Bad interval.^ endiff`
 ⥬:
  watcheck 9 0 7   for %c in (c d e f) do speedisk %c%:/f
  watcheck 8 0 1   web * /B /V /H /UG:
  watcheck 7 7200 0   aidstest c:/s/f
  unalias watcheck

,.      32   !

*)

{$A-,I-,S-,V-}

uses DOS, Strings, IO;

type
  TDay = integer;
  TSec = LongInt;
  DateTimeRec = record
    D: TDay;
    T: TSec;
  end;

function IsLeapYear (Year: integer): boolean;
  {- Return true if Year is a leap year -}
begin
  IsLeapYear := (Year mod 4 = 0) and (Year mod 4000 <> 0) and
    ((Year mod 100 <> 0) or (Year mod 400 = 0));
end;

function DaysInMonth (Month, Year: integer): integer;
  {- Return the number of days in the specified month of a given year -}
const
  MonthLen: array[1..12] of byte = (31,28,31,30,31,30,31,31,30,31,30,31);
begin
{ if word(Year) < 100 then inc(Year, 1900); }
  DaysInMonth := 0;
  if (Month >= 1) and (Month <= 12) then
    DaysInMonth := MonthLen[Month] + ord ((Month = 2) and IsLeapYear(Year));
end;

function GetAbsoluteDays: TDay;
var
  Y, M, D, I, Result: word;
begin
  GetDate (Y, M, D, I);
  Result := 0;
  for i:=1980 to Y-1 do inc(Result, 365 + ord(IsLeapYear(i)));
  for i:=   1 to M-1 do inc(Result, DaysInMonth(M, Y));
  inc(Result, D);
  GetAbsoluteDays := Result;
end;

function GetAbsoluteSecs: TSec;
var
  H, M, S, I: word;
begin
  GetTime (H, M, S, I);
  GetAbsoluteSecs := LongInt (H * 60 + M) * 60 + S;
end;

procedure DeltaDateTime (Day1, Day2: TDay; Sec1, Sec2: TSec;
  var DeltaDay: TDay; var DeltaSec: TSec);
const
  SecInDay = 86400;
begin
  if ((Day1 > Day2) and (Sec1 < Sec2)) or
     ((Day1 < Day2) and (Sec1 > Sec2)) then
  begin
    if Day1 > Day2 then begin
      Dec(Day1);
      Inc(Sec1, SecInDay);
    end else begin
      Dec(Day2);
      Inc(Sec2, SecInDay);
    end;
  end;
  DeltaDay := Day1 - Day2;
  DeltaSec := Sec1 - Sec2;
end;

const
  MaxTimes = 10;
  Signature: string[5] = 'LAST:';
  Last: array [0..MaxTimes-1] of DateTimeRec = (
    (D:0;T:0),(D:0;T:0),(D:0;T:0),(D:0;T:0),(D:0;T:0),
    (D:0;T:0),(D:0;T:0),(D:0;T:0),(D:0;T:0),(D:0;T:0));
  ShowMsg: string[27] = 'Watch   contains ';
  ShowTimer = '?';
  CheckTimer = '*';
  UpdateTimer = '!';

var
  ParamDays, DeltaDays: TDay;
  ParamSecs, DeltaSecs: TSec;
  SecsOk, DaysOk, IndexOk, Ret1: boolean;
  Current: DateTimeRec;
  Index, Code, I: integer;
  Operation: char;
  St: string;
  CurLast: ^DateTimeRec;

procedure Error (const s: string);
begin
  PrintStr ('INTERVAL: ');
  PrintStrLF (S);
  halt(2);
end;

procedure Syntax;
begin
  PrintStrLF (LF+
    'INTERVAL 1.0 (c) by EBCEEB,inc.'+LF+
    'Syntax:  INTERVAL {?|!|*} [/n] Secs [Days]' +LF+LF+
    'Compares saved and current times: IF it''s delta > Days:Secs, then update saved'+LF+
    'time and return ERRORLEVEL 1, else ERRORLEVEL 0. IF update failed, return EL 2');
  PrintStrLF (LF+
    'Example: INTERVAL * 3600 [/n] - return ERRORLEVEL 1 on each hour'+LF+
          #9' INTERVAL * 0 1  [/n] - return ERRORLEVEL 1 on each day'+LF+
          #9' INTERVAL !      [/n] - setup: save current time to self'+LF+
          #9' INTERVAL ?      [/n] - display saved times');
  PrintStrLF (LF+
    'INTERVAL.EXE contains 10 watches. Use ''/n'' for select (0..9)');
  halt(2);
end;

procedure Setup;
const
  Offset = $156E; {!!!}
var
  Buffer: array[0..63] of char;
  St: string absolute Buffer;
  Handle: integer;
begin
  Handle := _Open (StrPCopy (Buffer, ParamStr(0)), RdWr);
  LSeek (Handle, Offset, SEEK_SET);
 _Read (Handle, St, sizeof(Signature));
  if (GetIOerror = 0) and (St <> Signature) then
    Error('Bad EXE-file, cannot save current time to it!');
  LSeek (Handle, Index*sizeof(DateTimeRec), SEEK_CUR);
 _Write (Handle, Current, sizeof(Current));
  if GetIOerror <> 0 then Error('I/O error, cannot save current time to self!');
 _Close (Handle);
end;

procedure ShowOneTimer;
begin
  ShowMsg[7] := char(Index+ord('0'));     PrintStr (ShowMsg);
  Str(CurLast^.D, St);  PrintStr(St);  PrintStr (' days, ');
  Str(CurLast^.T, St);  PrintStr(St);  PrintStrLF (' secs');
end;

begin
  Current.D := GetAbsoluteDays;
  Current.T := GetAbsoluteSecs;

  St := ParamStr(1);
  if Length(St) <> 1 then Syntax;
  Operation := St[1];
  case Operation of
    ShowTimer, CheckTimer, UpdateTimer:;
    else Syntax;
  end;

  for i:=2 to ParamCount do
  begin
    St := ParamStr(i);
    if St[1] = '/' then
    begin
      if Length(St) <> 2 then Syntax;
      Index := ord(St[2]) - ord('0');
      if (Index < 0) or (Index > 9) then Syntax;
      IndexOk := true;
    end else
    if not SecsOk then
    begin
      Val(St, ParamSecs, Code);
      if Code <> 0 then Syntax;
      SecsOk := true;
    end else
    if not DaysOk then
    begin
      Val(St, ParamDays, Code);
      if Code <> 0 then Syntax;
      DaysOk := true;
    end
    else Syntax;
  end;

  CurLast := @Last[Index];
  case Operation of
    ShowTimer: begin
      if SecsOk or DaysOk then Syntax;
      if IndexOk then ShowOneTimer else
      for Index:=0 to MaxTimes-1 do
      begin
        CurLast := @Last[Index];
        ShowOneTimer;
      end;
    end;
    CheckTimer: begin
      if not SecsOk then Syntax;
      DeltaDateTime (Current.D, CurLast^.D, Current.T, CurLast^.T, DeltaDays, DeltaSecs);
      if (DeltaDays < 0) or (DeltaSecs < 0) then
        Error('Current time is below as last saved, use "INTERVAL !" to fix.');
      Ret1 := (DeltaDays > ParamDays) or ((DeltaDays = ParamDays)
        and (DeltaSecs > ParamSecs));
      if Ret1 then Setup;
    end;
    UpdateTimer: begin
      if SecsOk then Current.T:=ParamSecs;
      if DaysOk then Current.D:=ParamDays;
      Setup;
    end;
  end;
  Halt (ord(Ret1));
end.
