unit    DiskData;

{                                ᥥ. -, 15.12.95
                                              প DPMI: 23.06.97
                                e-Mail: 2:5030/445.8@fidonet.org
                                        il@hm.csa.ru
    ⥪ ᯮ ᥣ  㭪,  㭪  㧭
⨯ ᪠.   ⠫    (   ⮫쪮 ), ᫨   ⮬,
 㦥 ,  뫮  ⪮.    㭪 GetDiskClass
 ⥪ OPRO ( OPDOS.PAS):
   -  㧭 ⨯ ᪠,   ᪮,   ᥣ    ;
   - ᪨ ଠ⮢, ⫨  360, 1.2, 720, 1.44,  ;
   - 䠭⮬ ᪨  .
  㭪   ⪮ 襭.  砥  ࠬ:
   - 㪢 ᪮ ('A', 'B', ... , 'Z')
   - 䫠 InfoDisk: ᫨  ࠢ TRUE,   ᬥ ᪮
     㧭 ࠪ⨪ ᪥ (   ⠢):
     Size/Free/Volume/SubstP,  ᫨ FALSE,  ⮫쪮 ࠪ⨪
     ᠬ ᪮: Class/Fixed/... .  ꥬ ᪮ 祭
     InfoDisk ஫  ࠥ.
   - 뫪   TDriveData,  㤥 
     祭 ଠ樥.
頥  TRUE, ᫨  諮 ଠ쭮,  FALSE, ᫨ 뫠
訡 (    ᪥   InfoDisk=TRUE).
⪮ ,   :
   -  ᯮ Bernoulli Drive,   ᪮  IOMega -
     ⮬      ᪮,  ᠭ;
   -  ஢ SuperStor;
   -  ।  Host-䠩  Stacker' ᪠ ('?:\STAC_VOL.*');
   -  ࠡ뢠 Join-᪨;
   -  ᯮ Assign-᪨;
   -   Subst-᪮  १ 㬥஢
     㭪 $60,  ॡ, ⮡ 뫠 ⠢ ᪥,
       ᠬ      ⮣.
   ᠬ  ⪮  ⠪   .
 (  ) ⪠ ਭ  ࠧࠡ稪 Microsoft
/ Borland,     祬:
   -  ⠭ DriveSpace ᬥ ᪮ 稭 
      맮 int21h AX=440Dh CX=860h   InfoDisk = False.
     ७ , 祬...
 ॡ:
   - Borland Pascal 7.0;
   - DOS 3.2 ( DOS 3.1,     ᪮ ᯮ  FloppyAll
⢥   ⠫    
ப "interface"  "implementation".
}

interface

uses    DOS;

const
  drvFixed      = $01;  { Fixed or Removable }
  drvPhantom    = $02;  { created with DRIVER.SYS ?}
  drvSubst      = $04;  { created with SUBST ?}
  drvShared     = $08;  { used by network server as shareable drive ?}

type
  TDriveClass   = ( Floppy360, Floppy12, Floppy720, Floppy8I,  Floppy8II,
                    Hard,      Tape,     Floppy144, Dummy1,    Floppy288,
                    NetDisk,   RamDisk,  CDROM,     Stacker,   DblSpace,
                    FloppyAll, Invalid );

  TDriveData    = record
    Class       : TDriveClass;
    DrvFlags    : word;         { see 'drvXXX' constants }
    Size        : LongInt;
    Free        : LongInt;
    Volume      : string [11];  { volume label }
    SubstP      : PathStr;      { original path for SUBST-drive }
    CVF         : string [15];  { CVF name: now support DriveSpace only! }
  end;

function DriveValid ( Drive : char ) : boolean;

function GetDriveDataPrim ( Drive : char; InfoDisk : boolean;
  var DriveData : TDriveData ) : boolean;

function GetDriveData ( Drive : char; InfoDisk : boolean;
  var DriveData : TDriveData ) : boolean;

implementation

uses    Strings {$IFDEF DPMI}, DPMI, WinAPI {$ENDIF};

{$IFNDEF DPMI}
type    TRealModeRegs = Registers;

procedure RealModeInt ( IntNo : byte; var Regs : TRealModeRegs ); far; assembler;
asm
  pop bp
  jmp far ptr Intr
end;
{$ENDIF}

type
  THeaderExtFCB = object
    Flag        : byte;
    Reserv      : array [1..5] of byte;
    Attrib      : byte;
    DiskNo      : byte;
    Name        : array [0..7] of char;
    Ext         : array [0..2] of char;
  end;

  TExtFCB       = object ( THeaderExtFCB )
    filler      : array [1..26] of byte;
  end;

  TResult11h    = object ( THeaderExtFCB )
    filler      : array [1..21] of byte;
  end;

  TDPB          = record
    bDrvNo      : byte;    { drive number (0=A, 1=B, etc.) }
    bUnitNo     : byte;    { sub-unit number }
    wSectSize   : word;    { bytes per sector }
    bClustMask  : byte;    { sectors per cluster-1 (max sector in cluster) }
    bClustShift : byte;    { cluster-to-sector shift (cluster is 2 sectors) }
    wFirstFAT   : word;    { sector number of first start of first FAT }
    bFatCnt     : byte;    { number of FATs }
    filler      : array [1..23] of byte;
  end;

  TDeviceParams = record
    Request     : byte;
    DrvType     : TDriveClass;
    filler      : array [1..1022] of byte;
  end;

var
  StacEntry     : ^Byte;
  DblSpaceFound : boolean;

procedure DetectStacker;
var
  Buf       : array[1..1024] of byte;
  StacRec   : record
    LongId  : LongInt;
    Entry   : ^Word;
  end absolute Buf;
{$IFDEF DPMI}
  R         : TRealModeRegs;
  DOSPtr    : longint;
begin
  DOSPtr := GlobalDOSAlloc ( 16 + 1024 );
  if DOSPtr <> 0 then begin
    R.ax := $CDCD;
    R.bx := $10;
    R.cx := 1;
    R.dx := 0;
    R.ds := HiWord ( DOSPtr );
    R.sp := 0;
    R.ss := 0;
    MemL [LoWord ( DOSPtr ) : $00] := $CB5925CD;   { int 25 / pop cx / retf }
    MemW [LoWord ( DOSPtr ) : $10] := 0;
    RealModeCall ( Ptr ( HiWord ( DOSPtr ), 0 ), R );
    Move ( Ptr ( LoWord ( DOSPtr ), $10 )^, Buf, 1024 );
    GlobalDOSFree ( LoWord ( DOSPtr ) );
  end else
    R.Flags := FCarry;
{$ELSE}
begin
  asm
    mov   ax, 0CDCDh
    lea   bx, Buf
    mov   cx, 1
    xor   dx, dx
    push  ds
    push  ss
    pop   ds
    mov   word ptr [bx], dx
    int   25h
    pop   cx
    pop   ds
  end;
{$ENDIF}
  if ( StacRec.LongId = $0001CDCD ) and ( StacRec.Entry^ = $A55A ) then
    StacEntry := pointer ( StacRec.Entry );
end;

procedure DetectDblSpace;
var R : TRealModeRegs;
begin
  DblSpaceFound := False;
  if Lo ( DosVersion ) >= 6 then begin
    R.ax := $4A11;
    R.bx := 0;
{$IFDEF DPMI}
    R.sp := 0;
    R.ss := 0;
{$ENDIF}
    RealModeInt ( $2F, R );
    if ( R.ax = 0 ) and ( R.bx = $444D ) then
      DblSpaceFound := True;
  end;
end;

function DriveValid ( Drive: char ) : boolean; assembler;
asm
    mov   ah, 19h         { Save the current drive in BL }
    int   21h
    mov   bl, al
    mov   dl, Drive       { Select the given drive }
    sub   dl, 'A'
    mov   ah, 0Eh
    int   21h
    mov   ah, 19h         { Retrieve what DOS thinks is current }
    int   21h
    mov   cx, 0           { Assume false }
    cmp   al, dl          { Is the current drive the given drive? }
    jne   @@1
    mov   cx, 1           { It is, so the drive is valid }
    mov   dl, bl          { Restore the old drive }
    mov   ah, 0Eh
    int   21h
@@1:xchg  cx, ax          { Put the return value into AX }
end;

function GetDriveDataPrim ( Drive : char; InfoDisk : boolean;
  var DriveData : TDriveData ) : boolean;
var
  PR        : Registers;
  R, Q      : TRealModeRegs;
  DOSPtr    : longint;
  D, DosVer : integer;
  SR        : SearchRec;
  Result    : boolean;
  TrueName  : array [0..127] of char;
  DPB       : ^TDPB;
  DevParms  : TDeviceParams;
  TempDTA   : TResult11h;
  S         : string [16];
const
  SubstSt   : array [0..3] of char = 'A:\'#0;
  VolExtFCB : TExtFCB = (
    Flag    : $FF;
    Reserv  : ( 0, 0, 0, 0, 0 );
    Attrib  : VolumeId;
    DiskNo  : 0;
    Name    : '????????';
    Ext     : '???' );
begin
{$IFDEF DPMI}
  R.sp := 0;
  R.ss := 0;
  Q.sp := 0;
  Q.ss := 0;
{$ENDIF}
  Result := True;
  DosVer := Swap ( DosVersion );
  Drive  := UpCase ( Drive );
  D := succ ( ord ( Drive ) - ord ( 'A' ) );
  FillChar ( DriveData, Sizeof ( DriveData ), 0 );
  with DriveData do begin
    if DosVer >= $30A then begin { fn 4409 allowed in DOS 3.10+ }
      R.ax := $4409;
      R.bx := D;
      RealModeInt ( $21, R );
    end else begin
      R.dx := 0;
      R.Flags := ord ( DriveValid ( Drive ) );  { set or clear FCarry (=1) }
    end;
    if R.Flags and FCarry = 0 then begin
      Q.ax := $150B;   { Check CDROM }
      Q.bx := 0;
      Q.cx := D - 1;
      RealModeInt ( $2F, Q );
      if ( Q.bx = $ADAD ) and ( Q.ax > 0 ) then
        Class := CDROM;
      if ( R.dx and $1000 = 0 ) or ( Class = CDROM ) then begin
        if R.dx and $0100 > 0 then
          Inc ( DrvFlags, drvShared );
        if R.dx and $8000 > 0 then
          Inc ( DrvFlags, drvSubst );
        R.ax := $4408;
        R.bl := D;
        RealModeInt ( $21, R );
        if ( R.Flags and FCarry = 0 ) and ( R.ax = 0 ) then begin { is floppy }
          if DrvFlags and drvSubst = 0 then begin
            R.ax := $440E;
            R.bl := D;
            RealModeInt ( $21, R );
            if ( R.Flags and FCarry = 0 ) and ( R.al > 0 ) and ( R.al <> D ) then
              Inc ( DrvFlags, drvPhantom );
          end;
          if DosVer >= $314 then begin { fn 440D.60 allowed in DOS 3.20+ }
{$IFDEF DPMI}
            DOSPtr := GlobalDOSAlloc ( 38 );
            if DOSPtr <> 0 then begin
              R.ax := $440D;
              R.bl := D;
              R.cx := $860;
              R.dx := 0;
              R.ds := HiWord ( DOSPtr );
              Mem [LoWord ( DOSPtr ) : 0] := 4;
              RealModeInt ( $21, R );
              Move ( Ptr ( LoWord ( DOSPtr ), 0 )^, DevParms, 38 );
              GlobalDOSFree ( LoWord ( DOSPtr ) );
            end else
              R.Flags := FCarry;
{$ELSE}
            DevParms.Request := 4;
            R.ax := $440D;
            R.bx := D;
            R.cx := $860;
            R.dx := Ofs ( DevParms );
            R.ds := Seg ( DevParms );
            RealModeInt ( $21, R );
{$ENDIF}
            if R.Flags and FCarry = 0 then
              Class  := DevParms.DrvType
            else
              Result := False;
          end else
            Class := FloppyAll;
        end else
          if Class <> CDROM then begin { is fixed }
            inc ( DrvFlags, drvFixed );
            PR.ah := $32;
            PR.dl := D;
            MSDOS ( PR );
            DPB := Ptr ( PR.ds, PR.bx );
            if PR.al <> $FF then
              with DPB^ do begin
                if bFatCnt = 1 then
                  Class := RamDisk
                else
                  Class := Hard;
              end
            else
              Result:=False;
          end; { unremovable }
        if ( Seg ( StacEntry^ ) <> 0 ) then begin { check stacker }
          Inc ( Word ( StacEntry ), $3E );
          R.ax := $4408;
          R.bl := D;
          if DosVer = $031F then
            R.ax := $440E;
          StacEntry^ := $FF;
          RealModeInt ( $21, R );
          if StacEntry^ <> $FF then
            Class := Stacker;
          Dec ( Word ( StacEntry ), $3E );
        end;
        if DblSpaceFound then begin
          Q.ax := $4A11;
          Q.bx := 1;
          Q.dl := D - 1;
          RealModeInt ( $2F, Q );
          if ( Q.ax = 0 ) and ( Q.bl and $80 <> 0 ) then
            Class := DblSpace;
          Str ( Q.bh, S );
          CVF := '?:\DRVSPACE.000';
          CVF [1] := char ( ( Q.bl and not $80 ) + ord ( 'A' ) );
          Move ( S [1], CVF [Length ( CVF ) - Length ( S ) + 1], Length ( S ) );
          if DosVer <= $614 then begin
            CVF [5] := 'B';
            CVF [6] := 'L';
          end;
        end;
      end { local } else begin { network }
        Inc ( DrvFlags, drvFixed );
        Class := NetDisk;
      end;
      if DrvFlags and drvFixed > 0 then
        InfoDisk := True;
      if InfoDisk then begin
        if DrvFlags and drvSubst <> 0 then begin
{$IFDEF DPMI}
          DOSPtr := GlobalDOSAlloc ( 4 + 128 );
          if DOSPtr <> 0 then begin
            Q.ah := $60;
            Q.si := 0;
            Q.ds := HiWord ( DOSPtr );
            Q.di := 4;
            Q.es := HiWord ( DOSPtr );
            MemL [LoWord ( DOSPtr ) : 0] := $005C3A40 + ord ( D ); { 'D:\'#0 }
            RealModeInt ( $21, Q );
            Move ( Ptr ( LoWord ( DOSPtr ), 4 )^, TrueName, 128 );
            GlobalDOSFree ( LoWord ( DOSPtr ) );
          end else
            Q.Flags := FCarry;
{$ELSE}
          SubstSt [0] := Drive;
          Q.ah := $60;
          Q.si := Ofs ( SubstSt );
          Q.ds := Seg ( SubstSt );
          Q.di := Ofs ( TrueName );
          Q.es := Seg ( TrueName );
          RealModeInt ( $21, Q );
{$ENDIF}
          if ( Q.Flags and FCarry > 0 ) or
             not GetDriveData ( TrueName [0], InfoDisk, DriveData ) then
            Result := False;
          SubstP := StrPas ( TrueName );
          drvFlags := drvFlags or drvSubst;
        end else begin
          Free := DiskFree ( D );
          if Free = -1 then
            Result := False
          else begin
            Size := DiskSize ( D );
            if Size = -1 then
              Result := False
            else begin
              VolExtFCB.DiskNo := D;
              PR.ah := $1A;
              PR.ds := Seg ( TempDTA );
              PR.dx := Ofs ( TempDTA );
              MSDOS ( PR );
              PR.ah := $11;
              PR.ds := Seg ( VolExtFCB );
              PR.dx := Ofs ( VolExtFCB );
              MSDOS ( PR );
              if PR.al = 0 then begin
                Volume [0] := #11;
                Move ( TempDTA.Name, Volume [1], Length ( Volume ) );
              end;
            end; { DiskSize ok }
          end; { DiskFree ok }
        end; { not Subst }
      end; { InfoDisk }
    end { not Carry }
    else
      Result := False;
    if not Result then
      Class := Invalid;
  end; { with }
  GetDriveDataPrim := Result;
end;

function GetDriveData ( Drive : char; InfoDisk : boolean;
  var DriveData : TDriveData ) : boolean;
var
  Result : boolean;
begin
  Result := GetDriveDataPrim ( Drive, InfoDisk, DriveData );
  if ( ( Ofs ( StacEntry^ ) <> 0 ) or DblSpaceFound ) and
     Result and InfoDisk and ( DriveData.DrvFlags and drvFixed = 0 ) then
    Result := GetDriveDataPrim ( Drive, InfoDisk, DriveData );
  GetDriveData := Result;
end;

begin
  DetectDblSpace;
  DetectStacker;
end.
