program CountryService;

{$A-,I-,S-,V-}

uses DOS, IO;

type
  CountryBlock = record
    wDateFormat: word;               { 0=mdy, 1=dmy, 2=ymd }
    szCrncySymb: array[0..4] of char;{ currency symbol     }
    szThouSep,                       { thousands separator }
    szDecSep,                        { decimal separator }
    szDateSep,                       { date separator }
    szTimeSep: array[0..1] of char;  { time separator }
    bCrncyFlags: byte;               { 0="$xx", 1="xx$", 2="$ xx", 3="xx $" }
    bCrncyDigits: byte;              { decimals digits in currency }
    bTimeFormat: byte;               { 0=12, 1=24 }
    pfCasemap: pointer;              { Casemap FAR call address }
    szDataSep: array[0..1] of char;  { data list separator }
    reserved: array[0..9] of char;
  end;

  ExtCountryBlock = record
    bRecID: byte;       { Information ID (01H on calls to fn 6501H) }
    wRecLen: word;      { size of information }
    wCountryID: word;   { Country Code }
    wCodePgID: word;    { Code Page }
    X: CountryBlock;
  end;

procedure Syntax;
begin
  PrintStrLF ('Syntax: country.exe [countryNumber]');
  Halt(1);
end;

function Hex (Value: word; Size: integer): string;
const
  BaseStr: PChar = '0123456789ABCDEF';
begin
  Hex[0] := char(Size);
  while Size > 0 do
  begin
    Hex[Size] := BaseStr[Value and $F];
    Value := Value shr 4;
    dec(Size);
  end;
end;

const
  DateFormat: array[0..2] of string[8] = ('MM/DD/YY', 'DD/MM/YY', 'YY/MM/DD');
  Separator: array[0..3] of string[11] =
    ('  Thousands', '    Decimal', '       Date', '       Time');
  CrncyFlags: array[0..3] of string[8] = ('$123.00', '123.00$', '$ 123.00', '123.00 $');
  Time: array[0..1] of string[8] = ('12 hours', '24 hours');

var
  Code, Err: integer;
  C: ExtCountryBlock;
  R: Registers;
  P: PChar;
  S: string;

begin
  PrintStrLF ('Country 1.0 (c) 1995 by EBCEEB, inc.');
  if Lo(DosVersion) < 3 then PrintStrLF ('Sorry, DOS 3.0 required.')
  else if ParamCount > 1 then Syntax
  else with R do begin {**}
    if ParamCount = 1 then
    begin
      Val (ParamStr(1), Code, Err);
      if (Err<>0) or (Code=0) then Syntax;
      AX := $38FF;
      BX := Code;
      DX := $FFFF;
      MSDos (R);
      if Flags and FCarry <> 0 then PrintStrLF ('Select country bad.')
    end;

    AX := $38FF;
    BX := 0;
    DS := Seg(C.X);
    DX := Ofs(C.X);
    MSDos (R);
    if Flags and FCarry <> 0 then PrintStrLF ('Get current country bad.')
    else Code:=BX;

    AX := $6501;
    BX := $FFFF;
    CX := sizeof(ExtCountryBlock);
    DX := Code;
    ES := Seg(C);
    DI := Ofs(C);
    MSDos (R);
    if Flags and FCarry <> 0 then PrintStrLF ('Get country bad.')
    else with C, C.X do begin

      Str(wCountryID, S);  PrintStr (LF+'         Country code: ');  PrintStrLF(S);
      Str(wCodePgID, S);   PrintStr (   '            Code page: ');  PrintStrLF(S);

      PrintStr ('           DateFormat: ');
      PrintStrLF (DateFormat [wDateFormat]);

      PrintStr ('      Currency symbol: ');
      _Write (StdOut, szCrncySymb, sizeof(szCrncySymb));
      PrintStrLF ('');

      P := @szThouSep;
      for Code := 0 to 3 do
      begin
        PrintStr (Separator[Code]);
        PrintStr (' separator: ');
        _Write (StdOut, P^, 2);
        inc(P, 2);
        PrintStrLF ('');
      end;

      PrintStr ('      Currency format: ');
      PrintStrLF (CrncyFlags [bCrncyFlags]);

      PrintStr ('       Decimal digits: ');
      PrintStrLF (char (bCrncyDigits + ord('0')));

      PrintStr ('          Time format: ');
      PrintStrLF (Time [bTimeFormat]);

      PrintStr ('            Casemap @: ');
      PrintStr (Hex(Seg(pfCaseMap^), 4));
      PrintStr (':');
      PrintStrLF (Hex(Ofs(pfCaseMap^), 4));

      PrintStr ('       Data separator: ');
      _Write (StdOut, szDataSep, sizeof(szDataSep));
      PrintStrLF ('');
    end;
  end; {**}
end.
