unit ChTicks;

(*                               ᥥ. -, 10.06.95
                                e-Mail: 2:5030/445.8@fidonet.org
    ⥪ ।⠢   ८। 
맮 ⠩. -  䮭 OPTIMER.PAS   OPRO  -
 祭 㠫쭮 룫廊,       ⭮ - 祣  ᪠
 OPTIMER. ᯮ ᥣ  㭪:
   function SetMsPerTick (ms: word): boolean;
ms -   ⢮ ᥪ㭤  맮 뢠 ⠩.
頥  TRUE, ᫨  ଠ쭮,  FALSE, ᫨ ms > 55.
   ᪠ ?
   1) SetMsPerTick   樨 8- 뢠
       ⠢   ᢮ ࠡ稪.  ࠡ稪,  ᢮ ।,
      믮 -⢥ :    ࠢ୮
      뢠  ࠡ稪  । ⮩ 18 ࠧ/ᥪ.
       ࠧ,   , 樨  ᪮  .. த
       ୮ ६.
   2) ⮡ ⠭ 쬮 , 맮
      SetMsPerTick(StandardMsPerTick).  襭 ணࠬ
      ⠪ 맮  ⮬᪨.
   3) ᫨ ணࠬ 蠥 ਭ㤨⥫쭮,  ⠩    
      ⠭ -   ⮣,  ਭ㦤 (ନ PT.COM
      ⠭, Turbo Debugger 2.5 - ). 室 : 
      १ 設,   ணࠬ, ⠭
      ࠢ  맮 뢠, ਬ:
        uses ChTicks;
        begin
        end.
   4)    楤,  㤥 뢠 直 ࠧ,
       ࠡ稪 뢠 砥 ࠢ,  ⮣ 
        ᪮஢  樥 {$F+},    ᥭ
       ६ UserTicks. ᫨  稭, ⨬, 楤
      ந뢠 䮭 모, ன 㦭  맮 100
      ࠧ/ᥪ,   ᯮ짮 㤥 룫拉 ਬ୮ ⠪:
        UserTicks := @MusicProc;
        SetMsPertTick (10);         { 100 ࠧ/ᥪ = 1ᥪ/10 }
        Readln;                     { - ,  몠 ࠥ ... }
        SetMsPerTick (StandardMsPerTick);   { 祭  }
        UserTicks := nil;           {  直  }
   5) Turbo Pascal  , 稭  5.0
*)

interface

uses DOS;

const
  StandardMsPerTick = 55;
  MsPerTick: word = StandardMsPerTick;

var
  UserTicks: procedure;

function SetMsPerTick (ms: word): boolean;

implementation

var
  SaveIntr: procedure;
  SaveExit: pointer;
 isActived: boolean;

procedure pushf; inline($9C);

function SimStep (n1, n2: word): word;
const
  n : word = 0;
  k : word = 0;
  x0: word = 0;
  y0: word = 0;
  xi: word = 0;
  yi: word = 0;
var
  tmp1, tmp2: word;
begin
  if n2 <> 0 then begin
    n:=n1;  k:=n2;
    x0 := n div k;
    y0 := n mod k;
    xi := 0;  yi := 0;
    SimStep := 0;
  end else
  begin
    if xi + yi = k  then begin xi:=0; yi:=0; end;
    tmp1 := (k - y0) * yi;
    tmp2 := y0 * xi;
    if (xi = 0) and (yi = 0) then
      if (k - y0 >= y0)
        then  begin  SimStep := x0;       inc(xi); end
        else  begin  SimStep := Succ(x0); inc(yi); end
      else if tmp1 > tmp2 then
        begin  SimStep := x0; inc(xi);  end
      else if tmp1 < tmp2 then
        begin  SimStep := Succ(x0);  inc(yi);  end
      else if tmp1 = tmp2  then
        if k-y0 >= y0
          then  begin SimStep := x0;       inc(xi); end
          else  begin SimStep := Succ(x0); inc(yi); end;
  end;  { current step }
end; { SimStep }

procedure BackTickInt; interrupt;
var
  i: integer;
begin
  for i:=1 to SimStep (0, 0) do
  begin
    pushf;
    SaveIntr;
  end;
  Port[$20]:=$20;
  if @UserTicks <> nil then UserTicks;
end;

function SetMsPerTick (ms: word): boolean;
var
  Latch: record L, H: word; end;
begin
  SetMsPerTick := False;
  if ms > StandardMsPerTick then Exit;
  SetMsPerTick := True;
  LongInt(Latch) := 1193180 * ms div 1000;
  if Latch.H <> 0 then Latch.L:=$FFFF;
  Port [$43] := $36;
  Port [$40] := Lo(Latch.L);
  Port [$40] := Hi(Latch.L);
  MsPerTick := ms;
  SimStep (1000 div StandardMsPerTick, 1000 div MsPerTick);
  if not isActived and (ms <> StandardMsPerTick) then
  begin
    GetIntVec (8, @SaveIntr);
    SetIntVec (8, @BackTickInt);
    isActived := True;
  end;
  if isActived and (ms = StandardMsPerTick) then
  begin
    SetIntVec (8, @SaveIntr);
    isActived := False;
  end;
end;

procedure TickExit; far;
begin
  SetMsPerTick (StandardMsPerTick);
  ExitProc := SaveExit;
end;

begin
  SaveExit := ExitProc;
  ExitProc := @TickExit;
  SetMsPerTick (StandardMsPerTick);
end.
