
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined( __MSDOS__ ) || defined( _WIN32 )

#include <sys\stat.h>
#include <io.h>
#define SLASH '\\'

#else /* if UNIX */

#include <sys/types.h>
#include <sys/stat.h>
#define SLASH '/'
#define O_BINARY 0

#endif /* if UNIX */

#include <fcntl.h>

#define  defSize  0x10000L    /*  64 KB */
#define  minSize  0x01000L    /*   4 KB */
#define  maxSize  0x80000L    /* 512 KB */
#define  bufSize  0x01000     /*   4 KB */

void halt( int exitcode, const char *msg )
{
    if( msg )
        puts( msg );
    exit( exitcode );
}

#define  syntax()  halt( 1, syntaxStr )

static char syntaxStr[] = "Syntax: binsplit file.ext [kilobytes]" ;

void int2str( int value, char *str, int width )
{
    int i, div;
    for( i = 1, div = 1; i < width; i++, div *= 10);
    for( ; div > 0; div /= 10 ) {
        *str++ = '0' + ( char )( i = value / div );
        value -= i * div;
    }
    *str = 0;
}

int main( int argc, char** argv )
{
    int h1, h2, num, nread;
    long portionSize = defSize, nallread;
    char outfname[256], *p, buf[bufSize];
    puts( "BIN Split tool v1.0   Copyright (c) 1998 by EBCEEB,inc." );
    if( argc==1 || argc > 3 )
        syntax();
    if( argc==3 && ( ( portionSize = 1024 * atol( argv[ 2 ] ) ) < minSize
            || portionSize > maxSize ) )
        halt( 2, "ERROR: invalid portion size value" );
    if( ( p = strrchr( argv[1], SLASH ) ) == NULL )
        p = argv[1];
    else ++p;
    if( ( p = strrchr( strcpy( outfname, p ), '.' ) ) == NULL )
        *( p = outfname + strlen( outfname ) ) = '.';
    ++p;
    if( ( h1 = open( argv[ 1 ], O_RDONLY|O_BINARY ) ) < 0 )
        halt( 3, "ERROR: cannot open source file" );
    num = 0;
    do {
        int2str( num, p, 3 );
        puts( outfname );
        if( ( h2 = open( outfname, O_CREAT|O_TRUNC|O_WRONLY|O_BINARY,
                S_IREAD|S_IWRITE ) ) < 0 )
            halt( 4, "ERROR: cannot create output file" );
        for( nallread = 0;
            nallread < portionSize && ( nread = read( h1, buf, bufSize ) ) > 0;
            nallread += nread )
        {
            if( write( h2, buf, nread ) != nread )
                halt( 5, "ERROR: cannot write to output file" );
        }
        close( h2 );
        if( nread < 0 )
            halt( 6, "ERROR: cannot read source file" );
        num++;
    } while( nread );
    close( h1 );
    return 0;
}
