;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                    PATCH.ASM                    
;                                                 
;                   File Patch                    
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

BufferSize	equ	64512
ProgramSize	equ	4096

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@15
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@15:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	bl, 2
		mov	di, Offset Par2
		mov	cx, 79
		call	ParamStr
		cmp	bh, 2
		jae	@01
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		xor	al, al
		jmp	@02
@01:		mov	bl, 1
		mov	di, Offset Par1
		mov	cx, 79
		call	ParamStr
		mov	dx, Offset Par1
		mov	ax, 3D00h
		int	21h
		jnc	@04
@05:		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@03
@04:		mov	si, ax
		mov	dx, Offset PatchName
		mov	ax, 3D00h
		int	21h
		jc	@05
		mov	PatchFile, ax
		mov	dx, Offset Par2
		xor	cx, cx
		mov	ah, 3Ch
		int	21h
		jnc	@08
		mov	dx, Offset CannotCreate
		mov	ah, 9
		int	21h
		mov	dx, Offset Par2
		stc
		call	PrintStr
		jmp	@02
@08:		mov	di, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@13
		mov	dx, Offset NoMemory
		jmp	@03
@13:		mov	Buffer, ax
		mov	bx, PatchFile
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		sub	ax, 4
		sbb	dx, 0
		mov	PatchLen, ax
		or	dx, dx
		je	@07
		mov	dx, Offset PatchName
		jmp	@12
@07:		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	cx, 4
		mov	dx, Offset OrigLen
		mov	ah, 3Fh
		int	21h
		mov	bx, si
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		cmp	word ptr OrigLen[0], ax
		jne	@10
		cmp	word ptr OrigLen[2], dx
		je	@11
@10:		mov	dx, Offset Par1
@12:		clc
		call	PrintStr
		mov	dx, Offset InvalidSize
		jmp	@03
@11:		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	ax, word ptr OrigLen[0]
		mov	dx, word ptr OrigLen[2]
		add	ax, PatchLen
		add	dx, 0
		mov	word ptr ReadLen[0], ax
		mov	word ptr ReadLen[2], dx
		mov	ax, 5700h
		int	21h
		mov	Time, cx
		mov	Date, dx
		xor	ax, ax
		mov	word ptr Pos[0], ax
		mov	word ptr Pos[2], ax
		mov	dx, Offset OrigLen
		mov	cx, 4
		mov	bx, PatchFile
		mov	ah, 40h
		int	21h
		mov	dx, Offset Patching
		mov	ah, 9
		int	21h
		mov	dx, Offset Par1
		clc
		call	PrintStr
		mov	dx, Offset Conjunctive
		mov	ah, 9
		int	21h
		mov	dx, Offset Par2
		stc
		call	PrintStr
		call	Percent
@09:		mov	ax, word ptr OrigLen[0]
		mov	dx, word ptr OrigLen[2]
		mov	bx, word ptr Pos[0]
		mov	cx, word ptr Pos[2]
		sub	ax, bx
		sbb	dx, cx
		jc	@17
		or	dx, dx
		jne	@18
		or	ax, ax
		je	@17
		cmp	ax, BufferSize
		jbe	@19
@18:		mov	ax, BufferSize
@19:		mov	cx, ax
		mov	ax, word ptr Pos[0]
		mov	dx, word ptr Pos[2]
		add	ax, cx
		adc	dx, 0
		mov	word ptr Pos[0], ax
		mov	word ptr Pos[2], dx
		mov	bx, si
		mov	ax, Buffer
		call	BlockRead
		mov	bx, di
		mov	ax, Buffer
		call	BlockWrite
		call	Percent
		jmp	@09
@17:		mov	bx, si
		mov	ah, 3Eh
		int	21h
		mov	ax, PatchLen
		mov	ax, Buffer
		mov	bx, PatchFile
		mov	cx, PatchLen
		call	BlockRead
		call	Percent
		xor	bx, bx
@16:		cmp	bx, word ptr PatchLen[0]
		jae	@14
		push	ds
		mov	ds, cs:Buffer
		mov	dx, ds:[bx]
		mov	cx, ds:[bx][2]
		mov	si, ds:[bx][4]
		add	bx, 6
		push	bx
		push	bx
		mov	bx, di
		mov	ax, 4200h
		int	21h
		pop	dx
		mov	cx, si
		mov	ah, 40h
		int	21h
		pop	bx
		add	bx, si
		pop	ds
		add	word ptr Pos[0], 6
		add	word ptr Pos[0], si
		push	bx
		call	Percent
		pop	bx
		jmp	@16
@14:		push	es
		mov	es, Buffer
		mov	ah, 49h
		int	21h
		pop	es
		mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		mov	bx, di
		mov	ax, 5701h
		mov	cx, Time
		mov	dx, Date
		int	21h
		mov	ah, 3Eh
		int	21h
@06:		xor	al, al
		jmp	@02
@03:		mov	ah, 9
		int	21h
		mov	al, 1
		jmp	@20
@02:		xor	al, al
@20:		push	ax
		call	ClrLine
		pop	ax
		mov	ah, 4Ch
		int	21h

BlockRead:	push	ds
		push	dx
		mov	ds, ax
		xor	dx, dx
		mov	ah, 3Fh
		int	21h
		pop	dx
		pop	ds
		retn

BlockWrite:	push	ds
		push	dx
		mov	ds, ax
		xor	dx, dx
		mov	ah, 40h
		int	21h
		pop	dx
		pop	ds
		retn

ClrLine:	mov	dl, 13
		mov	ah, 2
		int	21h
		mov	cx, 79
		mov	dl, ' '
@01_ClrLine:	int	21h
		loop	@01_ClrLine
		mov	dl, 13
		mov	ah, 2
		int	21h
		retn

Percent:	mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		mov	cx, 100
		xor	bx, bx
		call	LongDiv
		jc	@01_Percent
		or	ax, ax
		jne	@02_Percent
		or	dx, dx
		je	@03_Percent
@02_Percent:	mov	cx, ax
		mov	bx, dx
		mov	ax, word ptr Pos[0]
		mov	dx, word ptr Pos[2]
		call	LongDiv
		cmp	al, 100
		jbe	@04_Percent
@03_Percent:	mov	al, 100
@04_Percent:	push	ax
		mov	dl, ' '
		mov	ah, 2
		int	21h
		pop	ax
		xor	dx, dx
		mov	bx, 10
		mov	cx, 0320h
		call	NumStr
		call	PrintStr
		cmp	al, 100
		mov	dx, Offset Complete
		mov	ah, 9
		int	21h
@01_Percent:	retn

HexStr:		mov	bx, 10h
		jmp	NumStr
DecStr:		mov	bx, 10
		xor	cx, cx
NumStr:		push	si
		push	di
		push	cx
		mov	si, bx
		mov	di, Offset NumStrBuffer[10]
		mov	byte ptr [di], 0
		mov	cx, di
		mov	bx, dx
@01_NumStr:	xor	dx, dx
		xchg	bx, ax
		div	si
		xchg	bx, ax
		div	si
		add	dl, '0'
		cmp	dl, '9'
		jbe	@02_NumStr
		add	dl, 'A' - '0' - 10
@02_NumStr:	dec	di
		mov	[di], dl
		mov	dx, ax
		or	dx, bx
		jne	@01_NumStr
		sub	cx, di
		pop	bx
		or	bh, bh
		je	@03_NumStr
		sub	bh, cl
		jbe	@03_NumStr
@04_NumStr:	dec	di
		mov	byte ptr [di], bl
		inc	cx
		dec	bh
		jne	@04_NumStr
@03_NumStr:	mov	dx, di
		pop	di
		pop	si
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
		call	UpCase
		stosb
		lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

LongDiv:	push	si
		push	di
		xor	dx, bx
		pushf
		xor	dx, bx
		pushf
		jns	@01_LongDiv
		not	dx
		neg	ax
		sbb	dx, -1
@01_LongDiv:	or	bx, bx
		jns	@02_LongDiv
		not	bx
		neg	cx
		sbb	bx, -1
@02_LongDiv:	jne	@03_LongDiv
		cmp	dx, cx
		jb	@04_LongDiv
		jcxz	@10_LongDiv
		xchg	ax, bx
		xchg	ax, dx
		div	cx
		xchg	ax, bx
@04_LongDiv:	div	cx
		mov	cx, dx
		mov	dx, bx
		xor	bx, bx
		jmp	@05_LongDiv
@03_LongDiv:	push	dx
		push	ax
		mov	si, cx
		mov	di, bx
		or	bh, bh
		je	@06_LongDiv
		mov	cl, ch
		mov	ch, bl
		mov	bl, bh
		xor	bh, bh
		mov	al, ah
		mov	ah, dl
		mov	dl, dh
		mov	dh, bh
@06_LongDiv:	shr	dx, 1
		rcr	ax, 1
		shr	bx, 1
		rcr	cx, 1
		jne	@06_LongDiv
		div	cx
		mov	cx, ax
		mov	bx, ax
		mul	di
		xchg	ax, cx
		mul	si
		add	dx, cx
		pop	cx
		sub	cx, ax
		mov	ax, bx
		pop	bx
		sbb	bx, dx
		jnb	@07_LongDiv
		add	cx, si
		adc	bx, di
		dec	ax
@07_LongDiv:	xor	dx, dx
@05_LongDiv:	popf
		jns	@08_LongDiv
		not	bx
		neg	cx
		sbb	bx, -1
@08_LongDiv:	popf
		jns	@09_LongDiv
		not	dx
		neg	ax
		sbb	dx, -1
@09_LongDiv:	clc
		jmp	@11_LongDiv
@10_LongDiv:	stc
@11_LongDiv:	pop	di
		pop	si
		retn

Hello		db	'File Patch by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program changes files using the patches created by MAKPATCH.', 13, 10, 13, 10
		db	'Usage: PATCH <original-file> <changed-file>', 13, 10, '$'
CannotCreate	db	'Cannot create ', '$'
NotFound	db	' not found', 13, 10, '$'
InvalidSize	db	' has an invalid size', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
Patching	db	'Patching $'
Conjunctive	db	' to $'
Complete	db	'% complete', 13, '$'
LineFeed	db	13, 10
PatchName	db	'PATCH.DAT', 0

DataStart:

Time		dw	?
Date		dw	?
PatchFile	dw	?
Pos		dd	?
OrigLen		dd	?
ReadLen		dd	?
PatchLen	dw	?
Buffer		dw	?
NumStrBuffer	db	10 + 1 dup (?)
Par1		db	79 + 1 dup (?)
Par2		db	79 + 1 dup (?)

DataEnd:

CSeg		ends

		end	Main
