Attribute VB_Name = "XQmodMain"
Option Explicit
Option Private Module
Private Type BrowseInfo
  hwndOwner      As Long
  pIDLRoot       As Long
  pszDisplayName As Long
  lpszTitle      As Long
  ulFlags        As Long
  lpfnCallback   As Long
  lParam         As Long
  iImage         As Long
End Type
Private Const WM_USER = &H400
Private Const BFFM_INITIALIZED = 1
Private Const BFFM_SELCHANGED = 2
Private Const BFFM_SETSTATUSTEXT = (WM_USER + 100)
Private Const BFFM_ENABLEOK = (WM_USER + 101)
Private Const BFFM_SETSELECTION = (WM_USER + 102)
Private Const MAX_PATH = 255
Private Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long
Private Declare Function SHBrowseForFolder Lib "Shell32" (lpbi As BrowseInfo) As Long
Private Declare Function SHGetPathFromIDList Lib "Shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long
Private Declare Function SHGetSpecialFolderLocation Lib "Shell32" (ByVal hwndOwner As Long, ByVal nFolder As Integer, ppidl As Long) As Long
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hWnd&, ByVal uMsg&, ByVal wparam&, lParam As Any) As Long
Private Parent As XQBrowseFolders
Private bShowStatus As Boolean '//If True, the value of StatusText will be drawn in the window
Private bEnableOK As Boolean '//If TRUE, the use can click OK
Private strStatusText As String
Private strInitDir As String
Public Property Let StatusEnabled(ByVal X As Boolean)
 bShowStatus = X
End Property
Public Property Let EnableOK(ByVal X As Boolean)
 bEnableOK = X
End Property
Public Property Let StatusText(ByVal X As String)
 strStatusText = X
End Property
Public Property Let InitDir(ByVal X As String)
 If Len(X) > 3 Then '//no drive
  If Mid$(X, Len(X), 1) = "\" Then '//API don't want a \ at the end
   strInitDir = Left$(X, Len(X) - 1)
  Else
   strInitDir = X
  End If
 Else
  strInitDir = X
 End If
 strInitDir = UCase$(strInitDir) '//Da die Windows Funktion nur grossbuchstaben schluckt!
End Property
'//Returns the Path of a special Folder
Public Function GetPath(ByVal hwndOwner As Long, What As Long) As String
 Dim pIDL As Long: pIDL = 0
 Dim s As String: s = ""
 
 If SHGetSpecialFolderLocation(hwndOwner, What, pIDL) = 0 Then
  s = ShellGetString(pIDL)
 Else
  s = ""
 End If
 
 GetPath = s
End Function
'//Shows the Dialog
Public Function Start(ByVal hwndOwner As Long, ByVal strText As String, ByVal lRoot As Long, ByVal lOptions As Long, PointerToYou As XQBrowseFolders) As String
  '//Set the pointer to Parent
  Set Parent = PointerToYou
  
  Dim pIDL As Long: pIDL = 0
  Dim tBrowseInfo As BrowseInfo
            
  tBrowseInfo.hwndOwner = hwndOwner
  tBrowseInfo.pIDLRoot = lRoot
  tBrowseInfo.lpfnCallback = GetAddr(AddressOf BrowseForFolderCallback)
  tBrowseInfo.ulFlags = lOptions
  If Len(strText) <> 0 Then
   tBrowseInfo.lpszTitle = lstrcat(ByVal strText, "")
  End If
  
  On Error GoTo Away
  pIDL = SHBrowseForFolder(tBrowseInfo)
  If pIDL Then
   Start = ShellGetString(pIDL)
  Else
   Start = ""
  End If
  On Error GoTo 0
Away:
End Function
Private Function GetAddr(lAddr&) As Long
  GetAddr = lAddr
End Function
'//Get's a pIDL and converts it to a correct string
Private Function ShellGetString(pIDL As Long) As String
  Dim strPath As String
  strPath = Space$(MAX_PATH)
  Call SHGetPathFromIDList(pIDL, strPath)
  strPath = Left$(strPath, InStr(strPath, Chr$(0)) - 1)
  ShellGetString = strPath
End Function
Private Function BrowseForFolderCallback(ByVal hWnd As Long, ByVal uMsg As Long, ByVal lParam As Long, ByVal lpData As Long) As Long
 Dim strPath As String, nPos As Integer
 Select Case uMsg
  '//Init
  Case BFFM_INITIALIZED
   If Len(strInitDir) > 0 Then '//Init-Dir set ?
    SendMessage hWnd, BFFM_SETSELECTION, 1, ByVal strInitDir
   End If
   
   If bShowStatus Then '//Init Status-Message
    SendMessage hWnd, BFFM_SETSTATUSTEXT, 0, ByVal strStatusText
   End If
   
  '//Select
  Case BFFM_SELCHANGED
   strPath = ShellGetString(lParam)
   
   Debug.Print "Currently selected: " & strPath
   Call Parent.EventRaiser(strPath)
   
   If bShowStatus Then '//Should we display Status-Messages ?
    SendMessage hWnd, BFFM_SETSTATUSTEXT, 0, ByVal strStatusText
   End If
   
   If bEnableOK Then '//Enable the OK button
    Debug.Print "modMain: Enable OK"
    SendMessage hWnd, BFFM_ENABLEOK, 0, ByVal 1&
   Else
    Debug.Print "modMain: Disable OK"
    SendMessage hWnd, BFFM_ENABLEOK, 0, ByVal 0&
   End If
   
  End Select
End Function
