VERSION 5.00
Begin VB.UserControl XQBrowseFolders 
   ClientHeight    =   465
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   705
   InvisibleAtRuntime=   -1  'True
   Picture         =   "XQBrowseFolder.ctx":0000
   ScaleHeight     =   465
   ScaleWidth      =   705
   ToolboxBitmap   =   "XQBrowseFolder.ctx":1136
End
Attribute VB_Name = "XQBrowseFolders"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Event SelectionChanged(ByVal CurrentPath As String)
Attribute SelectionChanged.VB_Description = "Occurs, if the use clicks something in the dialog."
Attribute SelectionChanged.VB_HelpID = 50600
', ByRef EnableOK As Boolean, ByRef NewStatusbarText As String)
Public Enum ENUM_SHELLFOLDERS
  brofDesktop = &H0&
  brofPrograms = &H2&
  brofControls = &H3&
  brofPrinters = &H4&
  brofPersonal = &H5&
  brofFavorites = &H6&
  brofStartup = &H7&
  brofRecent = &H8&
  brofSendTo = &H9&
  brofTrashcan = &HA&
  brofStartmenu = &HB&
  brofDesktopDirectory = &H10&
  brofDrivers = &H11&
  brofNetwork = &H12&
  brofNethood = &H13&
  brofFonts = &H14&
  brofTemplates = &H15&
  'brofCommon_Startmenu = &H16& //AcX crashes if these values are used!
  'brofCommon_Programs = &H17&
  'brofCommon_Startup = &H18&
  'brofCommon_DesktopDirectory = &H19&
  'brofAppData = &H1A&
  'brofPrinthood = &H1B&
End Enum
Private Const BIF_RETURNONLYFSDIRS = 1
Private Const BIF_STATUSTEXT = 4
Private Const BIF_BROWSEFORCOMPUTER = &H1000
Private lStyle As Long
Private strText As String  '//Text below the Title
Private strStatusText As String '//Text below Caption
Private strInitialDir As String
Private bShowStatus As Boolean
Private bEnableOK As Boolean

Private Sub UserControl_InitProperties()
 lStyle = 0
 strText = "Please select a directory:"
 strStatusText = ""
 strInitialDir = ""
 bShowStatus = False
 bEnableOK = True
End Sub
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
 lStyle = PropBag.ReadProperty("Style", 0)
 strText = PropBag.ReadProperty("Caption", "")
 strStatusText = PropBag.ReadProperty("StatusText", "")
 strInitialDir = PropBag.ReadProperty("InitialDir", "")
 bShowStatus = PropBag.ReadProperty("ShowStatus", False)
 bEnableOK = PropBag.ReadProperty("EnableOK", True)
End Sub
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
 Call PropBag.WriteProperty("Style", lStyle, 0)
 Call PropBag.WriteProperty("Caption", strText)
 Call PropBag.WriteProperty("StatusText", strStatusText, "")
 Call PropBag.WriteProperty("InitialDir", strInitialDir, "")
 Call PropBag.WriteProperty("ShowStatus", bShowStatus, False)
 Call PropBag.WriteProperty("EnableOK", bEnableOK, True)
End Sub
Private Sub UserControl_Resize()
 Width = 705
 Height = 465
End Sub
Public Property Get Style() As ENUM_SHELLFOLDERS
Attribute Style.VB_Description = "Returns/sets the Style of BrowseWindow."
Attribute Style.VB_HelpID = 50900
Attribute Style.VB_ProcData.VB_Invoke_Property = ";Appearance"
Attribute Style.VB_MemberFlags = "200"
 Style = lStyle
End Property
Public Property Let Style(ByVal X As ENUM_SHELLFOLDERS)
 lStyle = X
 PropertyChanged "Style"
End Property
'//Text below the title ("Search for Folder")
Public Property Get Caption() As String
Attribute Caption.VB_Description = "Returns/sets the text, that should appear in the dialog."
Attribute Caption.VB_HelpID = 50200
Attribute Caption.VB_ProcData.VB_Invoke_Property = ";Text"
 Caption = strText
End Property
Public Property Let Caption(ByVal X As String)
 strText = X
 PropertyChanged ("Caption")
End Property
'//Should we display a Status?
Public Property Get ShowStatus() As Boolean
Attribute ShowStatus.VB_Description = "Returns/sets if there should be some extra text below ""Caption""."
Attribute ShowStatus.VB_HelpID = 50700
Attribute ShowStatus.VB_ProcData.VB_Invoke_Property = ";Behavior"
 ShowStatus = bShowStatus
End Property
Public Property Let ShowStatus(ByVal X As Boolean)
 bShowStatus = X
 PropertyChanged "ShowStatus"
End Property
'//Is OK enabled/disanled ?
Public Property Get EnableOK() As Boolean
Attribute EnableOK.VB_Description = "Returns/sets if the OK-button is enabled (TRUE) or not (FALSE)."
Attribute EnableOK.VB_HelpID = 50300
Attribute EnableOK.VB_ProcData.VB_Invoke_Property = ";Appearance"
 EnableOK = bEnableOK
End Property
Public Property Let EnableOK(ByVal X As Boolean)
 bEnableOK = X
 XQmodMain.EnableOK = X
 PropertyChanged "EnableOK"
End Property
'//Text below the title
Public Property Get StatusText() As String
Attribute StatusText.VB_Description = "Returns/sets extra text, that appears below ""Caption"".To use this property, set ShowStatus to TRUE."
Attribute StatusText.VB_HelpID = 50800
Attribute StatusText.VB_ProcData.VB_Invoke_Property = ";Text"
 StatusText = strStatusText
End Property
Public Property Let StatusText(ByVal X As String)
 strStatusText = X
 XQmodMain.StatusText = strStatusText
 Call PropertyChanged("StatusText")
End Property
Public Property Get InitialDir() As String
Attribute InitialDir.VB_Description = "Returns/sets which directory should be selected if the dialog will be shown."
Attribute InitialDir.VB_HelpID = 50400
Attribute InitialDir.VB_ProcData.VB_Invoke_Property = ";Behavior"
 InitialDir = strInitialDir
End Property
Public Property Let InitialDir(ByVal X As String)
 strInitialDir = X
 
 PropertyChanged "InitialDir"
End Property
Friend Sub EventRaiser(ByVal CurSelection As String)
 Dim s As String
 s = CurSelection
  
 RaiseEvent SelectionChanged(s)
End Sub

'///////////////////////////////////
'//---------------Publics-----------
'//Used from modMain to raise an event
Public Function BrowseFolders(hWnd_Of_Owner As Long) As String
Attribute BrowseFolders.VB_Description = "Shows the dialog."
Attribute BrowseFolders.VB_HelpID = 50100
 Dim s As String
 
 XQmodMain.EnableOK = bEnableOK
 XQmodMain.StatusEnabled = bShowStatus
 XQmodMain.StatusText = strStatusText
 XQmodMain.InitDir = strInitialDir
 
 If bShowStatus = True Then
  s = XQmodMain.Start(hWnd_Of_Owner, strText, lStyle, BIF_RETURNONLYFSDIRS Or BIF_STATUSTEXT, Me)
 Else
  s = XQmodMain.Start(hWnd_Of_Owner, strText, lStyle, BIF_RETURNONLYFSDIRS, Me)
 End If
 
 If bEnableOK = False Then '//if the user has disabled OK, he truly not want a path!
  BrowseFolders = ""
 Else
  BrowseFolders = s
 End If
End Function
Public Property Get Path() As String
Attribute Path.VB_Description = "Returns the absolute path of 'Style'. For example, if Style is set to '0 - Desktop', 'Path' may return 'C:\\Windows\\Desktop'."
Attribute Path.VB_HelpID = 50500
 Dim s As String

 s = XQmodMain.GetPath(UserControl.hWnd, lStyle)
 
 Path = s
End Property
