VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "XQCRegistrySettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'//Used to change string text to a proper looking string
Private Declare Function OemToChar Lib "user32" Alias "OemToCharA" (ByVal lpszSrc As String, ByVal lpszDst As String) As Long

Private Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, lpSecurityAttributes As Long, phkResult As Long, lpdwDisposition As Long) As Long
Private Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, ByRef phkResult As Long) As Long
Private Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long      '//VB-Info: Note that if you declare the lpData parameter as String, you must pass it By Value.
Private Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long  '//VB-Info: Note that if you declare the lpData parameter as String, you must pass it By Value.
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String) As Long
Private Const ERROR_SUCCESS = 0&
Private Const HKEY_CURRENT_USER = &H80000001
Private Const HKEY_LOCAL_MACHINE = &H80000002
Private Const HKEY_CLASSES_ROOT = &H80000000
Private Const KEY_CREATE_SUB_KEY = &H4
Private Const KEY_QUERY_VALUE = &H1
Private Const KEY_SET_VALUE = &H2
Private Const REG_OPTION_NON_VOLATILE = 0
Private Const REG_DWORD = 4
Private Const REG_SZ = 1
Private Const c_LongSize As Integer = 4
'Private bInitDone As Boolean '//TRUE=Create ist gelaufen
'Private bDestDone As Boolean '//TRUE=Destroy ist gelaufen
Private strCompany As String '//Firmennamen
Private strAppname As String '//Programm-Name
Private strAppVersion As String '//Version des Programms
Private lHandle As Long '//Aktuelle Key der geffnet ist
Private bMessage As Long '//Fehlermeldung schon geschickt?
Private bKeyClosed As Boolean '//TRUE=Key already closed
Private bCurrentUser As Boolean '//TRUE = write to HKEY_CURRENT_USER

Private Sub Class_Initialize()
 bMessage = False
 bKeyClosed = True
 bCurrentUser = True
End Sub
Private Sub Class_Terminate()
 Call CloseKey
' If Not bDestDone Then Call Destroy
End Sub

Property Let CurrentUserMode(X As Boolean)
 bCurrentUser = X
End Property

Property Let Company(CompanyName As String)
 strCompany = CompanyName
End Property
Property Get Company() As String: Company = strCompany: End Property

Property Let AppName(AppName As String)
 strAppname = AppName
End Property
Property Get AppName() As String: AppName = strAppname: End Property

Property Let AppVersion(AppVersion As String)
 strAppVersion = AppVersion
End Property
Property Get AppVersion() As String: AppVersion = strAppVersion: End Property

'//Check ob alle Angaben gemacht worden sind
Private Function InputOK() As Boolean
 Dim b As Boolean
 If Len(strCompany) <= 0 Then
  b = False
 Else
  If Len(strAppname) <= 0 Then
   b = False
  Else
   If Len(strAppVersion) <= 0 Then
    b = False
   Else
    b = True
   End If
  End If
 End If
 
 If b = False Then '//Fehler...
  If Not bMessage Then
   Debug.Print "Ein Property in CRegistrySetting wurde nicht gesetzt!"
   Debug.Print "Company: " & strCompany
   Debug.Print "Appname: " & strAppname
   Debug.Print "AppVersion: " & strAppVersion
   bMessage = True
  End If
 End If
 
 InputOK = b
End Function
Private Function GetRegPath() As String
 GetRegPath = "Software\" & strCompany & "\" & strAppname & "\" & strAppVersion
End Function
'//ffnet einen Keys. Wenn nicht vorhanden gibt es eine Fehlermeldung
Private Function OpenKey(KeyPath As String) As Boolean
 Dim lRet As Long: lRet = 0
 
 If bCurrentUser Then
  lRet = RegOpenKeyEx(HKEY_CURRENT_USER, KeyPath, 0, KEY_QUERY_VALUE, lHandle)
 Else
  lRet = RegOpenKeyEx(HKEY_LOCAL_MACHINE, KeyPath, 0, KEY_QUERY_VALUE, lHandle)
 End If
 
 If lRet <> ERROR_SUCCESS Then
  OpenKey = False
  bKeyClosed = True
 Else
  OpenKey = True
  bKeyClosed = False
 End If
 
 Debug.Print "OpenKey says: " & lRet
End Function
'//ffnet oder erstellt einen Key je nachdem ob der Key schon vorhanden ist oder nicht.
Private Function OpenKeyEx(KeyPath As String) As Boolean
 Dim lRet As Long: lRet = 0    '//Zurckgegebener Wert
 Dim lNull As Long: lNull = 0  '//Null-Wert
 Dim lTmp As Long: lTmp = 0    '//Fr den Rckgabewert von ldwDispostion => Unntig, wird ignoriert
 Dim sObj As String: sObj = "" '//Class-Name. Unntig und daher leer
 
 If bCurrentUser Then
  lRet = RegCreateKeyEx(HKEY_CURRENT_USER, KeyPath, 0, sObj, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE + KEY_CREATE_SUB_KEY, lNull, lHandle, lTmp)
 Else
  lRet = RegCreateKeyEx(HKEY_LOCAL_MACHINE, KeyPath, 0, sObj, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE + KEY_CREATE_SUB_KEY, lNull, lHandle, lTmp)
 End If
 
 If lRet <> ERROR_SUCCESS Then
  OpenKeyEx = False
  bKeyClosed = True
  Debug.Print "OpenKey FAILED!"
 Else
  OpenKeyEx = True
  bKeyClosed = False
 End If
 Debug.Print "OpenKeyEx says: " & lRet
End Function

Private Sub DeleteKey(SubKeyPath As String)
 Dim lRet As Long: lRet = 0
 lRet = RegDeleteKey(lHandle, ByVal SubKeyPath)
 If lRet <> ERROR_SUCCESS Then
 End If
End Sub

Private Sub CloseKey()
 If Not bKeyClosed Then
  
  If RegCloseKey(lHandle) <> ERROR_SUCCESS Then
   Debug.Print "RegCloseKey failed..."
  End If
  
  bKeyClosed = True
 End If
End Sub

'//Speichert einen String in der Registry
Public Sub StrWrite(ValueName As String, ValueToSave As String)
 Dim s As String: s = ""
 
 If OpenKeyEx(GetRegPath) Then '//Erfolgreich
  Dim lValLen As Long: lValLen = 0 '//Lnge von Wert der geschrieben wird
  lValLen = Len(ValueToSave) + 1 '//Lnge errechnen
  
  If Len(ValueToSave) = 0 Then
   Call RegSetValueEx(lHandle, ValueName, 0, REG_SZ, vbNullString, 0) '//Value schreiben
  Else
   Call RegSetValueEx(lHandle, ValueName, 0, REG_SZ, ByVal ValueToSave, lValLen) '//Value schreiben
  End If
  
  CloseKey
 End If '//ob KeyOpen OK war!
End Sub
'//Liest einen String aus der Registry
Public Function StrRead(ValueName As String, DefaultValue As String) As String
 If InputOK Then
  Dim lRet As Long: lRet = 0
  Dim s As String: s = Space$(4097)
  
  If OpenKey(GetRegPath) Then '//Key konnte geffnet werden
   lRet = RegQueryValueEx(lHandle, ValueName, 0, REG_SZ, ByVal s, 4096)
   If lRet <> ERROR_SUCCESS Then
    StrRead = DefaultValue
   Else '//OpenKey hat funktoniert
    StrRead = XQ_ConvertWinString(s)
   End If
   CloseKey
  Else
   StrRead = DefaultValue
  End If
 Else
  StrRead = DefaultValue
 End If '//inputOK
End Function

'//Schreibt einen LONG in die Registry
Public Sub LngWrite(ValueName As String, ValueToSave As Long)
 If OpenKeyEx(GetRegPath) Then '//Erfolgreich
  Dim l As Long
  l = RegSetValueEx(lHandle, ValueName, 0, REG_DWORD, ValueToSave, c_LongSize) '//Value schreiben
  Debug.Print "LngWrite returns: " & l
  CloseKey
 End If '//ob KeyOpen OK war!
End Sub
'//Liest einen Long aus der Registry aus
Public Function LngRead(ValueName As String, DefaultValue As Long) As Long
 If InputOK Then
  Dim lRet As Long: lRet = 0
  Dim l As Long: l = 0
  
  If OpenKey(GetRegPath) Then '//Key konnte geffnet werden
   lRet = RegQueryValueEx(lHandle, ValueName, 0, REG_DWORD, l, c_LongSize)
   If lRet <> ERROR_SUCCESS Then
    LngRead = DefaultValue
   Else
    LngRead = l
   End If
   CloseKey
  Else '//OpenKey hat nicht funktoniert
   LngRead = DefaultValue
  End If
  
 Else
  LngRead = DefaultValue
 End If '//inputOK
End Function

'//Schreibt einen Integer in die Registry
Public Sub IntWrite(ValueName As String, ValueToSave As Integer)
 Dim l As Long: l = ValueToSave
 Call LngWrite(ValueName, l)
End Sub
'//Liest einen Integer aus der Registry aus
Public Function IntRead(ValueName As String, DefaultValue As Integer) As Integer
 Dim l As Long: l = 0
 Dim i As Integer: i = 0
  
 On Error GoTo ConvErr
 l = LngRead(ValueName, CInt(DefaultValue))
 i = CInt(l)
 On Error GoTo 0
 
 IntRead = i
 Exit Function
ConvErr:
 IntRead = DefaultValue
End Function


Public Sub BoolWrite(ValueName As String, ValueToSave As Boolean)
 
 If ValueToSave = True Then
  Call IntWrite(ValueName, 1)
 Else
  Call IntWrite(ValueName, 0)
 End If
 
End Sub

Public Function BoolRead(ValueName As String, DefaultValue As Boolean) As Boolean
 Dim l As Integer
 
 If DefaultValue = True Then
  l = 1
 Else
  l = 0
 End If
 
 l = IntRead(ValueName, l)
 
 If l = 1 Then
  BoolRead = True
 Else
  BoolRead = False
 End If
End Function

'//Lscht den Key dieses Apps (NICHT der Company aus der Registy)
Public Sub DeleteApp()
 If InputOK Then
  If OpenKey("Software\" & strCompany & "\" & strAppname) Then
   DeleteKey (strAppVersion)
   CloseKey
  End If
  
  If OpenKey("Software\" & strCompany) Then
   DeleteKey (strAppname)
   CloseKey
  End If
 End If
End Sub



'//Converts a string from windows (with \0) to a correct VB string
Private Function XQ_ConvertWinString(WinString As String, Optional Oem2Char As Boolean = False) As String
 Dim s As String
     s = WinString
 
 If Oem2Char Then
  Dim sTMP As String
  sTMP = Space$(Len(s) + 1)
  Call OemToChar(s, sTMP)
  s = Trim(sTMP)
 End If
 
 
 Dim l As Long
 
 l = InStr(1, s, Chr(0))
 
 If l - 1 >= 0 Then
  XQ_ConvertWinString = Left(s, l - 1)
 Else
  XQ_ConvertWinString = s
 End If
End Function

