VERSION 5.00
Begin VB.UserControl XQAppSettings 
   ClientHeight    =   510
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   480
   InvisibleAtRuntime=   -1  'True
   Picture         =   "XQAppSettings.ctx":0000
   ScaleHeight     =   510
   ScaleWidth      =   480
   ToolboxBitmap   =   "XQAppSettings.ctx":0C42
End
Attribute VB_Name = "XQAppSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Enum asetModeEnum
 asetCurrentUser = 1
 asetLocalMachine = 2
End Enum

Private Const c_NoVersion As String = "CurrentVersion"
Private strCompany As String
Private strApp As String
Private strVersion As String
Private lMod As asetModeEnum
Private CReg As XQCRegistrySettings


Private Sub UserControl_Initialize()
 Set CReg = New XQCRegistrySettings
 
 strCompany = ""
 strApp = ""
 strVersion = c_NoVersion
 
 lMod = asetCurrentUser
 CReg.CurrentUserMode = True
 
 Debug.Print "AppSettings: INIT"
End Sub
Private Sub UserControl_Terminate()
 Set CReg = Nothing
 Debug.Print "AppSettings: Terminate!"
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
 With PropBag
  strCompany = .ReadProperty("Company", strCompany)
  strVersion = .ReadProperty("Version", c_NoVersion)
  strApp = .ReadProperty("AppName", strApp)
  lMod = .ReadProperty("Mode", lMod)
 End With
 
 
 CReg.Company = strCompany
 CReg.AppVersion = strVersion
 CReg.AppName = strApp
 If lMod = asetCurrentUser Then
  CReg.CurrentUserMode = True
 Else
  CReg.CurrentUserMode = False
 End If
 
 
 Debug.Print "AppSettings: ReadProp..."
End Sub
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
 With PropBag
  Call .WriteProperty("Company", strCompany)
  Call .WriteProperty("Version", strVersion, c_NoVersion)
  Call .WriteProperty("AppName", strApp)
  Call .WriteProperty("Mode", lMod)
 End With
 
 Debug.Print "AppSettings: WriteProp..."
End Sub
Private Sub UserControl_Resize()
 UserControl.Width = 480
 UserControl.Height = 480
End Sub

'////////////////////////////////////////////////////////////////
'//--------Public-----------------------------------------------
Public Property Get Mode() As asetModeEnum
Attribute Mode.VB_Description = "Returns/Sets if the settings applies to the current user only or to all user on this machine."
 Mode = lMod
End Property
Public Property Let Mode(X As asetModeEnum)
 lMod = X
 
 If lMod = asetCurrentUser Then
  CReg.CurrentUserMode = True
 Else
  CReg.CurrentUserMode = False
 End If
 
 PropertyChanged "Mode"
End Property

Public Property Get Company() As Variant
 Company = strCompany
End Property
Public Property Let Company(ByVal X As Variant)
Attribute Company.VB_Description = "Returns/Sets the name of your company (i.e.""RubberWare"")."
 Dim s As String
 On Error GoTo Arg
 s = CStr(X)
 On Error GoTo 0
 If Len(s) = 0 Then GoTo Arg '//No Null Strings!
 
 CReg.Company = s
 strCompany = s
 PropertyChanged "Company"
 Exit Property

Arg:
 Call Err.Raise(vbObjectError + 512 + 1, App.FileDescription, "Incorrect value for property 'Company'.")
End Property
Public Property Get AppName() As Variant
Attribute AppName.VB_Description = "Returns/Sets the name of your application (i.e. ""CoolEdit"")."
Attribute AppName.VB_HelpID = 10100
Attribute AppName.VB_ProcData.VB_Invoke_Property = ";Behavior"
 AppName = strApp
End Property
Public Property Let AppName(ByVal X As Variant)
 Dim s As String
 
 On Error GoTo Arg
 s = CStr(X)
 On Error GoTo 0
 
 If Len(s) = 0 Then GoTo Arg '//No Null Strings!
 
 CReg.AppName = s
 strApp = s
 PropertyChanged "AppName"
 Exit Property

Arg:
 Call Err.Raise(vbObjectError + 512 + 1, App.FileDescription, "Incorrect value for property 'AppName'.")
End Property
Public Property Get Version() As Variant
Attribute Version.VB_Description = "Returns/Sets the version of this application (i.e. ""1.0""). If empty, the string ""CurrentVersion"" is used."
Attribute Version.VB_HelpID = 10600
Attribute Version.VB_ProcData.VB_Invoke_Property = ";Behavior"
 Version = strVersion
End Property
Public Property Let Version(ByVal X As Variant)
 Dim s As String
 On Error GoTo Arg
 s = CStr(X)
 On Error GoTo 0
 If Len(s) = 0 Then s = c_NoVersion
 
 CReg.AppVersion = s
 strVersion = s
 PropertyChanged "Version"
 Exit Property

Arg:
 Call Err.Raise(vbObjectError + 512 + 1, App.FileDescription, "Incorrect value for property 'Version'.")
End Property

Public Sub WriteString(ValueName As String, Value As String)
Attribute WriteString.VB_Description = "Writes a string to the registry."
Attribute WriteString.VB_HelpID = 10900
 Call CReg.StrWrite(ValueName, Value)
End Sub
Public Function ReadString(ValueName As String, Optional Default As String)
Attribute ReadString.VB_Description = "Reads a string from the registry."
Attribute ReadString.VB_HelpID = 10500
 ReadString = CReg.StrRead(ValueName, Default)
End Function


Public Sub WriteLong(ValueName As String, Value As Long)
Attribute WriteLong.VB_Description = "Writes a long value to the registry."
Attribute WriteLong.VB_HelpID = 10800
 Call CReg.LngWrite(ValueName, Value)
End Sub
Public Function ReadLong(ValueName As String, Optional Default As Long)
Attribute ReadLong.VB_Description = "Reads a long value from the registry."
Attribute ReadLong.VB_HelpID = 10400
 ReadLong = CReg.LngRead(ValueName, Default)
End Function


Public Sub WriteInteger(ValueName As String, Value As Integer)
Attribute WriteInteger.VB_Description = "Writes an integer value to the registry."
Attribute WriteInteger.VB_HelpID = 10700
 Call CReg.IntWrite(ValueName, Value)
End Sub
Public Function ReadInteger(ValueName As String, Optional Default As Integer)
Attribute ReadInteger.VB_Description = "Reads an integer value from the registry."
Attribute ReadInteger.VB_HelpID = 10300
 ReadInteger = CReg.IntRead(ValueName, Default)
End Function


Public Sub WriteBoolean(ValueName As String, Value As Boolean)
Attribute WriteBoolean.VB_Description = "Writes a boolean value to the registry."
 Call CReg.BoolWrite(ValueName, Value)
End Sub
Public Function ReadBoolean(ValueName As String, Optional Default As Boolean)
Attribute ReadBoolean.VB_Description = "Reads a boolean value from the registry."
 ReadBoolean = CReg.BoolRead(ValueName, Default)
End Function
