unit PrefEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TPrefixEditor = class(TForm)
    Label1: TLabel;
    NameEdit: TEdit;
    Label2: TLabel;
    OkButton: TButton;
    Button2: TButton;
    PrefixEdit: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure EditChange(Sender: TObject);
    procedure PrefixEditChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PrefixEditor: TPrefixEditor;

implementation

{$R *.DFM}

procedure TPrefixEditor.FormActivate(Sender: TObject);
begin
  ActiveControl:=NameEdit;
  EditChange(nil);
end;

function ValidPrefix(Prefix: string): Boolean;
begin
  Result:=
    (Length(Prefix)=3) and
    (Prefix[1] in ['a'..'z','_']) and
    (Prefix[2] in ['a'..'z','_','0'..'9']) and
    (Prefix[3] in ['a'..'z','_','0'..'9']);
end;

procedure TPrefixEditor.EditChange(Sender: TObject);
begin
  OkButton.Enabled:=(NameEdit.Text<>'') and ValidPrefix(PrefixEdit.Text);
end;

procedure TPrefixEditor.PrefixEditChange(Sender: TObject);
var
  OldSel: Integer;
begin
  with PrefixEdit do
  begin
    OldSel:=SelStart;
    Text:=LowerCase(Text);
    SelStart:=OldSel;
  end;
  OkButton.Enabled:=(NameEdit.Text<>'') and ValidPrefix(PrefixEdit.Text);
end;

end.
