unit NameProp;

interface

uses Classes, Forms, Controls, IniFiles, DsgnIntf;

type
  TNameProperty=class(TComponentNameProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure Register;

implementation

uses NameDlg;

const
  SecName = 'Delphi Component''s Prefixes';
  FileName = 'Prefixes.lst';

var
  List: TStringList;

procedure TNameProperty.Edit;
var
  S: TCaption;
  Idx: Integer;
begin
  with TNameEditor.Create(Application) do
  try
    lsbPrefixes.Items.Assign(List);

    if TComponent(GetComponent(0)).Owner<>nil then
      S:=TComponent(GetComponent(0)).Owner.Name+'.'
    else S:='';
    Caption:=S+TComponent(GetComponent(0)).Name+'.'+GetName;

    S:=GetComponent(0).ClassName;
    NativeType:=S;

    with List do
    begin
      Idx:=IndexOf(Copy(S,2,Pred(Length(S))));
      if Idx<>-1 then
      begin
        lblPrefix.Caption:=TPrefix(Objects[Idx]);
        lblClassName.Caption:=S;
        ComponentType:=S;
      end
      else
      begin
        S:=GetComponent(0).ClassParent.ClassName;
        Idx:=IndexOf(Copy(S,2,Pred(Length(S))));
        if Idx<>-1 then
        begin
          lblPrefix.Caption:=TPrefix(Objects[Idx]);
          lblClassName.Caption:='Inherited from '+S;
          ComponentType:=S;
        end
        else
        begin
          lblPrefix.Caption:='???';
          lblClassName.Caption:=NativeType;
          btnOK.Enabled:=False;
        end;
      end;
    end;

    S:=TComponent(GetComponent(0)).Name;
    if Copy(S,1,3)=lblPrefix.Caption then
      edtName.Text:=Copy(S,4,Length(S)-3);

    ShowModal;
    if ModalResult=mrOK then
      SetValue(lblPrefix.Caption+edtName.Text);
    List.Assign(lsbPrefixes.Items);
  finally
    Free;
  end;
end;

function TNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result:=inherited GetAttributes+[paDialog];
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TComponentName),TComponent,'Name',TNameProperty);
end;

procedure CreateList;
var
  i: Integer;
  L: TStringList;
begin
  List:=TStringList.Create;
  L:=TStringList.Create;
  with TIniFile.Create(FileName) do
  try
    ReadSectionValues(SecName,L);
    for i:=0 to Pred(L.Count) do
      List.AddObject(L.Names[i],Pointer(TPrefix(L.Values[L.Names[i]])));
  finally
    L.Free;
    Free;
  end;
end;

procedure FreeList;
var
  i: Integer;
begin
  with TIniFile.Create(FileName) do
  try
    with List do
    try
      for i:=0 to Pred(Count) do
        WriteString(SecName,Strings[i],TPrefix(Objects[i]));
    finally
      Free;
    end;
  finally
    Free;
  end;
end;

initialization

  CreateList;

finalization

  FreeList;

end.
