unit NameDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type

  TPrefix = string[3];

  TNameEditor = class(TForm)
    lblPrefix: TLabel;
    edtName: TEdit;
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lblClassName: TLabel;
    btnMore: TButton;
    lsbPrefixes: TListBox;
    btnNew: TButton;
    btnEdit: TButton;
    btnDelete: TButton;
    lblListPrefix: TLabel;
    btnFind: TButton;
    procedure btnMoreClick(Sender: TObject);
    procedure lsbPrefixesClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnNewClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure edtNameChange(Sender: TObject);
  private
    { Private declarations }
    FNativeType,FComponentType: string;
    function GetPrefix: TPrefix;
    procedure SetComponentType(Value: string);
    procedure EnableOK;
  public
    { Public declarations }
    property NativeType: string read FNativeType write FNativeType;
    property ComponentType: string read FComponentType write SetComponentType;
  end;

implementation

{$R *.DFM}

uses PrefEdit, FindPref;

procedure TNameEditor.EnableOK;
begin
  with lsbPrefixes.Items do
    btnOK.Enabled:=((IndexOf(Copy(ComponentType,2,Pred(Length(ComponentType))))<>-1) or
      (IndexOf(Copy(NativeType,2,Pred(Length(NativeType))))<>-1)) and (edtName.Text<>'');
end;

function TNameEditor.GetPrefix: TPrefix;
var
  Idx: Integer;
begin
  with lsbPrefixes,Items do
  begin
    Idx:=IndexOf(Copy(NativeType,2,Pred(Length(NativeType))));
    if Idx<>-1 then Result:=TPrefix(Objects[Idx])
    else
      Idx:=IndexOf(Copy(ComponentType,2,Pred(Length(ComponentType))));
      if Idx<>-1 then Result:=TPrefix(Objects[Idx])
      else Result:='???';
  end;
end;

procedure TNameEditor.SetComponentType(Value: string);
begin
  if Value<>FComponentType then
  begin
    FComponentType:=Value;
    lblPrefix.Caption:=GetPrefix;
    EnableOK;
  end;
end;

procedure TNameEditor.btnMoreClick(Sender: TObject);
begin
  if btnMore.Caption='&Prefixes  >>' then
  begin
    btnMore.Caption:='&Prefixes  <<';
    btnNew.Visible:=True;
    btnEdit.Visible:=True;
    btnDelete.Visible:=True;
    lsbPrefixes.Visible:=True;
    lblListPrefix.Visible:=True;
    ClientHeight:=lsbPrefixes.Top+lsbPrefixes.Height+lsbPrefixes.Left;
  end
  else
  begin
    ClientHeight:=btnOK.Top+btnOK.Height+btnOK.Left;
    btnMore.Caption:='&Prefixes  >>';
    btnNew.Visible:=False;
    btnEdit.Visible:=False;
    btnDelete.Visible:=False;
    lsbPrefixes.Visible:=False;
    lblListPrefix.Visible:=False;
  end;
end;

procedure TNameEditor.lsbPrefixesClick(Sender: TObject);
var
  Prefix: Pointer;
begin
  with lsbPrefixes do
  try
    Prefix:=Items.Objects[ItemIndex];
    lblListPrefix.Caption:=TPrefix(Prefix);
  except
  end;
end;

procedure TNameEditor.FormShow(Sender: TObject);
begin
  lblPrefix.Caption:=GetPrefix;
  ClientHeight:=btnOK.Top+btnOK.Height+btnOK.Left;
  lsbPrefixes.ItemIndex:=0;
  lsbPrefixesClick(nil);
end;

procedure TNameEditor.btnNewClick(Sender: TObject);
var
  Idx: Integer;
begin
  with lsbPrefixes,Items,TPrefixEditor.Create(Self) do
  try
    if NativeType<>ComponentType then
      NameEdit.Text:=Copy(NativeType,2,Pred(Length(NativeType)));
    ShowModal;
    if ModalResult=mrOK then
      if IndexOf(NameEdit.Text)<>-1 then
        MessageBox(Self.Handle,
          PChar('Class '+NameEdit.Text+' already registered.'),
          'Name property editor',MB_OK or MB_ICONHAND)
      else
      begin
        Idx:=IndexOfObject(Pointer(TPrefix(PrefixEdit.Text)));
        if Idx<>-1 then
          MessageBox(Self.Handle,
            PChar('Prefix '+PrefixEdit.Text+' already registered.'#13'('+Strings[Idx]+')'),
            'Name property editor',MB_OK or MB_ICONHAND)
        else
        begin
          ItemIndex:=lsbPrefixes.Items.AddObject(NameEdit.Text,Pointer(TPrefix(PrefixEdit.Text)));
          lsbPrefixesClick(nil);
          lblPrefix.Caption:=GetPrefix;
          EnableOK;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TNameEditor.btnDeleteClick(Sender: TObject);
var
  Idx: Integer;
begin
  with lsbPrefixes do
    if MessageBox(Self.Handle,
      PChar('Delete "'+Items[ItemIndex]+' - '+TPrefix(Items.Objects[ItemIndex])+'"?'),
      'Name property editor',MB_YESNO or MB_ICONQUESTION)=ID_YES then
    begin
      Idx:=ItemIndex;
      Items.Delete(ItemIndex);
      if Idx>Pred(Items.Count) then Idx:=Pred(Items.Count);
      ItemIndex:=Idx;
      lsbPrefixesClick(nil);
      lblPrefix.Caption:=GetPrefix;
      EnableOK;
    end;
end;

procedure TNameEditor.btnEditClick(Sender: TObject);
var
  Idx,OldIdx: Integer;
begin
  with lsbPrefixes,Items,TPrefixEditor.Create(Self) do
  try
    OldIdx:=ItemIndex;
    NameEdit.Text:=Items[ItemIndex];
    PrefixEdit.Text:=TPrefix(Objects[ItemIndex]);
    ShowModal;
    if ModalResult=mrOK then
      if (IndexOf(NameEdit.Text)<>-1) and (IndexOf(NameEdit.Text)<>OldIdx) then
        MessageBox(Self.Handle,
          PChar('Class '+NameEdit.Text+' already registered.'),
          'Name property editor',MB_OK or MB_ICONHAND)
      else
      begin
        Idx:=IndexOfObject(Pointer(TPrefix(PrefixEdit.Text)));
        if (Idx<>-1) and (Idx<>OldIdx) then
          MessageBox(Self.Handle,
            PChar('Prefix '+PrefixEdit.Text+' already registered.'#13'('+Strings[Idx]+')'),
            'Name property editor',MB_OK or MB_ICONHAND)
        else
        begin
          Delete(OldIdx);
          ItemIndex:=lsbPrefixes.Items.AddObject(NameEdit.Text,Pointer(TPrefix(PrefixEdit.Text)));
          lsbPrefixesClick(nil);
          lblPrefix.Caption:=GetPrefix;
          EnableOK;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TNameEditor.btnFindClick(Sender: TObject);
var
  Idx: Integer;
begin
  with TFindPrefix.Create(Self) do
  try
    ShowModal;
    if ModalResult=mrOK then
      with lsbPrefixes,Items do
      begin
        Idx:=IndexOfObject(Pointer(TPrefix(PrefixEdit.Text)));
        if Idx=-1 then
          MessageBox(Self.Handle,
            PChar('Prefix "'+PrefixEdit.Text+'" not found.'),
            'Name property editor',MB_OK or MB_ICONINFORMATION)
        else
        begin
          ItemIndex:=Idx;
          lsbPrefixesClick(nil);
        end;
      end;
  finally
    Free;
  end;
end;

procedure TNameEditor.edtNameChange(Sender: TObject);
begin
  EnableOK;
end;

end.
