
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

   PUBLIC PIXEL
PIXEL PROC
   PUSH BP
   MOV BP,SP
   PUSHA           ; Save registers

   MOV AX,0A000H   ;    video memory segment number
   MOV ES,AX       ;    place it in es

   MOV DX,03C4H
   MOV AL,2
   OUT DX,AL
   INC DX

   MOV AL,1
   MOV CX,WORD PTR [BP+4]
   AND CX,3
   SHL AL,CL
   OUT DX,AL

   XOR DI,DI

; Calculate the Offset
   mov ax,MODE_WIDTH          ; Mode_width / 4
   SHR AX,2
   mul word ptr [bp+6]        ; (Y * (mode_width / 4))
   mov bx,word ptr [bp+4]     ; (X / 4) + (Y * (mode_width / 4))
   shr bx,2
   add ax,bx
; Done!

   ADD DI,AX
   mov ah,[bp+8]  ;    move the Color into ah
   mov es:[di],ah ;    move the value to the screen

QUIT1:
   POPA           ; Restore registers
   POP BP
   RET 6
PIXEL ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
; Puts an icon on the screen
; void PutIcon(int X, int Y, char Icon[], int Width, int Height);
   PUBLIC PUTICON
PUTICON PROC
   PUSH BP
   MOV BP,SP
   PUSHA          ; Save registers

   MOV SI,[BP+8]

   MOV BX,[BP+6] ; Move in Y start value
   MOV CX,0 
LOOP1:

   MOV AX,[BP+4] ; Move in X start value
   MOV DX,0 
LOOP2:
      CMP BYTE PTR [SI],0 ; Check to see if the color is 0
      JE OUT1

      PUSH WORD PTR [SI]  ; Push the Color value
      PUSH BX             ; Push the Y value
      PUSH AX             ; Push the X value
      CALL PIXEL

   OUT1:

   INC SI              ; Increment our pointer in the array
   INC AX              ; Increment our X pointer
   INC DX              ; Increment our width counter 
   CMP DX,[BP+10]      ; compare it to the width of the icon
   JB LOOP2            ; and loop.

   INC BX              ; Increment our Y pointer
   INC CX              ; Increment our height counter 
   CMP CX,[BP+12]      ; compare it to the height of the icon
   JB LOOP1            ; and loop

   POPA                ; Restore registers
   POP BP
   RET 10
PUTICON ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

MESSAGE PROC

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 10
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 30
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 70
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 90
   PUSH 10
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 30
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 10
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 30
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 70
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 90
   PUSH 50
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 10
   PUSH 100
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 50
   PUSH 100
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 70
   PUSH 100
   CALL PUTICON

   PUSH 16
   PUSH 16
   PUSH OFFSET ICON
   PUSH 90
   PUSH 100
   CALL PUTICON

   RET
MESSAGE ENDP

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
