/*
Nine puzzle solver

A nine-puzzle is a 3x3 with moveable squares 1-8 and one blank
Solve it by 'moving the blank'

eg from  top: 1.2           to 312     solution is LDR
         mid: 345              4.5
         bot: 678              678
*/


#include <stdio.h>
#include <ctype.h>
#include <string.h>

char  opena[300][10], action[300][20], closed[500][10];

void main(), exit(int n);
 
void main()
{
 
char goal[10], initial[10], store[10], current[10];
 
char itop[4], imid[4], ibot[4];
char gtop[4], gmid[4], gbot[4];
 
int open_num, close_num;
int shift, line, got_flag, s_pos, closed_check, s_loop;
 
close_num = open_num = 0;
initial[0] = goal[0] = 0;

itop[0] = imid[0] = ibot[0] = 0;
gtop[0] = gmid[0] = gbot[0] = 0;

printf("Initial top line   : "); scanf("%s",itop);
printf("Initial middle line: "); scanf("%s",imid);
printf("Initial bottom line: "); scanf("%s",ibot);
printf("\n\n");
 
printf("Goal top line      : "); scanf("%s",gtop);
printf("Goal middle line   : "); scanf("%s",gmid);
printf("Goal bottom line   : "); scanf("%s",gbot);
 
printf("\n\nSearching for solution.\n\n");
 
strcat(initial,itop);
strcat(initial,imid);
strcat(initial,ibot);

strcat(goal,gtop);
strcat(goal,gmid);
strcat(goal,gbot);
 
for (line=0; line <300; line++)
     {   action[line][0] = 0;
         opena  [line][0] = 0;   }

strcpy(opena[0],initial);

for(;;)
{
strcpy(current,opena[0]);
strcpy(closed[close_num++],current);
if (strcmp(goal,current) == 0)
     { printf("Solution found : %s \n",action[0]);
       exit(0); }
 
strcpy(store,current);
s_pos = -1;

for(s_loop=0; s_loop<10; s_loop++)
{ if(*(current+s_loop) == '.') s_pos = s_loop; }

if (s_pos == -1)
     { printf("Illegal input.");
       exit(0); }
 
/* Configuration where empty square goes UP. */
 
if (s_pos > 2) {

current[s_pos] = current[s_pos - 3];
*(current + s_pos - 3) = '.';
got_flag = 0;
 
for (closed_check=0; closed_check<=close_num; closed_check++)
{ if(strcmp(current,closed[closed_check]) == 0) got_flag=1; }
 
if (got_flag == 0) { strcpy(opena[++open_num],current);
                     strcpy(action[open_num],action[0]);
                     strcat(action[open_num],"U"); } }
 
/* Configuration where empty square goes DOWN. */
 
strcpy(current,store);
 
if (s_pos < 6) {
 
current[s_pos] = current[s_pos+3];
*(current + s_pos + 3) = '.';
got_flag = 0;
 
for (closed_check=0; closed_check<=close_num; closed_check++)
{ if(strcmp(current,closed[closed_check]) == 0) got_flag=1; }
 
if(got_flag == 0) { strcpy(opena[++open_num],current);
                    strcpy(action[open_num],action[0]);
                    strcat(action[open_num],"D"); } }
 
/* Configuration where empty square goes LEFT. */
 
strcpy(current,store);
 
if((s_pos!=0) && (s_pos!=3) && (s_pos!=6)) {
 
current[s_pos] = current[s_pos-1];
*(current + s_pos - 1) = '.';
got_flag = 0;
 
for (closed_check=0; closed_check<=close_num; closed_check++)
{ if(strcmp(current,closed[closed_check]) == 0) got_flag=1; }
 
if(got_flag==0) { strcpy(opena[++open_num],current);
                  strcpy(action[open_num],action[0]);
                  strcat(action[open_num],"L"); } }
 
/* Configuration where empty square goes RIGHT. */
 
strcpy(current,store);
 
if((s_pos!=2) && (s_pos!=5) && (s_pos!=8)) {
current[s_pos] = current[s_pos+1];
*(current + s_pos + 1) = '.';
got_flag=0;
 
for(closed_check=0; closed_check<=close_num; closed_check++)
{ if(strcmp(current,closed[closed_check]) == 0) got_flag=1; }
 
if(got_flag == 0) { strcpy(opena[++open_num],current);
                    strcpy(action[open_num],action[0]);
                    strcat(action[open_num],"R"); } }
 
for(shift=0; shift<open_num; shift++)
{ strcpy(opena[shift], opena[shift+1]);
  strcpy(action[shift],action[shift+1]); } } }
