;        Modified 03/19/93 for MD86 v3.0-2 and later.
;
;        Important MSDOS Low memory addresses and I/O port names. Note
;        that memory address MUST follow a ";Segment..." line which holds the
;        segment value. The names themselves have the offset values.
;
;        Memory address are specified first and then come the port names.
;
;        Port names start after the line ";Ports..." and continue until the
;        ";End" line is reached. Everything else is ignored by MD86 so special
;        macro definitions may be included in this file also.
;
;        MD86 uses the closest port not exceeding a the value and adds
;        an offset byte IF this is <= 7 AND if only the lower hex digit is
;        different. Thus with the list below, port 2ch is shown as PIC02+4 and
;        port 81h is unknown and not named.
;
;        At present there is room for 170 names max. Any extras will be
;        ignored.
;
;Segment  equ   0040h       ;Segment value for items.
_EqptLst  equ   0010h       ;16 bit equipment list data.
_UseMem   equ   0013h       ;16 bit usable memory size in Kb.
_KbdStat  equ   0017h       ;16 bit keyboard status bytes.
_BuffrHd  equ   001ah       ;16 bit pointer to head of keyboard buffer.
_BuffrTl  equ   001ch       ;16 bit pointer to keyboard buffer tail.
_KbdBufr  equ   001eh       ;32 byte keyboard buffer (16 two byte entries).
_DrvRcal  equ   003eh       ;1 byte diskette recalibration needed flag.
_MtrStat  equ   003fh       ;1 byte diskette motor status.
_MtrOff   equ   0040h       ;1 byte diskette motor off counter.
_DskStat  equ   0041h       ;1 byte diskette status code.
_DskCntl  equ   0042h       ;7 byte diskette controller status cache.
_VidMode  equ   0049h       ;1 byte storage for current video mode.
_HorSize  equ   004ah       ;16 bit value of characters per row.
_ScrnSiz  equ   004ch       ;16 bit value of number of characters per screen.
_CurPage  equ   004eh       ;16 bit offset to current video page.
_CurPos   equ   0050h       ;8 16-bit pointers for cursor location.
_CurSize  equ   0060h       ;16 bit cursor size (scan lines).
_PageNum  equ   0062h       ;1 byte current page value.
_CrtPort  equ   0063h       ;16 bit port for CRT controller.
_CrtMode  equ   0065h       ;1 byte CRT mode register contents.
_CrtColr  equ   0066h       ;1 byte CRT color register contents.
_Casette  equ   0067h       ;5 bytes for cassette control (early PC's).
_MstrClk  equ   006ch       ;32 bit master clock tick counter.
_ClkOvfl  equ   0070h       ;1 byte clock overflow flag.
_CtrlBrk  equ   0071h       ;1 bye control-break pressed flag.
_Passwrd  equ   0072h       ;2 byte passord set to 1234h after memory check.
_DrvCntl  equ   0074h       ;4 byte area used for disk drive control.
_TimOutP  equ   0078h       ;4 byte time out values for parallel ports.
_TimOutS  equ   007ch       ;4 byte time out values for serial ports.
_KbdBuff  equ   0080h       ;16 bit pointer to start of keyboard buffer.
_KbdEnd   equ   0082h       ;16 bit pointer to end of keyboard buffer.
_VerSize  equ   0084h       ;1 byte vertical screen size starting from zero.
_ChrHght  equ   0085h       ;16 bit height in scan lines of screen chars.
_VidPrms  equ   0087h       ;4 byte area used for various video parameters.
_DrvInfo  equ   008bh       ;11 bytes used for drive control/status info.
_RtClock  equ   0098h       ;9 byte area used by the real-time clock.
_VidDfts  equ   00a8h       ;4 byte address of video defaults table.
_PrtScrn  equ   0100h       ;1 byte status of print screen operation.
_OneDisk  equ   0104h       ;1 byte code for single disk systems.
_DefltDS  equ   0110h       ;2 byte default DS: value used by ROM BASIC.
_ClkInt   equ   0112h       ;4 byte address of BASICs clock interupt rtrn.
_BrkKey   equ   0116h       ;4 byte address of BASICs break-key interupt rtn.
_DskErr   equ   011ah       ;4 byte address of BASICs disk error routine.
;
;   PC Port assignments. MD86 uses the coloest (lower) port name and adds an
;   offset (eg,'SysTmr01+3' for port 43h).
;
;Ports
PIC01     equ   20h           ;Programmable Interupt Controller (32 ports).
PIC02     equ   28h
PIC03     equ   30h
PIC04     equ   38h
SysTmr01  equ   40h           ;System timer (32 ports).
SysTmr02  equ   48h
SysTmr03  equ   50h
SysTmr04  equ   58h
KeyCtr01  equ   60h           ;Keyboard controller (16 ports).
KeyCtr02  equ   68h
RTC01     equ   70h           ;Real-time clock (16 ports).
RTC02     equ   78h
NMImask   equ   0a0h          ;NMI mask on PC/XT/AT, not PS/2.
X8087_01  equ   0f0h          ;Math coprocessor (16 ports).
X8087_02  equ   0f8h
FxdDsk01  equ   1f0h          ;Fixed disk controller (16 ports).
FxdDsk02  equ   1f8h
GamePort  equ   200h          ;Game controller (8 ports).
PPLPrt3   equ   278h          ;Parallel printer port #3. (8 ports).
Com2Port  equ   2f8h          ;Serial communications port #2 (8 ports).
FxDskXT1  equ   320h          ;Fixed disk ports on XT's (16 ports).
FxDskXT2  equ   328h
NetWrk01  equ   360h          ;PC network ports (16 ports).
NewWrk02  equ   368h
PPLPrt2   equ   378h          ;Parallel printer port #2 (8 ports).
MDAPort1  equ   3b0h          ;MDA (also EGA/VGA) adaptor (8 ports).
PPLPrt1   equ   3b8h          ;Parallel printer port #1 (8 ports).
EGAPort1  equ   3c0h          ;EGA/VGA ports (16 ports).
EGAPort2  equ   3c8h
CGAPort1  equ   3d0h          ;CGA/MCGA (also EGA/VGA in color mode) (16 ports).
CGAPort2  equ   3d8h
FlpyPort  equ   3f0h          ;Diskette controller (8 ports).
Com1Port  equ   3f8h          ;Serial communications port #1 (8 ports).
;End
;
;   End MD86 port assignments.
