.xcref
.xlist
if1
;=============================================================================
;
;     Macro definition file compatible with MASM v5.1.
;
;     These provide the definitions that the assembler needs to assemble the
;     intrinsic and standard user-preference macros as supplied with MD86 v3.0
;     in files MD86.SRC and MD86.DAT.
;
;=============================================================================
;
;     Macro to push a variable number of registers.
;
_push macro r1,r2,r3,r4,r5,r6,r7,r8
     irp reg,<r1,r2,r3,r4,r5,r6,r7,r8>
       ifdef reg
       push reg
       endif
     endm
    endm
;
;     Macro to pop a variable number of registers.
;
_pop macro r1,r2,r3,r4,r5,r6,r7,r8
     irp reg,<r1,r2,r3,r4,r5,r6,r7,r8>
       ifdef reg
       pop  reg
       endif
     endm
    endm
;
;     Macro to enter a procedure. An optional argument specifies the number of
;     bytes of stack space to be reserved.
;
_ENTER  macro  arg
        push   bp
        mov    bp,sp
        if arg
        sub    sp,arg
        endif
        endm
;
;    Macro to leave a near procedure. This restores the stack and the BP
;    register. If an argument is supplied, then this many bytes are removed
;    from the stack before exiting.
;
_LEAVE  macro  arg
        mov    sp,bp
        pop    bp
        if arg
        ret    arg
        else
        ret
        endif
        endm
;
;    Macro to leave a far procedure. This restores the stack and the BP
;    register. If an argument is supplied, then this many bytes are removed
;    from the stack before exiting.
;
_LEAVEF macro  arg
        mov    sp,bp
        pop    bp
        if arg
        retf   arg
        else
        retf
        endif
        endm
;
;    Conditional jumps with a destination beyond the 128 byte limit. These
;    use a near jump instead.
;
_JZ    macro  arg
       local  skip
       jnz    skip
       jmp    arg
skip:
       endm
_JNZ   macro  arg
       local  skip
       jz     skip
       jmp    arg
skip:
       endm
_JC    macro  arg
       local  skip
       jnc    skip
       jmp    arg
skip:
       endm
_JNC   macro  arg
       local  skip
       jc     skip
       jmp    arg
skip:
       endm
;
;    Shifts with a bit count greater than 1. This will use the CL register as
;    a counter.
;
_SHR   macro  reg,arg
       mov    cl,arg
       shr    reg,cl
       endm
_SHL   macro  reg,arg
       mov    cl,arg
       shl    reg,cl
       endm
_SAR   macro  reg,arg
       mov    cl,arg
       sar    reg,cl
       endm
_ROL   macro  reg,arg
       mov    cl,arg
       rol    reg,cl
       endm
_ROR   macro  reg,arg
       mov    cl,arg
       ror    reg,cl
       endm
endif
;
;      Macros to get and set interupt vectors.
;
GetVector macro vec,addr
       mov    ax,3500h+vec
       int    21h
       mov    [addr],bx
       mov    [addr+2],es
       endm
SetVector macro vec,addr
       mov    dx,offset addr
       mov    ax,2500h+vec
       int    21h
       endm
;
;      Go TSR using interupt 27h and reserve a given number of bytes.
;
TSR_Int27 macro bytes
       mov    dx,bytes
       int    27h
       endm
.cref
.list
