;     
;                    PRE-DEFINED BYTE AND BIT ADDRESSES
;     
;     The following tables detail the pre-defined byte and bit addresses 
;     for the 8051/8031 microcontrollers supported by the MetaLink family 
;     of emulators.  Proliferation parts are delimited from the standard 
;     MCS-51 definitions by asterisk ("*") boxes.  
;     
;     This list covers these microcontrollers:
;     
;     8044  8031   8032   8051   8052   8053  80C154  80C321
;     8344  80C31  80C32  8751   8752   8753  83C154  80C521
;     8744                80C51  80C52        85C154  87C521
;                         87C51
;     
;     80C321  80C51FA(80C252)  80C452  80C152JA/JB/JC/JD    80C851
;     80C541  83C51FA(83C252)  83C452  83C152JA/JC          83C851
;     87C541  87C51FA(87C252)  87C452
;     
;     80C451  80C652  80C552  83C751  83C752  80512  80515  80C515  80C517
;     83C451  83C652  83C552  87C751  87C752  80532  80535  80C535  80C537
;     87C451  87C652  87C552

$NOLIST
;DEFINE 8032	TRUE
;DEFINE 80512	TRUE
;DEFINE 80515	TRUE
;DEFINE 8052	TRUE
;DEFINE 80532   TRUE                                               
;DEFINE 80535	TRUE
;DEFINE 80C152	TRUE
;DEFINE 80C154	TRUE
;DEFINE 80C252	TRUE
;DEFINE 80C321	TRUE
;DEFINE 80C452	TRUE
;DEFINE 80C517	TRUE
;DEFINE 80C51FA	TRUE
;DEFINE 80C521  TRUE                                              
;DEFINE 80C537	TRUE
;DEFINE 80C552	TRUE
;DEFINE 80C652	TRUE
;DEFINE 80C851  TRUE                                               
;DEFINE 83C152	TRUE
;DEFINE 83C154	TRUE
;DEFINE 83C252	TRUE
;DEFINE 83C451  TRUE                                              
;DEFINE 83C452	TRUE
;DEFINE 83C51FA	TRUE
;DEFINE 83C552	TRUE
;DEFINE 83C652	TRUE
;DEFINE 83C751	TRUE ; Problem with C/T
;DEFINE 83C752	TRUE
;DEFINE 83C851	TRUE
;DEFINE RUPI-44 TRUE                                                     

;----------------------------------------------------------------------
;Pre-defined Byte Addresses
;----------------------------------------------------------------------
     
;P0        EQU      080H      ;PORT 0
;SP        EQU      081H      ;STACK POINTER
;DPL       EQU      082H      ;EQU POINTER - LOW BYTE
;DPH       EQU      083H      ;EQU POINTER - HIGH BYTE

;----------------------------------------------------------------------
IFDEF 80C321 OR 80C521                                                
DPL1      EQU      084H      ;EQU POINTER LOW 1                    
DPH1      EQU      085H      ;EQU POINTER HIGH 1                   
DPS       EQU      086H      ;EQU POINTER SELECTION                
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
GMOD      EQU      084H      ;GSC MODE
TFIFO     EQU      085H      ;GSC TRANSMIT BUFFER
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
WDTREL    EQU      086H      ;WATCHDOG TIMER RELOAD REG
ENDIF
;----------------------------------------------------------------------

;PCON      EQU      087H      ;POWER CONTROL
;TCON      EQU      088H      ;TIMER CONTROL
;TMOD      EQU      089H      ;TIMER MODE
;TL0       EQU      08AH      ;TIMER 0 - LOW BYTE
;TL1       EQU      08BH      ;TIMER 1 - LOW BYTE

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752
RTL       EQU      08BH      ;TIMER 0 - LOW BYTE RELOAD
ENDIF
;----------------------------------------------------------------------

;TH0       EQU      08CH      ;TIMER 0 - HIGH BYTE
;TH1       EQU      08DH      ;TIMER 1 - HIGH BYTE

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752
RTH       EQU      08DH      ;TIMER 0 - HIGH BYTE RELOAD
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C752                                                       
PWM       EQU      08EH      ;PULSE WIDTH MODULATION
ENDIF
;----------------------------------------------------------------------

;P1        EQU      090H      ;PORT 1

;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152
P5        EQU      091H      ;PORT 5
DCON0     EQU      092H      ;DMA CONTROL 0
DCON1     EQU      093H      ;DMA CONTROL 1
BAUD      EQU      094H      ;GSC BAUD RATE
ADR0      EQU      095H      ;GSC MATCH ADDRESS 0
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
DCON0     EQU      092H      ;DMA CONTROL 0
DCON1     EQU      093H      ;DMA CONTROL 1
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
DPSEL     EQU      092H      ;EQU POINTER SELECT REGISTER
ENDIF
;----------------------------------------------------------------------

;SCON      EQU      098H      ;SERIAL PORT CONTROL
;SBUF      EQU      099H      ;SERIAL PORT BUFFER

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
I2CON     EQU      098H      ;I2C CONTROL
I2DAT     EQU      099H      ;I2C EQU
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
IEN2      EQU      09AH      ;INTERRUPT ENABLE REGISTER 2
S1CON     EQU      09BH      ;SERIAL PORT CONTROL 1
S1BUF     EQU      09CH      ;SERIAL PORT BUFFER 1
S1REL     EQU      09DH      ;SERIAL RELOAD REG 1
ENDIF
;----------------------------------------------------------------------

;P2        EQU      0A0H      ;PORT 2
;IE        EQU      0A8H      ;INTERRUPT ENABLE

;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252
SADDR     EQU      0A9H      ;SLAVE INDIVIDUAL ADDRESS              
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535 OR 80C517 OR 80C537
IP0       EQU      0A9H      ;INTERRUPT PRIORITY REGISTER 0         
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C321 OR 80C521                                                
WDS       EQU      0A9H      ;WATCHDOG SELECTION                    
WDK       EQU      0AAH      ;WATCHDOG KEY                          
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
P6        EQU      0A1H      ;PORT 6
SARL0     EQU      0A2H      ;DMA SOURCE ADDR. 0 (LOW)
SARH0     EQU      0A3H      ;DMA SOURCE ADDR. 0 (HIGH)
IFS       EQU      0A4H      ;GSC INTERFRAME SPACING
ADR1      EQU      0A5H      ;GSC MATCH ADDRESS 1
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
SARL0     EQU      0A2H      ;DMA SOURCE ADDR. 0 (LOW)
SARH0     EQU      0A3H      ;DMA SOURCE ADDR. 0 (HIGH)
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C552 OR 83C552                                                
CML0      EQU      0A9H      ;COMPARE 0 - LOW BYTE
CML1      EQU      0AAH      ;COMPARE 1 - LOW BYTE
CML2      EQU      0ABH      ;COMPARE 2 - LOW BYTE
CTL0      EQU      0ACH      ;CAPTURE 0 - LOW BYTE
CTL1      EQU      0ADH      ;CAPTURE 1 - LOW BYTE
CTL2      EQU      0AEH      ;CAPTURE 2 - LOW BYTE
CTL3      EQU      0AFH      ;CAPTURE 3 - LOW BYTE
ENDIF
;----------------------------------------------------------------------

;P3        EQU      0B0H      ;PORT 3

;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
SARL1     EQU      0B2H      ;DMA SOURCE ADDR. 1 (LOW)
SARH1     EQU      0B3H      ;DMA SOURCE ADDR. 1 (HIGH)
SLOTTM    EQU      0B4H      ;GSC SLOT TIME
ADR2      EQU      0B5H      ;GSC MATCH ADDRESS 2
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
SARL1     EQU      0B2H      ;DMA SOURCE ADDR. 1 (LOW)
SARH1     EQU      0B3H      ;DMA SOURCE ADDR. 1 (HIGH)
ENDIF
;----------------------------------------------------------------------

;IP        EQU      0B8H      ;INTERRUPT PRIORITY

;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252
SADEN     EQU      0B9H      ;SLAVE ADDRESS ENABLE                  
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535 OR 80C517 OR 80C537
IP1       EQU      0B9H      ;INTERRUPT PRIORITY REGISTER 1         
IRCON     EQU      0C0H      ;INTERRUPT REQUEST CONTROL             
CCEN      EQU      0C1H      ;COMPARE/CAPTURE ENABLE                
CCL1      EQU      0C2H      ;COMPARE/CAPTURE REGISTER 1  - LOW BYTE
CCH1      EQU      0C3H      ;COMPARE/CAPTURE REGISTER 1  - HIGH BYTE
CCL2      EQU      0C4H      ;COMPARE/CAPTURE REGISTER 2  - LOW BYTE
CCH2      EQU      0C5H      ;COMPARE/CAPTURE REGISTER 2  - HIGH BYTE
CCL3      EQU      0C6H      ;COMPARE/CAPTURE REGISTER 3  - LOW BYTE
CCH3      EQU      0C7H      ;COMPARE/CAPTURE REGISTER 3  - HIGH BYTE
T2CON     EQU      0C8H      ;TIMER 2 CONTROL                       
CRCL      EQU      0CAH      ;COMPARE/RELOAD/CAPTURE - LOW BYTE     
CRCH      EQU      0CBH      ;COMPARE/RELOAD/CAPTURE - HIGH BYTE    
TL2       EQU      0CCH      ;TIMER 2 - LOW BYTE                    
TH2       EQU      0CDH      ;TIMER 2 - HIGH BYTE                   
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
CC4EN     EQU      0C9H      ;COMPARE/CAPTURE 4 ENABLE
CCL4      EQU      0CEH      ;COMPARE/CAPTURE REGISTER 4  - LOW BYTE
CCH4      EQU      0CFH      ;COMPARE/CAPTURE REGISTER 4  - HIGH BYTE
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF RUPI-44
STS       EQU      0C8H      ;SIU STATUS REGISTER                   
SMD       EQU      0C9H      ;SERIAL MODE                           
RCB       EQU      0CAH      ;RECEIVE CONTROL BYTE                  
RBL       EQU      0CBH      ;RECEIVE BUFFER LENGTH                 
RBS       EQU      0CCH      ;RECEIVE BUFFER START                  
RFL       EQU      0CDH      ;RECEIVE FIELD LENGTH                  
STAD      EQU      0CEH      ;STATION ADDRESS                       
DMA_CNT   EQU      0CFH      ;DMA COUNT                             
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 8052 OR 8032 OR 80C51FA OR 83C51FA OR 83C252 OR 80C252 OR 80C154 OR 83C154
T2CON     EQU      0C8H      ;TIMER 2 CONTROL                       
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252 
T2MOD     EQU      0C9H      ;TIMER 2 MODE CONTROL                  
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 8052 OR 8032 OR 80C51FA OR 83C51FA OR 83C252 OR 80C252 OR 80C154 OR 83C154     
RCAP2L    EQU      0CAH      ;TIMER 2 CAPTURE REGISTER, LOW BYTE    
RCAP2H    EQU      0CBH      ;TIMER 2 CAPTURE REGISTER, HIGH BYTE   
TL2       EQU      0CCH      ;TIMER 2 - LOW BYTE                    
TH2       EQU      0CDH      ;TIMER 2 - HIGH BYTE                   
ENDIF
;----------------------------------------------------------------------


;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
P4        EQU      0C0H      ;PORT 4
DARL0     EQU      0C2H      ;DMA DESTINATION ADDR. 0 (LOW)
DARH0     EQU      0C3H      ;DMA DESTINATION ADDR. 0 (HIGH)
BKOFF     EQU      0C4H      ;GSC BACKOFF TIMER
ADR3      EQU      0C5H      ;GSC MATCH ADDRESS 3
IEN1      EQU      0C8H      ;INTERRUPT ENABLE REGISTER 1
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
P4        EQU      0C0H      ;PORT 4
DARL0     EQU      0C2H      ;DMA DESTINATION ADDR. 0 (LOW)
DARH0     EQU      0C3H      ;DMA DESTINATION ADDR. 0 (HIGH)
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C451 OR 83C451                                                
P4        EQU      0C0H      ;PORT 4
P5        EQU      0C8H      ;PORT 5
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80512 OR 80532                                                  
IRCON     EQU      0C0H      ;INTERRUPT REQUEST CONTROL
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C552 OR 83C552                                                
P4        EQU      0C0H      ;PORT 4
P5        EQU      0C4H      ;PORT 5
ADCON     EQU      0C5H      ;A/D CONVERTER CONTROL
ADCH      EQU      0C6H      ;A/D CONVERTER HIGH BYTE
TM2IR     EQU      0C8H      ;T2 INTERRUPT FLAGS
CMH0      EQU      0C9H      ;COMPARE 0 - HIGH BYTE
CMH1      EQU      0CAH      ;COMPARE 1 - HIGH BYTE
CMH2      EQU      0CBH      ;COMPARE 2 - HIGH BYTE
CTH0      EQU      0CCH      ;CAPTURE 0 - HIGH BYTE
CTH1      EQU      0CDH      ;CAPTURE 1 - HIGH BYTE
CTH2      EQU      0CEH      ;CAPTURE 2 - HIGH BYTE
CTH3      EQU      0CFH      ;CAPTURE 3 - HIGH BYTE
ENDIF
;----------------------------------------------------------------------

;PSW       EQU      0D0H      ;PROGRAM STATUS WORD

;----------------------------------------------------------------------
IFDEF RUPI-44                                                      
NSNR      EQU      0D8H      ;SEND COUNT/RECEIVE COUNT              
SIUST     EQU      0D9H      ;SIU STATE COUNTER                     
TCB       EQU      0DAH      ;TRANSMIT CONTROL BYTE                 
TBL       EQU      0DBH      ;TRANSMIT BUFFER LENGTH                
TBS       EQU      0DCH      ;TRANSMIT BUFFER START                 
FIFO0     EQU      0DDH      ;THREE BYTE FIFO                       
FIFO1     EQU      0DEH                                             
FIFO2     EQU      0DFH                                             
ENDIF
;----------------------------------------------------------------------



;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252 
CCON      EQU      0D8H      ;CONTROL COUNTER                       
CMOD      EQU      0D9H      ;COUNTER MODE                          
CCAPM0    EQU      0DAH      ;COMPARE/CAPTURE MODE ; for PCA MODULE 0 
CCAPM1    EQU      0DBH      ;COMPARE/CAPTURE MODE ; for PCA MODULE 1 
CCAPM2    EQU      0DCH      ;COMPARE/CAPTURE MODE ; for PCA MODULE 2 
CCAPM3    EQU      0DDH      ;COMPARE/CAPTURE MODE ; for PCA MODULE 3 
CCAPM4    EQU      0DEH      ;COMPARE/CAPTURE MODE ; for PCA MODULE 4 
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535                                                   
ADCON     EQU      0D8H      ;A/D CONVERTER CONTROL                 
ADDAT     EQU      0D9H      ;A/D CONVERTER EQU                    
DAPR      EQU      0DAH      ;D/A CONVERTER PROGRAM REGISTER        
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
DARL1     EQU      0D2H      ;DMA DESTINATION ADDR. 1 (LOW)
DARH1     EQU      0D3H      ;DMA DESTINATION ADDR. 1 (HIGH)
TCDCNT    EQU      0D4H      ;GSC TRANSMIT COLLISION COUNTER
AMSK0     EQU      0D5H      ;GSC ADDRESS MASK 0
TSTAT     EQU      0D8H      ;TRANSMIT STATUS (DMA & GSC)
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
DARL1     EQU      0D2H      ;DMA DESTINATION ADDR. 1 (LOW)
DARH1     EQU      0D3H      ;DMA DESTINATION ADDR. 1 (HIGH)
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C451 OR 83C451                                                
P6        EQU      0D8H      ;PORT 6
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80512 OR 80532                                                  
ADCON     EQU      0D8H      ;A/D CONVERTER CONTROL
ADDAT     EQU      0D9H      ;A/D CONVERTER EQU
DAPR      EQU      0DAH      ;D/A CONVERTER PROGRAM REGISTER
P6        EQU      0DBH      ;PORT 6
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
I2CFG     EQU      0D8H      ;I2C CONFIGURATION
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C552 OR 83C552 OR 80C652 OR 83C652
S1CON     EQU      0D8H      ;SERIAL 1 CONTROL
S1STA     EQU      0D9H      ;SERIAL 1 STATUS
S1DAT     EQU      0DAH      ;SERIAL 1 EQU
S1ADR     EQU      0DBH      ;SERIAL 1 SLAVE ADDRESS
ENDIF
;----------------------------------------------------------------------




;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
CML0      EQU      0D2H      ;COMPARE REGISTER 0  - LOW BYTE
CMH0      EQU      0D3H      ;COMPARE REGISTER 0  - HIGH BYTE
CML1      EQU      0D4H      ;COMPARE REGISTER 1  - LOW BYTE
CMH1      EQU      0D5H      ;COMPARE REGISTER 1  - HIGH BYTE
CML2      EQU      0D6H      ;COMPARE REGISTER 2  - LOW BYTE
CMH2      EQU      0D7H      ;COMPARE REGISTER 2  - HIGH BYTE
ADCON0    EQU      0D8H      ;A/D CONVERTER CONTROL 0
ADDAT     EQU      0D9H      ;A/D CONVERTER EQU
DAPR      EQU      0DAH      ;D/A CONVERTER PROGRAM REGISTER
P7        EQU      0DBH      ;PORT 7
ADCON1    EQU      0DCH      ;A/D CONVERTER CONTROL 1
P8        EQU      0DDH      ;PORT 8
CTRELL    EQU      0DEH      ;COM TIMER REL REG - LOW BYTE
CTRELH    EQU      0DFH      ;COM TIMER REL REG - HIGH BYTE
ENDIF
;----------------------------------------------------------------------

;ACC       EQU      0E0H      ;ACCUMULATOR

;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
BCRL0     EQU      0E2H      ;DMA BYTE COUNT 0 (LOW)
BCRH0     EQU      0E3H      ;DMA BYTE COUNT 0 (HIGH)
PRBS      EQU      0E4H      ;GSC PSEUDO-RANDOM SEQUENCE
AMSK1     EQU      0E5H      ;GSC ADDRESS MASK 1
RSTAT     EQU      0E8H      ;RECEIVE STATUS (DMA & GSC)
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
BCRL0     EQU      0E2H      ;DMA BYTE COUNT 0 (LOW)
BCRH0     EQU      0E3H      ;DMA BYTE COUNT 0 (HIGH)
HSTAT     EQU      0E6H      ;HOST STATUS
HCON      EQU      0E7H      ;HOST CONTROL
SLCON     EQU      0E8H      ;SLAVE CONTROL
SSTAT     EQU      0E9H      ;SLAVE STATUS
IWPR      EQU      0EAH      ;INPUT WRITE POINTER
IRPR      EQU      0EBH      ;INPUT READ POINTER
CBP       EQU      0ECH      ;CHANNEL BOUNDARY POINTER
FIN       EQU      0EEH      ;FIFO IN
CIN       EQU      0EFH      ;COMMAND IN
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535                                                   
P4        EQU      0E8H      ;PORT 4                                
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C451 OR 83C451                                                
CSR       EQU      0E8H      ;CONTROL STATUS
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80512 OR 80532                                                  
P4        EQU      0E8H      ;PORT 4
ENDIF
;----------------------------------------------------------------------


;----------------------------------------------------------------------
IFDEF 80C552 OR 83C552                                                
IEN1      EQU      0E8H      ;INTERRUPT ENABLE REGISTER 1
TM2CON    EQU      0EAH      ;T2 COUNTER CONTROL
CTCON     EQU      0EBH      ;CAPTURE CONTROL
TML2      EQU      0ECH      ;TIMER 2 - LOW BYTE
TMH2      EQU      0EDH      ;TIMER 2 - HIGH BYTE
STE       EQU      0EEH      ;SET ENABLE
RTE       EQU      0EFH      ;RESET/TOGGLE ENABLE
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252      
CL        EQU      0E9H      ;CAPTURE BYTE LOW                      
CCAP0L    EQU      0EAH      ;COMPARE/CAPTURE 0 LOW BYTE            
CCAP1L    EQU      0EBH      ;COMPARE/CAPTURE 1 LOW BYTE            
CCAP2L    EQU      0ECH      ;COMPARE/CAPTURE 2 LOW BYTE            
CCAP3L    EQU      0EDH      ;COMPARE/CAPTURE 3 LOW BYTE            
CCAP4L    EQU      0EEH      ;COMPARE/CAPTURE 4 LOW BYTE            
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
CTCON     EQU      0E1H      ;COM TIMER CONTROL REG
CML3      EQU      0E2H      ;COMPARE REGISTER 3  - LOW BYTE
CMH3      EQU      0E3H      ;COMPARE REGISTER 3  - HIGH BYTE
CML4      EQU      0E4H      ;COMPARE REGISTER 4  - LOW BYTE
CMH4      EQU      0E5H      ;COMPARE REGISTER 4  - HIGH BYTE
CML5      EQU      0E6H      ;COMPARE REGISTER 5  - LOW BYTE
CMH5      EQU      0E7H      ;COMPARE REGISTER 5  - HIGH BYTE
P4        EQU      0E8H      ;PORT 4
MD0       EQU      0E9H      ;MUL/DIV REG 0
MD1       EQU      0EAH      ;MUL/DIV REG 1
MD2       EQU      0EBH      ;MUL/DIV REG 2
MD3       EQU      0ECH      ;MUL/DIV REG 3
MD4       EQU      0EDH      ;MUL/DIV REG 4
MD5       EQU      0EEH      ;MUL/DIV REG 5
ARCON     EQU      0EFH      ;ARITHMETIC CONTROL REG
ENDIF
;----------------------------------------------------------------------

;B         EQU      0F0H      ;MULTIPLICATION REGISTER

;----------------------------------------------------------------------
IFDEF 80C154 OR 83C154                                                 
IOCON     EQU      0F8H      ;I/O CONTROL REGISTER                   
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
BCRL1     EQU      0F2H      ;DMA BYTE COUNT 1 (LOW)
BCRH1     EQU      0F3H      ;DMA BYTE COUNT 1 (HIGH)
RFIFO     EQU      0F4H      ;GSC RECEIVE BUFFER
MYSLOT    EQU      0F5H      ;GSC SLOT ADDRESS
IPN1      EQU      0F8H      ;INTERRUPT PRIORITY REGISTER 1
ENDIF
;----------------------------------------------------------------------

;----------------------------------------------------------------------
IFDEF 83C851 OR 80C851                                                 
EADRL     EQU      0F2H      ;EEPROM Address Register - Low Byte
EADRH     EQU      0F3H      ;EEPROM Address Register - High Byte
EDAT      EQU      0F4H      ;EEPROM EQU Register
ETIM      EQU      0F5H      ;EEPROM Timer Register
ECNTRL    EQU      0F6H      ;EEPROM Control Register
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
BCRL1     EQU      0F2H      ;DMA BYTE COUNT 1 (LOW)
BCRH1     EQU      0F3H      ;DMA BYTE COUNT 1 (HIGH)
ITHR      EQU      0F6H      ;INPUT FIFO THRESHOLD
OTHR      EQU      0F7H      ;OUTPUT FIFO THRESHOLD
IEP       EQU      0F8H      ;INTERRUPT PRIORITY 
MODE      EQU      0F9H      ;MODE 
ORPR      EQU      0FAH      ;OUTPUT READ POINTER
OWPR      EQU      0FBH      ;OUTPUT WRITE POINTER
IMIN      EQU      0FCH      ;IMMEDIATE COMMAND IN
IMOUT     EQU      0FDH      ;IMMEDIATE COMMAND OUT
FOUT      EQU      0FEH      ;FIFO OUT
COUT      EQU      0FFH      ;COMMAND OUT
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535                                                   
P5        EQU      0F8H      ;PORT 5                                
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80512 OR 80532                                                  
P5        EQU      0F8H      ;PORT 5
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
I2STA     EQU      0F8H      ;I2C STATUS
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C552 OR 83C552                                                
IP1       EQU      0F8H      ;INTERRUPT PRIORITY REGISTER 1
PWM0      EQU      0FCH      ;PULSE WIDTH REGISTER 0
PWM1      EQU      0FDH      ;PULSE WIDTH REGISTER 1
PWMP      EQU      0FEH      ;PRESCALER FREQUENCY CONTROL
T3        EQU      0FFH      ;T3 - WATCHDOG TIMER
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
CMEN      EQU      0F6H      ;COMPARE ENABLE
CML6      EQU      0F2H      ;COMPARE REGISTER 6  - LOW BYTE
CMH6      EQU      0F3H      ;COMPARE REGISTER 6  - HIGH BYTE
CML7      EQU      0F4H      ;COMPARE REGISTER 7  - LOW BYTE
CMH7      EQU      0F5H      ;COMPARE REGISTER 7  - HIGH BYTE
CMSEL     EQU      0F7H      ;COMPARE INPUT REGISTER 
P5        EQU      0F8H      ;PORT 5
P6        EQU      0FAH      ;PORT 6
ENDIF
;----------------------------------------------------------------------


;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252      
CH        EQU      0F9H      ;CAPTURE HIGH BYTE                     
CCAP0H    EQU      0FAH      ;COMPARE/CAPTURE 0 HIGH BYTE           
CCAP1H    EQU      0FBH      ;COMPARE/CAPTURE 1 HIGH BYTE           
CCAP2H    EQU      0FCH      ;COMPARE/CAPTURE 2 HIGH BYTE           
CCAP3H    EQU      0FDH      ;COMPARE/CAPTURE 3 HIGH BYTE           
CCAP4H    EQU      0FEH      ;COMPARE/CAPTURE 4 HIGH BYTE           
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C752                                                       
PWENA     EQU      0FEH      ;PULSE WIDTH ENABLE
ENDIF
;----------------------------------------------------------------------


;----------------------------------------------------------------------
;Pre-defined Bit Addresses
;----------------------------------------------------------------------

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
SCL       BIT       080H      ;P0.0 - I2C SERIAL CLOCK
SDA       BIT       081H      ;P0.1 - I2C SERIAL EQU
ENDIF
;----------------------------------------------------------------------

;IT0       BIT       088H      ;TCON.0 - EXT. INTERRUPT 0 TYPE
;IE0       BIT       089H      ;TCON.1 - EXT. INTERRUPT 0 EDGE FLAG
;IT1       BIT       08AH      ;TCON.2 - EXT. INTERRUPT 1 TYPE
;IE1       BIT       08BH      ;TCON.3 - EXT. INTERRUPT 1 EDGE FLAG
;TR0       BIT       08CH      ;TCON.4 - TIMER 0 ON/OFF CONTROL
;TF0       BIT       08DH      ;TCON.5 - TIMER 0 OVERFLOW FLAG
;TR1       BIT       08EH      ;TCON.6 - TIMER 1 ON/OFF CONTROL
;TF1       BIT       08FH      ;TCON.7 - TIMER 1 OVERFLOW FLAG

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
;C/T       BIT       08EH      ;TCON.6 - COUNTER OR TIMER OPERATION
C_T       BIT       08EH      ;TCON.6 - COUNTER OR TIMER OPERATION
GATE      BIT       08FH      ;TCON.7 - GATE TIMER 
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535                                                   
INT3      BIT       090H      ;P1.0 - EXT. INTERRUPT 3/CAPT & COMP 0 
INT4      BIT       091H      ;P1.1 - EXT. INTERRUPT 4/CAPT & COMP 1 
INT5      BIT       092H      ;P1.2 - EXT. INTERRUPT 5/CAPT & COMP 2 
INT6      BIT       093H      ;P1.3 - EXT. INTERRUPT 6/CAPT & COMP 3 
INT2      BIT       094H      ;P1.4 - EXT. INTERRUPT 2               
T2EX      BIT       095H      ;P1.5 - TIMER 2 EXT. RELOAD TRIGGER INP
CLKOUT    BIT       096H      ;P1.6 - SYSTEM CLOCK OUTPUT            
T2        BIT       097H      ;P1.7 - TIMER 2 INPUT                  
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
GRXD      BIT       090H      ;P1.0 - GSC RECEIVER EQU INPUT
GTXD      BIT       091H      ;P1.1 - GSC TRANSMITTER EQU OUTPUT
DEN       BIT       092H      ;P1.2 - DRIVE ENABLE TO ENABLE EXT DRIVE
TXC       BIT       093H      ;P1.3 - GSC EXTERNAL TRANSMIT CLOCK INPU
RXC       BIT       094H      ;P1.4 - GSC EXTERNAL RECEIVER CLOCK INPU
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C552 OR 80C552                                                
CT0I      BIT       090H      ;P1.0 - CAPTURE/TIMER INPUT 0
CT1I      BIT       091H      ;P1.1 - CAPTURE/TIMER INPUT 1
CT2I      BIT       092H      ;P1.2 - CAPTURE/TIMER INPUT 2
CT3I      BIT       093H      ;P1.3 - CAPTURE/TIMER INPUT 3
T2        BIT       094H      ;P1.4 - T2 EVENT INPUT
RT2       BIT       095H      ;P1.5 - T2 TIMER RESET SIGNAL
SCL       BIT       096H      ;P1.6 - SERIAL PORT CLOCK LINE I2C
SDA       BIT       097H      ;P1.7 - SERIAL PORT EQU LINE I2C
ENDIF
;----------------------------------------------------------------------

;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
INT3      BIT       090H      ;P1.0 - EXT. INTERRUPT 3/CAPT & COMP 0
INT4      BIT       091H      ;P1.1 - EXT. INTERRUPT 4/CAPT & COMP 1
INT5      BIT       092H      ;P1.2 - EXT. INTERRUPT 5/CAPT & COMP 2
INT6      BIT       093H      ;P1.3 - EXT. INTERRUPT 6/CAPT & COMP 3
INT2      BIT       094H      ;P1.4 - EXT. INTERRUPT 2
T2EX      BIT       095H      ;P1.5 - TIMER 2 EXT. RELOAD TRIGGER INPU
CLKOUT    BIT       096H      ;P1.6 - SYSTEM CLOCK OUTPUT
T2        BIT       097H      ;P1.7 - TIMER 2 INPUT
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452 OR 80C152 OR 83C152
HLD       BIT       095H      ;P1.5 - DMA HOLD REQUEST I/O
HLDA      BIT       096H      ;P1.6 - DMA HOLD ACKNOWLEDGE OUTPUT
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
UNDEF INT0
INT0      BIT       095H      ;P1.5 - EXTERNAL INTERRUPT 0 INPUT
UNDEF INT1
INT1      BIT       096H      ;P1.6 - EXTERNAL INTERRUPT 1 INPUT
UNDEF T0
T0        BIT       096H      ;P1.7 - TIMER 0 COUNT INPUT
ENDIF
;----------------------------------------------------------------------

;RI        BIT       098H      ;SCON.0 - RECEIVE INTERRUPT FLAG
;TI        BIT       099H      ;SCON.1 - TRANSMIT INTERRUPT FLAG
;RB8       BIT       09AH      ;SCON.2 - RECEIVE BIT 8
;TB8       BIT       09BH      ;SCON.3 - TRANSMIT BIT 8
;REN       BIT       09CH      ;SCON.4 - RECEIVE ENABLE
;SM2       BIT       09DH      ;SCON.5 - SERIAL MODE CONTROL BIT 2
;SM1       BIT       09EH      ;SCON.6 - SERIAL MODE CONTROL BIT 1
;SM0       BIT       09FH      ;SCON.7 - SERIAL MODE CONTROL BIT 0

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
MASTER    BIT        099H      ;I2CON.1 - MASTER
STP       BIT        09AH      ;I2CON.2 - STOP
STR       BIT        09BH      ;I2CON.3 - START
ARL       BIT        09CH      ;I2CON.4 - ARBITRATION LOSS
DRDY      BIT        09DH      ;I2CON.5 - EQU READY
ATN       BIT        09EH      ;I2CON.6 - ATTENTION
RDAT      BIT        09FH      ;I2CON.7 - RECEIVE EQU
XSTP      BIT        098H      ;I2CON.0 - TRANSMIT STOP
XSTR      BIT        099H      ;I2CON.1 - TRANSMIT REPEATED START
CSTP      BIT        09AH      ;I2CON.2 - CLEAR STOP
CSTR      BIT        09BH      ;I2CON.3 - CLEAR START
CARL      BIT        09CH      ;I2CON.4 - CLEAR ARBITRATION LOSS
CDR       BIT        09DH      ;I2CON.5 - CLEAR EQU READY
IDLE      BIT        09EH      ;I2CON.6 - GO IDLE
CXA       BIT        09FH      ;I2CON.7 - CLEAR TRANSMIT ACTIVE
ENDIF
;----------------------------------------------------------------------

;EX0       BIT       0A8H      ;IE.0 - EXTERNAL INTERRUPT 0 ENABLE
;ET0       BIT       0A9H      ;IE.1 - TIMER 0 INTERRUPT ENABLE
;EX1       BIT       0AAH      ;IE.2 - EXTERNAL INTERRUPT 1 ENABLE
;ET1       BIT       0ABH      ;IE.3 - TIMER 1 INTERRUPT ENABLE
;ES        BIT       0ACH      ;IE.4 - SERIAL PORT INTERRUPT ENABLE    

;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
EI2       BIT       0ACH      ;IE.4 - SERIAL PORT INTERRUPT ENABLE
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 8052 OR 8032 OR 80C154 OR 83C154 OR 80C252 OR 80C51FA OR 80515 OR 80535       
ET2       BIT       0ADH      ;TIMER 2 INTERRUPT ENABLE              
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C652 OR 83C652                                                
ES1       BIT       0ADH      ;IE.5 - SERIAL PORT 1 INTERRUPT ENABLE
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C252 OR 80C51FA   
EC        BIT       0AEH      ;IE.6 - ENABLE PCA INTERRUPT
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535                                                   
WDT       BIT       0AEH      ;IEN0.6 - WATCHDOG TIMER RESET         
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C552 OR 80C552                                                
ES1       BIT       0ADH      ;IEN0.5 - SERIAL PORT 1 INTERRUPT ENABLE
EAD       BIT       0AEH      ;IEN0.6 - ENABLE A/D INTERRUPT
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
ET2       BIT       0ADH      ;IEN0.5 - TIMER 2 INTERRUPT ENABLE
WDT       BIT       0AEH      ;IEN0.6 - WATCHDOG TIMER RESET
ENDIF
;----------------------------------------------------------------------

;EA        BIT       0AFH      ;IE.7 - GLOBAL INTERRUPT ENABLE         
;RXD       BIT       0B0H      ;P3.0 - SERIAL PORT RECEIVE INPUT       
;TXD       BIT       0B1H      ;P3.1 - SERIAL PORT TRANSMIT OUTPUT     
;INT0      BIT       0B2H      ;P3.2 - EXTERNAL INTERRUPT 0 INPUT      
;INT1      BIT       0B3H      ;P3.3 - EXTERNAL INTERRUPT 1 INPUT      
;T0        BIT       0B4H      ;P3.4 - TIMER 0 COUNT INPUT             
;T1        BIT       0B5H      ;P3.5 - TIMER 1 COUNT INPUT             
;WR        BIT       0B6H      ;P3.6 - WRITE CONTROL ; for EXT. MEMORY   
;RD        BIT       0B7H      ;P3.7 - READ CONTROL ; for EXT. MEMORY    
;PX0       BIT       0B8H      ;IP.0 - EXTERNAL INTERRUPT 0 PRIORITY   
;PT0       BIT       0B9H      ;IP.1 - TIMER 0 PRIORITY                
;PX1       BIT       0BAH      ;IP.2 - EXTERNAL INTERRUPT 1 PRIORITY   
;PT1       BIT       0BBH      ;IP.3 - TIMER 1 PRIORITY                
;PS        BIT       0BCH      ;IP.4 - SERIAL PORT PRIORITY            
                                                                      
;----------------------------------------------------------------------
IFDEF 80C154 OR 83C154                                                 
PT2       BIT       0BCH      ;IP.5 - TIMER 2 PRIORITY
PCT       BIT       0BFH      ;IP.7 - INTERRUPT PRIORITY DISABLE     
ENDIF
;----------------------------------------------------------------------


;----------------------------------------------------------------------
IFDEF 80C652 OR 83C652                                                
PS1       BIT       0BDH      ;IP.5 - SERIAL PORT 1 PRIORITY
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252
PT2       BIT       0BDH      ;IP.5 - TIMER 2 PRIORITY               
PPC       BIT       0BEH      ;IP.6 - PCA PRIORITY                   
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535 OR 80C517 OR 80C537
EADC      BIT       0B8H      ;IEN1.0 - A/D CONVERTER INTERRUPT EN   
EX2       BIT       0B9H      ;IEN1.1 - EXT. INTERRUPT 2 ENABLE      
EX3       BIT       0BAH      ;IEN1.2 - EXT. INT 3/CAPT/COMP INT 0 EN
EX4       BIT       0BBH      ;IEN1.3 - EXT. INT 4/CAPT/COMP INT 1 EN
EX5       BIT       0BCH      ;IEN1.4 - EXT. INT 5/CAPT/COMP INT 2 EN
EX6       BIT       0BDH      ;IEN1.5 - EXT. INT 6/CAPT/COMP INT 3 EN
SWDT      BIT       0BEH      ;IEN1.6 - WATCHDOG TIMER START         
EXEN2     BIT       0BFH      ;IEN1.7 - T2 EXT. RELOAD INTER START   
IADC      BIT       0C0H      ;IRCON.0 - A/D CONVERTER INTER REQUEST 
IEX2      BIT       0C1H      ;IRCON.1 - EXT. INTERRUPT 2 EDGE FLAG  
IEX3      BIT       0C2H      ;IRCON.2 - EXT. INTERRUPT 3 EDGE FLAG  
IEX4      BIT       0C3H      ;IRCON.3 - EXT. INTERRUPT 4 EDGE FLAG  
IEX5      BIT       0C4H      ;IRCON.4 - EXT. INTERRUPT 5 EDGE FLAG  
IEX6      BIT       0C5H      ;IRCON.5 - EXT. INTERRUPT 6 EDGE FLAG  
TF2       BIT       0C6H      ;IRCON.6 - TIMER 2 OVERFLOW FLAG       
EXF2      BIT       0C7H      ;IRCON.7 - TIMER 2 EXT. RELOAD FLAG    
T2IO      BIT       0C8H      ;T2CON.0 - TIMER 2 INPUT SELECT BIT 0  
T2I1      BIT       0C9H      ;T2CON.1 - TIMER 2 INPUT SELECT BIT 1  
T2CM      BIT       0CAH      ;T2CON.2 - COMPARE MODE                
T2R0      BIT       0CBH      ;T2CON.3 - TIMER 2 RELOAD MODE SEL BIT 0
T2R1      BIT       0CCH      ;T2CON.4 - TIMER 2 RELOAD MODE SEL BIT 1
I2FR      BIT       0CDH      ;T2CON.5 - EXT. INT 2 F/R EDGE FLAG    
I3FR      BIT       0CEH      ;T2CON.6 - EXT. INT 3 F/R EDGE FLAG    
T2PS      BIT       0CFH      ;T2CON.7 - PRESCALER SELECT BIT        
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C552 OR 80C552                                                
PS1       BIT       0BDH      ;IP0.5 - SIO1
PAD       BIT       0BEH      ;IP0.6 - A/D CONVERTER
CMSR0     BIT       0C0H      ;P4.0 - T2 COMPARE AND SET/RESET OUTPUTS
CMSR1     BIT       0C1H      ;P4.1 - T2 COMPARE AND SET/RESET OUTPUTS
CMSR2     BIT       0C2H      ;P4.2 - T2 COMPARE AND SET/RESET OUTPUTS
CMSR3     BIT       0C3H      ;P4.3 - T2 COMPARE AND SET/RESET OUTPUTS
CMSR4     BIT       0C4H      ;P4.4 - T2 COMPARE AND SET/RESET OUTPUTS
CMSR5     BIT       0C5H      ;P4.5 - T2 COMPARE AND SET/RESET OUTPUTS
CMT0      BIT       0C6H      ;P4.6 - T2 COMPARE AND TOGGLE OUTPUTS
CMT1      BIT       0C7H      ;P4.7 - T2 COMPARE AND TOGGLE OUTPUTS
CTI0      BIT       0C8H      ;TM2IR.0 - T2 CAPTURE 0
CTI1      BIT       0C9H      ;TM2IR.1 - T2 CAPTURE 1
CTI2      BIT       0CAH      ;TM2IR.2 - T2 CAPTURE 2
CTI3      BIT       0CBH      ;TM2IR.3 - T2 CAPTURE 3
CMI0      BIT       0CCH      ;TM2IR.4 - T2 COMPARATOR 0
CMI1      BIT       0CDH      ;TM2IR.5 - T2 COMPARATOR 1
CMI2      BIT       0CEH      ;TM2IR.6 - T2 COMPARATOR 2
T2OV      BIT       0CFH      ;TM2IR.7 - T2 OVERFLOW
ENDIF

;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF RUPI-44                                                      
RBP       BIT       0C8H      ;STS.0 - RECEIVE BUFFER PROTECT        
AM        BIT       0C9H      ;STS.1 - AUTO/ADDRESSED MODE SELECT    
OPB       BIT       0CAH      ;STS.2 - OPTIONAL POLL BIT             
BOV       BIT       0CBH      ;STS.3 - RECEIVE BUFFER OVERRUN      
UNDEF SI
SI        BIT       0CCH      ;STS.4 - SIU INTERRUPT FLAG            
RTS       BIT       0CDH      ;STS.5 - REQUEST TO SEND               
RBE       BIT       0CEH      ;STS.6 - RECEIVE BUFFER EMPTY          
TBF       BIT       0CFH      ;STS.7 - TRANSMIT BUFFER FULL          
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 8052 OR 8032 OR 80C154 OR 83C154 OR 80C51FA OR 83C51FA OR 83C252 OR 80C252     
CAP2      BIT       0C8H      ;T2CON.0 - CAPTURE OR RELOAD SELECT    
CNT2      BIT       0C9H      ;T2CON.1 - TIMER OR COUNTER SELECT     
TR2       BIT       0CAH      ;T2CON.2 - TIMER 2 ON/OFF CONTROL      
EXEN2     BIT       0CBH      ;T2CON.3 - TIMER 2 EXTERNAL ENABLE FLAG
TCLK      BIT       0CCH      ;T2CON.4 - TRANSMIT CLOCK SELECT       
RCLK      BIT       0CDH      ;T2CON.5 - RECEIVE CLOCK SELECT        
EXF2      BIT       0CEH      ;T2CON.6 - EXTERNAL TRANSITION FLAG    
TF2       BIT       0CFH      ;T2CON.7 - TIMER 2 OVERFLOW FLAG       
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 OR 80C152                                                 
EGSRV     BIT       0C8H      ;IEN1.0 - GSC RECEIVE VALID
EGSRE     BIT       0C9H      ;IEN1.1 - GSC RECEIVE ERROR
EDMA0     BIT       0CAH      ;IEN1.2 - DMA CHANNEL REQUEST 0
EGSTV     BIT       0CBH      ;IEN1.3 - GSC TRANSMIT VALID
EDMA1     BIT       0CCH      ;IEN1.4 - DMA CHANNEL REQUEST 1
EGSTE     BIT       0CDH      ;IEN1.5 - GSC TRANSMIT ERROR
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80512 OR 80532                                                  
IADC      BIT       0C0H      ;IRCON.0 - A/D CONVERTER INTERRUPT REQ
ENDIF
;----------------------------------------------------------------------

;P         BIT       0D0H      ;PSW.0 - ACCUMULATOR PARITY FLAG

;----------------------------------------------------------------------
IFDEF 83C552 OR 80C552                                                
F1        BIT       0D1H      ;PSW.1 - FLAG 1
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80512 OR 80532                                                  
F1        BIT       0D1H      ;PSW.1 - FLAG 1
MX0       BIT       0D8H      ;ADCON.0 - ANALOG INPUT CH SELECT BIT 0
MX1       BIT       0D9H      ;ADCON.1 - ANALOG INPUT CH SELECT BIT 1
MX2       BIT       0DAH      ;ADCON.2 - ANALOG INPUT CH SELECT BIT 2
ADM       BIT       0DBH      ;ADCON.3 - A/D CONVERSION MODE
BSY       BIT       0DCH      ;ADCON.4 - BUSY FLAG
BD        BIT       0DFH      ;ADCON.7 - BAUD RATE ENABLE
ENDIF
;----------------------------------------------------------------------

;OV        BIT       0D2H      ;PSW.2 - OVERFLOW FLAG
;RS0       BIT       0D3H      ;PSW.3 - REGISTER BANK SELECT 0
;RS1       BIT       0D4H      ;PSW.4 - REGISTER BANK SELECT 1
;F0        BIT       0D5H      ;PSW.5 - FLAG 0
;AC        BIT       0D6H      ;PSW.6 - AUXILIARY CARRY FLAG
;CY        BIT       0D7H      ;PSW.7 - CARRY FLAG

;----------------------------------------------------------------------
IFDEF 80C51FA OR 83C51FA OR 83C252 OR 80C252 
CCF0      BIT       0D8H      ;CCON.0 -PCA MODULE 0 INTERRUPT FLAG   
CCF1      BIT       0D9H      ;CCON.1 -PCA MODULE 1 INTERRUPT FLAG   
CCF2      BIT       0DAH      ;CCON.2 -PCA MODULE 2 INTERRUPT FLAG   
CCF3      BIT       0DBH      ;CCON.3 -PCA MODULE 3 INTERRUPT FLAG   
CCF4      BIT       0DCH      ;CCON.4 -PCA MODULE 4 INTERRUPT FLAG   
UNDEF CR
CR        BIT       0DEH      ;CCON.6 - COUNTER RUN                  
CF        BIT       0DFH      ;PCA COUNTER OVERFLOW FLAG             
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF RUPI-44                                                      
SER       BIT       0D8H      ;NSNR.0 - RECEIVE SEQUENCE ERROR       
NR0       BIT       0D9H      ;NSNR.1 - RECEIVE SEQUENCE COUNTER-BIT 0
NR1       BIT       0DAH      ;NSNR.2 - RECEIVE SEQUENCE COUNTER-BIT 1
NR2       BIT       0DBH      ;NSNR.3 - RECEIVE SEQUENCE COUNTER-BIT 2
SES       BIT       0DCH      ;NSNR.4 - SEND SEQUENCE ERROR          
NS0       BIT       0DDH      ;NSNR.5 - SEND SEQUENCE COUNTER-BIT 0  
NS1       BIT       0DEH      ;NSNR.6 - SEND SEQUENCE COUNTER-BIT 1  
NS2       BIT       0DFH      ;NSNR.7 - SEND SEQUENCE COUNTER-BIT 2  
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80515 OR 80535                                                   
MX0       BIT       0D8H      ;ADCON.0 - ANALOG INPUT CH SELECT BIT 0
MX1       BIT       0D9H      ;ADCON.1 - ANALOG INPUT CH SELECT BIT 1
MX2       BIT       0DAH      ;ADCON.2 - ANALOG INPUT CH SELECT BIT 2
ADM       BIT       0DBH      ;ADCON.3 - A/D CONVERSION MODE         
BSY       BIT       0DCH      ;ADCON.4 - BUSY FLAG                   
CLK       BIT       0DEH      ;ADCON.5 - SYSTEM CLOCK ENABLE         
BD        BIT       0DFH      ;ADCON.7 - BAUD RATE ENABLE            
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C652 OR 83C652                                                
CR0       BIT       0D8H      ;S1CON.0 - CLOCK RATE 0
CR1       BIT       0D9H      ;S1CON.1 - CLOCK RATE 1
AA        BIT       0DAH      ;S1CON.2 - ASSERT ACKNOWLEDGE
UNDEF SI
SI        BIT       0DBH      ;S1CON.3 - SIO1 INTERRUPT BIT
STO       BIT       0DCH      ;S1CON.4 - STOP FLAG
STA       BIT       0DDH      ;S1CON.5 - START FLAG
ENS1      BIT       0DEH      ;S1CON.6 - ENABLE SIO1
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C152 || 80C152                                                 
DMA       BIT       0D8H      ;TSTAT.0 - DMA SELECT
TEN       BIT       0D9H      ;TSTAT.1 - TRANSMIT ENABLE
TFNF      BIT       0DAH      ;TSTAT.2 - TRANSMIT FIFO NOT FULL
TDN       BIT       0DBH      ;TSTAT.3 - TRANSMIT DONE
TCDT      BIT       0DCH      ;TSTAT.4 - TRANSMIT COLLISION DETECT
UR        BIT       0DDH      ;TSTAT.5 - UNDERRUN
NOACK     BIT       0DEH      ;TSTAT.6 - NO ACKNOWLEDGE
LNI       BIT       0DFH      ;TSTAT.7 - LINE IDLE
HBAEN     BIT       0E8H      ;RSTAT.0 - HARDWARE BASED ACKNOWLEDGE EN
GREN      BIT       0E9H      ;RSTAT.1 - RECEIVER ENABLE
RFNE      BIT       0EAH      ;RSTAT.2 - RECEIVER FIFO NOT EMPTY
RDN       BIT       0EBH      ;RSTAT.3 - RECEIVER DONE
CRCE      BIT       0ECH      ;RSTAT.4 - CRC ERROR
AE        BIT       0EDH      ;RSTAT.5 - ALIGNMENT ERROR
RCABT     BIT       0EEH      ;RSTAT.6 - RCVR COLLISION/ABORT DETECT
UNDEF OR
OR        BIT       0EFH      ;RSTAT.7 - OVERRUN
PGSRV     BIT       0F8H      ;IPN1.0 - GSC RECEIVE VALID
PGSRE     BIT       0F9H      ;IPN1.1 - GSC RECEIVE ERROR
PDMA0     BIT       0FAH      ;IPN1.2 - DMA CHANNEL REQUEST 0
PGSTV     BIT       0FBH      ;IPN1.3 - GSC TRANSMIT VALID
PDMA1     BIT       0FCH      ;IPN1.4 - DMA CHANNEL REQUEST 1
PGSTE     BIT       0FDH      ;IPN1.5 - GSC TRANSMIT ERROR
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C452 OR 83C452                                                
OFRS      BIT       0E8H      ;SLCON.0 - OUTPUT FIFO CH REQ SERVICE
IFRS      BIT       0E9H      ;SLCON.1 - INPUT FIFO CH REQ SERVICE
FRZ       BIT       0EBH      ;SLCON.3 - ENABLE FIFO DMA FREEZE MODE
ICOI      BIT       0ECH      ;SLCON.4 - GEN INT WHEN IMMEDIATE COMMAN
                              ;          OUT REGISTER IS AVAILABLE
ICII      BIT       0EDH      ;SLCON.5 - GEN INT WHEN A COMMAND IS 
                              ;          WRITTEN TO IMMEDIATE COMMAND IN REG
OFI       BIT       0EEH      ;SLCON.6 - ENABLE OUTPUT FIFO INTERRUPT
IFI       BIT       0EFH      ;SLCON.7 - ENABLE INPUT FIFO INTERRUPT
EFIFO     BIT       0F8H      ;IEP.0 - FIFO SLAVE BUS I/F INT EN
PDMA1     BIT       0F9H      ;IEP.1 - DMA CHANNEL REQUEST 1
PDMA0     BIT       0FAH      ;IEP.2 - DMA CHANNEL REQUEST 0
EDMA1     BIT       0FBH      ;IEP.3 - DMA CHANNEL 1 INTERRUPT ENABLE
EDMA0     BIT       0FCH      ;IEP.4 - DMA CHANNEL 0 INTERRUPT ENABLE
PFIFO     BIT       0FDH      ;IEP.5 - FIFO SLAVE BUS I/F INT PRIORITY
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C451 OR 83C451                                                
IBF       BIT       0E8H      ;CSR.0 - INPUT BUFFER FULL
OBF       BIT       0E9H      ;CSR.1 - OUTPUT BUFFER FULL
IDSM      BIT       0EAH      ;CSR.2 - INPUT EQU STROBE
OBFC      BIT       0EBH      ;CSR.3 - OUTPUT BUFFER FLAG CLEAR
MA0       BIT       0ECH      ;CSR.4 - AFLAG MODE SELECT
MA1       BIT       0EDH      ;CSR.5 - AFLAG MODE SELECT
MB0       BIT       0EEH      ;CSR.6 - BFLAG MODE SELECT
MB1       BIT       0EFH      ;CSR.7 - BFLAG MODE SELECT
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C751 OR 83C752                                                
CTO       BIT        0D8H      ;I2CFG.0 - CLOCK TIMING 0
CT0       BIT        0D8H      ;I2CFG.0 - CLOCK TIMING 0
CT1       BIT        0D9H      ;I2CFG.1 - CLOCK TIMING 1
T1RUN     BIT        0DCH      ;I2CFG.4 - START/STOP TIMER 1
TIRUN     BIT        0DCH      ;I2CFG.4 - START/STOP TIMER 1
CLRTI     BIT        0DDH      ;I2CFG.5 - CLEAR TIMER 1 INTERRUPT FLAG
MASTRQ    BIT        0DEH      ;I2CFG.6 - MASTER I2C
SLAVEN    BIT        0DFH      ;I2CFG.7 - SLAVE I2C
RSTP      BIT        0F8H      ;I2STA.0 - XMIT STOP CONDITION
RSTR      BIT        0F9H      ;I2STA.1 - XMIT REPEAT STOP COND.
MAKSTP    BIT        0FAH      ;I2STA.2 - STOP CONDITION
MAKSTR    BIT        0FBH      ;I2STA.3 - START CONDITION
XACTV     BIT        0FCH      ;I2STA.4 - XMIT ACTIVE
XEQU      BIT        0FDH      ;I2STA.5 - CONTENT OF XMIT BUFFER
RIDLE     BIT        0FEH      ;I2STA.6 - SLAVE IDLE FLAG
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 83C552 OR 80C552                                                
CR0       BIT       0D8H      ;S1CON.0 - CLOCK RATE 0
CR1       BIT       0D9H      ;S1CON.1 - CLOCK RATE 1
AA        BIT       0DAH      ;S1CON.2 - ASSERT ACKNOWLEDGE
UNDEF SI
SI        BIT       0DBH      ;S1CON.3 - SERIAL I/O INTERRUPT
STO       BIT       0DCH      ;S1CON.4 - STOP FLAG
STA       BIT       0DDH      ;S1CON.5 - START FLAG
ENS1      BIT       0DEH      ;S1CON.6 - ENABLE SERIAL I/O 
ECT0      BIT       0E8H      ;IEN1.0 - ENABLE T2 CAPTURE 0
ECT1      BIT       0E9H      ;IEN1.1 - ENABLE T2 CAPTURE 1 
ECT2      BIT       0EAH      ;IEN1.2 - ENABLE T2 CAPTURE 2
ECT3      BIT       0EBH      ;IEN1.3 - ENABLE T2 CAPTURE 3
ECM0      BIT       0ECH      ;IEN1.4 - ENABLE T2 COMPARATOR 0
ECM1      BIT       0EDH      ;IEN1.5 - ENABLE T2 COMPARATOR 1
ECM2      BIT       0EEH      ;IEN1.6 - ENABLE T2 COMPARATOR 2
ET2       BIT       0EFH      ;IEN1.7 - ENABLE T2 OVERFLOW
PCT0      BIT       0F8H      ;IP1.0 - T2 CAPTURE REGISTER 0
PCT1      BIT       0F9H      ;IP1.1 - T2 CAPTURE REGISTER 1
PCT2      BIT       0FAH      ;IP1.2 - T2 CAPTURE REGISTER 2
PCT3      BIT       0FBH      ;IP1.3 - T2 CAPTURE REGISTER 3
PCM0      BIT       0FCH      ;IP1.4 - T2 COMPARATOR 0
PCM1      BIT       0FDH      ;IP1.5 - T2 COMPARATOR 1
PCM2      BIT       0FEH      ;IP1.6 - T2 COMPARATOR 2
PT2       BIT       0FFH      ;IP1.7 - T2 OVERFLOW
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C517 OR 80C537                                                
F1        BIT       0D1H      ;PSW.1 - FLAG 1
MX0       BIT       0D8H      ;ADCON0.0 - ANALOG INPUT CH SELECT BIT 0
MX1       BIT       0D9H      ;ADCON0.1 - ANALOG INPUT CH SELECT BIT 1
MX2       BIT       0DAH      ;ADCON0.2 - ANALOG INPUT CH SELECT BIT 2
ADM       BIT       0DBH      ;ADCON0.3 - A/D CONVERSION MODE
BSY       BIT       0DCH      ;ADCON0.4 - BUSY FLAG
CLK       BIT       0DEH      ;ADCON0.5 - SYSTEM CLOCK ENABLE
BD        BIT       0DFH      ;ADCON0.7 - BAUD RATE ENABLE
ENDIF
;----------------------------------------------------------------------
;----------------------------------------------------------------------
IFDEF 80C154 OR 83C154                                                 
ALF       BIT       0F8H      ;IOCON.0 - CPU POWER DOWN MODE CONTROL  
P1F       BIT       0F9H      ;IOCON.1 - PORT 1 HIGH IMPEDANCE        
P2F       BIT       0FAH      ;IOCON.2 - PORT 2 HIGH IMPEDANCE        
P3F       BIT       0FBH      ;IOCON.3 - PORT 3 HIGH IMPEDANCE        
IZC       BIT       0FCH      ;IOCON.4 - 10K TO 100 K OHM SWITCH (P1-3)
SERR      BIT       0FDH      ;IOCON.5 - SERIAL PORT RCV ERROR FLAG   
T32       BIT       0FEH      ;IOCON.6 - 32 BIT TIMER SWITCH          
WDT       BIT       0FFH      ;IOCON.7 - WATCHDOG TIMER CONTROL       
ENDIF
;----------------------------------------------------------------------
$LIST



