;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;									; 
; File		: 8051.inc						;
; Function   	: ** Information only do not include ** 					;
;		: Special function registers for 8051			;
; Author	: M.B.Clay						;
; Date		: 13/07/92						; 
;									; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

P0	EQU	080H	;Parallel port 0
SP	EQU	081H  	;Stack pointer
DPL	EQU	082H  	;Data pointer Low byte
DPH	EQU	083H 	;Data pointer High byte
TCON	EQU	088H 	;Timer Control
TMOD	EQU	089H 	;Timer Mode
TL0	EQU	08AH 	;Timer 0 Low byte
TL1	EQU	08BH 	;Timer 1 Low byte
TH0	EQU	08CH 	;Timer 0 High byte
TH1	EQU	08DH 	;Timer 1 High byte
P1	EQU	090H 	;Parallel port 1
SCON	EQU	098H 	;Serial Control
SBUF	EQU	099H 	;Serial  Data Buffer
P2	EQU	0A0H 	;Parallel Port 2
IE	EQU	0A8H 	;Interrupt Enable Control
P3	EQU	0B0H 	;Parallel Port 3
IP	EQU	0B8H 	;Interrupt Priority Control
PSW	EQU	0D0H	;Program Status Word
ACC	EQU	0E0H	;Accumulator
B	EQU	0F0H	;Register B

;Built in BIT equates
;Program Status Word
CY	BIT	PSW.7	;Carry Flag
AC	BIT	PSW.6	;Auxiliary Carry
F0	BIT	PSW.5	;User flag 0 
RS1	BIT	PSW.4	;Register Select 0
RS0	BIT	PSW.3	;Register Select 1
OV	BIT	PSW.2	;Overflow flag
P	BIT	PSW.0	;Parity Flag Timer
TF1	BIT	TCON.7	;Counter 1 Interrupt request and overflow flag
TR1	BIT	TCON.6	;Counter 1 Enable/Disable bit
TF0	BIT	TCON.5	;Counter 0 interrupt request and overflow flag
TR0	BIT	TCON.4	;Counter 0 Enable/Disable bit
IE1	BIT	TCON.3	;External Interrupt Request Flag 1
IT1	BIT	TCON.2	;Input INT1 Transition-Activated
IE0	BIT	TCON.1	;External Interrupt Request Flag 0
IT0	BIT	TCON.0	;Input INT0 Transition-Activated

;Serial
SM0	BIT	SCON.7	;Serial Port Operation Mode (MSB)
SM1	BIT	SCON.6	;Serial Port Operation Mode (LSB)
SM2	BIT	SCON.5	;Conditional Receiver Enable
REN	BIT	SCON.4	;Receiver Enable
TB8	BIT	SCON.3	;Transmitter Data Bit 8
RB8	BIT	SCON.2	;Receiver Data Bit 8
TI	BIT	SCON.1	;Transmission Complete Interrupt Flag
RI	BIT	SCON.0	;Reception Complete Interrupt Flag

;Interrupt Enable Flags
EA	BIT	IE.7	;All Enabled
ES	BIT	IE.4	;Internal Serial Port
ET1	BIT	IE.3	;Internal Timer/Counter 1
EX1	BIT	IE.2	;External Request 1
ET0	BIT	IE.1	;Internal Timer/Counter 0
EX0	BIT	IE.0	;External Request 0

;Interrupt Priority Flags
PS	BIT	IP.4	;Internal Serial Port
PT1	BIT	IP.3	;Internal Timer/Counter 1
PX1	BIT	IP.2	;External Request 1
PT0	BIT	IP.1	;Internal Timer/Counter 0
PX0	BIT	IP.0	;External Request 0

;Parallel Port 3
RD	BIT	P3.7	;Read External Data
WR	BIT	P3.6	;Write External Data
T1	BIT	P3.5	;Test Input 1
T0	BIT	P3.4	;Test Input 0
INT1	BIT	P3.3	;Interrupt 1
INT0	BIT	P3.2	;Interrupt 0
TXD	BIT	P3.1	;Transmit Data
RXD	BIT	P3.0	;Receive Data














