 * File......: MBUTTON.PRG
 * Author....: Leo Letendre CIS: 73607,233
 * Date......:  6/23/93
 * Revision..: V2.0       // update to clipper 5.2 release
 *
 * Copyright 1991-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.
 *
 * Modification history:
 *
 * 12/30/92  V1.01  Added storage of messages and coordinates to allow these
 *                  routines to refresh the screen rather than the caller.
 * 02/06/93  V1.02  Fixed restoring screen after button removal/cool when
 *                  the button has been warmed
 * 02/25/93  V1.03  Skipped printing message when string is NIL
 * 03/25/93  V1.04  Added inactive option to buttons which allows a button
 *                  to be build without it being displayed or being active
#include "mouse.ch"

* Define the indexes into the aId array of Button()

#define IDNUM       1
#define MOUSESYSTEM 2
#define FUNCTIONKEY 3
#define ACTIONBLOCK 4
#define SCREENSAVE  5
#define TOP         6
#define LEFT        7
#define BOTTOM      8
#define RIGHT       9
#define AMESSAGE   10
#define ACOLOR     11
#define AIDSIZE    11    // equal to the last element defined above

* Define directives to allow shutting off certain systems
* These are here so that the systems while not get loaded if you  do
* not wish to use them while still wanting to use these button command

*#define NOREAD         // Don't use buttons in GET/READ
*#define NOMEMOEDIT     // Don't use buttons in MEMOEDIT
*#define NOACHOICE      // Don't use buttons in ACHOICE
*#define NOMENUTO       // Don't use buttons in MENU TO
*#define NOBROWSE       // Don't use buttons in BROWSE

#stdout
#ifdef NOREAD         // Don't use buttons in GET/READ
	#stdout No Reads assumed
#endif
#ifdef NOMEMOEDIT     // Don't use buttons in MEMOEDIT
	#stdout No memoedit assumed
#endif
#ifdef NOACHOICE      // Don't use buttons in ACHOICE
	#stdout No achoice assumed
#endif
#ifdef NOMENUTO       // Don't use buttons in MENU TO
	#stdout No menu to assumed
#endif
#ifdef NOBROWSE       // Don't use buttons in BROWSE
	#stdout No Browse assumed
#endif


*+
FUNCTION Button(nTop, nLeft, nBottom, nRight, xString,nFunctionKey, ;
	bAction, nMouseSystem, nButton, nSleep, lRelease, cColor, lActive ) 
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Make a mouse button with function key for mouse system
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/25/92   LJL       Initial Version
*         V1.01    12/30/92   LJL       Added storage of message and necessary
*                                       support
*
/*  $DOC$
 *  $FUNCNAME$
 *     Button()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Make a mouse button on screen with associated function key
 *  $SYNTAX$
 *     Button(<nTop>, <nLeft>, <nBottom>, <nRight>, [<xString>],;
 *          [<nFunctionKey>][, <xAction>][, <nMouseSystem>][, <nButton>];
 *          [, <nSleep>][, <lRelease>][, <cColor>][, <lActive>] ) -> <aId>
 *  $ARGUMENTS$
 *     <nTop>, <nLeft>, <nBottom>, <nRight> are coordinates to include
 *          in hot spot and to clear to put string
 *     <xString> is either a character string to print or a code block
 *          which will print the button on the screen. It is centered
 *          in the area defined above.
 *     <nFunctionKey> is the function key (as defined in inkey.ch) to be
 *          associated with this button. Can be NIL
 *     <bAction> is a code block to be associated with this button. 
 *     <nMouseSystem> is the mouse system to place the hot spot into. The
 *          values are defined in MOUSE.CH and are MREAD, MBROWSE, MMENU,
 *          MMEMOEDIT, MACHOICE, MGENERAL
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on
 *              clicking any button (the code block can decide
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presse2s.
 *              Prevents routine from operating too quickly and
 *              reading the press of a button multiple times
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> - Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *     <cColor> is the the color for button. If blank then current color
 *          used.
 *     <lActive> indicates if you wish to activate the button immediately.
 *              If you choose to not activate the button you can do so by
 *              calling the buttonwarm() function. That is, the effect
 *              of setting lActive to .F. is the same as calling Button()
 *              followed immediately by ButtonCool(). If lActive is .F.
 *              the button is not displayed immediately but can be shown
 *              with the call to ButtonWarm()
 *
 *  $RETURNS$
 *     <aId> which is a unique identifier of the button. It is not the same
 *           as the ids produced by the individual hotspot routines so do not
 *           use them for that purpose.
 *  $DESCRIPTION$
 *      This routine provides a simple method of associating a screen hot
 *      spot and a function key to a given action.
 *      The screen area behind the button is saved.
 *  $EXAMPLES$
 *     aId1=Button(0,0,0,6,"Help",K_F1,{|| MyHelp()},MREAD,"W/N")
 *  $SEEALSO$
 *     RemoveButton() ButtonCool() ButtonWarm()
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/
*-
* LOCAL variables: 
LOCAL aId:=ARRAY(AIDSIZE)
*
* Entry Point
*

IF VALTYPE(lActive)<>"L"
	lActive=.T.
ENDIF
* Save some of the id array

aId[SCREENSAVE]=SAVESCREEN(nTop,nLeft,nBottom, nRight)
aId[FUNCTIONKEY]=nFunctionKey
aId[MOUSESYSTEM]=nMouseSystem
aId[ACTIONBLOCK]=bAction
aId[TOP   ]=nTop
aId[LEFT  ]=nLeft
aId[BOTTOM]=nBottom
aId[RIGHT ]=nRight
aId[AMESSAGE]=xString
aId[ACOLOR]=cColor

* Clear screen area

IF lActive
	@ nTop,nLeft CLEAR TO nBottom, nRight
ENDIF

* Now write out the string

IF VALTYPE(xString)="B".AND.lActive
	EVAL(xString)
ELSEIF VALTYPE(xString)="C".AND.lActive
	@ nTop+INT((nBottom-nTop)/2), INT((nRight+nLeft-LEN(xString)+1)/2) ;
		SAY xString COLOR cColor
ENDIF

* Set up the function key

IF nFunctionKey !=NIL
	SETKEY(nFunctionKey,bAction)
ENDIF

* Set up the hot spot

DO CASE
#ifndef NOREAD
	CASE nMouseSystem=MREAD
		aId[IDNUM]  = RDHotSpot( nTop, nLeft, nBottom, nRight, bAction, ;
					nButton, nSleep, lRelease)
#endif
#ifndef NOBROWSE
	CASE nMouseSystem=MBROWSE
		aId[IDNUM]  = BRHotSpot( nTop, nLeft, nBottom, nRight, bAction, ;
					nButton, nSleep, lRelease)
#endif
#ifndef NOMENUTO
	CASE nMouseSystem=MMENU
		aId[IDNUM]  = MHotSpot( nTop, nLeft, nBottom, nRight, bAction, ;
					nButton, nSleep, lRelease)
#endif
#ifndef NOMEMOEDIT
	CASE nMouseSystem=MMEMOEDIT
		aId[IDNUM]  = MEHotSpot( nTop, nLeft, nBottom, nRight, bAction, ;
					nButton, nSleep, lRelease)
#endif
#ifndef NOACHOICE
	CASE nMouseSystem=MACHOICE
		aId[IDNUM]  = ACHotSpot( nTop, nLeft, nBottom, nRight, bAction, ;
					nButton, nSleep, lRelease)
#endif
	CASE nMouseSystem=MGENERAL
		aId[IDNUM]  = GHotSpot( nTop, nLeft, nBottom, nRight, bAction, ;
					nButton, nSleep, lRelease)
	OTHERWISE
		ALERT("Proper subsystem not loaded for Button Functions")

ENDCASE

IF !lActive
	ButtonCool(aId,.F.)
ENDIF

* Return enough information to deleted, cool and warm

RETURN aId

* End of Button

*+
FUNCTION ButtonCool(aId, lRestore)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Suspend a mouse button with function key for mouse system
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/25/92   LJL       Initial Version
*         V1.01    12/30/92   LJL       Added storage of message and necessary
*                                       support
*         V1.02    05/31/93   LJL       return value now .T. for easier use
*                                       with VALID and WHEN clauses
*
/*  $DOC$
 *  $FUNCNAME$
 *     ButtonCool()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Suspend a mouse screen button with associated function key
 *  $SYNTAX$
 *     ButtonCool(<aId> [, <lRestore>] ) -> NIL
 *  $ARGUMENTS$
 *     <aId> which is the id information provided by Button()
 *     <lRestore> which indicates if the screen area should be restored to
 *           the original
 *
 *  $RETURNS$
 *      .T.
 *  $DESCRIPTION$
 *      This routine provides a method to temporarily shutting off a button
 *      created by button(). Both the action of the function key and the mouse
 *      are suspended. They can be reactivated using ButtonWarm(). The screen
 *      area saved can also be restored if <lRestore> =.T.
 *  $EXAMPLES$
 *     aId1=Button(0,0,0,6,"Help",K_F1,{|| MyHelp()},MREAD,"W/N")
 *
 *     <Some Code>
 *
 *     ButtonCool(aId1, .T.)
 *
 *     <Some Code>
 *
 *     ButtonWarm(aId1, .T.)
 *  $SEEALSO$
 *     RemoveButton() Button() ButtonWarm()
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/
*-
*
* Local variables
*

* Cool off the correct hot spot based upon the correct system


DO CASE
#ifndef NOREAD
	CASE aId[MOUSESYSTEM] =MREAD
		RDCoolSpot( aId[IDNUM]) 
#endif
#ifndef NOBROWSE
	CASE aId[MOUSESYSTEM] =MBROWSE
		BRCoolSpot( aId[IDNUM]) 
#endif
#ifndef NOMENUTO
	CASE aId[MOUSESYSTEM] =MMENU
		MCoolSpot( aId[IDNUM]) 
#endif
#ifndef NOMEMOEDIT
	CASE aId[MOUSESYSTEM] =MMEMOEDIT
		MECoolSpot( aId[IDNUM])
#endif
#ifndef NOACHOICE
	CASE aId[MOUSESYSTEM] =MACHOICE
		ACCoolSpot( aId[IDNUM])
#endif
	CASE aId[MOUSESYSTEM] =MGENERAL
		GCoolSpot( aId[IDNUM])
	OTHERWISE
		ALERT("Proper subsystem not loaded for Button Functions")
ENDCASE

* Cool off the function key

IF aId[FUNCTIONKEY]!=NIL
	SETKEY(aId[FUNCTIONKEY], NIL)
ENDIF

* Restore screen area if requested

IF VALTYPE(lRestore)="L" .AND. lRestore
	RESTSCREEN(aId[TOP], aId[LEFT], aId[BOTTOM], aId[RIGHT], aId[SCREENSAVE])
ENDIF

RETURN .T.


*+
FUNCTION ButtonWarm(aId, lRestore)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Reactivate a mouse button with function key for mouse system
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/25/92   LJL       Initial Version
*         V1.01    12/30/92   LJL       Added storage of message and necessary
*                                       support
*         V1.02     2/05/93   LJL       Saved screen prior to restoring button
*         V1.03    05/31/93   LJL       Return value now .T. for easier use
*                                       with VALID and WHEN clauses
/*  $DOC$
 *  $FUNCNAME$
 *     ButtonWarm()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Reactivate a mouse screen button with associated function key
 *  $SYNTAX$
 *     ButtonWarm(<aId> [,<lRestore>] ) -> NIL
 *  $ARGUMENTS$
 *     <aId> which is the id information provided by Button()
 *     <lRestore> which indicates if the message should be repainted (.T.)
 *
 *  $RETURNS$
 *      .T.
 *  $DESCRIPTION$
 *      This routine provides a method to reactivate a suspended button
 *      created by button(). Both the action of the function key and the mouse
 *      are reactivated. They can be suspended using ButtonCool(). The
 *      original message is repainted if <lRestore> = .T.
 *  $EXAMPLES$
 *     aId1=Button(0,0,0,6,"Help",K_F1,{|| MyHelp()},MREAD,"W/N")
 *
 *     <Some Code>
 *
 *     ButtonCool(aId1)
 *
 *     <Some Code>
 *
 *     ButtonWarm(aId1)
 *  $SEEALSO$
 *     RemoveButton() ButtonCool() Button()
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/
*-
*
* Local variables
*
LOCAL cSaveColor:=SETCOLOR(aId[ACOLOR])
* warm up the correct hot spot based upon the correct system


DO CASE
#ifndef NOREAD
	CASE aId[MOUSESYSTEM] =MREAD
		RDWarmSpot( aId[IDNUM]) 
#endif
#ifndef NOBROWSE
	CASE aId[MOUSESYSTEM] =MBROWSE
		BRWarmSpot( aId[IDNUM]) 
#endif
#ifndef NOMENUTO
	CASE aId[MOUSESYSTEM] =MMENU
		MWarmSpot( aId[IDNUM]) 
#endif
#ifndef NOMEMOEDIT
	CASE aId[MOUSESYSTEM] =MMEMOEDIT
		MEWarmSpot( aId[IDNUM])
#endif
#ifndef NOACHOICE
	CASE aId[MOUSESYSTEM] =MACHOICE
		ACWarmSpot( aId[IDNUM])
#endif
	CASE aId[MOUSESYSTEM] =MGENERAL
		GWarmSpot( aId[IDNUM])
	OTHERWISE
		ALERT("Proper subsystem not loaded for Button Functions")

ENDCASE

* Reactivate the function key

IF aId[FUNCTIONKEY]!=NIL
	SETKEY(aId[FUNCTIONKEY], aId[ACTIONBLOCK])
ENDIF

* Restore message if requested

IF VALTYPE(lRestore)="L" .AND. lRestore

* Save the screen properly
	aId[SCREENSAVE]:=SAVESCREEN(aId[TOP], aId[LEFT], aId[BOTTOM], aId[RIGHT])

	IF VALTYPE(aId[AMESSAGE])="B"
		EVAL(aId[AMESSAGE])
	ELSEIF VALTYPE(aId[AMESSAGE])="C"
		@ aId[TOP]+INT((aId[BOTTOM]-aId[TOP])/2), ;
		 INT((aId[RIGHT]+aId[LEFT]-LEN(aId[AMESSAGE])+1)/2) ;
			SAY aId[AMESSAGE]
	ENDIF
ENDIF

* Restore color

SETCOLOR(cSaveColor)

RETURN .T.

* End of ButtonWarm

*+
FUNCTION RemoveButton( aId, lRestore )
*
* This routine and all accompaning database structures are 
* Copyright (C) 1992 Leo J. Letendre. All rights reserved.
*
* Purpose: Remove a mouse button with function key from mouse system
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/25/92   LJL       Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     RemoveButton()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Remove a mouse screen button with associated function key
 *  $SYNTAX$
 *     RemoveButton(<aId>, <lRestore>) -> NIL
 *  $ARGUMENTS$
 *     <aId> which is the id information provided by Button() of the button
 *           to be removed
 *     <lRestore> which signifies if you wish to restore the screen. The
 *           default is .T.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine provides a method to delete a button from the screen
 *      and restoring the screen to the original state if requested.
 *  $EXAMPLES$
 *     aId1=Button(0,0,0,6,"Help",K_F1,{|| MyHelp()},MREAD,"W/N")
 *
 *     <Some Code>
 *
 *     ButtonCool(aId1)
 *
 *     <Some Code>
 *
 *     ButtonWarm(aId1)
 *
 *     <Some Code>
 *
 *     RemoveButton(aId1, .F.)
 *  $SEEALSO$
 *     Button() ButtonCool() ButtonWarm()
 *  $INCLUDE$
 *     MOUSE.CH
 *  $END$
*/
*-
*
* Local variables
*

* Cool off the correct hot spot based upon the correct system


DO CASE
#ifndef NOREAD
	CASE aId[MOUSESYSTEM] =MREAD
		RDRemHotSpot( aId[IDNUM]) 
#endif
#ifndef NOBROWSE
	CASE aId[MOUSESYSTEM] =MBROWSE
		BRRemHotSpot( aId[IDNUM]) 
#endif
#ifndef NOMENUTO
	CASE aId[MOUSESYSTEM] =MMENU
		MRemHotSpot( aId[IDNUM]) 
#endif
#ifndef NOMEMOEDIT
	CASE aId[MOUSESYSTEM] =MMEMOEDIT
		MERemHotSpot( aId[IDNUM])
#endif
#ifndef NOACHOICE
	CASE aId[MOUSESYSTEM] =MACHOICE
		ACRemHotSpot( aId[IDNUM])
#endif
	CASE aId[MOUSESYSTEM] =MGENERAL
		GRemHotSpot( aId[IDNUM])
	OTHERWISE
		ALERT("Proper subsystem not loaded for Button Functions")
ENDCASE

* Remove the function key

IF aId[FUNCTIONKEY]!=NIL
	SETKEY(aId[FUNCTIONKEY], NIL)
ENDIF

* Restore the screen if requested

IF lRestore==NIL .OR. lRestore
	RESTSCREEN(aId[TOP], aId[LEFT], aId[BOTTOM], aId[RIGHT], aId[SCREENSAVE])
ENDIF

RETURN NIL

* End of RemoveButton

