const
	FOR_READ		= 0;
	FOR_WRITE		= 1;
	FOR_READ_AND_WRITE	= 2;
	FROM_BEGIN		= 0;
	FROM_CURRENT		= 1;
	FROM_END		= 2;
	TChar			= 0;
	TByte			= 1;
	TWord			= 2;
	TLong			= 3;
	Bin			= 0;
	Tasm			= 1;
	Pascal			= 2;
	Cpp			= 3;
	kos			= '\';
	ap			='''';
	C_char	: array [8..13] of char='btnfvr';
	HexChar	: array [0..15] of char='0123456789ABCDEF';
	Tip	: array [0..3] of string[7]=
			('char','byte','word','longint');
	Asm_char: array [0..3] of char='BBWD';
	IOsize	 = 4*5000;
type
	IObuffer = record
			case Integer of
			0:(b:array [1..IOSIZE] of byte);
			1:(w:array [1..IOSIZE div 2] of word);
			2:(l:array [1..IOSIZE div 4] of longint);
		end;
var
	iobuf	: IObuffer;
	s,stmp	: string;
	ch,
	lng,
	mode	: byte;
	hexmode,
	pr_char,
	n_ch	: boolean;
	cur,
	cnt,
	rlen	: word;
	offset,
	count	: longint;
	f,f1	: integer;
	f2	: text;

function OpenFile(filename:string;mode:byte):integer;
begin 
	asm
        	MOV WORD PTR [BP-2],0FFFFH
      		MOV BX,DS
      		MOV CL,[BP-102H]
      		XOR CH,CH
      		LEA DI,[BP-101H]  (*151*)
      		MOV DX,DI
      		MOV AX,SS
      		MOV DS,AX
		ADD DI,CX
		MOV BYTE PTR [DI],CH
		MOV AH,3Dh
		MOV AL,BYTE PTR [BP+4]
		CMP AL,1
		JNE @@1
		XOR CX,CX
		DEC AH
@@1:		INT 21H
		JC @@2
		MOV [BP-2],AX				
@@2:      	MOV DS,BX
	END;	
end;
{---------------------------------------------------------------------------}
function CloseFile(handle:integer):boolean;
LABEL L83;
begin
	ASM
		MOV BYTE PTR [BP-1],0
		MOV BX,[BP+4]
		MOV AH,3EH
		INT 21H
		JC L83
		INC BYTE PTR [BP-1]
L83:
	END;		
end;
{---------------------------------------------------------------------------}
function LSeek(handle:integer;distance:Longint;fromwhere:byte):longint;
LABEL L98,L99;
begin
	ASM
		MOV AL,[BP+4]
		MOV BX,[BP+0AH]
		MOV CX,[BP+8]
		MOV DX,[BP+6]
		MOV AH,42H
		INT 21H
		JC L98
		MOV [BP-4],AX
		MOV [BP-2],DX
		JMP L99
L98:		MOV WORD PTR [BP-4],0FFFFH
		MOV WORD PTR [BP-2],0FFFFH
L99:
	END;		
end;
{---------------------------------------------------------------------------}
function ReadFile(handle:integer;buffer:pointer;count:word):word;
LABEL L120;
begin 
	ASM
		MOV WORD PTR [BP-2],0
		MOV BX,[BP+0AH]
		MOV CX,[BP+4]
		MOV SI,DS
		LDS DX,[BP+6]
		MOV AH,3FH
		INT 21H
		JC L120
		MOV [BP-2],AX
L120:		MOV DS,SI
	END;		
end;
{---------------------------------------------------------------------------}
function WriteFile(handle:integer;buffer:pointer;count:word):word;
LABEL L120;
begin
	ASM
		MOV WORD PTR [BP-2],0
		MOV BX,[BP+0AH]
		MOV CX,[BP+4]
		MOV SI,DS
		LDS DX,[BP+6]
		MOV AH,40H
		INT 21H
		JC L120
		MOV [BP-2],AX
L120:		MOV DS,SI
	END;		
end;
{---------------------------------------------------------------------------}
function FileLength(handle:integer):longint;
begin
	ASM
		MOV BX,[BP+4]
		XOR CX,CX
		MOV AX,4202H
		XOR DX,DX
		INT 21H
		JC @@1
		MOV [BP-2],DX
		MOV [BP-4],AX
		JMP @@2
	@@1:	MOV WORD PTR [BP-4],0FFFFH
		MOV WORD PTR [BP-2],0FFFFH
	@@2:
	END;		
end;	
{---------------------------------------------------------------------------}
procedure Usage;
begin
	Writeln('Usage: LGSHRED <input_file> <output_file> <offset> <count> </lmh> [limit],');
	Writeln;
	Writeln('where');
	Writeln;
	Writeln('l       - language(b-binary output,a-asm,p-pascal,c-c++)');
	Writeln('m       - mode(c-character,b-byte,w-word,l-long)-ignored if binary');
	Writeln('h       - hex( 1 - if character mode - except c++ contiguous string ');
	Writeln('               else - hexadecimal numbers)  -ignored if binary');
	Writeln('limit   - right border(ignored if binary,by default - 80)');
	Writeln;
	Writeln('Examples:');
	Writeln;
	Writeln('LGSHRED 1.com 1 $2345 3456 /b');
	Writeln('LGSHRED 1.com 1 10000 $1000 /aw0 55');
	Writeln('LGSHRED 1.com 1 0 20 /pc1');
	Writeln('LGSHRED 1.com 1 $200 550 /cl1 120');
	Halt(1);
end;
{---------------------------------------------------------------------------}
function Hex(b:byte):string;
begin
	Hex:=HexChar[b div 16]+HexChar[b mod 16];
end;
{---------------------------------------------------------------------------}
function Oct(b:byte):string;
begin
	Oct:=HexChar[b div 64]+HexChar[(b div 8) and 7]+HexChar[b and 7];
end;
{---------------------------------------------------------------------------}
function InHex(s:string;var err:integer):longint;
var l:longint;i,k:byte;
begin
	InHex:=0; err:=1;
	l:=0;
	for i:=2 to length(s) do begin
		k:=Ord(UpCase(s[i]))-48;
		if not (k in [0..9,17..22]) then Exit;
		if k>9 then Dec(k,7);
		l:=l*16+k;
	end;
        err:=0;
	InHex:=l;
end;
{---------------------------------------------------------------------------}
procedure Params;
label l1;
var err:integer;
begin
	rlen:=80;
	if ParamCount<5 then Usage;
	s:=ParamStr(1);
	f:=OpenFile(s,FOR_READ);
	if f<0 then begin
		Writeln('Failed to open ',s);
		Halt(2);
	end;
	s:=ParamStr(3);
	if s[1]='$' then offset:=InHex(s,err)
	else Val(s,offset,err);
	if (err<>0) or (offset<0) then Usage;
	if offset>FileLength(f) then begin
		Writeln('Offset is greater then filesize');
		Halt(4);
	end;
	s:=ParamStr(4);
	if s[1]='$' then count:=InHex(s,err)
	else Val(s,count,err);
	if (err<>0) or (count<=0) then Usage;
	if count>FileLength(f)-offset then count:=FileLength(f)-offset;
	s:=ParamStr(5);
	if not (s[1] in ['/','-']) then Usage;
	if UpCase(s[2])='B' then lng:=Bin else begin
		case UpCase(s[2]) of
		'A':lng:=Tasm;
		'P':lng:=Pascal;
		'C':lng:=Cpp;
		else Usage;
		end;
		case UpCase(s[3]) of
		'C':mode:=Tchar;
		'B':mode:=Tbyte;
		'W':mode:=Tword;
		'L':mode:=Tlong;
		else Usage;
		end;
		if s[4]='1' then hexmode:=True;
		if ParamCount>5 then begin
			s:=ParamStr(6);
			Val(s,rlen,err);
			if err<>0 then Usage;
			if rlen<40 then rlen:=40;
			if rlen>255 then rlen:=255;
		end;
	end;
	s:=ParamStr(2);
	if lng<>Bin then begin
		Assign(f2,s);{$I-}Rewrite(f2);{$I+}
		if IOResult<>0 then goto l1;
	end else begin
		f1:=OpenFile(s,FOR_WRITE);
		if f1<0 then begin
l1:			Writeln('Failed to open output file ',s);
			Halt(3);
		end
	end;
end;
{---------------------------------------------------------------------------}
begin
	{$IFNDEF VER70}
	pr_char:=False;
	hexmode:=False;
	n_ch:=False;
	{$ENDIF}
	Writeln('File hacking program LGSHRED v1.0            1994 written by Yuri G.Lyapko');
	Writeln;
	Params; LSeek(f,offset,FROM_BEGIN);
	if lng<>Bin then begin
		if lng=Cpp then begin
			tip[1]:='char';
			tip[2]:='int';
			tip[3,0]:=Chr(4);
		end;
		if lng=Tasm then s:='buf     D'+Asm_char[mode]+' '
		else begin
			Str(count-1,stmp);
			case lng of
			Pascal:s:='const buf:array [0..'+stmp+'] of '+
				tip[mode]+'=';
			Cpp:begin
				if mode<>TChar then s:='unsigned ' else
                                s:='';
				s:=s+tip[mode]+' buf['+stmp+']=';
				end;
			end;
			Writeln(f2,s);
			case lng of
			Pascal:if (mode=Tchar) and hexmode then
				s:='        ' else s:='       (';
			Cpp:s:='       {';
			end;
		end;
	end;
	while count>0 do begin
		if count>SizeOf(IObuf) then cnt:=SizeOf(IObuf) else
		cnt:=count;
		ReadFile(f,@iobuf,cnt);
		Dec(count,cnt);
		if lng=Bin then
			WriteFile(f1,@iobuf,cnt)
		else begin
			if mode>=TWord then cnt:=cnt div 2;
			if mode=TLong then cnt:=cnt div 2;
			for cur:=1 to cnt do begin
				if mode=TChar then begin
					ch:=iobuf.b[cur];
					if lng=cpp then
					case ch of
					8..13:stmp:=ap+kos+c_char[ch]+ap;
					0:stmp:=ap+kos+'0'+ap;
					34,39,92,255:
					stmp:=ap+kos+Chr(ch)+ap;
					32..254:
					stmp:=ap+Chr(ch)+ap
					else stmp:=ap+kos+Oct(ch)+ap;
					end else if ch in [32..38,
					40..254] then
					if pr_char then begin
						n_ch:=True;
						if lng=Tasm then
						Dec(s[0],2) else
						Dec(s[0]);
						stmp:=Chr(ch)+ap;
					end else begin
						n_ch:=False;
						stmp:=ap+Chr(ch)+ap;
						if hexmode then
						pr_char:=True
					end else begin
						pr_char:=False;
						Str(iobuf.b[cur],stmp);
						if lng=Pascal then
						stmp:='#'+stmp;
					end
				end else if not hexmode then
					case mode of
					Tbyte:Str(iobuf.b[cur],stmp);
					Tword:Str(iobuf.w[cur],stmp);
					Tlong:Str(iobuf.l[cur],stmp);
					end else begin
					case mode of
					Tbyte:stmp:=Hex(iobuf.b[cur]);
					Tword:stmp:=Hex(iobuf.w[cur] div 256)+
					Hex(iobuf.w[cur] mod 256);
					Tlong:stmp:=Hex(iobuf.l[cur] shr 24)+
					Hex((iobuf.l[cur] shr 12) mod 256)+
					Hex((iobuf.l[cur] shr 8) mod 256)+
					Hex(iobuf.l[cur] mod 256);
					end;
					case lng of
						Pascal:stmp:='$'+stmp;
						Tasm:begin
						if stmp[1]>'9' then
						stmp:='0'+stmp;
						stmp:=stmp+'h';
						end;
						Cpp:stmp:='0x'+stmp;
					end;
					end;
				if (lng<>Pascal) or (mode<>TChar)
				or (not hexmode) then
				stmp:=stmp+',';
				if length(s)+length(stmp)<rlen then
				s:=s+stmp
				else begin
					case lng of
					Tasm:if not pr_char then Dec(s[0])
					else if n_ch then begin
                                             stmp:=ap+stmp;
                                             s:=s+ap;
                                        end else Dec(s[0]);
					Pascal:if pr_char then begin
						stmp:=ap+stmp;
						if n_ch then s:=s+ap;
						s:=s+'+';
						end else
						if (mode=Tchar) and hexmode
                                                then s:=s+'+';
					end;
					Writeln(f2,s);
					if pr_char then n_ch:=True
					else n_ch:=False;
					if lng=Tasm then
					s:='        D'+Asm_char[mode]+
					' '+stmp else
					s:='        '+stmp;
				end;
			end;
		end;
	end;
	CloseFile(f);
	if lng=Bin then CloseFile(f1) else begin
		case lng of
		Pascal:if (mode<>Tchar) or (not hexmode) then begin
                            Dec(s[0]);
                            s:=s+');'
			end else s:=s+';';
		Cpp:begin
				Dec(s[0]);s:=s+'}';
			end;
		Tasm:Dec(s[0]);
		end;
		Writeln(f2,s);
		Close(f2);
	end;
end.
