uses Crt;
label l1;
const	LINE1='LGPATCH';
	OFSET='OFS:';
	OLD='OLD:';
	NEW='NEW:';
	NOFS=0;NOLD=1;NNEW=2;
type	replace_Bufer=array [0..24] of byte;
var	f,f1:file;fname:string;fsize:longint;
	pf:text;
	tmpbuf:array [0..29999] of byte;
	oldbuf,newbuf:replace_Bufer;
	BytesToReplace:integer;
	Offset:longint;
	WaitFor:byte;

function Trim(s:string):string;
var i:integer;
begin
	i:=1;while (i<=length(s)) and (s[i]=' ') do Inc(i);
	Delete(s,1,i-1);
	i:=length(s);while (i>0) and (s[i]=' ') do Dec(i);
	Delete(s,i+1,length(s));
	Trim:=s;
end;

function UpStr(s:string):string;
var i:integer;
begin
	for i:=1 to length(s) do s[i]:=UpCase(s[i]);
	UpStr:=s;
end;

function HexToLong(s:string):longint;
var i:integer;l:longint;
begin
	if s='' then begin
		HexToLong:=-1;Exit
	end;
	l:=0;
	s:=UpStr(s);
	for i:=1 to length(s) do begin
		l:=l*$10;
		case s[i] of
		'0'..'9':Inc(l,Ord(s[i])-Ord('0'));
		'A'..'F':Inc(l,Ord(s[i])-Ord('A')+$0A);
		else begin
			HexToLong:=-1;
			Exit
		end;
		end;
	end;
	HexToLong:=l;
end;

function GetBufer(var a:replace_Bufer;s:string):integer;
var i,k:integer;l:longint;
begin
	GetBufer:=0;
	k:=0;
	i:=1;
	while i<=length(s) do begin
		l:=HexToLong(Copy(s,i,2));
		if l=-1 then Exit;
		a[k]:=Byte(l);Inc(k);Inc(i,2);
		if i>length(s) then break;
		if s[i]<>' ' then Exit;
		Inc(i);
	end;
	GetBufer:=k;
end;

var	i,error:integer;s:string;ch:char;
begin
	Writeln(
'LGPATCH v1.0               Freeware          (c) 1998 by George Lyapko'#10);
	if ParamCount<>1 then begin
		Writeln('Usage: LGPATCH patch_file');
		Exit
	end;
	Assign(pf,ParamStr(1));
	{$I-}Reset(pf);{$I+}
	if IOResult<>0 then begin
		Writeln('Patch file ',ParamStr(1),' not found!!!');
		Exit
	end;
	{$I-}Readln(pf,s);{$I+}
	if (IOResult<>0) or (Copy(UpStr(s),1,7)<>LINE1) then begin
		Writeln('Invalid patch file!!!');goto l1;
	end;
	{$I-}Readln(pf,s);{$I+}
	if IOResult<>0 then begin
		Writeln('Error in patch file!!!');goto l1;
	end;
	Writeln(s);
	repeat
		Write('Do you wish to continue(Y/N)?');
		ch:=Readkey;
		Writeln(ch);
		if ch=#0 then ReadKey;
	until UpCase(ch) in ['Y','N'];
	if UpCase(ch)='N' then goto l1;
	{$I-}Readln(pf,fname);{$I+}
	if IOResult<>0 then begin
		Writeln('Error in patch file!!!');goto l1;
	end;
	Assign(f,fname);
	{$I-}Reset(f,1);{$I+}
	if IOResult<>0 then begin
		Writeln('File ',fname,' not found!!!');goto l1
	end;
	{$I-}Readln(pf,s);{$I+}
	if IOResult<>0 then begin
		Writeln('Error in patch file!!!');
		Close(f);goto l1;
	end;
	Val(s,fsize,error);
	if fsize<>FileSize(f) then begin
		Writeln('Wrong size of ',fname,'!!!');
		Close(f);
		goto l1
	end;
	Assign(f1,'(lgpat).$1$');Rewrite(f1,1);
	BlockRead(f,tmpbuf,SizeOf(tmpbuf),i);
	while i<>0 do begin
		BlockWrite(f1,tmpbuf,i,error);
		if i<>error then begin
			Writeln(i,' ',error);
			Writeln('Write error - not enough space?');
			Close(f1);Erase(f1);Close(f);goto l1;
		end;
		BlockRead(f,tmpbuf,SizeOf(tmpbuf),i);
	end;
	Close(f);
	while not eof(pf) do begin
		Readln(pf,s);
		if s[1]='#' then Writeln(Copy(s,2,length(s))) else begin
			s:=UpStr(s);
			case WaitFor of
			NOFS:begin
				if Copy(s,1,4)<>OFSET then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - Ofs: not found!!!');
					goto l1;
				end;
				Delete(s,1,4);
				Offset:=HexToLong(Trim(s));
				if (Offset=-1) or (Offset>fsize) then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - wrong offset!!!');
					goto l1;
				end;
				Seek(f1,Offset);
				WaitFor:=NOLD;
			end;
			NOLD:begin
				if Copy(s,1,4)<>OLD then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - Old: not found!!!');
					goto l1;
				end;
				Delete(s,1,4);
				BytesToReplace:=GetBufer(oldbuf,Trim(s));
				if (BytesToReplace=0) or 
				(BytesToReplace>25) then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - wrong bytes to be replaced!!!');
					goto l1;
				end;
				BlockRead(f1,tmpbuf,BytesToReplace,error);
				if BytesToReplace<>error then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - wrong offset!!!');
					goto l1;
				end;
				for i:=0 to Pred(BytesToReplace) do if
				oldbuf[i]<>tmpbuf[i] then begin
					Close(f1);Erase(f1);
					Writeln('Bytes not match!!!');
					goto l1;
				end;
				Seek(f1,Offset);
				WaitFor:=NNEW;
			end;
			NNEW:begin
				if Copy(s,1,4)<>NEW then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - New: not found!!!');
					goto l1;
				end;
				Delete(s,1,4);
				error:=GetBufer(newbuf,Trim(s));
				if (BytesToReplace<>error) then begin
					Close(f1);Erase(f1);
					Writeln('Error in patch file - wrong bytes to replace!!!');
					goto l1;
				end;
				BlockWrite(f1,newbuf,BytesToReplace);
				WaitFor:=NOFS;
			end;
			end;
		end;		
	end;
	Close(f1);Erase(f);Rename(f1,fname);
l1:	Close(pf);
end.