;
; Copyright (C) 2000 Grzegorz Kowal
;

;;
;; VESA BIOS MACROS
;;


VESAPresent	EQU	1
GLOBAL	VESAWidth:DWORD
GLOBAL	VESAHeight:DWORD
GLOBAL	VESAStartX:DWORD
GLOBAL	VESAStartY:DWORD
GLOBAL	VESABank:WORD
GLOBAL	VESABuffer:BYTE:256
GLOBAL	ScrBuff:DWORD

GLOBAL	_VESAInit:PROC
GLOBAL	PutBlock:PROC
GLOBAL	GetBlock:PROC
GLOBAL	FillBlock:PROC
GLOBAL	PutPixel:PROC
GLOBAL	GetPixel:PROC
GLOBAL	PutLine:PROC
GLOBAL	SetPal:PROC
GLOBAL	SetGrayPal:PROC
GLOBAL	SetNulPal:PROC
GLOBAL	LoadPal:PROC
GLOBAL	PutGpxText:PROC
GLOBAL	PutGpxChar:PROC
GLOBAL	ShowColoRIX:PROC
GLOBAL	ShowGIF:PROC
GLOBAL	WipeScr:PROC
GLOBAL	Input:PROC
GLOBAL	InitScrBuff:PROC
GLOBAL	KillScrBuff:PROC
GLOBAL	PutScrBuff:PROC
GLOBAL	GetScrBuff:PROC
GLOBAL	FastLine:PROC
GLOBAL	UseButtons:PROC
GLOBAL	PutDialog:PROC
GLOBAL	ButtonFont:DWORD
GLOBAL	ButtonFg:BYTE
GLOBAL	ButtonBg:BYTE
GLOBAL	ButtonU1:BYTE
GLOBAL	ButtonU2:BYTE
GLOBAL	ButtonL1:BYTE
GLOBAL	ButtonL2:BYTE
GLOBAL	ButtonBd:BYTE
GLOBAL	FrameFg:BYTE
GLOBAL	FrameBg:BYTE
GLOBAL	WindowFont:DWORD
GLOBAL	WindowFg:BYTE
GLOBAL	WindowBg:BYTE
GLOBAL	WindowU:BYTE
GLOBAL	WindowL:BYTE
GLOBAL	ScrollUp:DWORD
GLOBAL	ScrollDown:DWORD
GLOBAL	ScrollLeft:DWORD
GLOBAL	ScrollRight:DWORD
GLOBAL	ScrollF:BYTE


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; VESAInit  ->  buffer
;; Checks for VESA BIOS and returns SVGA information.
;;
;; Expects:	nothing
;;
;; Returns:	VESABuffer = info
;;
;; Note:	ALL REGISTERS *DESTROYED*
;;
VESAInit	MACRO
		call	_VESAInit
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetModeInfo (mode)  ->  AX,buffer
;; Returns info on bank switching and virtual screen size.
;;
;; Expects:	mode (word)
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;		VESABuffer = info
;;
GetModeInfo	MACRO	P1
		push	cx di
		mov	ax,4F01h
		mov	cx,P1
		Init_es_di VESABuffer
		DosInt	10h
		pop	di cx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetMode (mode)  ->  AX
;; Set video mode.
;;
;; Expects:	mode = [1--640x480 | 2--800x600 | 3--1024x768]
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
SetMode		MACRO	P1
		LOCAL	Skip1
		IFDIFI	<P1>,<1>
			IFDIFI	<P1>,<2>
				IFDIFI	<P1>,<3>
					ERR	"Invalid video mode number"
				ENDIF
			ENDIF
		ENDIF
		push	bx
		mov	ax,4F02h
		IFIDNI	<P1>,<1>
			mov	bx,101h
		ENDIF
		IFIDNI	<P1>,<2>
			mov	bx,103h
		ENDIF
		IFIDNI	<P1>,<3>
			mov	bx,105h
		ENDIF
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		IFIDNI	<P1>,<1>
			mov	VESAWidth,640
			mov	VESAHeight,480
		ENDIF
		IFIDNI	<P1>,<2>
			mov	VESAWidth,800
			mov	VESAHeight,600
		ENDIF
		IFIDNI	<P1>,<3>
			mov	VESAWidth,1024
			mov	VESAHeight,768
		ENDIF
		mov	VESABank,0
		mov	VESAStartX,0
		mov	VESAStartY,0
Skip1:
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetMode ()  ->  BX,AX
;; Returns current mode.
;;
;; Expects:	nothing
;;
;; Returns:	BX	= mode (bit 15 ignored)
;;		AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
GetMode		MACRO
		mov	ax,4F03h
		DosInt	10h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetBank (bank)  ->  AX (DX may be modified if an error occurs).
;; Hooks bank to window A.
;;
;; Expects:	bank (word)
;;
;; Returns:	ZF	= status (ZY--ok, ZN--error)
;;		AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
;;
SetBank		MACRO	P1
		LOCAL	Skip1
		push	bx
		IFDIFI	<P1>,<dx>
			push	dx
		ENDIF
		mov	ax,4F05h
		xor	bx,bx
		IFDIFI	<P1>,<dx>
			mov	dx,P1
		ENDIF
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		mov	VESABank,dx
Skip1:
		IFDIFI	<P1>,<dx>
			pop	dx
		ENDIF
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetScanLen (width)  ->  AX,BX,CX,DX
;; Sets virtual screen width.
;;
;; Expects:	width (word) in pixels
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;		BX	= bytes per line
;;		CX	= virtual screen width in pixels
;;		DX	= maximal number of lines
;;
SetScanLen	MACRO	P1
		LOCAL	Skip1
		mov	ax,4F06h
		xor	bl,bl
		mov	cx,P1
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		mov	word ptr VESAWidth,cx
		cmp	dx,word ptr VESAHeight
		jae	Skip1
		mov	word ptr VESAHeight,dx
Skip1:
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetScanLen ()  ->  AX,BX,CD,DX
;; Returns virtual screen width.
;;
;; Expects:	nothing
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;		BX	= bytes per line
;;		CX	= virtual screen width in pixels
;;		DX	= maximal number of lines
;;
GetScanLen	MACRO
		mov	ax,4F06h
		mov	bl,1
		DosInt	10h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetScreenStart (first column,first line)  ->  AX
;; Sets position of the virtual screen's upper-left corner.
;;
;; Expects:	column # displayed first (word) -- 388
;;		line # displayed first (word) -- 0
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
SetScreenStart	MACRO	P1,P2
		LOCAL	Skip1
		push	bx
		IFDIFI	<P1>,<cx>
			push	cx
		ENDIF
		IFDIFI	<P2>,<dx>
			push	dx
		ENDIF
		mov	ax,4F07h
		xor	bx,bx
		IFDIFI	<P1>,<cx>
			mov	cx,P1
		ENDIF
		IFDIFI	<P2>,<dx>
			mov	dx,P2
		ENDIF
		DosInt	10h
		or	ah,ah
		jnz	Skip1
		mov	WORD PTR VESAStartX,cx
		mov	WORD PTR VESAStartY,dx
Skip1:
		IFDIFI	<P2>,<dx>
			pop	dx
		ENDIF
		IFDIFI	<P1>,<cx>
			pop	cx
		ENDIF
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetDACPal (bits per RGB)  ->  AX
;; Sets number of bits per RGB.
;;
;; Expects:	number of bits per RGB (byte)
;;
;; Returns:	AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
SetDACPal	MACRO	P1
		push	bx
		mov	ax,4F08h
		xor	bl,bl
		mov	bh,P1
		DosInt	10h
		pop	bx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetDACPal ()  ->  BX,AX
;; Returns number of bits per RGB.
;;
;; Expects:	nothing
;;
;; Returns:	BH	= number of bits per RGB
;;		AH	= status (0--ok, 1--error)
;;		AL	= VESA BIOS installed (4Fh--yes)
;;
GetDACPal	MACRO
		mov	ax,4F08h
		mov	bl,1
		DosInt	10h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; ScrollOn
;; Turns scrolling on.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
ScrollOn	MACRO
		and	ScrollF,01111111b
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; ScrollOff
;; Turns scrolling off.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
ScrollOff	MACRO
		or	ScrollF,10000000b
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Sets Button colors.
;;
;; Expects:	Fg,Bg,U1,U2,L1,L2,Bd
;; 
;; Returns:	nothing
;;
ButtonCol	MACRO	P1,P2,P3,P4,P5,P6,P7
		mov	ButtonFg,P1
		mov	ButtonBg,P2
		mov	ButtonU1,P3
		mov	ButtonU2,P4
		mov	ButtonL1,P5
		mov	ButtonL2,P6
		mov	ButtonBd,P7
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Sets Frame colors.
;;
;; Expects:	Fg,Bg
;; 
;; Returns:	nothing
;;
FrameCol	MACRO	P1,P2
		mov	FrameFg,P1
		mov	FrameBg,P2
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Sets Window colors.
;;
;; Expects:	Fg,Bg,U,L
;; 
;; Returns:	nothing
;;
WindowCol	MACRO	P1,P2,P3,P4
		mov	WindowFg,P1
		mov	WindowBg,P2
		mov	WindowU,P3
		mov	WindowL,P4
		ENDM


ButEnd		EQU	DD 0


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines a window button.
;;
;; Expects:	Func	= button handling function
;;		X	= X position (relative to window upper-left corner)
;;		Y	= Y position (relative to window upper-left corner)
;;		Type	= button type [0|4|8|C]
;;		Text	= "caption", 1->8 depending on button type
;;			  0--1 char
;;			  4--3 chars
;;			  8--8 chars
;;			  C--1 char (special button)
;;
;; Returns:	nothing
;;
WinBut		MACRO	Func,X,Y,BType,BText
@@StrLen	SIZESTR <&BText>
		ERRIF	@@StrLen LT 3 "Button must have caption"
		IF	@@StrLen GT 10
			ERR "Caption too long (max 8)"
			EXITM
		ENDIF
		DD	Func
		DW	WinX + X
		DW	WinY + Y
		DB	0&BType&0h + @@StrLen - 2
		DB	Btext
		REPT	(10 - @@StrLen)
			DB 0
		ENDM
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines a stand-alone button.
;;
;; Expects:	Func	= button handling function
;;		X	= X position (absolute coordinates)
;;		Y	= Y position (absolute coordinates)
;;		Type	= button type [0|4|8|C]
;;		Text	= "caption", 1->8 depending on button type
;;			  0--1 char
;;			  4--3 chars
;;			  8--8 chars
;;			  C--1 char (special button)
;;
;; Returns:	nothing
;;
AbsBut		MACRO	Func,X,Y,BType,BText
@@StrLen	SIZESTR <&BText>
		ERRIF	@@StrLen LT 3 "Button must have caption"
		IF	@@StrLen GT 10
			ERR "Caption too long (max 8)"
			EXITM
		ENDIF
		DD	Func
		DW	X
		DW	Y
		DB	0&BType&0h + @@StrLen - 2
		DB	Btext
		REPT	(10 - @@StrLen)
			DB 0
		ENDM
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines a frame button (relative).
;;
;; Expects:	Func	= button handling function
;;		X	= X position (relative to window upper-left corner)
;;		Y	= Y position (relative to window upper-left corner)
;;		XS	= X-size
;;		YS	= Y-size
;;
;; Returns:	nothing
;;
WinFrame	MACRO	Func,X,Y,XS,YS,MenuItemNum:=<0>
		DD	Func
		DW	WinX + X
		DW	WinY + Y
		DB	00100000b
		DW	XS
		DW	YS
		DB	MenuItemNum
		DB	0,0,0
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines a frame button (absolute).
;;
;; Expects:	Func	= button handling function
;;		X	= X position (absolute coordinates)
;;		Y	= Y position (absolute coordinates)
;;		XS	= X-size
;;		YS	= Y-size
;;
;; Returns:	nothing
;;
AbsFrame	MACRO	Func,X,Y,XS,YS
		DD	Func
		DW	X
		DW	Y
		DB	00100000b
		DW	XS
		DW	YS
		DD	0
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines an X close button.
;;
;; Expects:	Func	= button handling function
;;
;; Returns:	nothing
;;
XBut		MACRO	Func
		DD	Func
		DW	WinX + WinXS - 19
		DW	WinY + 1
		DB	01h
		DB	"X       "
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines a button placed at the bottom of the window.
;;
;; Expects:	Func	= button handling function
;;		Caption = "caption", max 8 chars
;;
;; Returns:	nothing
;;
Win1But		MACRO	Func,Caption
@@StrLen	SIZESTR <&Caption>
		ERRIF	@@StrLen LT 3 "Button must have caption"
		IF	@@StrLen GT 10
			ERR "Caption too long (max 8)"
			EXITM
		ENDIF
		DD	Func
		DW	WinX + (WinXS - 74)/2
		DW	WinY + WinYS - 38
		DB	80h + @@StrLen - 2
		DB	Caption
		REPT	(10 - @@StrLen)
			DB 0
		ENDM
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines 2 buttons placed at the bottom of the window.
;;
;; Expects:	Func	= button handling function
;;		Caption = "caption", max 8 chars
;;		Func2
;;		Caption2
;;
;; Returns:	nothing
;;
Win2But		MACRO	Func,Caption,Func2,Caption2
@@StrLen	SIZESTR <&Caption>
@@StrLen2	SIZESTR <&Caption2>
		ERRIF	@@StrLen LT 3 "Button must have caption"
		ERRIF	@@StrLen2 LT 3 "Button must have caption"
		IF	(@@StrLen GT 10) OR (@@StrLen2 GT 10)
			ERR "Caption too long (max 8)"
			EXITM
		ENDIF
		DD	Func
		DW	WinX + WinXS/3 - 74/2
		DW	WinY + WinYS - 38
		DB	80h + @@StrLen - 2
		DB	Caption
		REPT	(10 - @@StrLen)
			DB 0
		ENDM
		DD	Func2
		DW	WinX + WinXS/3*2 - 74/2
		DW	WinY + WinYS - 38
		DB	80h + @@StrLen2 - 2
		DB	Caption2
		REPT	(10 - @@StrLen2)
			DB 0
		ENDM
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines 3 buttons placed at the bottom of the window.
;;
;; Expects:	Func	= button handling function
;;		Caption = "caption", max 8 chars
;;		Func2
;;		Caption2
;;		Func3
;;		Caption3
;;
;; Returns:	nothing
;;
Win3But		MACRO	Func,Caption,Func2,Caption2,Func3,Caption3
@@StrLen	SIZESTR <&Caption>
@@StrLen2	SIZESTR <&Caption2>
@@StrLen3	SIZESTR <&Caption3>
		ERRIF	@@StrLen LT 3 "Button must have caption"
		ERRIF	@@StrLen2 LT 3 "Button must have caption"
		ERRIF	@@StrLen3 LT 3 "Button must have caption"
		IF	(@@StrLen GT 10) OR (@@StrLen2 GT 10) OR (@@StrLen3 GT 10)
			ERR "Caption too long (max 8)"
			EXITM
		ENDIF
		DD	Func
		DW	WinX + WinXS/4 - 74/2
		DW	WinY + WinYS - 38
		DB	80h + @@StrLen - 2
		DB	Caption
		REPT	(10 - @@StrLen)
			DB 0
		ENDM
		DD	Func2
		DW	WinX + WinXS/4*2 - 74/2
		DW	WinY + WinYS - 38
		DB	80h + @@StrLen2 - 2
		DB	Caption2
		REPT	(10 - @@StrLen2)
			DB 0
		ENDM
		DD	Func3
		DW	WinX + WinXS/4*3 - 74/2
		DW	WinY + WinYS - 38
		DB	80h + @@StrLen3 - 2
		DB	Caption3
		REPT	(10 - @@StrLen3)
			DB 0
		ENDM
		ENDM


WinDef		MACRO	X,Y,XS,YS
		DW	X		; x-pos
		DW	Y		; y-pos
		DW	XS		; x-size
		DW	YS		; y-size
		WinX = X
		WinY = Y
		WinXS = XS
		WinYS = YS
		ENDM


WinTitle	MACRO	TitleText
		DB	1,TitleText,0
		ENDM


WinText		MACRO	XPos,YPos,Text
		DB	2
		DW	XPos,YPos
		DB	Text,0
		ENDM


WinTextCt	MACRO	YPos,Text
@@StrLen	SIZESTR	<&Text>
		DB	2
		DW	(WinXS-(@@StrLen-2)*9)/2,YPos
		DB	Text,0
		ENDM


WinTxt		MACRO	XPos,YPos,Text
		DB	2
		DW	10+9*XPos,30+16*YPos
		DB	Text,0
		ENDM


WinTxtCt	MACRO	YPos,Text
@@StrLen	SIZESTR	<&Text>
		DB	2
		DW	(WinXS-(@@StrLen-2)*9)/2,30+16*YPos
		DB	Text,0
		ENDM


WinH		MACRO	XPos,YPos,XSize,YSize
		DB	3
		DW	XPos,YPos,XSize,YSize
		ENDM


WinHText	MACRO	XPos,YPos,Len,Text
		WinH	XPos,YPos,Len*9+10,20
		WinText XPos+5,YPos+2,Text
		ENDM


WinL		MACRO	XPos,YPos,XSize,YSize
		DB	4
		DW	XPos,YPos,XSize,YSize
		ENDM


WinLText	MACRO	XPos,YPos,Len,Text
		WinL	XPos,YPos,Len*9+10,20
		WinText XPos+5,YPos+2,Text
		ENDM


BtnStrucNum = 0
MenuButton = 0
MenuSeparation = 20


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Defines a dialog.
;;
;; Expects:	Name	= Dialog name
;;
;;		OPTIONAL PARAMETERS
;;		Rt	= Right mouse click function
;;		KbH	= Keyboard handler
;;		Func	= Function invoked after the window and buttons are
;;			  displayed
;;
;; Returns:	nothing
;;
Dialog		MACRO	Name,Rt:=<0>,KbH:=<0>,Func:=<0>
		_Dialog %BtnStrucNum,Name,Rt,KbH,Func
		ENDM


_Dialog		MACRO	BS,Name,Rt,KbH,Func
&Name		DD	BtnStruc&BS	; button struc
		DD	Rt		; right mouse click
		DD	KbH		; keyboard handler
		DD	Func		; function
		ENDM


WinMenuDef	MACRO	Name,X,Y,L
		MenuFunc = Name
		MenuX = X
		MenuY = Y
		MenuL = L
		MenuButton = 0
		ENDM


WinMenuDefCt	MACRO	Name,L
		MenuFunc = Name
		MenuX = (WinXS-(L*9+10))/2
		MenuY = 38
		MenuL = L
		MenuButton = 0
		ENDM


WinMenu		MACRO	Text
		WinHText MenuX,MenuY,MenuL,Text
		MenuY = MenuY + MenuSeparation
		MenuButton = MenuButton + 1
		ENDM


WinMenuCt	MACRO	Text
@@StrLen	SIZESTR <&Text>
		ERRIF	@@StrLen LT 3 "Menu entry must have caption"
		WinH	MenuX,MenuY,MenuL*9+10,20
		WinText MenuX+((MenuL*9+10)-((@@StrLen-2)*9))/2,MenuY+2,Text
		MenuY = MenuY + MenuSeparation
		MenuButton = MenuButton + 1
		ENDM


WinEnd		MACRO
		DB	0
		_WinEnd %BtnStrucNum
		BtnStrucNum = BtnStrucNum + 1

		IF	MenuButton GT 0
			MenuY = MenuY - MenuButton * MenuSeparation
			@@tmp = 0
			REPT MenuButton
				WinFrame MenuFunc,MenuX+3,MenuY+2,MenuL*9+4,16,@@tmp
				MenuY = MenuY + MenuSeparation
				@@tmp = @@tmp + 1
			ENDM
			MenuButton = 0
		ENDIF
		ENDM


_WinEnd		MACRO	Name
BtnStruc&Name	LABEL	DWORD
		ENDM


AbsButDef	MACRO	Name
&Name		LABEL	BYTE
		ENDM


RetC		MACRO
		clc
		ret
		ENDM


RetX		MACRO
		stc
		ret
		ENDM
