{ This includefile is for convenience only }

function SysUTC2ISOdttm : string;
var s : string;
begin
     // Calculate the UTC - Local systemtime
     s := '';
     SetLength (s,255);
     if SysUTC2dttm (pchar (s), 255) then
     begin
          SetLength (s, StrLen (pchar(s)));
          Result := s
     end
     else Result := '';
end;

function SysLocTime2ISOdttm : string;
var s : string;
begin
     // Calculate the Local systemtime
     s := '';
     SetLength (s,255);
     if SysLocTime2dttm (pchar (s), 255) then
     begin
          SetLength (s, StrLen(pchar(s)));
          Result := s
     end
     else Result := '';
end;

function ISOdttm2TimeLocale (s : string) : string;
begin
     // Convert to the time locale
     SetLength (s,255);
     if dttm2timelocale (pchar (s), 255) then
     begin
          SetLength (s, StrLen(pchar(s)));
          Result := s;
     end
     else Result := '';
end;

function ISOdttm2ShortDateLocale (s : string) : string;
begin
     // Convert to the short date locale
     SetLength (s,255);
     if dttm2datelocale (pchar (s), 255, false) then
     begin
          SetLength (s, StrLen(pchar(s)));
          Result := s;
     end
     else Result := '';
end;

function ISOdttm2LongDateLocale (s : string) : string;
begin
     // Convert to the short date locale
     SetLength (s,255);
     if dttm2datelocale (pchar (s), 255, true) then
     begin
          SetLength (s, StrLen(pchar(s)));
          Result := s;
     end
     else Result := '';
end;

function ISOdttm2JulianSeconds (s : string) : integer;
var js : integer;
begin
     // Calculate the julian seconds for the current system time
     if dttm2js (pchar (s), 255, js) then
        Result := js else Result := 0;
end;

function JulianSeconds2ISOdttm (js : integer) : string;
var s : string;
begin
     // Calculate the datetime for the current number of julian seconds
     SetLength (s ,255);
     if js2dttm (js, pchar (s), 255) then
     begin
          SetLength (s, StrLen(pchar(s)));
          Result := s;
     end
     else Result := '';
end;

function ISOdttm2WeekNr (s : string) : integer;
var wnr : integer;
begin
     // Calculate the weeknumber
     if dttm2weeknr (pchar (s), 255, wnr) then
        Result := wnr else Result := 0;
end;

function ISOdttm2DayOfWeek (s : string) : integer;
var dow : integer;
begin
     // Calculate the number of the day of the week (0=sunday, 1=monday etc.)
     if dttm2dayofweek (pchar (s), 255, dow) then
        Result := dow else Result := 0;
end;
    
function CheckISOdttm (s : string) : boolean;
     // Check the datetime
begin
     if chkdttm (pchar (s), 255) then Result := true else Result := false;
end;
