unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Timer1: TTimer;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    StaticText8: TStaticText;
    StaticText9: TStaticText;
    StaticText11: TStaticText;
    StaticText12: TStaticText;
    StaticText13: TStaticText;
    StaticText14: TStaticText;
    Label15: TLabel;
    StaticText15: TStaticText;
    StaticText10: TStaticText;
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

{$INCLUDE Julsec_decl.inc}

implementation

{$INCLUDE Julsec_func.inc}

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
var dttm : string;
    TZ, year, js, js1, js2, res : integer;
begin
     // Calculate the UTC - Local systemtime
     StaticText1.caption := SysUTC2ISOdttm;

     // Calculate the Local systemtime
     StaticText2.caption := SysLocTime2ISOdttm;

     dttm := StaticText2.caption;

     // Calculate the current timezone
     if GetTimeZone (TZ) then StaticText3.caption := inttostr(TZ) + ' hour(s)';

     // Convert to the time locale
     StaticText4.caption := ISOdttm2TimeLocale (dttm);

     // Convert to the short date locale
     StaticText5.caption := ISOdttm2ShortDateLocale (dttm);

     // Convert to the long date locale
     StaticText6.caption := ISOdttm2LongDateLocale (dttm);

     // Calculate the julian seconds for the current system time
     StaticText7.Caption := inttostr (ISOdttm2JulianSeconds (dttm)) + ' seconds since January 1, 2000';

     // Calculate the datetime for the current number of julian seconds
     StaticText8.Caption := JulianSeconds2ISOdttm (ISOdttm2JulianSeconds (dttm));

     // Calculate the weeknumber
     StaticText9.caption := inttostr (ISOdttm2WeekNr (dttm));

     // Calculate the number of the day of the week (0=sunday, 1=monday etc.)
     StaticText10.caption := inttostr (ISOdttm2DayOfWeek (dttm));

     // Check the julian seconds number
     js := ISOdttm2JulianSeconds (SysLocTime2ISOdttm);
     if chkjs (js) then StaticText11.caption := inttostr (js) + ' is valid' else StaticText11.caption := inttostr (js) + ' is NOT valid';

     // Check the datetime
     if CheckISOdttm (dttm) then StaticText12.caption := dttm + ' is valid' else StaticText12.caption := dttm + ' is NOT valid';

     // Determine if the current year is a leapyear or not
     year := strtoint (copy (dttm, 1, 4));
     if IsLeapYear (year) then StaticText13.caption := inttostr (year) + ' is a leapyear' else StaticText13.caption := inttostr (year) + ' is NOT a leapyear';

     // Calculate the number of days between to ISO datetime's
     // First, calculate the Julian Seconds of both ISO datetime's
     js1 := ISOdttm2JulianSeconds ('19630924183000');
     js2 := ISOdttm2JulianSeconds (SysLocTime2ISOdttm);
     // then, substract them
     res := js2 - js1;
     // divide the result by 24 hours x 60 minutes x 60 seconds to get the number of days
     res := res div (24 * 60 * 60);
     StaticText14.caption := inttostr (res) + ' days';

     // Calculate the number of weeks between september 24th, 1963 and current local systemtime
     // Both dates are already converted to julian seconds (js1 and js2), so
     // substract them
     res := js2 - js1;
     // and divide the result by 7 days x 24 hours x 60 minutes x 60 seconds to get the number of weeks
     res := res div (7 * 24 * 60 * 60);
     StaticText15.caption := inttostr (res) + ' weeks';
end;

end.
