{ SNDTST.PAS : Test on SNDLIB unit

  title   : SNDTST
  version : 1.2
  date    : Apr 30,1999
  author  : J R Ferguson
  language: Borland Pascal v7.0 (DOS Real or protected mode)
  usage   : Test program
}


{
--- Compiler options ---
}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }


PROGRAM SndTst;

Uses
  SndLib,
  ConLib, ChrLib,
{$ifdef WINDOWS}
  WinCrt;
{$else}
  Crt;
{$endif}

const
  C_Dfl_Duration  = 500;  { default note duration in milliseconds }
  C_Dfl_Frequency = 440;  { default note frequency }

var
  Duration  : word;
  Frequency : word;

procedure wrln2; begin writeln; writeln; end;

procedure RdWrd(const prompt: string; var w: word);
begin
  wrln2;
  repeat
    write(prompt,' (0..65535): ');
    {$I-} Readln(w); {$I+}
  until IOResult = 0;
end;

procedure PlayNote;
begin SndPlayNote(Frequency, Duration) end;

procedure SetDuration;
begin
  RdWrd('Duration in milliseconds',Duration);
  PlayNote;
end;

procedure SetFrequency;
begin
  RdWrd('Frequency in Hertz',Frequency);
  PlayNote;
end;

{$I SNDTSTM.PAS}

BEGIN {program}
  Duration  := C_Dfl_Duration;
  Frequency := C_Dfl_Frequency;
  SndTstM;
{$ifdef WINDOWS}
  DoneWinCrt;
{$else}
  ClrScr;
{$endif}
END.
