{ PBMTSTW.PAS : Test on PBMLIB unit

  title   : PBMTSTW
  version : 1.0
  date    : Feb 19, 2000
  author  : J R Ferguson
  language: Borland Pascal v7.0 with Objects
  usage   : MS-Windows v3.1 application
}


{
--- Compiler options ---
}

{$B-} { Short-circuit Boolean expression evaluation }
{$V-} { Relaxed var-string checking }
{$X+} { Extended syntax }


PROGRAM PBMTSTW;

Uses
  PbmTst1,
  BWCC, WinTypes, WinProcs, ODialogs, OWindows, Strings, PbmLib;

{$R PBMTSTW.RES} { Resource file }
{$I PBMTSTW.INC} { Resource file related constants }

const
  C_ProgramIdent    = 'PBMTSTW';
  C_MainWindowClass = 'PBMTSTWMAIN';
  C_MaxStatusMsg    = 29;

type
  P_Application = ^T_Application;
  P_MainWindow  = ^T_MainWindow;
  P_TestMusicBuf= ^T_TestMusicBuf;
  P_TestMusicDlg= ^T_TestMusicDlg;

  T_StatusMsg   = array[0..C_MaxStatusMsg] of char;

  T_Application = Object(TApplication)
    procedure   InitMainWindow; virtual;
  end;

  T_MainWindow  = Object(TWindow)
    function    GetClassName: PChar; virtual;
    procedure   SetupWindow; virtual;
    procedure   Paint(V_DC: HDC; var V_PaintInfo: TPaintStruct); virtual;
  end;

  T_TestMusicBuf= record
    IO_Melody   : array[1..3]  of word;
    IO_StatusMsg: T_StatusMsg;
  end;

  T_TestMusicDlg= Object(TDialog)
    IOBuffer    : T_TestMusicBuf;
    Melody      : integer;
    StatusMsg   : T_StatusMsg;
    ControlsOK  : boolean;
    Constructor Init(V_Parent: PWindowsObject; V_Name: PChar);
    procedure   InitControls;        virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
    procedure   DoPlay;              virtual id_First + id_Play;
  end;

const
  C_PlayingMsg  : array[1..3] of T_StatusMsg =
                  ('Playing Happy Birthday',
                   'Playing Broadway',
                   'Playing William Tell overture');
                   {....v....1....v....2....v....}

{
--- T_Application ---
}

procedure   T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow,Init(nil,''));
end;


{
--- T_MainWindow ---
}

function    T_MainWindow.GetClassName: PChar;
begin
  GetClassName:= C_MainWindowClass;
end;

procedure   T_MainWindow.SetupWindow;
begin
  Inherited SetupWindow;
  {display TestMusic dialog immediately}
  Application^.ExecDialog(New(P_TestMusicDlg, Init(@Self, MakeIntResource(Dlg_Test))));
end;

procedure   T_MainWindow.Paint(V_DC: HDC; var V_PaintInfo: TPaintStruct);
begin
  {exit as soon as TestMusic dialog is closed; do not display main window}
  Done;
end;


{
--- T_TestMusicDlg ---
}

Constructor T_TestMusicDlg.Init(V_Parent: PWindowsObject; V_Name: PChar);
begin
  Inherited Init(V_Parent,V_Name);
  ControlsOK:= false;
  Melody    := 1;
  StrCopy(StatusMsg,'');
  InitControls; ImportData;
  ControlsOK:= true;
end;

procedure   T_TestMusicDlg.InitControls;
var p: PControl; i: integer;
begin
  TransferBuffer:= @IOBuffer;
  p:= New(PGroupBox, InitResource(@Self,id_Melody));
  PGroupBox(p)^.NotifyParent:= true;
  for i:= 0 to 2 do
    p:= New(PRadioButton, InitResource(@Self,id_Melody1+i));
  p:= New(PStatic, InitResource(@Self,id_StatusMsg,C_MaxStatusMsg+1));
end;

procedure   T_TestMusicDlg.ImportData;
var i: integer;
begin with IOBuffer do begin
  for i:= 1 to 3 do
    if i = Melody then IO_Melody[i]:= bf_Checked else IO_Melody[i]:= bf_Unchecked;
  StrCopy(IO_StatusMsg,StatusMsg);
  TransferData(tf_SetData);
end; end;

function    T_TestMusicDlg.ExportData: boolean;
var i: integer;
begin with IOBuffer do begin
  TransferData(tf_GetData);
  for i:= 1 to 3 do
    if IO_Melody[i] = bf_Checked then Melody:= i;
  ExportData:= true;
end; end;

procedure   T_TestMusicDlg.DoPlay;
begin
  ExportData;
  StrCopy(StatusMsg,C_PlayingMsg[Melody]);
  ImportData;
  case Melody of
    1 : PlaySample1;
    2 : PlaySample2;
    3 : PlaySample3;
  end;
  StrCopy(StatusMsg,'');
  ImportData;
end;


{
--- Main progam ---
}

begin { Main program }
  Application:= New(P_Application, Init(C_ProgramIdent));
  Application^.Run;
  Dispose(Application,Done);
end.
