{ VIDTST.PAS : Test on VIDLIB.PAS

  title   : VIDTST
  version : 1.1
  date    : Feb 16, 2000
  author  : J R Ferguson
  language: Borland Pascal v7.0
  usage   : Program
}

PROGRAM VIDTST;
Uses VidLib, DefLib, ConLib, ChrLib, NioLib, Crt;

type
  StateTyp = (DoInit, DoSnowOn, DoSnowOff, DoSetPos, DoGetPos, DoSetAttr,
              DoGetAttr, DoDspChr, DoPutChr, DoPutChrAttr, DoChgAttr,
              DoChgChr, DoRetChr, DoRetAttr, DoRetChrAttr, DoPutNChr,
              DoPutNChrAttr, DoChgNAttr, DoChgNChr, DoDspStz, DoPutStz,
              DoDspStp, DoPutStp, DoClrEol, DoClrEolAttr, DoClrEos,
              DoClrEosAttr, DoClrScr, DoClrScrAttr);

const
  CTST   = '*';
  MaxStz = 1024;

var
  State: StateTyp;
  c    : char;
  attr : byte;
  cnt  : word;
  row  : byte;
  col  : byte;
  strZ : array[0..MaxStz] of char;
  strN : string;


procedure WrLn2; begin writeln; writeln;                           end;
procedure WrChr; begin if IsPrint(c) then write('"',c,'" ');
                       obuhex(ord(c)); writeln('h');               end;
procedure WrAtr; begin write('attr='); obuhex(attr); writeln('h'); end;
procedure WrRow; begin write('row ='); writeln(row);               end;
procedure WrCol; begin write('col ='); writeln(col);               end;
procedure RdChr; begin write('char:'); c:= Key; WrChr;           end;
procedure RdAtr; begin write('attr (hex):'); attr:=ibuhex;         end;
procedure RdRow; begin write('row  (dec):'); row := ibudec;        end;
procedure RdCol; begin write('col  (dec):'); col := ibudec;        end;
procedure RdCnt; begin write('cnt:'); readln(cnt);                 end;
procedure RdStz; begin write('s:'); readln(strZ);                  end;
procedure RdStp; begin write('s:'); readln(strN);                  end;
procedure PtChr; begin VidPutChr(CTST);                            end;
procedure PtRow; begin for col:= 0 to 79 do PtChr;                 end;
procedure PtPag; begin for row:= 0 to 24 do PtRow;                 end;


procedure xxInit;        begin VidInit; PtChr; end;
procedure xxSnowOn;      begin VidSnow(true); PtPag; end;
procedure xxSnowOff;     begin VidSnow(false); PtPag; end;
procedure xxSetPos;      begin RdRow; RdCol;
                               writeln('VidSetPos=',VidSetPos(row,col));
                               PtChr;
                         end;
procedure xxGetPos;      begin VidGetPos(row,col); WrRow; WrCol; PtChr; end;
procedure xxSetAttr;     begin RdAtr; VidSetAttr(attr); PtChr; end;
procedure xxGetAttr;     begin attr:= VidGetAttr; WrAtr; PtChr; end;
procedure xxDspChr;      begin RdChr; VidDspChr(c); end;
procedure xxPutChr;      begin RdChr; VidPutChr(c); end;
procedure xxPutChrAttr;  begin RdChr; RdAtr; VidPutChrAttr(c,attr); end;
procedure xxChgAttr;     begin RdAtr; VidChgAttr(attr); end;
procedure xxChgChr;      begin RdChr; VidChgChr(c); end;
procedure xxRetAttr;     begin attr:= VidRetAttr; WrAtr; end;
procedure xxRetChr;      begin c:= VidRetChr; WrChr; end;
procedure xxRetChrAttr;  begin VidRetChrAttr(c,attr); WrChr; WrAtr; end;
procedure xxPutNChr;     begin RdChr; RdCnt; VidPutNChr(c,cnt); end;
procedure xxPutNChrAttr; begin RdChr; RdAtr; RdCnt;
                               VidPutNChrAttr(c,attr,cnt)
                         end;
procedure xxChgNAttr;    begin RdAtr; RdCnt; VidChgNAttr(attr,cnt); end;
procedure xxChgNChr;     begin RdChr; RdCnt; VidChgNChr(c,cnt); end;
procedure xxPutStz;      begin RdStz; VidPutStz(strZ); end;
procedure xxDspStz;      begin RdStz; VidDspStz(strZ); end;
procedure xxPutStp;      begin RdStp; VidPutStp(strN); end;
procedure xxDspStp;      begin RdStp; VidDspStp(strN); end;
procedure xxClrEol;      begin VidClrEol; end;
procedure xxClrEolAttr;  begin RdAtr; VidClrEolAttr(attr); end;
procedure xxClrEos;      begin VidClrEos; end;
procedure xxClrEosAttr;  begin RdAtr; VidClrEosAttr(attr); end;
procedure xxClrScr;      begin VidClrScr; end;
procedure xxClrScrAttr;  begin RdAtr; VidClrScrAttr(attr); end;


procedure Action;
begin
  write(chr(ord('A') + ord(State)), chr(AsciiBS));
  case State of
    DoInit         : xxInit;
    DoSnowOn       : xxSnowOn;
    DoSnowOff      : xxSnowOff;
    DoSetPos       : xxSetPos;
    DoGetPos       : xxGetPos;
    DoSetAttr      : xxSetAttr;
    DoGetAttr      : xxGetAttr;
    DoDspChr       : xxDspChr;
    DoPutChr       : xxPutChr;
    DoPutChrAttr   : xxPutChrAttr;
    DoChgAttr      : xxChgAttr;
    DoChgChr       : xxChgChr;
    DoRetChr       : xxRetChr;
    DoRetAttr      : xxRetAttr;
    DoRetChrAttr   : xxRetChrAttr;
    DoPutNChr      : xxPutNChr;
    DoPutNChrAttr  : xxPutNChrAttr;
    DoChgNAttr     : xxChgNAttr;
    DoChgNChr      : xxChgNChr;
    DoDspStz       : xxDspStz;
    DoPutStz       : xxPutStz;
    DoDspStp       : xxDspStp;
    DoPutStp       : xxPutStp;
    DoClrEol       : xxClrEol;
    DoClrEolAttr   : xxClrEolAttr;
    DoClrEos       : xxClrEos;
    DoClrEosAttr   : xxClrEosAttr;
    DoClrScr       : xxClrScr;
    DoClrScrAttr   : xxClrScrAttr;
  end;
  if Key = chr(AsciiESC) then {redraw} else {redraw};
end;

{$I VIDTSTM0.PAS}

procedure xInit       ; begin State:= DoInit       ; vidtstm0 end;
procedure xSnowOn     ; begin State:= DoSnowOn     ; vidtstm0 end;
procedure xSnowOff    ; begin State:= DoSnowOff    ; vidtstm0 end;
procedure xSetPos     ; begin State:= DoSetPos     ; vidtstm0 end;
procedure xGetPos     ; begin State:= DoGetPos     ; vidtstm0 end;
procedure xSetAttr    ; begin State:= DoSetAttr    ; vidtstm0 end;
procedure xGetAttr    ; begin State:= DoGetAttr    ; vidtstm0 end;
procedure xDspChr     ; begin State:= DoDspChr     ; vidtstm0 end;
procedure xPutChr     ; begin State:= DoPutChr     ; vidtstm0 end;
procedure xPutChrAttr ; begin State:= DoPutChrAttr ; vidtstm0 end;
procedure xChgAttr    ; begin State:= DoChgAttr    ; vidtstm0 end;
procedure xChgChr     ; begin State:= DoChgChr     ; vidtstm0 end;
procedure xRetChr     ; begin State:= DoRetChr     ; vidtstm0 end;
procedure xRetAttr    ; begin State:= DoRetAttr    ; vidtstm0 end;
procedure xRetChrAttr ; begin State:= DoRetChrAttr ; vidtstm0 end;
procedure xPutNChr    ; begin State:= DoPutNChr    ; vidtstm0 end;
procedure xPutNChrAttr; begin State:= DoPutNChrAttr; vidtstm0 end;
procedure xChgNAttr   ; begin State:= DoChgNAttr   ; vidtstm0 end;
procedure xChgNChr    ; begin State:= DoChgNChr    ; vidtstm0 end;
procedure xDspStz     ; begin State:= DoDspStz     ; vidtstm0 end;
procedure xPutStz     ; begin State:= DoPutStz     ; vidtstm0 end;
procedure xDspStp     ; begin State:= DoDspStp     ; vidtstm0 end;
procedure xPutStp     ; begin State:= DoPutStp     ; vidtstm0 end;
procedure xClrEol     ; begin State:= DoClrEol     ; vidtstm0 end;
procedure xClrEolAttr ; begin State:= DoClrEolAttr ; vidtstm0 end;
procedure xClrEos     ; begin State:= DoClrEos     ; vidtstm0 end;
procedure xClrEosAttr ; begin State:= DoClrEosAttr ; vidtstm0 end;
procedure xClrScr     ; begin State:= DoClrScr     ; vidtstm0 end;
procedure xClrScrAttr ; begin State:= DoClrScrAttr ; vidtstm0 end;

{$I VIDTSTM1.PAS}
{$I VIDTSTM2.PAS}
{$I VIDTSTM.PAS}

begin { Main program }
  vidtstm;
  WrLn2;
end.
