unit Srttstd1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls;

const
  C_Count     = 100;
  C_MaxValue  = 1000;

type
  P_Integer     = ^Integer;
  P_Data        = ^T_Data;
  T_SortMethod  = (C_SortInsert,C_SortSelect,C_SortQuick);
  T_DataInd     = 0..C_Count;
  T_Data        = array[1..C_Count] of integer;

type
  TWndMain = class(TForm)
    GrpMethod: TRadioGroup;
    LstBefore: TListBox;
    LstAfter: TListBox;
    BtnNewData: TButton;
    BtnSort: TButton;
    BtnExit: TBitBtn;
    procedure BtnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnNewDataClick(Sender: TObject);
    procedure BtnSortClick(Sender: TObject);
  private
  public
    SortMethod   : T_SortMethod;
    Before,After : P_Data;
    procedure   DataInit;
    procedure   DataTerm;
    procedure   DlgImport;
    procedure   DlgExport;
  end;

var
  WndMain: TWndMain;

implementation
Uses SrtLib;

{$R *.DFM}

{ --- General --- }

procedure InitData(V_Data: P_Data);
var i: T_DataInd;
begin
  Randomize;
  for i:= 1 to C_Count do
    V_Data^[i]:= Random(C_MaxValue);
end;

procedure CopyData(V_Dst,V_Src: P_Data);
var i: T_DataInd;
begin for i:= 1 to C_Count do V_Dst^[i]:= V_Src^[i]; end;

function CompareData(e1,e2:SrtElmPtr): integer; far;
begin CompareData:= P_Integer(e1)^ - P_Integer(e2)^ end;

procedure SortData(V_SortMethod: T_SortMethod; V_Dst: P_Data);
begin case V_SortMethod of
  C_SortInsert : SrtBinIns(V_Dst,C_Count,SizeOf(Integer),CompareData);
  C_SortSelect : SrtSelect(V_Dst,C_Count,SizeOf(Integer),CompareData);
  C_SortQuick  : SrtQuick (V_Dst,C_Count,SizeOf(Integer),CompareData);
end end;

{ --- TwndMain : public --- }

procedure TWndMain.DataInit;
begin
  New(Before);
  New(After);
  InitData(Before);
  CopyData(After,Before);
end;

procedure TWndMain.DataTerm;
begin
  Dispose(Before);
  Dispose(After);
end;

procedure TWndMain.DlgImport;
var i: T_DataInd; s: String[4];
begin
  GrpMethod.ItemIndex:= ord(SortMethod);
  LstBefore.Clear;
  LstAfter.Clear;
  for i:= 1 to C_Count do begin
    Str(Before^[i]:4,s); LstBefore.Items.Add(s);
    Str(After ^[i]:4,s); LstAfter.Items.Add(s);
  end;
end;

procedure TWndMain.DlgExport;
begin case GrpMethod.ItemIndex of
  0 : SortMethod:= C_SortInsert;
  1 : SortMethod:= C_SortSelect;
  2 : SortMethod:= C_SortQuick ;
end end;

{ --- TwndMain : Generated --- }

procedure TWndMain.BtnExitClick(Sender: TObject);
begin
  Exit;
end;

procedure TWndMain.FormCreate(Sender: TObject);
begin
  SortMethod:= C_SortInsert;
  DataInit;
  DlgImport;
end;

procedure TWndMain.FormDestroy(Sender: TObject);
begin
  DataTerm;
end;

procedure TWndMain.BtnNewDataClick(Sender: TObject);
begin
  DlgExport;
  InitData(Before);
  CopyData(After,Before);
  DlgImport;
end;

procedure TWndMain.BtnSortClick(Sender: TObject);
begin
  DlgExport;
  CopyData(After,Before);
  SortData(SortMethod,After);
  DlgImport;
end;

end.
