unit Sndtstd1;

interface

uses
  SndLib,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons;

type
  TMainWnd = class(TForm)
    BtnExit: TBitBtn;
    PnlFrequency: TGroupBox;
    ScbFrequency: TScrollBar;
    TxtFrequency: TLabel;
    LblFrequency: TLabel;
    PnlDuration: TGroupBox;
    TxtDuration: TLabel;
    LblDuration: TLabel;
    ScbDuration: TScrollBar;
    BtnPlay: TBitBtn;
    TxtMinFrequency: TLabel;
    TxtMaxFrequency: TLabel;
    TxtMinDuration: TLabel;
    TxtMaxDuration: TLabel;
    procedure BtnExitClick(Sender: TObject);
    procedure ScbFrequencyChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnPlayClick(Sender: TObject);
    procedure ScbDurationChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainWnd: TMainWnd;

implementation

{$R *.DFM}

function PosToHz(V_Position: integer): integer;
begin
  PosToHz:= Round(exp(V_Position / 1000.0));
end;

function HzToPos(V_Frequency: integer): integer;
begin
  HzToPos:= Round(1000.0 * ln(V_Frequency));
end;

procedure TMainWnd.BtnExitClick(Sender: TObject);
begin
  Exit;
end;

procedure TMainWnd.ScbFrequencyChange(Sender: TObject);
begin
  TxtFrequency.Caption:= IntToStr(PosToHz(ScbFrequency.Position));
end;

procedure TMainWnd.FormCreate(Sender: TObject);
begin
  ScbFrequency.Position   := HzToPos(440);
  TxtFrequency.Caption    := IntToStr(PosToHz(ScbFrequency.Position));
  TxtMinFrequency.Caption := IntToStr(PosToHz(ScbFrequency.Min));
  TxtMaxFrequency.Caption := IntToStr(PosToHz(ScbFrequency.Max));
  TxtDuration.Caption     := IntToStr(ScbDuration.Position);
  TxtMinDuration.Caption  := IntToStr(ScbDuration.Min);
  TxtMaxDuration.Caption  := IntToStr(ScbDuration.Max);
end;

procedure TMainWnd.BtnPlayClick(Sender: TObject);
begin
  SndPlayNote(PosToHz(ScbFrequency.Position),ScbDuration.Position);
end;

procedure TMainWnd.ScbDurationChange(Sender: TObject);
begin
  TxtDuration.Caption:= IntToStr(ScbDuration.Position);
end;

end.
