{ DTMTSTV.PAS : Test DtmLib Unit (Turbo Vision)

  Title   : DTMTSTV
  Version : 2.0
  Date    : Nov 10,1996
  Author  : J R Ferguson
  Language: Borland Pascal v7.0 with Turbo Vision v2.0
  Usage   : DOS Program
}

PROGRAM DTMTSTV;

uses App, Drivers, Menus, Objects, Views, Dialogs, MsgBox, DtmLib;


const
  cm_InfoAbout  = 901;
  cm_InfoHelp   = 902;
  cm_OK         = cmOK;
  cm_Quit       = cmQuit;
  cm_DtmCvt     = 101;
  cm_DtmAdd     = 102;
  cm_DtmSub     = 103;

type
  P_Dialog      = ^T_DtmDlg;
  P_DtmCvtDlg   = ^T_DtmCvtDlg;
  P_DtmAddDlg   = ^T_DtmAddDlg;
  P_DtmSubDlg   = ^T_DtmSubDlg;

  T_DlgType     = (C_DtmCvtDlg, C_DtmAddDlg, C_DtmSubDlg);

  T_DtmInfBuf   = record
                    IO_Function: word;
                    IO_ErrMsg  : PChar;
                    IO_IdfDays : string[6];
                    IO_JulYear : string[6];
                    IO_JulDays : string[6];
                    IO_YmdYear : string[6];
                    IO_YmdMonth: string[6];
                    IO_YmdDay  : string[6];
                    IO_CalYear : string[6];
                    IO_CalWeek : string[6];
                    IO_CalDay  : string[6];
                    IO_CalDayNm: PChar;
                  end;

  T_DtmCvtBuf   = record
                    IO_Result  : PChar;
                    IO_Date    : T_DtmInfBuf;
                  end;

  T_DtmAddBuf   = record
                    IO_Result  : PChar;
                    IO_DateBeg : T_DtmInfBuf;
                    IO_DateEnd : T_DtmInfBuf;
                    IO_Days    : string[6];
                  end;

  T_DtmDlg      = Object(TDialog)
    DlgType     : T_DlgType;
    Constructor Init(V_Bounds: TRect; V_DlgType: T_DlgType);
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   DoCmOK;              virtual;
    procedure   InitData;            virtual;
    procedure   ProcessData;         virtual;
    procedure   InitControls;        virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
  end;

  T_DtmCvtDlg   = Object(T_DtmDlg)
    IOBuffer    : T_DtmCvtBuf;
    DateRec     : DtmDateRec;
    Result      : boolean;
    procedure   InitData;            virtual;
    procedure   ProcessData;         virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
  end;

  T_DtmAddDlg   = Object(T_DtmDlg)
    IOBuffer    : T_DtmAddBuf;
    DateBeg     : DtmDateRec;
    DateEnd     : DtmDateRec;
    Days        : LongInt;
    Result      : boolean;
    procedure   InitData;            virtual;
    procedure   ProcessData;         virtual;
    procedure   ImportData;          virtual;
    function    ExportData: boolean; virtual;
  end;

  T_DtmSubDlg   = Object(T_DtmAddDlg)
    procedure   InitData;            virtual;
    procedure   ProcessData;         virtual;
  end;

  T_Application = Object(TApplication)
    Constructor Init;
    procedure   InitMenuBar;         virtual;
    procedure   InitStatusLine;      virtual;
    procedure   InitDialog(V_DlgType: T_DlgType);
    procedure   ChngDialog(V_DlgType: T_DlgType);
    procedure   DoCmDtmCvt;          virtual;
    procedure   DoCmDtmAdd;          virtual;
    procedure   DoCmDtmSub;          virtual;
    procedure   DoCmInfoAbout;       virtual;
    procedure   DoCmInfoHelp;        virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
  end;

const
  DlgTitle      : array[T_DlgType] of string[25] =
                  ( 'DtmTst: Convert date'     ,
                    'DtmTst: Add days to date' ,
                    'DtmTst: Subtract dates'    );

  ResultMsg     : array[boolean]  of String[5] = ('false','true');
  DtmErrMsg     : array[DtmRcTyp] of String[8] =
                  ('DtmRcOk','DtmRcWrn','DtmRcRng','DtmRcFun');
  CalDayNm      : array[1..7] of String[9] =
                  ('Monday','Tuesday','Wednesday','Thursday',
                   'Friday','Saturday','Sunday');

var
  G_Application: T_Application;


{--- General functions ---}

procedure ImportDtmInf(var V_Buf: T_DtmInfBuf; V_Rec: DtmDateRec);
begin with V_Buf, V_Rec do begin
  IO_Function:= Word(Fn);
  IO_ErrMsg  := @DtmErrMsg[Rc];
  Str(Idf      ,IO_IdfDays );
  Str(Jul.Year ,IO_JulYear );
  Str(Jul.Day  ,IO_JulDays );
  Str(Ymd.Year ,IO_YmdYear );
  Str(Ymd.Month,IO_YmdMonth);
  Str(Ymd.Day  ,IO_YmdDay  );
  Str(Cal.Year ,IO_CalYear );
  Str(Cal.Week ,IO_CalWeek );
  Str(Cal.Day  ,IO_CalDay  );
  IO_CalDayNm:= @CalDayNm[Cal.Day];
end end;

function ExportDtmInf(var V_Rec: DtmDateRec; V_Buf: T_DtmInfBuf): boolean;
var code: integer;
begin with V_Buf, V_Rec do begin
  Fn:= DtmFnTyp(IO_Function);
  Val(IO_IdfDays ,Idf      ,code);
  Val(IO_JulYear ,Jul.Year ,code);
  Val(IO_JulDays ,Jul.Day  ,code);
  Val(IO_YmdYear ,Ymd.Year ,code);
  Val(IO_YmdMonth,Ymd.Month,code);
  Val(IO_YmdDay  ,Ymd.Day  ,code);
  Val(IO_CalYear ,Cal.Year ,code);
  Val(IO_CalWeek ,Cal.Week ,code);
  Val(IO_CalDay  ,Cal.Day  ,code);
  ExportDtmInf:= true;
end end;


{--- T_DtmDlg ---}

Constructor T_DtmDlg.Init(V_Bounds: TRect; V_DlgType: T_DlgType);
begin
  Inherited Init(V_Bounds,DlgTitle[V_DlgType]);
  Flags:= Flags and not (wfMove or wfClose); Palette:= wpBlueWindow;
  DlgType:= V_DlgType; InitControls; InitData; ProcessData; ImportData;
end;

procedure   T_DtmDlg.HandleEvent(var V_Event: TEvent);
begin
  if (V_Event.What = evCommand) and (V_Event.Command = cm_OK) then begin
    DoCmOK; ClearEvent(V_Event);
  end;
  Inherited HandleEvent(V_Event);
end;

procedure   T_DtmDlg.DoCmOK;
begin if ExportData then begin ProcessData; ImportData; end; end;

procedure   T_DtmDlg.InitControls;
var R: TRect; p: PView;
  procedure InsDateRec(Col,Row: integer; Title:string);
    procedure InsInput(Col,Row:integer; Title:string; Min,Max:LongInt);
    var SMin,SMax: string[6];
    begin
      Str(Min,SMin); Str(Max,SMax);
      R.Assign(Col   ,Row,Col+10,Row+01);
        Insert(New(PStaticText,Init(R,Title)));
      R.Assign(Col+11,Row,Col+19,Row+01);
        Insert(New(PInputLine,Init(R,6)));
      R.Assign(Col+20,Row,Col+37,Row+01);
        Insert(New(PStaticText,Init(R,'('+SMin+'..'+SMax+')')));
    end;
  begin {InsDateRec}
    R.Assign(Col+00,Row+00,Col+18,Row+01);
    Insert(New(PStaticText,Init(R,#3+Title)));
    R.Assign(Col+00,Row+02,Col+09,Row+08);
      p:= New(PStaticText,Init(R,#3'Function'));
      p^.Options:= p^.Options or ofFramed; Insert(p);
    R.Assign(Col+00,Row+03,Col+09,Row+08);
      Insert(New(PRadioButtons, Init(R,
        NewSItem('C~u~r',
        NewSItem('~I~df',
        NewSItem('~J~ul',
        NewSItem('~Y~md',
        NewSItem('~C~al',
      nil))))))));
    R.Assign(Col+11,Row+02,Col+19,Row+08);
      p:= New(PStaticText,Init(R,#3'Return code'));
      p^.Options:= p^.Options or ofFramed; Insert(p);
    R.Assign(Col+11,Row+05,Col+19,Row+06);
      Insert(New(PParamText,Init(R,#3'%s',1)));
    InsInput(Col+00,Row+09,'Idf days :',694325,767008);
    InsInput(Col+00,Row+11,'Jul Year :',  1901,  2099);
    InsInput(Col+00,Row+12,'    Day  :',     1,   366);
    InsInput(Col+00,Row+14,'Ymd Year :',  1901,  2099);
    InsInput(Col+00,Row+15,'    Month:',     1,    12);
    InsInput(Col+00,Row+16,'    Day  :',     1,    31);
    InsInput(Col+00,Row+18,'Cal Year :',  1901,  2099);
    InsInput(Col+00,Row+19,'    Week :',     1,    53);
    InsInput(Col+00,Row+20,'    Day  :',     1,     7);
    R.Assign(Col+27,Row+20,Col+36,Row+21);
      Insert(New(PParamText,Init(R,'%s',1)));
  end;
  procedure InsResult(Col,Row: integer);
  begin
    R.Assign(Col+00,Row+00,Col+09,Row+03);
      p:= New(PStaticText,Init(R,#3'Result'));
      p^.Options:= p^.Options or ofFramed; Insert(p);
    R.Assign(Col+00,Row+02,Col+09,Row+03);
      Insert(New(PParamText,Init(R,#3'%s',1)));
  end;
  procedure InsButton(Col,Row: integer);
  begin
    R.Assign(Col+00,Row+00,COl+10,Row+02);
      Insert(New(PButton,Init(R,'O~k~',cm_OK,bfDefault)));
  end;
  procedure InsDaysFld(Col,Row: integer; Title: String);
  begin
    R.Assign(Col+00,Row+00,Col+12,Row+01);
      Insert(New(PStaticText,Init(R,Title)));
    R.Assign(Col+01,Row+02,Col+10,Row+03);
      p:= New(PInputLine,Init(R,6));
      p^.Options:= p^.Options or ofFramed; Insert(p);
  end;
begin {T_DtmDlg.InitControls}
  case DlgType of
    C_DtmCvtDlg: begin
                   InsResult (27,03);
                   InsDateRec(03,01,'Date Info');
                   InsButton (47,05);
                 end;
    C_DtmAddDlg: begin
                   InsResult (27,06);
                   InsDateRec(03,01,'Starting date');
                   InsDateRec(41,01,'Ending date');
                   InsDaysFld(26,01,'Days to add');
                   InsButton (65,05);
                 end;
    C_DtmSubDlg: begin
                   InsResult (27,06);
                   InsDateRec(03,01,'Starting date');
                   InsDateRec(41,01,'Ending date');
                   InsDaysFld(26,01,'Days between');
                   InsButton (65,05);
                 end;
  end;
  SelectNext(false);
end;

procedure   T_DtmDlg.InitData;            begin end;
procedure   T_DtmDlg.ProcessData;         begin end;
procedure   T_DtmDlg.ImportData;          begin end;
function    T_DtmDlg.ExportData: boolean; begin ExportData:= true; end;


{--- T_DtmCvtDlg ---}

procedure   T_DtmCvtDlg.InitData;
begin DateRec.Fn:= DtmFnCur; end;

procedure   T_DtmCvtDlg.ProcessData;
begin Result:= DtmConvert(DateRec); end;

procedure   T_DtmCvtDlg.ImportData;
begin with IOBuffer do begin
  IO_Result  := @ResultMsg[Result];
  ImportDtmInf(IO_Date, DateRec);
  SetData(IOBuffer);
end end;

function    T_DtmCvtDlg.ExportData: boolean;
begin
  GetData(IOBuffer);
  ExportData:= ExportDtmInf(DateRec, IOBuffer.IO_Date);
end;


{--- T_DtmAddDlg ---}

procedure   T_DtmAddDlg.InitData;
begin DateBeg.Fn:= DtmFnCur; Days:= 0; end;

procedure   T_DtmAddDlg.ProcessData;
begin Result:= DtmAdd(Datebeg,Days,DateEnd); end;

procedure   T_DtmAddDlg.ImportData;
begin with IOBuffer do begin
  IO_Result  := @ResultMsg[Result];
  ImportDtmInf(IO_DateBeg, DateBeg);
  ImportDtmInf(DtmInfEnd, DateEnd);
  Str(Days,IOBuffer.IO_Days);
  SetData(IOBuffer);
end end;

function    T_DtmAddDlg.ExportData: boolean;
var code: integer;
begin with IOBuffer do begin
  GetData(IOBuffer);
  Val(IO_Days,Days,code);
  ExportData:= (code = 0)
           and ExportDtmInf(DateBeg, IOBuffer.IO_DateBeg)
           and ExportDtmInf(DateEnd, IOBuffer.DtmInfEnd);
end end;


{--- T_DtmSubDlg ---}

procedure   T_DtmSubDlg.InitData;
begin DateBeg.Fn:= DtmFnCur; DateEnd.Fn:= DtmFnCur; end;

procedure   T_DtmSubDlg.ProcessData;
begin Result:= DtmSubtract(DateEnd,DateBeg,Days); end;


{--- T_Application ---}

Constructor T_Application.Init;
begin
  Inherited Init;
  InitDialog(C_DtmCvtDlg);
end;


procedure   T_Application.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y:= R.A.Y + 1;
  MenuBar:= New(PMenuBar,Init(R,NewMenu(
    NewSubMenu('~O~ptions', hcNoContext, NewMenu(
      NewItem('Dtm~C~onvert' , ''     , kbNoKey, cm_DtmCvt   , hcNoContext,
      NewItem('Dtm~A~dd'     , ''     , kbNoKey, cm_DtmAdd   , hcNoContext,
      NewItem('Dtm~S~ubtract', ''     , kbNoKey, cm_DtmSub   , hcNoContext,
      NewItem('E~x~it'       , 'Atl+X', kbAltX , cm_Quit     , hcNoContext,
      nil))))),
    NewSubMenu('I~n~fo'  , hcNoContext, NewMenu(
      NewItem('~H~elp'   , 'F1'   , kbF1   , cm_InfoHelp , hcNoContext,
      NewItem('~A~bout'  , ''     , kbNoKey, cm_InfoAbout, hcNoContext,
      nil))),
    nil)))));
end;


procedure   T_Application.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y:= R.B.Y - 1;
  New(StatusLine, Init(R,
    NewStatusDef($0000,$FFFF,
      NewStatusKey('~Alt+X~ Exit', kbAltX , cm_Quit,
      NewStatusKey('~F1~ Help'   , kbF1   , cm_InfoHelp,
    nil)),nil)));
end;


procedure   T_Application.InitDialog(V_DlgType: T_DlgType);
var R: TRect;
begin
  DeskTop^.GetExtent(R);
  case V_DlgType of
    C_DtmCvtDlg: InsertWindow(New(P_DtmCvtDlg,Init(R,V_DlgType)));
    C_DtmAddDlg: InsertWindow(New(P_DtmAddDlg,Init(R,V_DlgType)));
    C_DtmSubDlg: InsertWindow(New(P_DtmSubDlg,Init(R,V_DlgType)));
  end;
end;


procedure   T_Application.ChngDialog(V_DlgType: T_DlgType);
var Dialog: PView;
begin
  Dialog:= DeskTop^.Current;
  if Dialog <> nil then begin
    DeskTop^.Delete(Dialog);
    Dispose(Dialog,Done);
    InitDialog(V_DlgType);
  end;
end;


procedure   T_Application.DoCmDtmCvt;
begin ChngDialog(C_DtmCvtDlg); end;


procedure   T_Application.DoCmDtmAdd;
begin ChngDialog(C_DtmAddDlg); end;


procedure   T_Application.DoCmDtmSub;
begin ChngDialog(C_DtmSubDlg); end;


procedure   T_Application.DoCmInfoAbout;
begin
  MessageBox(
    #3'DTMTSTV v2.0 - Test DTMLIB unit'#13 +
    #3'Borland Pascal v7.0 + Turbo Vision'#13 +
    #3'(c) J.R. Ferguson, 1996'#13 ,
    nil,
    mfInformation or mfOKButton);
end;


procedure   T_Application.DoCmInfoHelp;
var R: TRect;
begin
  R.Assign(42,02,75,14);
  MessageBoxRect(R,
  #3'Return codes'#13#13 +
    'DtmRcOK  : Success'#13 +
    'DtmRcWrn : Out of scale'#13 +
    'DtmRcRng : Out of range'#13 +
    'DtmRcFun : Unknown function'#13,
    nil,
    mfInformation or mfOKButton);
end;



procedure   T_Application.HandleEvent(var V_Event: TEvent);
begin with V_Event do begin
  Inherited HandleEvent(V_Event);
  case What of
    evCommand: case Command of
     cm_DtmCvt   : begin DoCmDtmCvt   ; ClearEvent(V_Event); end;
     cm_DtmAdd   : begin DoCmDtmAdd   ; ClearEvent(V_Event); end;
     cm_DtmSub   : begin DoCmDtmSub   ; ClearEvent(V_Event); end;
     cm_InfoAbout: begin DoCmInfoAbout; ClearEvent(V_Event); end;
     cm_InfoHelp : begin DoCmInfoHelp ; ClearEvent(V_Event); end;
    end;
  end;
end end;


{--- Main line ---}


begin with G_Application do begin
  Init;
  Run;
  Done;
end end.
